/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.matrx.ui;

import de.admadic.calculator.modules.matrx.MatrxActions;
import de.admadic.calculator.modules.matrx.MatrxCfg;
import de.admadic.calculator.modules.matrx.core.DMatrix;
import de.admadic.calculator.modules.matrx.core.MatrixLinearDependentException;
import de.admadic.calculator.modules.matrx.core.MatrixOp;
import de.admadic.calculator.modules.matrx.ui.FloatingPointFormatter;
import de.admadic.calculator.modules.matrx.ui.ICfgHandler;
import de.admadic.calculator.modules.matrx.ui.MatrixPanel;
import de.admadic.calculator.modules.matrx.ui.MatrixUiUtil;
import de.admadic.calculator.modules.matrx.ui.QuarterSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EquSlvOpPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public FloatingPointFormatter a;
    public MatrxCfg a;
    public ICfgHandler a;
    public QuarterSplitPane a;
    public MatrixPanel a;
    public MatrixPanel b;
    public MatrixPanel c;
    public MatrixPanel d;
    public DMatrix a;
    public DMatrix b;
    public DMatrix c;
    public DMatrix d;
    public JToolBar a;
    public SolveEquationAction a;

    public EquSlvOpPanel(FloatingPointFormatter floatingPointFormatter, MatrxCfg matrxCfg, ICfgHandler iCfgHandler) {
        this.a = floatingPointFormatter;
        this.a = matrxCfg;
        this.a = iCfgHandler;
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        this.a = new QuarterSplitPane();
        this.add((Component)this.a, "Center");
        this.a = new MatrixPanel("Coefficient Matrix:", this.a);
        this.b = new MatrixPanel("Absolute Elements:", this.a);
        this.c = new MatrixPanel("Gaussian Elimination:", this.a);
        this.d = new MatrixPanel("Solution:", this.a);
        this.a.setPreferredSize(new Dimension(100, 100));
        this.b.setPreferredSize(new Dimension(100, 100));
        this.c.setPreferredSize(new Dimension(100, 100));
        this.d.setPreferredSize(new Dimension(100, 100));
        this.a.setTopLeftComponent(this.a);
        this.a.setTopRightComponent(this.b);
        this.a.setBottomLeftComponent(this.c);
        this.a.setBottomRightComponent(this.d);
        this.a.setDividerLocation(0.5, 0.75);
        this.a = new JToolBar();
        this.add((Component)this.a, "First");
        this.a.add(new JButton(new CreateNewAction()));
        this.a.add(new JButton(new CreateNewInputAction()));
        this.a.add(new JButton(new CreateNewInputAbsElAction()));
        this.a = new SolveEquationAction();
        this.a.add(new JButton(this.a));
        this.b();
    }

    public void setInputMatrixCoeff(DMatrix dMatrix) {
        this.a = dMatrix;
        this.a.setMatrix(dMatrix);
        this.b();
        this.a.notifyCfgUpdate();
    }

    public void setInputMatrixAbsEl(DMatrix dMatrix) {
        this.b = dMatrix;
        this.b.setMatrix(dMatrix);
        this.b();
        this.a.notifyCfgUpdate();
    }

    public void setResultMatrixGauss(DMatrix dMatrix) {
        this.c = dMatrix;
        this.c.setMatrix(dMatrix);
        this.a.notifyCfgUpdate();
    }

    public void setResultMatrixSol(DMatrix dMatrix) {
        this.d = dMatrix;
        this.d.setMatrix(dMatrix);
        this.a.notifyCfgUpdate();
    }

    private void b() {
        boolean bl = true;
        if (this.a == null) {
            bl = false;
        }
        if (this.b == null) {
            bl = false;
        }
        this.a.setEnabled(bl);
    }

    public class SolveEquationAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SolveEquationAction() {
            this.putValue("Name", "Solve");
            this.putValue("ShortDescription", "Solve Equation");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-equ.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = new DMatrix(EquSlvOpPanel.this.b);
            MatrixOp.mul(dMatrix, -1.0);
            DMatrix dMatrix2 = MatrixOp.appendMatrixColumns(EquSlvOpPanel.this.a, dMatrix);
            try {
                MatrixOp.convertToUpperTriangularForm(dMatrix2);
            }
            catch (MatrixLinearDependentException matrixLinearDependentException) {
                JOptionPane.showMessageDialog(null, "Equations are linear dependent\n(Error: " + matrixLinearDependentException.getMessage() + ")", "Cannot solve LES", 0);
                return;
            }
            EquSlvOpPanel.this.setResultMatrixGauss(dMatrix2);
            DMatrix dMatrix3 = new DMatrix(EquSlvOpPanel.this.a.getColumnCount(), 1);
            MatrixOp.calcSolution(dMatrix2, dMatrix3);
            EquSlvOpPanel.this.setResultMatrixSol(dMatrix3);
        }
    }

    public class CreateNewInputAbsElAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateNewInputAbsElAction() {
            this.putValue("Name", "New|");
            this.putValue("ShortDescription", "Create New Absolute Elements Matrix from Input");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = MatrixUiUtil.getNewMatrixInput(EquSlvOpPanel.this.a);
            if (dMatrix == null) {
                return;
            }
            if (dMatrix.getColumnCount() != 1) {
                JOptionPane.showMessageDialog(null, "Absolute elements matrix must have 1 column", "Error", 0);
                return;
            }
            EquSlvOpPanel.this.setInputMatrixAbsEl(dMatrix);
        }
    }

    public class CreateNewInputAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateNewInputAction() {
            this.putValue("Name", "New[]");
            this.putValue("ShortDescription", "Create New Coefficient Matrix from Input");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = MatrixUiUtil.getNewMatrixInput(EquSlvOpPanel.this.a);
            if (dMatrix == null) {
                return;
            }
            EquSlvOpPanel.this.setInputMatrixCoeff(dMatrix);
        }
    }

    public class CreateNewAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateNewAction() {
            this.putValue("Name", "New");
            this.putValue("ShortDescription", "Create New Coefficient and Absolute Elements Matrix");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = MatrixUiUtil.getNewMatrix();
            if (dMatrix == null) {
                return;
            }
            DMatrix dMatrix2 = new DMatrix(dMatrix.getRowCount(), 1);
            EquSlvOpPanel.this.setInputMatrixCoeff(dMatrix);
            EquSlvOpPanel.this.setInputMatrixAbsEl(dMatrix2);
        }
    }
}

