/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.matrx.ui;

import de.admadic.calculator.appctx.IAppContext;
import de.admadic.calculator.modules.matrx.MatrxActions;
import de.admadic.calculator.modules.matrx.MatrxCfg;
import de.admadic.calculator.modules.matrx.core.DMatrix;
import de.admadic.calculator.modules.matrx.ui.BinaryOpPanel;
import de.admadic.calculator.modules.matrx.ui.CopyPasteCore;
import de.admadic.calculator.modules.matrx.ui.EquSlvOpPanel;
import de.admadic.calculator.modules.matrx.ui.FloatingPointFormatter;
import de.admadic.calculator.modules.matrx.ui.ICfgHandler;
import de.admadic.calculator.modules.matrx.ui.SettingsDialog;
import de.admadic.calculator.modules.matrx.ui.SimpleOpPanel;
import de.admadic.calculator.modules.matrx.ui.TabularCopyPasteCore;
import de.admadic.ui.util.AboutDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class MatrxFrame
extends JFrame
implements ActionListener,
ICfgHandler {
    private static final long serialVersionUID = 1L;
    public Logger a;
    public MatrxCfg a;
    public MatrxActions a;
    public FloatingPointFormatter a;
    public CopyPasteCore a;
    public JTabbedPane a;
    public JPanel a;
    public SimpleOpPanel a;
    public BinaryOpPanel a;
    public EquSlvOpPanel a;
    public ImageIcon a;
    public ImageIcon b;
    public boolean a = false;
    public boolean b = false;

    public MatrxFrame(MatrxCfg matrxCfg, MatrxActions matrxActions, IAppContext iAppContext) throws HeadlessException {
        this.a = matrxCfg;
        this.a = matrxActions;
    }

    public void initCore() {
        String string = this.a.getDisplayFormat();
        if (string == null) {
            string = "%g";
        }
        this.a = FloatingPointFormatter.createFormatter(string, Locale.getDefault());
    }

    private void a(JMenu jMenu, String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenu.add(jMenuItem);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this);
    }

    public ImageIcon loadIcon(String string) {
        String string2 = "de/admadic/calculator/modules/matrx/res/" + string;
        URL uRL = this.getClass().getClassLoader().getResource(string2);
        if (uRL == null) {
            if (this.a != null) {
                this.a.warning("could not get url for " + string2 + " (icon name = " + string + ")");
            }
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (image == null) {
            if (this.a != null) {
                this.a.warning("could not get image for " + uRL.toString() + " (icon name = " + string + ")");
            }
            return null;
        }
        return new ImageIcon(image);
    }

    public void initComponents() {
        this.initCore();
        this.b = this.loadIcon("icon-16.png");
        this.a = this.loadIcon("icon-48.png");
        this.a = (JPanel)this.getContentPane();
        if (this.b != null) {
            this.setIconImage(this.b.getImage());
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new c(this));
        this.setTitle("Matrx Module");
        new JMenuBar();
        JMenuBar jMenuBar = null;
        jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        this.a(jMenu, "Close", "mnu.file.exit");
        jMenu = new JMenu("Edit");
        jMenuBar.add(jMenu);
        this.a(jMenu, "Copy", "mnu.edit.copy");
        this.a(jMenu, "Paste", "mnu.edit.paste");
        if (this.a != null && this.a.getActions() != null) {
            JMenu jMenu2 = new JMenu("Module");
            jMenuBar.add(jMenu2);
            for (int i = 1; i < this.a.getActions().size(); ++i) {
                jMenu2.add(new JMenuItem((Action)this.a.getActions().get(i)));
            }
        }
        jMenu = new JMenu("Help");
        jMenuBar.add(jMenu);
        this.a(jMenu, "About...", "mnu.help.about");
        this.setJMenuBar(jMenuBar);
        this.a.setLayout(new BorderLayout());
        this.a = new JTabbedPane();
        this.a.add((Component)this.a, "Center");
        this.a = new SimpleOpPanel(this.a, this.a, this);
        this.a = new BinaryOpPanel(this.a, this.a, this);
        this.a = new EquSlvOpPanel(this.a, this.a, this);
        this.a.addTab("Simple", this.a);
        this.a.addTab("Binary", this.a);
        this.a.addTab("Equation Solver", this.a);
        this.pack();
        this.setLocationRelativeTo(null);
        this.loadSettings();
    }

    public void doHelpAbout() {
        AboutDialog aboutDialog = new AboutDialog((JFrame)this);
        String string = null;
        String string2 = null;
        string = this.a.getLicCompany();
        string = string == null || string.equals("") ? this.a.getLicName() : this.a.getLicName() + ", " + string;
        string2 = this.a.getLicSN();
        aboutDialog.setAboutInfo("admaDIC Calculator Module\nMatrx - Matrix Calculations\nVersion 1.0.0-r12", "Copyright (c) 2005-2006 - admaDIC\n04179 Leipzig, Germany", "For updates or more information \nplease visit http://www.admadic.de/", "Registered to: \n  " + string + "\n" + "Serial Number: \n" + "  " + string2, "This product includes the software JGoodies Forms:\nCopyright (c) 2002-2004 JGoodies Karsten Lentzsch.\nAll rights reserved.");
        aboutDialog.setTitle("About Matrx Module");
        if (this.a != null) {
            aboutDialog.setLogo(this.a.getImage());
        }
        aboutDialog.setVisible(true);
    }

    public boolean isSetupComplete() {
        return this.a;
    }

    public void setSetupComplete(boolean bl) {
        this.a = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("mnu.file.exit")) {
            this.doExit();
            return;
        }
        if (string.equals("mnu.edit.copy")) {
            this.a();
            return;
        }
        if (string.equals("mnu.edit.paste")) {
            this.b();
            return;
        }
        if (string.equals("mnu.help.about")) {
            this.doHelpAbout();
            return;
        }
        if (string.equals("mnu.tools.options")) {
            this.doToolsOptions();
        }
    }

    private void a() {
        JComponent jComponent;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (this.a == null) {
            this.a = new CopyPasteCore();
        }
        if (component instanceof JTextField) {
            jComponent = (JTextField)component;
            this.a.doCopyFrom((JTextField)jComponent);
        }
        if (component instanceof JTable) {
            jComponent = (JTable)component;
            TabularCopyPasteCore tabularCopyPasteCore = new TabularCopyPasteCore();
            tabularCopyPasteCore.doCopyFrom((JTable)jComponent);
        }
    }

    private void b() {
        JComponent jComponent;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (this.a == null) {
            this.a = new CopyPasteCore();
        }
        if (component instanceof JTextField) {
            jComponent = (JTextField)component;
            this.a.doPasteInto((JTextField)jComponent);
        }
        if (component instanceof JTable) {
            jComponent = (JTable)component;
            TabularCopyPasteCore tabularCopyPasteCore = new TabularCopyPasteCore();
            tabularCopyPasteCore.doPasteInto((JTable)jComponent, false);
        }
    }

    public void doExit() {
        this.dispose();
    }

    public void doToolsOptions() {
        SettingsDialog settingsDialog = new SettingsDialog(this, this.a);
        settingsDialog.initContents();
        settingsDialog.loadSettings();
        settingsDialog.setVisible(true);
        int n = settingsDialog.getResultCode();
        if (n == 1) {
            String string = this.a.getDisplayFormat();
            if (string == null) {
                string = "%g";
            }
            this.a.setFormatString(string);
        }
    }

    public void storeSettings() {
        if (!this.b) {
            return;
        }
        DMatrix[] dMatrixArray = new DMatrix[9];
        DMatrix[] dMatrixArray2 = dMatrixArray;
        dMatrixArray[0] = this.a.a;
        dMatrixArray2[1] = this.a.b;
        dMatrixArray2[2] = this.a.a;
        dMatrixArray2[3] = this.a.b;
        dMatrixArray2[4] = this.a.c;
        dMatrixArray2[5] = this.a.a;
        dMatrixArray2[6] = this.a.b;
        dMatrixArray2[7] = this.a.c;
        dMatrixArray2[8] = this.a.d;
        this.a.putMtxDataContent(dMatrixArray2);
    }

    public void loadSettings() {
        DMatrix[] dMatrixArray = this.a.getMtxDataContent();
        this.b = true;
        if (dMatrixArray == null) {
            return;
        }
        if (dMatrixArray.length < 1) {
            return;
        }
        this.a.setInputMatrix(dMatrixArray[0]);
        this.a.setResultMatrix(dMatrixArray[1]);
        this.a.setFirstInputMatrix(dMatrixArray[2]);
        this.a.setSecondInputMatrix(dMatrixArray[3]);
        this.a.setResultMatrix(dMatrixArray[4]);
        this.a.setInputMatrixCoeff(dMatrixArray[5]);
        this.a.setInputMatrixAbsEl(dMatrixArray[6]);
        this.a.setResultMatrixGauss(dMatrixArray[7]);
        this.a.setResultMatrixSol(dMatrixArray[8]);
    }

    public void notifyCfgUpdate() {
        this.storeSettings();
    }
}

