/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.matrx.ui;

import de.admadic.calculator.modules.matrx.MatrxActions;
import de.admadic.calculator.modules.matrx.MatrxCfg;
import de.admadic.calculator.modules.matrx.core.DMatrix;
import de.admadic.calculator.modules.matrx.core.MatrixException;
import de.admadic.calculator.modules.matrx.core.MatrixLinearDependentException;
import de.admadic.calculator.modules.matrx.core.MatrixOp;
import de.admadic.calculator.modules.matrx.ui.FloatingPointFormatter;
import de.admadic.calculator.modules.matrx.ui.ICfgHandler;
import de.admadic.calculator.modules.matrx.ui.MatrixPanel;
import de.admadic.calculator.modules.matrx.ui.MatrixUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SimpleOpPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public FloatingPointFormatter a;
    public MatrxCfg a;
    public ICfgHandler a;
    public JToolBar a;
    public JSplitPane a;
    public MatrixPanel a;
    public MatrixPanel b;
    public DMatrix a;
    public DMatrix b;
    public CreateUTFormAction a;
    public CalcTransposeAction a;
    public CalcCofactorAction a;
    public CalcAdjointAction a;
    public CalcInverseAction a;
    public CalcDeterminantAction a;
    public CalcTraceAction a;

    public SimpleOpPanel(FloatingPointFormatter floatingPointFormatter, MatrxCfg matrxCfg, ICfgHandler iCfgHandler) {
        this.a = floatingPointFormatter;
        this.a = matrxCfg;
        this.a = iCfgHandler;
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        this.a = new JSplitPane(0);
        this.a = new JToolBar();
        this.add((Component)this.a, "Center");
        this.add((Component)this.a, "First");
        this.a = new MatrixPanel("Input Matrix:", this.a);
        this.b = new MatrixPanel("Result Matrix:", this.a);
        this.a.setPreferredSize(new Dimension(100, 100));
        this.b.setPreferredSize(new Dimension(100, 100));
        this.a.setTopComponent(this.a);
        this.a.setBottomComponent(this.b);
        this.a.setDividerLocation(0.5);
        this.a.setResizeWeight(0.5);
        this.a.add(new JButton(new CreateNewAction()));
        this.a.add(new JButton(new CreateNewInputAction()));
        this.a = new CreateUTFormAction();
        this.a.add(new JButton(this.a));
        this.a = new CalcTransposeAction();
        this.a.add(new JButton(this.a));
        this.a = new CalcCofactorAction();
        this.a.add(new JButton(this.a));
        this.a = new CalcAdjointAction();
        this.a.add(new JButton(this.a));
        this.a = new CalcInverseAction();
        this.a.add(new JButton(this.a));
        this.a = new CalcDeterminantAction();
        this.a.add(new JButton(this.a));
        this.a = new CalcTraceAction();
        this.a.add(new JButton(this.a));
        this.a.add(new JButton(new CopyResultToInputAction()));
        this.a.setRollover(true);
        this.setInputMatrix(null);
    }

    public void setInputMatrix(DMatrix dMatrix) {
        this.a = dMatrix;
        this.a.setMatrix(dMatrix);
        boolean bl = dMatrix != null;
        this.a.setEnabled(bl);
        this.a.setEnabled(bl);
        this.a.setEnabled(bl);
        this.a.setEnabled(bl);
        this.a.setEnabled(bl);
        this.a.setEnabled(bl);
        this.a.setEnabled(bl);
        this.a.notifyCfgUpdate();
    }

    public void setResultMatrix(DMatrix dMatrix) {
        this.b = dMatrix;
        this.b.setMatrix(dMatrix);
        this.a.notifyCfgUpdate();
    }

    public class CopyResultToInputAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CopyResultToInputAction() {
            this.putValue("Name", "res->inp");
            this.putValue("ShortDescription", "Copy result to input");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleOpPanel.this.a = SimpleOpPanel.this.b != null ? new DMatrix(SimpleOpPanel.this.b) : null;
            SimpleOpPanel.this.setInputMatrix(SimpleOpPanel.this.a);
        }
    }

    public class CalcInverseAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CalcInverseAction() {
            this.putValue("ShortDescription", "Calculate Inverse");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-inv.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                SimpleOpPanel.this.b = MatrixOp.calcInverse(SimpleOpPanel.this.a);
            }
            catch (MatrixException matrixException) {
                JOptionPane.showMessageDialog(null, "Could not calculate inverse matrix.\n(Error: " + matrixException.getMessage() + ")", "Calculation error", 0);
                return;
            }
            SimpleOpPanel.this.setResultMatrix(SimpleOpPanel.this.b);
        }
    }

    public class CalcAdjointAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CalcAdjointAction() {
            this.putValue("ShortDescription", "Calculate Adjoint");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-adj.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                SimpleOpPanel.this.b = MatrixOp.calcAdjoint(SimpleOpPanel.this.a);
            }
            catch (MatrixException matrixException) {
                JOptionPane.showMessageDialog(null, "Could not calculate adjoint matrix.\n(Error: " + matrixException.getMessage() + ")", "Calculation error", 0);
                return;
            }
            SimpleOpPanel.this.setResultMatrix(SimpleOpPanel.this.b);
        }
    }

    public class CalcCofactorAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CalcCofactorAction() {
            this.putValue("ShortDescription", "Calculate Cofactor");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-cof.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = SimpleOpPanel.this.a.getSelectedRow();
            int n2 = SimpleOpPanel.this.a.getSelectedColumn();
            if (n < 0 || n2 < 0) {
                JOptionPane.showMessageDialog(null, "Please select a cell", "Cannot calculate cofactor", 0);
                return;
            }
            Double d = null;
            try {
                d = MatrixOp.calcCofactor(SimpleOpPanel.this.a, n, n2);
            }
            catch (MatrixException matrixException) {
                JOptionPane.showMessageDialog(null, "Could not calculate cofactor of selected element.\n(Error: " + matrixException.getMessage() + ")", "Calculation error", 0);
                return;
            }
            SimpleOpPanel.this.b = d == null ? null : new DMatrix(new Double[][]{{d}});
            SimpleOpPanel.this.setResultMatrix(SimpleOpPanel.this.b);
        }
    }

    public class CalcTraceAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CalcTraceAction() {
            this.putValue("ShortDescription", "Calculate Trace");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-trc.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Double d = MatrixOp.calcTrace(SimpleOpPanel.this.a);
            SimpleOpPanel.this.b = d == null ? null : new DMatrix(new Double[][]{{d}});
            SimpleOpPanel.this.setResultMatrix(SimpleOpPanel.this.b);
        }
    }

    public class CalcTransposeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CalcTransposeAction() {
            this.putValue("ShortDescription", "Calculate Transpose");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-tra.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleOpPanel.this.b = MatrixOp.createTranspose(SimpleOpPanel.this.a);
            SimpleOpPanel.this.setResultMatrix(SimpleOpPanel.this.b);
        }
    }

    public class CalcDeterminantAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CalcDeterminantAction() {
            this.putValue("ShortDescription", "Calculate Determinant");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-det.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Double d = null;
            try {
                d = MatrixOp.calcDeterminant(SimpleOpPanel.this.a);
            }
            catch (MatrixException matrixException) {
                JOptionPane.showMessageDialog(null, "Could not calculate determinant of matrix.\n(Error: " + matrixException.getMessage() + ")", "Calculation error", 0);
                return;
            }
            SimpleOpPanel.this.b = d == null ? null : new DMatrix(new Double[][]{{d}});
            SimpleOpPanel.this.setResultMatrix(SimpleOpPanel.this.b);
        }
    }

    public class CreateUTFormAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateUTFormAction() {
            this.putValue("ShortDescription", "Create Upper Triangular Form");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-ut.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleOpPanel.this.b = new DMatrix(SimpleOpPanel.this.a);
            try {
                MatrixOp.convertToUpperTriangularForm(SimpleOpPanel.this.b);
            }
            catch (MatrixLinearDependentException matrixLinearDependentException) {
                JOptionPane.showMessageDialog(null, "Could not calculate upper triangular form.\n(Error: " + matrixLinearDependentException.getMessage() + ")", "Calculation error", 0);
                return;
            }
            SimpleOpPanel.this.setResultMatrix(SimpleOpPanel.this.b);
        }
    }

    public class CreateNewInputAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateNewInputAction() {
            this.putValue("Name", "New[]");
            this.putValue("ShortDescription", "Create New Matrix from Input");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = MatrixUiUtil.getNewMatrixInput(SimpleOpPanel.this.a);
            if (dMatrix == null) {
                return;
            }
            SimpleOpPanel.this.setInputMatrix(dMatrix);
        }
    }

    public class CreateNewAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateNewAction() {
            this.putValue("Name", "New");
            this.putValue("ShortDescription", "Create New Matrix");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = MatrixUiUtil.getNewMatrix();
            if (dMatrix == null) {
                return;
            }
            SimpleOpPanel.this.setInputMatrix(dMatrix);
        }
    }
}

