'
'  This program will create a PCBoard-style DIRx file from a 00_INDEX.TXT
'  file.
'  This version is written for use with MicroSoft QuickBasic 4.5
'
'  exist 00_files.txt
'  CHECK FOR DUPS
'
'
	DECLARE SUB GetFile (FileSpec$, FileName$, FileType!)
	DECLARE FUNCTION SubDir$ (FileSpec$)
	DECLARE FUNCTION Exist% (path$)
	DIM CAT(300) AS STRING * 16
       

	'$INCLUDE: 'QB.BI'
     
	'-----  Some constants that SubDir$ uses
	CONST DOS = &H21
	CONST SetDTA = &H1A00, FindFirst = &H4E00, FindNext = &H4F00

'  Get the location of the first SimTel CDROM volume 

	COLOR 14, 0
       
	LOCATE 1, 1, 1
	CLS
	PRINT "Welcome to the PCBoard directory file maker for the SimTel CDROM set!"
	PRINT
	PRINT "  This program will generate the PCBoard conference files that are required"
	PRINT "   to use the SimTel CDROM set on a PCBoard v14.x or 15.x BBS."
	PRINT
	PRINT "Note:       "
	PRINT "  Although it is not necessary to do so before running this program,"
	PRINT "  it is assumed that you have already set up a separate PCBoard conference"
	PRINT "  for the SimTel CDROM file areas.  After this program completes, you should"
	PRINT "  be able to copy the directory files into your PCBoard's conference area."
	PRINT
	PRINT "  To make these files, we need to know the following:"
	PRINT
	PRINT "  Where to temporarily store this program's output files,"
	PRINT "  Which drive letters are assigned to the SimTel CDROM drives."
	PRINT "  Where the PCBoard directory files will ultimately be located."
	PRINT

	PRINT "WARNING:"
	PRINT "  This program creates the PCBoard files DIR, DIRxxx. DIR.LST and DLPATH.LST."
	PRINT "  DO NOT ENTER YOUR ACTUAL PCBOARD DIRECTORY AS THE TEMPORARY STORAGE AREA,"
	PRINT "  OR SOME OF YOUR PCBOARD FILES MAY BE DESTROYED!  BACK UP EVERYTHING!"
	PRINT
	PRINT "Enter drive and path for temporary output files (e.g. C:\TEMP): "
	LINE INPUT TempDir$
	TempDir$ = UCASE$(TempDir$)
	IF RIGHT$(TempDir$, 1) = "\" THEN TempDir$ = LEFT$(TempDir$, LEN(TempDir$) - 1)
	IF LEN(TempDir$) > 23 THEN
		PRINT "Maximum drive and path size must be 23 characters or less.  Aborting...": END
	END IF
	PRINT
	PRINT "Enter drive letter of SimTel CDROM volume SIMTEL1 (A-Z): ";
	CD1$ = UCASE$(INPUT$(1))
	IF CD1$ = CHR$(&H1B) THEN PRINT : PRINT "Aborting...": END
	IF CD1$ < "A" OR CD1$ > "Z" THEN
		PRINT "Invalid drive letter, Aborting...": END
	END IF
	PRINT CD1$
	PRINT "Enter drive letter of SimTel CDROM volume SIMTEL2 (A-Z): ";
	CD2$ = UCASE$(INPUT$(1))
	IF CD2$ = CHR$(&H1B) THEN PRINT : PRINT "Aborting...": END
	IF CD2$ < "A" OR CD2$ > "Z" THEN
		PRINT "Invalid drive letter, Aborting...": END
	END IF
	PRINT CD2$
	PRINT
	PRINT "Enter drive and path of your PCBoard's SimTel conference's DIR, DIRxxx, DIR.LST,"
	PRINT "and DLPATH.LST files:"
	LINE INPUT PD$
	PD$ = UCASE$(PD$)
	PRINT
	PRINT "Enter number of columns to display in DIR file (2 or 3): ";
	NumCols% = VAL(INPUT$(1))
	IF NumCols% = 2 OR NumCols% = 3 THEN
		PRINT X$
	ELSE
		PRINT "Invalid number of columns, Aborting...": END
	END IF

	CLS
	PRINT "We will now generate the DIR, DIRxxx, DIR.LST, and DLPATH.LST files for your"
	PRINT "PCBoard system.  The DIR file will be in "; LTRIM$(RTRIM$(STR$(NumCols%))); "-column format."
	PRINT
	PRINT "These files will be placed in the directory at: "; TempDir$
	PRINT "so that you can copy them into your PCBoard's SimTel conference area"
	PRINT "(as defined by you via the PCBSM utility)."
	PRINT
	PRINT "These files will assume that the SimTel volumes are located in "; CD1$; ":, and "; CD2$; ":,"
	PRINT "and that the PCBoard configuration will expect to see its files in the"
	PRINT PD$; " directory."
	PRINT
	PRINT "The DIR, DIRxxx, and DIR.LST files can be further edited, if desired,"
	PRINT "with any plain ASCII editor.  Conversion files are also available (PCB2ASC"
	PRINT "and ASC2PCB) to convert DLPATH.LST to a plain ASCII file for editing."
	PRINT
	PRINT
	PRINT "  Is this correct (Y/N)? ";
	X$ = UCASE$(INPUT$(1))
	IF X$ <> "Y" THEN
		PRINT "Please re-run this program with the desired parameters.  Aborting..."
		END
	END IF
	PRINT X$
	PRINT

'  Now we have the destination directory in TempDir$;
'  the CDROM's mounted in drives CD1$ and CD2$,
'  and we know that the PCBoard files will live in the PD$ directory

'  Now we need to make the DIR.LST file, the DLPATH.LST file, and the DIRxxx files.
'DIR.LST record format:
'  x:\path\dirfile (30)    x:\path\subdir (30)   description (35)   chr$(1)
'Example:
'F:\PCB\SIMT\DIR001            Q:\MSDOS\4DOS\                description                        x
'
'DLPATH.LST record format:
'  x:\path\subdir (var)    CRLF
'
'Each DIR file is generated from 00_INDEX.TXT located in each CDROM subdir
'
'Procedure:
'  Get subdir names of both volumes into array
'    Array: subdir name, subdir drive, xxx   <--- So we can sort later...
	PRINT "Reading subdirectory names into array..."
	NextDir% = 1
	CurrentDrive$ = CD1$
	IF CD1$ = CD2$ THEN
		PRINT "Please load SIMTEL1 into drive " + CD1$; ":, then press any key to continue: ";
		X$ = INPUT$(1)
	END IF
	GOSUB FillArray
	CurrentDrive$ = CD2$
	IF CD1$ = CD2$ THEN
		PRINT "Please load SIMTEL2 into drive " + CD1$; ":, then press any key to continue: ";
		X$ = INPUT$(1)
	END IF
	GOSUB FillArray

'  Now we have to sort the array into alphabetical order (OPTIONAL)
ReSort:
	PRINT "Sorting array...";
ReSort2:
	FOR p = 1 TO NextDir% - 1
		IF CAT(p) > CAT(p + 1) THEN SWAP CAT(p), CAT(p + 1): Change = Change + 1
	NEXT p
	IF Change <> 0 THEN
		Pass = Pass + 1
		LOCATE CSRLIN, 18
		PRINT Change; "swaps on pass"; Pass;
		Change = 0
		GOTO ReSort2
	END IF
	PRINT

'  Print the array on the screen
'        FOR p = 1 TO NextDir%
'                PRINT p, CAT(p)
'                IF p / 20 = INT(p / 20) THEN PRINT "[More] "; : x$ = INPUT$(1): PRINT
'        NEXT p
   
'  Now we can make the DIR.LST and DLPATH.LST files
	PRINT "Writing DIR.LST and DLPATH.LST files...";
	OPEN TempDir$ + "\DIR.LST" FOR OUTPUT AS 1
	OPEN TempDir$ + "\DLPATH.LST" FOR OUTPUT AS 2
	FOR p = 1 TO NextDir%
		DirFile$ = PD$ + "\DIR" + MID$(CAT(p), 14, 3)
		DirFile$ = DirFile$ + SPACE$(30 - LEN(DirFile$))
		SubPath$ = MID$(CAT(p), 13, 1) + ":\" + RTRIM$(LEFT$(CAT(p), 12))
		PRINT #2, SubPath$; "\"
		SubPath$ = SubPath$ + SPACE$(30 - LEN(SubPath$))
		Desc$ = LEFT$(CAT(p), 12) + SPACE$(23)
		PRINT #1, DirFile$; SubPath$; Desc$; CHR$(1);
	NEXT p
	CLOSE #1, #2
	PRINT

'  Now we can make the DIR file
	PRINT "Writing DIR file...";
	OPEN TempDir$ + "\DIR" FOR OUTPUT AS 1
	PRINT #1, "SimTel CDROM Library area directory"
	PRINT #1, ""
	IF NumCols% = 2 THEN
		NextCol% = NextDir% / 2
		IF NextCol% <> NextDir% * 2 THEN NextCol% = NextCol% + 1
		FOR p = 1 TO NextCol%
			LDir$ = STR$(p) + "   " + LEFT$(CAT(p), 12)
			IF NextCol% + p <= NextDir% THEN
				RDir$ = STR$(NextCol% + p) + "   " + LEFT$(CAT(NextCol% + p), 12)
			ELSE
				RDir$ = ""
			END IF
			PRINT #1, LDir$, TAB(40); RDir$
		NEXT p
	END IF
	IF NumCols% = 3 THEN
		NextCol% = NextDir% / 3
		IF NextCol% <> NextDir% * 3 THEN NextCol% = NextCol% + 1
		FOR p = 1 TO NextCol%
			LDir$ = STR$(p) + "   " + LEFT$(CAT(p), 12)
			MDir$ = STR$(NextCol% + p) + "   " + LEFT$(CAT(NextCol% + p), 12)
			IF NextCol% * 2 + p <= NextDir% THEN
				RDir$ = STR$(NextCol% * 2 + p) + "   " + LEFT$(CAT(NextCol% * 2 + p), 12)
			ELSE
				RDir$ = ""
			END IF
			PRINT #1, LDir$; TAB(27); MDir$; TAB(54); RDir$
		NEXT p
	END IF
      

	CLOSE #1
	PRINT

'  Now we can make the DIRxxx files
'  Make SubPath$ and OutFilxxx$, call MakeDirxxx for each array entry
	FOR p = 1 TO NextDir%
		SubPath$ = MID$(CAT(p), 13, 1) + ":\" + RTRIM$(LEFT$(CAT(p), 12))
		Outfilxxx$ = MID$(CAT(p), 14, 3)
		GOSUB MakeDirxxx
	NEXT p

	PRINT
	PRINT
	PRINT "File generation complete!"
	PRINT
	PRINT "You may now make any desired changes to the DIR files."
	PRINT "Use PCB2ASC and ASC2PCB to convert DIR.LST for editing, if desired."
	PRINT "Then, copy the DIRxxx, DLPATH.LST, and DIR.LST files to their"
	PRINT "appropriate areas ("; PD$; "), and test your PCBoard system's SimTel"
	PRINT "conference area."
	PRINT
	END



'  Enter with CurrentDrive$, NextDir%
'  Exit with array of subdirs, NextDir%=last
'  CAT(NextDir%)=Subdir(12)+Drive(1)+DirNumber(3)
'  Skip subdirectories that do not contain a 00_FILES.TXT file
FillArray:
	X$ = SubDir$(CurrentDrive$ + ":\*.*")
	IF X$ <> "." AND X$ <> ".." AND X$ <> "" AND LTRIM$(RTRIM$(X$)) <> "CDIX" THEN
		X$ = X$ + SPACE$(12 - LEN(X$))
		NextDir$ = LTRIM$(RTRIM$(STR$(NextDir%)))
		NextDir$ = STRING$(3 - LEN(NextDir$), "0") + NextDir$
		CAT(NextDir%) = X$ + CurrentDrive$ + NextDir$
		NextDir% = NextDir% + 1
	END IF
	IF X$ = "" THEN PRINT "No Subdirectories found!": RETURN
	DO
		X$ = SubDir$("")
		IF X$ = "." OR X$ = ".." OR X$ = "CDIX" THEN GOTO Skip
		IF X$ = "" THEN NextDir% = NextDir% - 1: EXIT DO
		X$ = X$ + SPACE$(12 - LEN(X$))
		NextDir$ = LTRIM$(RTRIM$(STR$(NextDir%)))
		NextDir$ = STRING$(3 - LEN(NextDir$), "0") + NextDir$
		CAT(NextDir%) = X$ + CurrentDrive$ + NextDir$
		NextDir% = NextDir% + 1
Skip:
	LOOP
	RETURN

       
MakeDirxxx:
	OPEN SubPath$ + "\00_INDEX.TXT" FOR INPUT AS 1
	OPEN TempDir$ + "\DIR" + Outfilxxx$ FOR OUTPUT AS 2
ReMakeDirxxx:
	WHILE NOT EOF(1)
		LINE INPUT #1, a$
		IF LEN(a$) > 80 THEN
			CLOSE #1, #2
			PRINT
			PRINT SubPath$; " is a unix-format file!  Fixing...  ";
			OPEN SubPath$ + "\00_INDEX.TXT" FOR BINARY AS 1
			X& = LOF(1)
			OPEN TempDir$ + "\TMP.$$$" FOR OUTPUT AS 2
			DO WHILE X& >= 1000
				GET #1, , a$
				X& = X& - LEN(a$)
				q = -1
ReDeLF:                           
				q = INSTR(q + 2, a$, CHR$(10))
				IF q <> 0 THEN
					IF MID$(a$, q - 1, 1) <> CHR$(&HD) THEN a$ = LEFT$(a$, q - 1) + CHR$(&HD) + MID$(a$, q): GOTO ReDeLF
				END IF
				PRINT #2, a$;
			LOOP
			CLOSE #1, #2
			PRINT "Fixed."
			PRINT "Resuming generation..."
			OPEN TempDir$ + "\TMP.$$$" FOR INPUT AS 1
			OPEN TempDir$ + "\DIR" + Outfilxxx$ FOR OUTPUT AS 2
			FixedDir% = 1
			GOTO ReMakeDirxxx
		END IF
		IF LEFT$(a$, 14) = STRING$(14, "=") THEN GOTO GotStart
	WEND
	PRINT "Error.  Rule line missing in "; SubPath$; ".  Improper 00_INDEX.TXT file format, aborting..."
	CLOSE
	RETURN

GotStart:
	PRINT #2, "Filename       Size      Date    Description of File Contents"
	PRINT #2, "============ ========  ========  ============================================"

	WHILE NOT EOF(1)
		LINE INPUT #1, a$
		O$ = UCASE$(LEFT$(a$, 13)) + MID$(a$, 16, 10) + MID$(a$, 28, 2) + "-" + MID$(a$, 30, 2) + "-" + MID$(a$, 26, 2) + "  " + MID$(a$, 34)
		PRINT #2, O$
	WEND
	CLOSE
	IF FixedDir% = 1 THEN FixedDir% = 0: KILL TempDir$ + "\TMP.$$$"
	LOCATE CSRLIN, 1
	PRINT "DIR" + Outfilxxx$; " output file successfully generated.";
	RETURN

SUB GetFile (FileSpec$, FileName$, FileType) STATIC
	DIM dta AS STRING * 44, Regs AS RegTypeX
	Null$ = CHR$(0)
     '-----  Set up our own DTA so we don't destroy COMMAND$
	Regs.ax = SetDTA                    'Set DTA function
	Regs.dx = VARPTR(dta)               'DS:DX points to our DTA
	Regs.ds = -1                        'Use current value for DS
	INTERRUPTX DOS, Regs, Regs          'Do the interrupt
     '-----  Check to see if this is First or Next
	IF LEN(FileSpec$) THEN              'FileSpec$ isn't null, so
					    'FindFirst
	   FileSpecZ$ = FileSpec$ + Null$   'Make FileSpec$ into an ASCIIZ
					    'string
	   Regs.ax = FindFirst              'Perform a FindFirst
	   Regs.cx = &H10                   'Only look for normal files
	   Regs.dx = SADD(FileSpecZ$)       'DS:DX points to ASCIIZ file
	   Regs.ds = -1                     'Use current DS
	ELSE                                'We have a null FileSpec$,
	   Regs.ax = FindNext               'so FindNext
	END IF
	INTERRUPTX DOS, Regs, Regs          'Do the interrupt
     '-----  Return file name or null
	IF Regs.flags AND 1 THEN            'No files found
	   FileName$ = ""                        'Return null string
	ELSE
	   Null = INSTR(31, dta, Null$)     'Get the filename found
	   FileName$ = MID$(dta, 31, Null - 31)  'It's an ASCIIZ string starting
	END IF                              'at offset 30 of the DTA
	FileType = ASC(MID$(dta, 22, 1))
END SUB

FUNCTION SubDir$ (FileSpec$)
	DO
		GetFile FileSpec$, FileName$, FileType
		FileSpec$ = ""
	LOOP UNTIL FileName$ = "" OR FileType = 16
	SubDir$ = FileName$
END FUNCTION

