/*
 * File......: EXIST.PRG
 * Author....: Steve Kolterman
 * CIS ID....: 76320,37
 * Date......: $Date:   28 Sep 1992 01:09:44  $
 * Revision..: $Revision:   1.3  $
 * Log file..: $Logfile:   C:/nanfor/src/exist.prv  $
 * 
 * This is an original work by Steve Kolterman and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log:   C:/nanfor/src/exist.prv  $
 * 
 *    Rev 1.3   28 Sep 1992 01:09:44   GLENN
 * Steve Kolterman clarified documentation on ft_exist()'s utility on 
 * networks.
 * 
 *    Rev 1.2   15 Aug 1991 23:03:34   GLENN
 * Forest Belt proofread/edited/cleaned up doc
 * 
 *    Rev 1.1   14 Jun 1991 19:51:48   GLENN
 * Minor edit to file header
 * 
 *    Rev 1.0   01 Apr 1991 01:01:20   GLENN
 * Nanforum Toolkit
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *     FT_EXIST()
 *  $CATEGORY$
 *     Environment
 *  $ONELINER$
 *     Test for drive and/or subdir on SINGLE-USER systems only.
 *  $SYNTAX$
 *     FT_EXIST( <cDriveDir> ) -> lResult
 *  $ARGUMENTS$
 *     <cDriveDir> is a character string containing drive spec (with colon)
 *     or drive spec and path to and including subdirectory being tested
 *     for.  Do not include backslash after subdirectory.  If drive spec
 *     is not part of string, the current drive is tested.
 *  $RETURNS$
 *     <lResult>  as logical -
 *     .T. if drive exists, or subdirectory exists on specified drive
 *     .F. if drive or subdirectory does not exist
 *  $DESCRIPTION$
 *     FT_Exist() tests for the existence of a drive and/or subdirectory...
 *     on single-user systems ONLY.  You may get correct results on some
 *     networks under certain conditions, but this function is not capable
 *     of working reliably on networks.
 *  $EXAMPLES$
 *    IF FT_EXIST( "D:" )
 *       Qout("OK To Perform Operation On Drive D:") 
 *    ENDIF
 *  $END$
 */


/*   Pre-processor option:
 *
 *    #translate FT_EXIST(<drv>) => ;
 *         FILE((<drv>+IF(SUBS(<drv>,-1,1)=="\","","\")+"NUL"))
 *
 */


FUNCTION FT_EXIST( cDrvDir )
  // check for "\" passed; add if necessary
RETURN FILE(( cDrvDir + IF(SUBS( cDrvDir, -1, 1) == "\", "", "\" ) + "NUL" ) )

