/*****************************************************************************/
/*                THE FOLLOWING PROGRAM IS THE SOLE PROPERTY OF              */
/*                               RONALD Q. SMITH                             */
/*             CONTAINING HIS PROPRIETARY CONFIDENTIAL INFORMATION           */
/*                       COPYRIGHT RONALD Q. SMITH 1992 - 1995               */
/*****************************************************************************/

/* Global data definitions                                                   */

#include <ctype.h>   
#include <dos.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <clktyp.h>
#include <ioctl.h>

/*
PROGRAM:  CLKDEMO

CLKDEMO is used with CLOCK.SYS to provide a minimum set of control and
display functions for handling both the DOS realtime clock and the calendar
clock.  CLKDEMO is intended only to provide an example of a running program
that uses all of the APIs unique to CLOCK.SYS.

INTERFACE:
        CLKDEMO  [C=A|D|R|W] [/?]

If CLKDEMO is used with no operands it displays the current CONNECTED status
of CLOCK.SYS and the time as obtained from both the DOS clock and the calendar
clock.

Each of the arguments may appear in any order and as many times as desired
except /?.  When /? is encountered, the usage message is displayed and CLKDEMO
exits.  Each argument is a command and is processed as it is encountered.
Thus you may perform a sequence of functions with a single call.

        CLKDEMO C=W

Connects the two clocks for writes.  Any DOS call to change the date or time,
sets both clocks.

        CLKDEMO C=D

Disconnects the two clocks.  When the clocks are disconnected, any DOS call
to change the date or time, only sets the DOS clock.  The calendar clock is
unchanged.

        CLKDEMO C=R

Connects the two clocks for writes and periodic reads.  If more than 10
seconds have elapsed since the last time the time was accessed, the calendar
clock is read and the DOS clock is set to that value.

        CLKDEMO C=A

Connects the two clocks for all operations.  All reads and writes are
directed to the calendar clock.  This is not recommended for most systems.
Most calendar clocks are slow and only increment in whole seconds.

CLOCK /? displays the interface.  If /? appears anywhere on the command line,
all other arguments are ignored.
*/

/* Global variables                                                         */

int handle;

int main(int argc, unsigned char *argv[])

{

        struct CLOCK_DATA data;
        struct tm calendar_tm;
        int connected;
        struct time_zone *cur_zone;
        char *timebuf;
        time_t ltime;
        unsigned char *arg;
        int iarg;
        void usage(int status, unsigned char *arg);

/* Display copyright message                                                */

        printf("CLKDEMO %s copyright 1992 - 1995 Ronald Q. Smith\n",version);

/* process command line tokens                                              */

        iarg = 0;
        while(++iarg < argc)
        {
            arg = argv[iarg];
            switch (toupper(arg[0]))
            {
                default:
                    usage(1, arg);

                case 'C':   /* Set connection mode */
                    if (arg[1] != '=')
                        usage(1, arg);
                    switch(toupper(arg[2]))
                    {
                        default:
                            usage(1, arg);

                        case 'A':   /* Connect for all operations */
                            connected = 3;
                            break;

                        case 'D':   /* Disconnect */
                            connected = 0;
                            break;

                        case 'R':   /* Connect for periodic reads */
                            connected = 2;
                            break;

                        case 'W':   /* Connect for writes only */
                            connected = 1;
                            break;

                    } /* End switch(toupper(arg[2])) */

                    connec(&connected);
                    break;

                case '-':
                case '/':
                    usage(arg[1] != '?', arg);

            } /* end switch() */

        } /* end while to process command line tokens */

/* Display status.  Also get here if no operands.                           */

    clksta(&data);

    printf("\n      CLOCK.SYS version : %.6s\n"
           "             Clock type : %X - %s\n",
        data.vers, data.clock_type, clock_name[data.clock_type]);

    if (clock_kind[data.clock_type] == 1)
    {
        printf("       Base I/O address : %X\n",data.ct_1);
    }
    else if (clock_kind[data.clock_type] == 2)
    {
        printf("    Base memory segment : %X\n"
               "            Read offset : %X\n"
               "         Write-0 offset : %X\n"
               "         Write-1 offset : %X\n",
            data.ct_1, data.ct_2, data.ct_3, data.ct_4);
    }
    else if (clock_kind[data.clock_type] == 3)
    {
        printf("              Base year : %d\n", data.ct_1);
    }

    printf("             Connection : %s\n",
        !data.connected ? "Disconnected" : ((data.connected == 1) ?
        "Writes only" : ((data.connected == 2) ? "Writes and periodic reads" :
        "All writes and reads")));

    cur_zone = data.mode.day_light ? &data.daylight : &data.standard;
    if (cur_zone->zone[0] && (cur_zone->zone[0] != ' '))
    {
        if (cur_zone->offs.hour < 0)
        {
            cur_zone->offs.minute = -cur_zone->offs.minute;
            cur_zone->offs.second = -cur_zone->offs.second;
        }

        printf("              Time zone : %.32s\n"
               "       Time zone offset : %.2hd:%.2hd:%.2hd\n",
               cur_zone->zone, cur_zone->offs.hour, cur_zone->offs.minute,
               cur_zone->offs.second);
    }

    if (data.mode.disabl || data.mode.chk_back || data.mode.chk_forw)
        printf("           Time changes : %s%s%s%s%s%s\n",
            data.mode.disabl ? "Disabled" : "", (data.mode.disabl &&
            (data.mode.chk_back || data.mode.chk_forw)) ? ", " : "",
            (data.mode.chk_back || data.mode.chk_forw) ? "Limited " : "",
            data.mode.chk_back ? "backward" : "",
            (data.mode.chk_back && data.mode.chk_forw) ? ", " : "",
            data.mode.chk_forw ? "forward" : "");

    if (data.mode.chk_back)
        printf("         Backward limit : -%.2d:%.2d:%.2d\n",
            data.rules.back.hour, data.rules.back.minute,
            data.rules.back.second);

    if (data.mode.chk_forw)
        printf("          Forward limit : +%.2d:%.2d:%.2d\n",
            data.rules.forward.hour, data.rules.forward.minute,
            data.rules.forward.second);

    if (data.mode.disp_tim)
        printf("Continuous time display : x=%d, y=%d, attribute=%.2X, "
            "%s-hour\n", data.display.x, data.display.y,
            data.display.attribute, data.mode.disp_24 ? "24" : "12");

    if (data.mode.pw_ena)
        printf("    Password protection : Enabled\n");

    calendar_tm.tm_sec = data.cal_time.time.second;
    calendar_tm.tm_min = data.cal_time.time.minute;
    calendar_tm.tm_hour = data.cal_time.time.hour;
    calendar_tm.tm_mday = data.cal_time.day;
    calendar_tm.tm_mon = data.cal_time.month - 1;
    calendar_tm.tm_year = data.cal_time.year - 1900;
    calendar_tm.tm_wday = 0;
    timebuf = asctime(&calendar_tm);

    printf("          Calendar time : %s",&timebuf[4]);

    time(&ltime);
    timebuf=ctime(&ltime);
    printf("               DOS time : %s",&timebuf[4]);

        return(0);
}

/*
PROCEDURE: usage

"usage" displays the interface to CLKDEMO.  It is called when the /? option is
used on the command line or when any invalid argument appears on the command
line.  A program exit with a code of status occurs.
*/

void usage(int status, unsigned char *arg)

{
        if (status)
            printf("\nIncorrect argument format: %s\n", arg);

        printf("\nCLKDEMO usage:\n\n"
               "          CLKDEMO [C=A|D|R|W] [/?]\n\n"
               "CLKDEMO     - displays the connected status and \n"
               "              the current DOS and calendar clock times.\n"
               "CLKDEMO C=A - Connects the DOS and calendar clocks\n"
               "              for all operations.\n"
               "CLKDEMO C=D - Disconnects the clocks.\n"
               "CLKDEMO C=R - Connects the DOS and calendar clocks for\n"
               "              writes and periodic reads.\n"
               "CLKDEMO C=W - Connects the DOS and calendard clocks for"
               " writes.\n"
               "CLKDEMO /? - displays this message.\n");
        exit(status);
}

/*****************************************************************************/
/*                THE PRECEDING PROGRAM IS THE SOLE PROPERTY OF              */
/*                               RONALD Q. SMITH                             */
/*             CONTAINING HIS PROPRIETARY CONFIDENTIAL INFORMATION           */
/*                       COPYRIGHT RONALD Q. SMITH 1992 - 1995               */
/*****************************************************************************/
