		ideal

		include	"PhilTime.I"

textAttribute   equ     (blinking*128+backgroundColor*16+forgroundColor)

if		redrawTime GT firstRedraw
startingCounter	equ	(redrawTime-firstRedraw)
else
startingCounter	equ	0
endif

if		backgroundColor GT 7
		display "Illegal background color"
err
endif

segment		displayTime
                assume  cs:displayTime

label		displayFirst	byte

oldTickHandler	dd	?
ticksSinceDraw  dw      startingCounter
ticksPerMinute  dw      1093
clockPosition   dd      0b800h:150
biosDataSegment	dw	0040h

proc		tickHandler	far
		pushf
		sti
                push    ax
                push    bx
                push    dx
		push	di
		push	ds
		push	es

		push	cs
		pop	ds
                assume  ds:displayTime

                ;see if enough time has passed
                inc     [ticksSinceDraw]
                cmp     [ticksSinceDraw],redrawTime
                jb      done
                mov     [ticksSinceDraw],0

                mov     ds,[biosDataSegment]
                assume  ds:nothing

                ;see if a display is required
if		watchScrollLock
                test    [byte ptr ds:17h],10h
		jnz	done
endif
if		watchVideoMode
                mov     al,[ds:49h]
                cmp     al,2
		jb	done
                cmp     al,3
		ja	done
endif

		;update the screen
                mov     dx,[ds:6ch]     ;bx:dx == number of clock
                mov     bx,[ds:6eh]     ;ticks since midnight
                les     di,[clockPosition]
if		twelveHourTime
		add	bl,12
adjust12:	cmp	bl,12
		jbe	adjusted12
		sub	bl,12
		jmp	adjust12
adjusted12:
endif
                call    printBL
                mov     al,':'
                stosw
                mov     ax,dx
                xor     dx,dx
                div     [ticksPerMinute]
                mov     bl,al
                call    printBL

if		NOT leadingZero
		cmp	[byte ptr es:di-10],'0'
		jne	noLeadingZero
		mov	[byte ptr es:di-10],' '
noLeadingZero:
endif

done:
		pop	es
		pop	ds
		pop	di
                pop     dx
                pop     bx
                pop     ax
		popf
		jmp	[cs:oldTickHandler]
endp		tickHandler	

;       IN: BL is the number (00-99) to be printed
;       IN: ES:DI is the position to print to
;       OUT: ES:DI is advanced 2 spaces
;       OUT: AH == textAttribute
;       OUT: AL is modified
;       OUT: BL is modified
proc            printBL
                mov     ax,textAttribute*100h+'0'
setTensDigit:   cmp     bl,10
                jb      drawTensDigit
                sub     bl,10
                inc     al
                jmp     setTensDigit
drawTensDigit:  stosw
                mov     al,'0'
                add     al,bl
                stosw
                ret
endp            printBL

                label           displayLast     byte

ends		displayTime

		public	displayFirst,displayLast,tickHandler,oldTickHandler

		end
