	SET TTHRU OFF		; Must be 1st line to suppress typethrough
	ON ESCAPE GOSUB Escape	; Exit if ESC
;****	TRACE ON		; Debugging
;
; ----- COM-AND INSTALL script for automatic execution
;	Commenced: 10/90 R.McG
; -----------------------------------------------------------------------
;	Purpose:
;	   This script, named INSTALL.CMD, is executed automatically by
;	COM-AND after the load-time creation of the DFT file.  It may be
;	manually invoked through the F2 window at any time, as well.
; -----------------------------------------------------------------------
;
;	Initialization
;
	LEGEND "Welcome..."
	SET RDISP OFF		; Ignore received chars
;
;	Establish a DWINDOW, and change the text display to window default.
;	.. Save the previous text display attribute, for restoration later.
;
	DWIND 1,2 22,78 	; Establish scrolling region
	N99 = "_TEXT"           ; Save original text attr
	SET TEXT "_DEFA"        ; Set text attr
;
;	Perform tasks
;
Again:
	GOSUB Intro		; Paint intro screen
	GOSUB Set		; Look at autoexec file
	GOSUB Port		; Select port for default use
	GOSUB Speed		; Select speed for default use
	GOSUB Type		; Select modem type
	GOSUB Update		; Ending "do it again?" query
	IF FAILED GOTO Again
;
;	Save current settings
;
	SET TEXT N99		; Reset text attr for store
	STORE DEFAULT		; Update defaults
	GOTO Almost		; Skip Escape tests
;
;	Escape was hit - if runtime invocation, do the CODA.
;
Escape:
	IF STRCMP "_RUNT" "NO" GOTO Exit
;
;	Last words
;
Almost:
	ON ESCAPE GOSUB EXIT	; New ESC processor
	SET TEXT "_DEFA"        ; Set text attr
	GOSUB Coda		; Ending last words
;
;	Exit the script
;
Exit:
	SET TEXT N99		; Reset text attr finally
	DWINDOW CLEAR		; Clear any scrolling region
	CLEAR			; Clear entire text window
	EXIT
;
; ----- Subroutine: Intro -> introductory screen
;	.. note: BOX instead of WOPEN is used - allowing global ESC
;
Intro:
	BOX   0,0 23,79 (default)
	ATSAY 0,2 (default)   " INSTALL intro "
	ATSAY 23,25 (default) " Press ESC to cancel INSTALL "
	LOCATE 2,2

	MESS "                                  "
	MESS "                                                "
	MESS "                                                  "
	MESS "                                      "
	MESS "                                                   "
	MESS "                                                   "
	MESS "                                       "
	MESS " "
;
;	Add introductory text
;
	IF STRCMP "_RUNT" "YES"
	   MESS "COM-AND has created a file named COM-AND.DFT for default values.  This means"
	   MESS "that this is the first time COM-AND has executed under these conditions.  A"
	   MESS "script (INSTALL.CMD) included with the COM-AND release will help install the"
	   MESS "settings you will use in this and subsequent COM-AND sessions."
	ELSE
	   MESS "You have invoked INSTALL.CMD to change COM-AND's default settings.  INSTALL"
	   MESS "simplifies 1) adding/changing a COM-AND= environment variable to the AUTO-"
	   MESS "EXEC.BAT, 2) setting modem port and type, and 3) setting operating values"
	   MESS "for this and subsequent COM-AND sessions."
	ENDIF
	MESS " "
	MESS "In order to use this script, you will need to know a few facts about your PC"
	MESS "and its configuration.  You will need to know the boot drive, the modem port"
	MESS "and the type of modem you will be using.  This script will help you decide"
	MESS "these matters (as much as it is able) and change the DFT file accordingly."
	MESS " "
	MESS "You may skip this installation script by pressing ESC now (or anytime during"
	MESS "the installation).  Press any other key to continue..."
;
;	Wait for a keypress
;
	KEYGET S0		; Wait for it
	RETURN			; And we're done
;
; ----- Subroutine: Set -> Inform of update autoexec.bat with COM-AND=
;
Set:
	ENVIRON S0 "COM-AND="   ; Look for pre-existing COM-AND= environ var
	IF FOUND GOTO Already	; If it exists, ask if its to be changed
;
;	Paint a screen
;
	BOX   0,0 23,79 (default)
	ATSAY 0,2 (default)   " Boot config "
	ATSAY 23,25 (default) " Press ESC to cancel INSTALL "
	LOCATE 2,2

	MESS "COM-AND works best if a single subdirectory is used for COM-AND files and"
	MESS "scripts.  COM-AND is executing currently from the subdirectory: "
	MESS " "
	MESS "_SUBD"
	MESS " "
	MESS "COM-AND looks for files and scripts 1) in the subdirectory it finds at run-"
	MESS "time, and if not there 2) in the subdirectory pointed out by the environment"
	MESS "variable 'COM-AND='.  If COM-AND's working subdirectory is indicated by that"
	MESS "environment variable, COM-AND may be executed in ANY subdirectory and still"
	MESS "find scripts and files."
	MESS " "
	MESS "You may use this script to update your AUTOEXEC.BAT file to SET the environ-"
	MESS "ment variable, or skip this step."
	MESS " "
	MESS "Select S)kip, U)pdate, or ESCape (escape cancels this script): "
;
;	Wait for a keypress
;
	GET S0 1		; Wait for a char
	SWITCH S0		; Switch on the return
	   CASE "S"             ; S)kip
	   ENDCASE
	   CASE "U"             ; U)pdate
		GOSUB Autoexec	; Do the update
	   ENDCASE
	   DEFAULT		; Any other selection
		SOUND 100,100
		GOTO Set
	   ENDCASE
	ENDSWITCH
	RETURN			; And continue
;
; ----- Error:	Open a window, display a message, and exit
;	S0 passes the error message
;
Error:
	WOPEN 10,10,12,70 (contrast)
	ATSAY 10,12 (contrast) " Error "
	ATSAY 11,12 (contrast) S0(0:55); Max msg width 55 chars
	ATSAY 12,26 (contrast) " Press any key to continue "
	;
	;    Wait a keypress
	;
	KEYGET S0			; Wait for any key
	WCLOSE
	RETURN
;
; ----- Subroutine: Autoexec -> update autoexec.bat with COM-AND=
;
Autoexec:
	BOX   0,0 23,79 (default)
	ATSAY 0,2 (default)   " AUTOEXEC update "
	ATSAY 23,25 (default) " Press ESC to cancel INSTALL "
	LOCATE 2,2

	MESS "Please enter the drive letter (A,B,C...) from which your PC is booted.  If"
	MESS "a diskette is used for boot, please see that the boot disk is in that drive."
	MESS " "
	MESS "Select drive: A,B,C...: "
;
;	Wait for a keypress
;
	GET S0 1		; Wait for a char
	IF NOT ALPHA S0
	   SOUND 100,100
	   GOTO Autoexec
	   ENDIF
;
;	Look for an autoexec.bat file on that drive
;
	S1 = S0*":\AUTOEXEC.BAT"
	IF ISFILE S1 GOTO Auto200
;
;	Missing autoexec.bat
;
	MESS " "
	MESS "No AUTOEXEC.BAT file was found on the indicated drive.  One will be created"
	MESS "if you wish, or you may try another drive."
	MESS " "
	MESS "Select C)reate, A)nother-drive, or ESCape (escape cancels this script): "
;
;	Wait for a keypress
;
	GET S0 1		; Wait for a char
	SWITCH S0		; Switch on the return
	   CASE "C"             ; C)reate
		GOTO AUTO100
	   ENDCASE
	   CASE "A"             ; A)nother
		GOTO Autoexec	; Do it again
	   ENDCASE
	   DEFAULT		; Any other selection
		SOUND 100,100
		GOTO Autoexec
	   ENDCASE
	ENDSWITCH
;
;	Create AUTOEXEC... get parameter for the subdirectory
;
Auto100:
	GOSUB GetSetVal
;
;	Create it
;
	FOPENO S1 TEXT		; Open for output
	IF FAILED		; If open failed
	   S0 = "Error opening "*S1
	   GOSUB Error
	   GOTO Autoexec
	   ENDIF
	WRITE "SET COM-AND="*S0*"!"
	WRITE "DATE!"
	WRITE "TIME!"
	WRITE "^Z"              ; ASCII EOF
	FCLOSEO 		; Close it
	RETURN			; And we're done creating it
;
;	AUTOEXEC exists... append SET COM-AND= to the file
;	.. note: I don't test for the presence of SHELL or another COM-AND=
;
Auto200:
	GOSUB GetSetVal
;
;	Create it
;
	FOPENO S1 TEXT APPEND	; Open for output - appending at EOF
	IF FAILED		; If open failed
	   S0 = "Error opening "*S1
	   GOSUB Error
	   GOTO Autoexec
	   ENDIF
	WRITE "SET COM-AND="*S0*"!"
	WRITE "^Z"              ; ASCII EOF
	FCLOSEO 		; Close it
	RETURN			; And we're done creating it
;
;	Subroutine: GetSETVal (S0 returns value)
;
GetSetVal:
	MESS "COM-AND is executing currently from the subdirectory: "
	MESS " "
	MESS "_SUBD"
	MESS " "
	MESS "Please enter the subdirectory you will use for COM-AND.  If the current sub-"
	MESS "directory is the one, just press return.  Otherwise enter the new subdirec-"
	MESS "tory as d:\path (d being drive letter, and path being fully qualified path)."
	MESS " "
	MESS "Enter COM-AND's working subdirectory (or press CR): "
;
;	Read working subdir
;
	GET S0 76		; Read response
	IF NULL S0 S0="_SUBD"   ; Make default condition
	RETURN
;
; ----- Subroutine: Already -> There is already a SET COM-AND=
;
Already:
	ENVIRON S0 "COM-AND="   ; Look for pre-existing COM-AND= environ var
	IF NOT FOUND GOTO Set	; Skip if not found
	LJ S0			; Left justify
	S0 = S0&""              ; Trim trailing blanks
	UPPER S0		; Force upper case
	S1 = "_SUBD"&""         ; Read current subdir
	UPPER S1		; ..
;
;	If current subdir = environment variable, no action.
;
	IF STRCMP S0 S1 RETURN	; Return if identical
	IF NOT STRCMP S0(1:1) ":" and STRCMP S1(2:79) S0 RETURN
;
;	Paint a screen
;
	BOX   0,0 23,79 (default)
	ATSAY 0,2 (default)   " Boot config "
	ATSAY 23,25 (default) " Press ESC to cancel INSTALL "
	LOCATE 2,2

	PRESERVE S0
	PRESERVE S1
	MESS "You have already declared a subdirectory for COM-AND, through the AUTO-"
	MESS "EXEC.BAT environment variable COM-AND.  It is:"
	MESS " "
	MESS S0
	MESS " "
	MESS "You are executing COM-AND now from the subdirectory:"
	MESS " "
	MESS S1
	MESS " "
	MESS "You may use this script to change your AUTOEXEC.BAT file to SET the environ-"
	MESS "ment variable, or skip this step."
	MESS " "
	MESS "Select S)kip, C)hange, or ESCape (escape cancels this script): "
;
;	Wait for a keypress
;
	GET S0 1		; Wait for a char
	SWITCH S0		; Switch on the return
	   CASE "S"             ; S)kip
	   ENDCASE
	   CASE "C"             ; U)pdate
		GOSUB Autoexec	; Do the update
	   ENDCASE
	   DEFAULT		; Any other selection
		SOUND 100,100
		GOTO Already
	   ENDCASE
	ENDSWITCH
	RETURN			; And continue
;
; ----- Subroutine: Port -> Select the port we'll use
;
Port:
	BOX   0,0 23,79 (default)
	ATSAY 0,2 (default)   " Port selection "
	ATSAY 23,25 (default) " Press ESC to cancel INSTALL "
	LOCATE 2,2

	MESS "COM-AND is defaulted to "*"_PARM"(11:14)*" for serial communications."
	MESS " "
	MESS "This may or may not be right for your PC.  At this point, you may skip"
	MESS "changing the setting, select another serial port for the default, and"
	MESS "optionally find ports on your machine for possible choices. "
	MESS " "
	MESS "Select S)kip, F)ind, or numeric port number (1,2,3,4): "
	CURSOR N1,N2		; Save current cursor

	MESS " "
	MESS "Alt-P may be used at any time in CRT mode to change this default."
	CURSOR N3,N4		; Save cursor here, too
;
;	Wait for a keypress
;
Port100:
	ATSAY N1,N2 (default) " "
	LOCATE N1,N2		; Relocate cursor
	GET S0 1		; Wait for a char
	SWITCH S0		; Switch on the return
	   CASE "S"             ; S)kip
	   ENDCASE
	   CASE "F"             ; Find
		LOCATE N3,N4	; Relocate cursor
		GOSUB Survey	; Do the survey
		GOTO Port100	; And ask again
	   ENDCASE
	   CASE "1"             ; COM1
		SET PORT COM1	; Do the update
	   ENDCASE
	   CASE "2"             ; COM2
		SET PORT COM2	; Do the update
	   ENDCASE
	   CASE "3"             ; COM3
		SET PORT COM3	; Do the update
	   ENDCASE
	   CASE "4"             ; COM4
		SET PORT COM4	; Do the update
	   ENDCASE
	   DEFAULT		; Any other selection
		SOUND 100,100
		GOTO Port
	   ENDCASE
	ENDSWITCH
	RETURN			; And continue
;
; ----- Test existing ports...
;
Survey:
	COMPARMS S0		; Get current settings
	S0 = S0(11:14)		; Save original value
	N0 = 0			; Make a counter of ports found
	MESS " "                ; new line
	SET PORT COM1
	IF "_UART" GE 0
	   MESS " I believe COM1 is a serial port"
	   INC N0
	   ENDIF
	SET PORT COM2
	IF "_UART" GE 0
	   MESS " I believe COM2 is a serial port"
	   INC N0
	   ENDIF
	SET PORT COM3
	IF "_UART" GE 0
	   MESS " I believe COM3 is a serial port"
	   INC N0
	   ENDIF
	SET PORT COM4
	IF "_UART" GE 0
	   MESS " I believe COM4 is a serial port"
	   INC N0
	   ENDIF
	SET PORT S0		; Restore default

	IF N0 eq 0 MESS " I can't find serial ports on COM1/2/3 or 4"
	RETURN
;
; ----- Subroutine: Speed -> Select the default speed we'll use
;
Speed:
	BOX   0,0 23,79 (default)
	ATSAY 0,2 (default)   " Speed selection "
	ATSAY 23,25 (default) " Press ESC to cancel INSTALL "
	LOCATE 2,2

	MESS "The current serial port "*"_PARM"(11:14)*" is defaulted to "*"_PARM"(0:3)*" bps."
	MESS " "
	MESS "This may or may not be right the best speed for your modem.  Please select"
	MESS "the HIGHEST speed your modem is able to use.  As before, you may skip this"
	MESS "step if you wish."
	MESS " "
	MESS "Select S)kip, or from below (1 through 8): "
	CURSOR N1,N2

	MESS " "
	MESS "    1)   300 bps"
	MESS "    2)  1200 bps"
	MESS "    3)  2400 bps"
	MESS "    4)  9600 bps"
	MESS "    5) 14.4K bps"
	MESS "    6) 19.2K bps"
	MESS "    7) 38.4K bps"
	MESS "    8) 57.6K bps"

	MESS " "
	MESS "Alt-P may be used at any time in CRT mode to change this default."
;
;	Wait for a keypress
;
	LOCATE N1,N2		; Relocate cursor
	GET S0 1		; Wait for a char
	SWITCH S0		; Switch on the return
	   CASE "S"             ; Skip
	   ENDCASE
	   CASE "1"
		SET BAUD 300	; Set speed
	   ENDCASE
	   CASE "2"
		SET BAUD 1200	; Set speed
	   ENDCASE
	   CASE "3"
		SET BAUD 2400	; Set speed
	   ENDCASE
	   CASE "4"
		SET RTSF ON	; Enable RTS/CTS flow control
		SET BAUD 9600	; Set speed
	   ENDCASE
	   CASE "5"
		SET RTSF ON	; Enable RTS/CTS flow control
		SET BAUD 14.4	; Set speed
	   ENDCASE
	   CASE "6"
		SET RTSF ON	; Enable RTS/CTS flow control
		SET BAUD 19.2	; Set speed
	   ENDCASE
	   CASE "7"
		SET RTSF ON	; Enable RTS/CTS flow control
		SET BAUD 38.4	; Set speed
	   ENDCASE
	   CASE "8"
		SET RTSF ON	; Enable RTS/CTS flow control
		SET BAUD 57.6	; Set speed
	   ENDCASE
	   DEFAULT		; Any other selection
		SOUND 100,100
		GOTO Speed
	   ENDCASE
	ENDSWITCH
	RETURN			; And continue
;
; ----- Subroutine: Type -> Select the modem type we'll use
;
Type:
	BOX   0,0 23,79 (default)
	ATSAY 0,2 (default)   " Modem type "
	ATSAY 23,25 (default) " Press ESC to cancel INSTALL "
	LOCATE 2,2

	MESS "When COM-AND created its defaults, modem commands were set to simple Hayes"
	MESS "(tm) commands.  You may select from one of the following modem types for"
	MESS "default values.  [This list is hardly comprehensive.  If your particular"
	MESS "modem is not listed, or you wish to change the modem commands later, use"
	MESS "setup (Alt-S) manually once in COM-AND, and refer to your modem manual.]"
	MESS " "
	MESS "Select S)kip, or from below (0 through 9, or a/z): "
	CURSOR N1,N2

	MESS " "
	MESS "1) Microcom 9624c                      a) USR Courier V.32"
	MESS "2) Microcom 3296/c                     b) USR Courier V.32bix (FAX)"
	MESS "3) Microcom AX 2400c                   c) USR Dual Standard"
	MESS "4) Everex 2400 internal                d) Intel 14.4e and 400"
	MESS "5) Everex, Evercom 24+ (MNP)           "
	MESS "6) Leading Edge 2400B 1/2 internal     "
	MESS "7) Prac. Periph. 2400 1/2 internal     "
	MESS "8) Prac. Periph. 9600 SA               "
	MESS "9) Zoom VFX V.32bis/V.42bis            "
	MESS "0) BocaModem 14.4k V.32bis             "
	MESS "---------------------------------------------------------------------"
	MESS "y) Hayes compatible 2400 bps & below (Hayes)  } Use these settings if"
	MESS "z) Generic 9600 bps & above                   } you're not sure..."
;
;	Wait for a keypress
;
	LOCATE N1,N2		; Relocate cursor
	GET S0 1		; Wait for a char
	IF FIND S0 "s" RETURN   ; Skip case

	SET DPREF "ATDT"        ; Default value
	SET DSUFF "!"           ; Default value
	SET MCONN "CONNECT"     ; Default value
	SET MHANG "ATH0!"       ; Default value
	SET SOFT ON		; Default value
	SET RTSF ON		; Enable RTS/CTS flow control for dft
	SET CDRES ON		; Default value
	SWITCH S0		; Switch on the return
	   CASE "1"             ; MICROCOM 9624c
		SET MINIT "ATE1\C1\G0\J1\K5\N3\Q0&T5\V1V1\X1S0=0!"
		SET DPREF "AT\N3DT"
	   ENDCASE
	   CASE "2"             ; MICROCOM 3296c                JP: 7/92
		SET MINIT "~~~~AT\Q3\N2%C0%U!"
		SET DPREF "AT\N2DT"
	   ENDCASE
	   CASE "3"             ; MICROCOM AX 2400c             DS: 11/92
		SET MINIT "AT E1\J0 \Q3 \N3 &C1 &D2 S7=54 ^M"
		SET DPREF "AT\N2DT"
	   ENDCASE
	   CASE "4"             ; Everex 2400 internal
		SET MINIT "AT&D2S7=60!"
		SET RTSF OFF	; Disable RTS/CTS flow control
	   ENDCASE
	   CASE "5"             ; Everex, Evercom 24+ (MNP)
		SET MINIT "AT\N3\Q1\K5\V1\X1\C1!"
		SET DPREF "AT\N3DT"
		SET RTSF OFF	; Disable RTS/CTS flow control
	   ENDCASE
	   CASE "6"             ; Leading Edge 2400B half-size internal
		SET MINIT "ATS7=60X3!"
		SET RTSF OFF	; Disable RTS/CTS flow control
	   ENDCASE
	   CASE "7"             ; Practical Peripherals 2400 half-size internal
		SET MINIT "AT&C1&D2L0X3!"
		SET RTSF OFF	; Disable RTS/CTS flow control
	   ENDCASE
	   CASE "8"             ; PPI 9600 SA                   MT: 7/92
		SET MINIT "AT&F&C1&D2S10=8S12=25S25=2S37=9S38=2!~~AT&B1!"
	   ENDCASE
	   CASE "9"             ; Zoom VFX V32bis/V42bix        BB: 7/92
	   ;*** SET MINIT "AT&F&C1&D2W2S95=3!"
		SET MINIT "AT&F!~~~~AT&C1&D2S0=1S9=15S95=3!"    BB: 11/92
	   ENDCASE
	   CASE "0"             ; BocaModem 14.4k V.32bis       MT: 7/92
		SET MINIT "AT&F~&C1&D2W2S7=60S11=55!"
	   ENDCASE
	   CASE "a"             ; USR Courier V.32              MT: 7/92
		SET MINIT "AT&F&B1&R2S11=55S28=4X6S0=0!"
	   ENDCASE
	   CASE "b"             ; USR Courier V.32bix (FAX)     MT: 7/92
		SET MINIT "AT&F!~~~ATC1E1Q0V1&A3&B1&H1&K3&R2!"
		SET FLOW OFF
	   ENDCASE
	   CASE "c"             ; USR Dual Standard             JA: 11/92
		SET MINIT "AT&Z!~~ATB0C1E1F1M1Q0V1X6&A3&B1&H3&R2&S1!"
	   ENDCASE
	   CASE "d"             ; Intel 14.4e and 400           DS: 11/92
		SET MINIT "AT&F!~~~AT&T5~S11=60!"
	   ENDCASE
	   CASE "y"             ; Hayes compatible 2400 and below
		SET MINIT "ATE0 S7=250 V1 X0 S11=55!"
		SET RTSF OFF	; Disable RTS/CTS flow control
	   ENDCASE
	   CASE "z"             ; Generic 9600 and above
		SET MINIT "AT&F2&C1&D2&S7=60S11=55!"
		SET RTSF ON	; Enable RTS/CTS flow control
	   ENDCASE
	   DEFAULT		; Any other selection
		SOUND 100,100
		GOTO Type
	   ENDCASE
	ENDSWITCH
;
;	Transmit the new modem init
;
	WOPEN 10,10,12,70 (defa)
	ATSAY 10,12 (defa) " "*S10&" "
	ATSAY 11,12 (defa) "Initializing modem..."

	TRANS "_MESC"                   ; Transmit modem esc
	TRANS "_MINI"                   ; Transmit modem init string
	WCLOSE
	RETURN			; And continue
;
; ----- Subroutine: Update -> update the default file
;
Update:
	BOX   0,0 23,79 (default)
	ATSAY 0,2 (default)   " Update "
	ATSAY 23,25 (default) " Press ESC to cancel INSTALL "
	LOCATE 2,2

	MESS "The INSTALL script is now complete.  You may press ESC at this point to can-"
	MESS "cel any settings you have made, and later invoke INSTALL with F2 (Scripts)."
	MESS " "
	MESS "You may run through the installation again if you wish.  Otherwise, changes"
	MESS "made here will be saved for COM-AND this session and in future sesions."
	MESS " "
	MESS "Select A)gain, U)pdate, or ESCape (escape cancels this script): "
;
;	Wait for a keypress
;
	GET S0 1		; Wait for a char
	SWITCH S0		; Switch on the return
	   CASE "A"             ; A)gain
		SET SUCCESS OFF
	   ENDCASE
	   CASE "U"             ; U)pdate
		SET SUCCESS ON
	   ENDCASE
	   DEFAULT		; Any other selection
		SOUND 100,100
		GOTO Update
	   ENDCASE
	ENDSWITCH
	RETURN			; And continue
;
; ----- Subroutine: Coda -> last words.
;
Coda:
	BOX   0,0 23,79 (default)
	ATSAY 0,2 (default)   " INSTALL Coda "
	LOCATE 2,2

	MESS "The following manual keys may be used to set default values for COM-AND:"
	MESS " "
	MESS "    Alt-S: Default values (modem strings, files, and constant values)"
	MESS "    Alt-O: Option settings (modem, display and programmatic flags)"
	MESS "    Alt-P: Communication parameters (speed, data/stop bits, parity, port)"
	MESS "    Alt-J: Menu, text and status bar color choices"
	MESS "    F4:    Default download subdirectory (unqualified downloads)"
	MESS " "
	MESS "To dial a number, you must setup at least one dialing directory entry."
	MESS "After INSTALL, use the Alt-D key to call up the dialing directory, and"
	MESS "the 'r'subcommand to revise an entry.  Once the entry has been revised,"
	MESS "dial it through Alt-D by its entry number."
	MESS " "
	MESS "There are two other directories that may be setup, F1 (accessories) and"
	MESS "Alt-M (macros).  However, these do not need to be setup immediately."
	MESS " "
	MESS "Please refer to the document COM-AND.DOC provided with this release for"
	MESS "a discussion of all the manual functions available.  A summary of key"
	MESS "commands, too, may be invoked in CRT mode at any time by pressing F10."
	MESS " "
	MESS "Press any key to terminate"
;
;	Wait for a keypress
;
	KEYGET S0		; Wait for a char
	RETURN			; And continue
