; ----- Install a tune as the default alarm
;	commenced: 8/2/88 R.McG
; ----------------------------------------------------------------
;	Note: This script creates the file COM-AND.TUN on the default
;	subdirectory (if no COM-AND= subdir, or if COM-AND.TUN already
;	exists on default), or on the COM-AND= subdir.
; ----------------------------------------------------------------
;
;	First, draw a box
;
	LEGEND " Select an alarm tune"
	ON ESCAPE GOSUB EXIT
	GOTO Start
;
;	Subroutine to intercept ESCAPE
;
Exit:
	RESTORE 		; Restore saved screen area
	EXIT			; No window foolishness
;
;	Start by opening a window
;
Start:
	GOSUB Window		; Open a window
;
;	Now, look for a keypress
;
Loop:
	KEYGET S1		; Read a single key
	SWITCH S1
	  CASE "1"              ; First call by Louis M. Sander
	    S0 = "T200MNO2G24O3C24E24G8G24G24G24G8E8E24E24E24E8C8E8C8O2G8"
	    PLAY S0		; Play the current selection
	  ENDCASE
	  CASE "2"              ; William Tell
	    S0 = "t220l16o3mnb4p8msbbmnb4p8msbbb8g#8e8g#8b8g#8b8o4e8o3b8g#8e8g#8b8g#8b8o4e8o3mnb4p8msbb"
	    PLAY S0		; Play the current selection
	  ENDCASE
	  CASE "3"              ; Theme from dragnet
	    S0 = "ms t250 o2 c2d8e-cp4 >c2d8e-cp4g-1 p2"
	    PLAY S0		; Play the current selection
	  ENDCASE
	  CASE "4"              ; Leave it to Beaver
	    S0 = "ms t190lO2L8CL4FL8A>C<AFL4GL8B-L4>DL8C<B>CFL4D L8 <B- L4 G.. P16"
	    PLAY S0		; Play the current selection
	  ENDCASE
	  CASE "5"              ; The TOnight Show
	    S0 = "ms t170 L4 A L8 G P16 F P16 L4 E P32 D.. P16.. L8 D.F P16 AG... P4"
	    PLAY S0		; Play the current selection
	  ENDCASE
	  CASE "6"              ; Beverly Hillbillies
	    S0 = "ms t190 o2 L8 CCFCFGAAFF L4 G P32 G P32 C. P16"
	    PLAY S0		; Play the current selection
	  ENDCASE
	  CASE "7"              ; The FLintstones
	    S0 = "ms t170 o3 L8 G.. P64 C P4 >C. P32 <AG.. P64 C P4 G. P64 FEEFG L4 CDC P32."
	    PLAY S0		; Play the current selection
	  ENDCASE
	  CASE "8"              ; The Adams Family
	    S0 = "ms t220 o3 O3 T220 L8 CDEF P4 O0 L4 F P8 F P8 O3L8 DEF#G P4 O1 L4 G P8 G P8O3 L8 DEF#G P4 DEF#G P4 CDEF P4 O1 L4 F P8 F P8"
	    PLAY S0		; Play the current selection
	  ENDCASE
	  CASE "9"              ; Final Jeapordy
	    S0 = "ms t150 o3 DGD <G >DGD P4DGDG MS B P8 MN L8 AGF#EE- L4DGD <G >DGD P4MS G P8"
	    PLAY S0		; Play the current selection
	  ENDCASE

	  CASE "A"              ; Birds
	    S0 = "l50 ml t255 o5 f#gf#gp64 f#gf#gp64 f#gf#gp64 f#gf#gp64 aa#ba#aa#ba#a p32 bbbbbb p64 f#gp64 f#gp64 f#gp64 f#gp64 f#g"
	    PLAY S0		; Play the current selection
	  ENDCASE
	  CASE "B"              ; More birds
	    S0 = "l64 ml t255 n64n66n68n70 p64 n66n68n70n72n74n76n78 p64 n66n68n70n72 p64 n64n66n68n70 p64 n70n72n74n76n78n80 p64"
	    PLAY S0		; Play the current selection
	  ENDCASE
	  CASE "C"              ; Charge
	    S0 = "mn t200 L8 CEFG P16 L8 E G8 >C1"
	    PLAY S0		; Play the current selection
	  ENDCASE
	  CASE "D"              ; Spaceship
	    S0 = "l64 mf ml t255 n50n60n52n62n54n64n56n66n54n64n52n62n51n62"
	    PLAY S0		; Play the current selection
	  ENDCASE
	  CASE "E"              ; More Spaceship
	    S0 = "l64 mf ml t255 n40n41n42n43 n50n51n52n53"
	    PLAY S0		; Play the current selection
	  ENDCASE
	  CASE "F"              ; Alfred Hitchcock
	    S0 = "t200 ml o2g ms o3cc8c ml o2bab. ms o3 cd1"
	    PLAY S0		; Play the current selection
	  ENDCASE
	  CASE "G"              ; Dixie
	    S0 = "t200 L16ge L8cc L16cdef L8gggeaaa. L16g a8.gab O4 L16cde4. c O3g O4c4.O3geg4.dec4"
	    PLAY S0		; Play the current selection
	  ENDCASE
	  CASE "H"              ; Reveille by Louis M Sander
	    S0 = "T140O2G8O3MSC8MNE16C16O2G8O3MSE8C8MNE16C16O2G8O3E8C8E16C16O2G8O3E8C2"
	    PLAY S0		; Play the current selection
	  ENDCASE
	  CASE "I"              ; Swim call by Louis M Sander
	    S0 = "T198 MN O2 G8 O3 C8 P8 C8 C8 E8 C8 O2 G8 P8 G8 G8 P8 G8 O3 C8 P8 C8 C8 E8 C8G"
	    PLAY S0		; Play the current selection
	  ENDCASE

	  CASE "P"
	    PLAY S0		; Play the current selection
	  ENDCASE
	  CASE "X"
	    IF NOT NULL S0
	       GOTO INSTALL	; Install it
	    ELSE
	       SOUND 200 100	; NOthing yet
	       ENDIF
	  ENDCASE

	  default
	    SOUND 100 100	; Not acceptible
	  ENDCASE
	ENDSWITCH
	GOTO LOOP
;
;	Install the selection as the current tune
;
INSTALL:
	SET TUNE S0		; Set for current execution
;
;	Construct a file name on the appropriate directory
;
	ENVIRON S1 "COM-AND="   ; Look for COM-AND= environment var
	IF FOUND		; If environment variable found
	   LENGTH S1 N0 	; Get its length
	   N0 = N0-1		; Point to last char in string
	   IF not STRCMP S1(n0:n0) "\"
	      N0 = N0+1
	      CONCAT S1(n0) "\"
	      ENDIF
	   ENDIF
	S1 = S1&"COM-AND.TUN"   ; Add the necessary file name
;
;	Open the file, write the scting, and close it
;
	FOPENO S1		; Open the file name so constructed
	LENGTH S0 N1		; Find string length
	WRITE S0 N1		; Write the string
	FCLOSEO 		; Close the file
	MESSAGE "Alarm installed!"
	RESTORE 		; Restore saved screen area
	EXIT			; And we're done
;
;	Open a window and display a menu
;
Window:
	SAVE  0 10 23 70
	box   0 10 23 70 (default)
	atsay 0 ,12 (default) " COM-AND Select Alarm tune "
	atsay 1 ,11 (default)  " COM-AND version 2.3 allows the alarm 'tune' to be set by  "
	atsay 2 ,11 (default)  " its user.  The alarm tune is set by default through the   "
	atsay 3 ,11 (default)  " file COM-AND.TUN.  It may be changed during COM-AND's     "
	atsay 4 ,11 (default)  " execution through any script using the command 'SET TUNE'."

	atsay 6 ,11 (default)  " This script both creates the TUN file and sets the alarm  "
	atsay 7 ,11 (default)  " for the current execution.  ESC exits without installing. "

	atsay 8 ,10 (default) "Ĵ"
	atsay 10 12 (default) "1) First call"
	atsay 11 12 (default) "2) William Tell"
	atsay 12 12 (default) "3) Theme from Dragnet"
	atsay 13 12 (default) "4) Leave it to Beaver"
	atsay 14 12 (default) "5) The Tonight Show"
	atsay 15 12 (default) "6) Beverly Hillbillies"
	atsay 16 12 (default) "7) Flintstones"
	atsay 17 12 (default) "8) The Adams Family"
	atsay 18 12 (default) "9) Final Jeapordy"
; ***	atsay 19 12 (default) "9) And something completely different"

	atsay 10 42 (default) "A) Birds"
	atsay 11 42 (default) "B) Another bird"
	atsay 12 42 (default) "C) Charge!! "
	atsay 13 42 (default) "D) Spaceship"
	atsay 14 42 (default) "E) Another spaceship"
	atsay 15 42 (default) "F) Alfred Hitchcock"
	atsay 16 42 (default) "G) Dixie"
	atsay 17 42 (default) "H) Reveille"
	atsay 18 42 (default) "I) Swim call"

	atsay 20 10 (default) "Ĵ"
	atsay 21 12 (default) "P) Play the selected tune again"
	atsay 22 12 (default) "X) Install the selected tune"
	atsay 23 32 (default) "Press ESC to exit"
	return
