	SET TTHRU OFF		; Allow type ahead
;
; ----- Dialing directory list
;	Commenced: 8/92 R.McG
; ----------------------------------------------------------------
;	Note: This script searches the current directory for *.DIR
;	files, and displays a menu of the results.
; ----------------------------------------------------------------
;
;	First, draw a box
;
	LEGEND " Select a dialing directory"
	ON ESCAPE GOSUB EXIT
;
;	Start by opening a window
;
	GOSUB Window		; Open a window
;
;	Now, look for a keypress
;
	FFIRST "*.DIR"          ; Search for directories
	IF FAILED GOTO EndLoop	; Exit if none found
	N10 = 0 		; Index of files found
	SET FLAG(0) OFF 	; Flag -> pass1/pass2
;
;	Build the menu
;
Loop:
	IF N10 GE 20 GOTO Keyget
	FNEXT S10[N10]		; Read next directory
	IF FAILED GOTO EndLoop

	N0 = N10\10		; Row # 0-9
	IF N10 LT 10
	   ATSAY N0+2,15 (defa) S10[N10]
	ELSE
	   ATSAY N0+2,45 (defa) S10[N10]
	   ENDIF
	INC N10
	GOTO Loop		; And loop
;
;	End of loop.  After pass on current subdir, if no
;	*.DIR's are found, try on the COM-AND= subdir...
;
EndLoop:
	IF N10 NE 0 GOTO KeyGet ; If we have any fnames, stop here
	IF FLAG(0) GOTO Exit	; There are no directories
	SET FLAG(0) ON		; Mark search in COM-AND= subdir

	ENVIRON S0 "COM-AND="   ; Get COM-AND= environment variable
	IF NOT FOUND GOTO Exit	; No action if no environment variable

	LENGTH S0 N0		; Get its length
	DEC N0			; Point to last char in string
	IF NOT STRCMP S0(N0:N0) "\" S0 = S0&"\"
	FFIRST S0&"*.DIR"       ; Concatenate path and name
	IF FAILED GOTO Exit	; Exit if none found
	GOTO Loop
;
;	Subroutine to intercept ESCAPE
;
Exit:
	WCLOSE ALL		; Restore saved screen area
	STACK "^@ "             ; "^@ " -> Alt-d  (open DD after script)
	EXIT			; No window foolishness
;
;	Invalid input
;
Invalid:
	SOUND 100,100		; Bronx cheer
;
;	Fetch a response
;
Keyget:
	KEYGET S0		; Set for current execution
	IF NOT FIND "1234567890abcdefghij" S0 N0 GOTO Invalid
	IF N0 GE N10 GOTO Invalid
;
;	Load the new directory
;
	LOAD DIAL S10[N0]	; Load new directoryiable found
	GOTO Exit
;
;	Open a window and display a menu
;
Window:
	WOPEN  0 10 16 70 (defa)
	ATSAY  0 12 (default) " COM-AND Dialing directories "
	ATSAY 16 30 (default) " Press ESC to cancel "

	ATSAY  2 12 (default) "1) "
	ATSAY  3 12 (default) "2) "
	ATSAY  4 12 (default) "3) "
	ATSAY  5 12 (default) "4) "
	ATSAY  6 12 (default) "5) "
	ATSAY  7 12 (default) "6) "
	ATSAY  8 12 (default) "7) "
	ATSAY  9 12 (default) "8) "
	ATSAY 10 12 (default) "9) "
	ATSAY 11 12 (default) "0) "

	ATSAY  2 42 (default) "A) "
	ATSAY  3 42 (default) "B) "
	ATSAY  4 42 (default) "C) "
	ATSAY  5 42 (default) "D) "
	ATSAY  6 42 (default) "E) "
	ATSAY  7 42 (default) "F) "
	ATSAY  8 42 (default) "G) "
	ATSAY  9 42 (default) "H) "
	ATSAY 10 42 (default) "I) "
	ATSAY 11 42 (default) "J) "

	S0 = "_DIRF"            ; Take current directory
	UPPER S0		; Upper case
	LENGTH S0 N0		; Take its length
	IF N0 GT 46 S0 = S0(N0-46:N0-1)
	ATSAY 13 12 (default) "Currently: "*S0
	ATSAY 14 12 (default) "Select the directory: "
	RETURN
