; ----- COM-AND dial a string of any width
; -----------------------------------
;	This script dials a string of any width, and performs the Alt-R
;	function, waiting for connect or redial.
;
;	The value in S0, if supplied, establishes the number being dialed.
;	Modem speed, parity, data and stop bits must be set by the caller.
;
;	Script: R.McG, commenced 9/89
; -----------------------------------
;
;	If number is not supplied, query for it
;
IF NULL S0			; Not passed as parm
   WOPEN 10,1, 13,77 (contrast) Exit
   ATSAY 11, 3 (contrast) "Enter the number to be dialed:"
   ATSAY 12, 3 (contrast) "->"
   ATSAY 13,26 (contrast) " Press ESC to exit"
   ATGET 12,6  (contrast) 60 S0
   WCLOSE			; Restore screen under
   IF NULL S0			; Null entry terminates script
      GOTO EXIT 		; No-op
      ENDIF
   ENDIF
GOTO Start
;
;	Successful connection
;
Done:
   CLOG "DIAL.CMD connect: "*S0
   WCLOSE			; Close open window
   SET SUCCESS ON		; Report success
   SET RDISP ON 		; Restore display
   IF FCALLED FRETURN
   EXIT
;
;	Failed DIAL
;
Unavailable:
   HANGUP
   WCLOSE			; Close open window
   SET SUCCESS OFF		; Report success
   SET RDISP ON 		; Restore display
   IF FCALLED FRETURN
   EXIT
;
;	General exit (modem not connected yet)
;
Exit:
   WCLOSE			; Close open window
   SET RDISP ON 		; Restore display
   SET SUCCESS OFF		; Report success
   IF FCALLED FRETURN
   EXIT
;
;	Initialize values
;
Start:
   TIME S1			; Redial sequaence start
   S2 = S1			; THis attempt start
   S3 = S1			; TIme now
   S4 = ""                      ; Modem return string
   N0 = 1			; Attempt #
   N1 = "_RDelay"               ; Redial delay
   RFLUSH			; Clear modem buffer
   SET RDISP OFF		; Don't display
;
;	Open a window to show progress
;
   WOPEN  5,10 14,70 (default) Unavailable
   ATSAY  5,12 (default) " COM-AND Connect (script) "
   ATSAY  7,12 (default) "Number: "*S0(0:50)
   ATSAY  8,12 (default) "Redial Started: "*S1
   ATSAY  9,12 (default) "Call started:   "*S2
   ATSAY 10,12 (default) "Call #:         "*N0
   ATSAY 11,12 (default) "Call delay:     "*N1

   ATSAY  9,40 (default) "Time now:       "*S3
   ATSAY 11,40 (default) "Modem: "*S4(0:20)

   ATSAY 13,12 (default) "Press space bar to cycle; ESC to cancel"
;
;	Hangup, and transmit the dialing cmd
;
Loop:
   TIME S2			; Set current time
   ATSAY  9,28 (default) S2	; Display time
   ATSAY 10,28 (default) N0	; Display attempt #
   ATSAY 10,40 (default) "Hanging up"
   TRANSMIT "_MESCa"&""         ; Wake up the modem
   TRANSMIT "_MHANg"&""         ; Hangup

   ATSAY 10,40 (default) "Dialing   "
   PAUSE 5			; Wait for modem to clear
   TRANS "_DPRE"& S0& ""& "_DSUF"& ""   ; Ensure trailing blanks deleted
;
;	Wait for a response from the modem
;
   ATSAY 10,40 (default) "Waiting   "
   SET TIMER (0)
Waiting:
   TIME S3			; Set current time
   ATSAY  9,56 (default) S3	; Display time
   IF HITKEY GOTO Keyhit	; Skip if

   RGET S5 1 1			; Wait for one char one sec
   IF SUCCESS			; We have a char
      IF NULL S5		; a c/r rtnd
	 S4 = ""                ; Clear rcv string
	 ATSAY 11,47 (default) "                     "
      ELSE
	 S4 = S4*S5
	 IF FIND S4 "_MCONN"&"" GOTO Done
	 ENDIF
      ENDIF

   ATSAY 11,47 (default) S4(0:20)
   TSINCE (0) N2,N3,N4
   N3 = N3*60+N2		; Total # secs
   IF LT N3 N1 GOTO Waiting	; If delay not exceeded

   INC N0			; Count the try
   GOTO Loop			; Start new attempt
;
;	Keypress is pending
;
Keyhit:
   KEYGET S5			; Read kbd
   IF STRCMP S5 " "             ; Space bar
      INC N0			; Count last attempt
      GOTO Loop 		; .. start new cycle
      ENDIF
   SOUND 100,100		; Indicate failed
   GOTO Waiting 		; Continue otherwise
