; ----- INDIR: Load the dialing directory from an ASCII file
; ----------------------------------------------------------------
;	Note: This script expects the file DIALING.TXT to be an ASCII file
;	of a specific format, carrying dialing directory entries.  Records
;	are structured:
;
;  Col: 0		  38		    57		      61
;	+-----+-/ /-+-----+-----+-/ /-+-----+-----+-/ /-+-----+-//
;	!  Entry name	  !  Phone number   ! Speed	      !
;	+-----+-/ /-+-----+-----+-/ /-+-----+-----+-/ /-+-----+-//
;		 !		   !		     +--------- 4 chars
;		 !		   +--------------------------- 14 chars
;		 +--------------------------------------------- 24 chars
;
;  Col:       61    62	  63	64    65    66	  67	68    69    70
;	      +-----+-----+-----+-----+-----+-----+-----+-----+-----+-//
;	      !     !  P  !	!  D  !     !  S  !	!  E  !     !
;	      +-----+-----+-----+-----+-----+-----+-----+-----+-----+-//
;		       !	   !	       !	   +--- Echo Y/N
;		       !	   !	       +--------------- Stop 1/2
;		       !	   +--------------------------- Data 7/8
;		       +--------------------------------------- Parity E/N/O
;
;  Col:       70		78
;	      +-----+-/ /-+-----+
;	      ! Script file	!
;	      +-----+-/ /-+-----+
;		       +--------------------------------------- 8 chars
;
; ----------------------------------------------------------------
;	Only the first 100 records in DIALING.TXT are used.  Blank records
;	result in an empty directory entry.
; ----------------------------------------------------------------
;	The long distance portion of the dialing directory is copied
;	from the file COM-AND.DIR (which must be present).
; ----------------------------------------------------------------
;
;	Move the header with no changes
;
	LEGEND "InDir: Dialing directory update"
	FOPENI "COM-AND.DIR" BINARY
	FOPENO "NCOM-AND.DIR" BINARY

	READ  S0 80 N0
	WRITE S0 80
	READ  S0 70 N0
	WRITE S0 70
;
;	Now, read the input file and update the directory
;
	FOPENI "Dialing.TXT" Text
	FOR N0 = 1,100			; Do 100 times
	    LEGEND "InDir: Entry # "*N0*" output"
	    READ S0 80 N1
	    IF EOF or NULL S0
	       S0(0:39)  = "........................              .-"
	       S0(40:79) = "...-....         1200,E,7,1,N         "
	       ENDIF
	    S1 = S0(0:23)		; Name	 (24 chars and a null)
	    S1(25:79) = S0(38:52)	; Number (14 chars and a null)
	    S1(40:79) = S0(57:61)	; Speed  (4 chars and a null)
	    S1(45:79) = " "*S0(62)*S0(64)*S0(66)*S0(68)*" " ; Parms (6 wide)
	    S1(51:79) = S0(70:77)	; Script (8 Chars and a null)
	    ITOC 0 S1(24)		; Null stoppers
	    ITOC 0 S1(39)
	    ITOC 0 S1(44)
	    ITOC 0 S1(59)
	    WRITE S1 60 		; Each entry is 60 wide with embedded
	    ENDFOR
