;	Kermit server command script file
;	---------------------------------
;	Commenced: 6/8/88 R.McG
;
;	First - open a window
;
	ON ESCAPE GOSUB Exit		; Exit if esc pressed
Restart:
	GOSUB Window			; Open window and ask for command
;
;	S0 returns the response: Interpret the response
;
	SWITCH S0
	   CASE "1"
	      GOTO Send
	   ENDCASE
	   CASE "2"
	      GOTO Receive
	   ENDCASE
	   CASE "3"
	      GOTO Finish
	   ENDCASE
	   CASE "4"
	      GOTO Logout
	   ENDCASE
	   CASE "S"
	      GOTO Send
	   ENDCASE
	   CASE "R"
	      GOTO Receive
	   ENDCASE
	   CASE "F"
	      GOTO Finish
	   ENDCASE
	   CASE "L"
	      GOTO Logout
	   ENDCASE
	ENDSWITCH
;
;	Unrecognized entry
;
	SOUND 100 500
	GOTO Restart
;
;	Exit routine
;
Exit:
	RESTORE 	; CLose the window we opened in subroutine Window
	EXIT
;
;	Command subroutine - build and send a KERMIT packet
;	.. The body of the packet is in S0
;
Command:
	N0 = 1		; Set MARK value (SOH)
	LENGTH S0 N2	; Compute length of type&data
	N3 = N2+2+32	; Account for blknum and checksum, and make an ASCII

	ITOC N0 S1(0)	; Set MARK into string
	ITOC N3 S1(1)	; Set length into string
	S1(2) = " "     ; Set block number
	S1(3:79) = S0	; Store type and data
;
;	Now, compute the checksum
;
	N4 = 1		; Start at length variable
	N5 = N2+2	; Make a loop count
	N6 = 0		; Initialize summation
Loop:
	CTOI S1(N4:N4) N7
	N6 = N6+N7	; Sum the value

	INC N4		; Point to next
	DEC N5		; Decrement count to go

	IF NOT ZERO N5	; Loop for count in
	   GOTO Loop	; .. N5
	   ENDIF

	N6 = N6-(N6/256)*256	; Reduce to 8 bits
	N7 = N6/64		; Extract top 2 bits
	N6 = N6+N7		; Sum MSBits with low 6 bits
	N6 = N6-(N6/64)*64	; And reduce result to 6 bits
	N6 = N6+32		; Make printable ascii
;
;	Store the CHECKSUM, and transmit the whole
;
	N2 = N2+3	; COmpute index to checksum
	ITOC N6 S1(n2:n2)
	INC N2		; Point after checksum
	S1(N2) = "!"    ; Store a c/r
	TRANS S1	; And send it
	RETURN		; And we're done
;
;	Build and send a logout and we're done
;
Logout:
	S0 = "GL"
	GOSUB Command
	GOTO Exit
;
;	Build and send a finish and we're done
;
Finish:
	S0 = "GF"
	GOSUB Command
	GOTO Exit
;
;	Initiate a KERMIT send operation
;
Send:
	SOUND 400 200
	ATSAY 17 12 (Default) "File name: "
	ATGET 17 27 (Default) 40 S1

	IF NOT ISFILE S1
	   SOUND 100 500
	   ATSAY 17 27 (Default) "File does not exist... please re-enter. "
	   PAUSE 5
	   GOTO Send
	   ENDIF
	SENDFILE KERMIT S1
	GOTO Exit
;
;	Initiate a KERMIT receive operation
;
Receive:
	SOUND 400 200
	ATSAY 17 12 (Default) "File name: "
	ATGET 17 27 (Default) 40 S1

	S0 = "R"&S1
	GOSUB Command
	GETFILE KERMIT
	GOTO Exit
;
;	Open a window and read a command
;
Window:
	SAVE 10 10 18 70
	BOX  10 10 18 70 (Default)
	ATSAY 10 12 (Default) " COM-AND Kermit Server "
	ATSAY 11 12 (Default) "(1) Send    (request host to receive file(s))"
	ATSAY 12 12 (Default) "(2) Receive (request host to send file(s))"
	ATSAY 13 12 (Default) "(3) Finish  (terminate host KERMIT server)"
	ATSAY 14 12 (Default) "(4) LogOut  (terminate host server and logoff)"

	ATSAY 16 12 (Default) "Enter command: "
	ATGET 16 27 (Default) 2 s0
	UPPER S0	; Make it upper case
	Return
