PAGE	58,132
TITLE	PHONRING	3-16-91	[3-16-91]

;v0.1 Obtained as a DEBUG script from Fido's Technical Echo.
;v0.2 Toad Hall Disassembly, tweak
;
;David Kirschbaum
;Toad Hall
;kirsch@usasoc.soc.mil

BACKWARDS	EQU	0

LF	EQU	0AH
CR	EQU	0DH
;
CSEG	SEGMENT
	ASSUME DS:CSEG, SS:CSEG ,CS:CSEG ,ES:CSEG
	org	2CH			;v0.2
envseg	label	word			;our environment seg		v0.2

	ORG	100H

PhonRing	proc	near
	JMP	Install_1EB

oldInt8_103	dd	0		;saved Int 8 vector
wcommnr_107	dw	0		;port number (0..3)
wport109	DW	0		;port address (base+6)
bhotkey10B	DB	0		;1 if hotkey pressed
bflag10C	DB	0		;1 if buzzer is on
bstat10D	DB	0		;save Port 61H status
ctrlrbytes_10E	DB	51H,0DH		;constants for stuffing ctrlr
freeseg_110	DW	Install_1EB	;first free segment		v0.2

PhonRing	endp

;Every clock tick
NewInt8_112	proc	far
	PUSHF
	PUSH	AX
	PUSH	DX
	MOV	AH,2			;Get shift status
	INT	16H			;via BIOS
	TEST	AL,8			;Alt depressed?
	JZ	Check_ScrollLock_125	;nope
	TEST	AL,1			;Right shift depressed?
	JZ	Check_ScrollLock_125	;nope
	TEST	AL,2			;Left shift depressed?
	JNZ	Uninstall_15B		;yep, that's our uninstall combo

;Scroll Lock depressed activates our demon
Check_ScrollLock_125:
	AND	AL,10H			;mask to max bit 4
	SHR	AL,1			;looking for the bit 4
	SHR	AL,1			;(scroll lock)
	SHR	AL,1
	SHR	AL,1
	MOV	CS:bhotkey10B,AL	;save scroll lock bit as hotkey flag

	CMP	CS:bflag10C,1		;have we been buzzing?
	JNZ	Skp13E			;nope
	 CALL	Buzzer_Off_1CB		;yep, turn the buzzer off
Skp13E:	CMP	CS:bhotkey10B,1		;hotkey pressed?
					;Scroll Lock *off* enables us
	JZ	Jmp_OldInt8		;yep, on to old Int 8

	MOV	DX,CS:wport109		;our comm port status address
	IN	AL,DX			;read the port status
	TEST	AL,40H			;ringing?
	JZ	Jmp_OldInt8		;nope
	 CALL	Buzzer_On_1B6		;yep, clear that ring status,
					;buzzer on
Jmp_OldInt8:
	POP	DX
	POP	AX
	POPF
	JMP	DWORD PTR CS:oldInt8_103	;on to old Int 8 code

;Uninstall ourselves after Hotkey combination
Uninstall_15B:
	PUSH	BX
	PUSH	CX
	PUSH	DS
	PUSH	ES
	CALL	Buzzer_Off_1CB			;buzzer off

;We have to see if we're the last program in memory
;before we can release ourselves and terminate.

	MOV	AX,CS:freeseg_110	;first free seg beyond our program
	MOV	BL,10H
	DIV	BL
;v0.2	CMP	AH,0
	or	ah,ah			;msb clear?			v0.2
	JZ	Skp170			;yep
	 INC	AX			;nope, bump AL
Skp170:	XOR	AH,AH			;clear msb
;v0.2	PUSH	CS
;v0.2	POP	BX
	mov	bx,CS			;larger, but faster		v0.2
	ADD	BX,AX			;our CSEG, + that AL value
	MOV	DS,BX			;make it DSEG
	CMP	BYTE PTR DS:0,5AH	;'Z'	memory free??
	JNZ	Pop_Jmp8_1B0		;nope, on to old Int 8

;Anyone else stolen Int 8's vector since us?
;v0.2	MOV	AL,8
;v0.2	MOV	AH,35H	;'5'
	mov	ax,3508H		;Get Int 8 vector		v0.2
	INT	21H
	MOV	BX,ES			;save segment
;v0.2	PUSH	CS
;v0.2	POP	AX
	mov	ax,CS
	CMP	AX,BX			;is Int 8 vector pointing to US?
	JNZ	Pop_Jmp8_1B0		;nope, on to old Int 8

;It's safe to put everything back and terminate
	CLI
;v0.2	MOV	DS,word ptr CS:oldInt8_103 + 2
;v0.2	MOV	DX,word ptr CS:oldInt8_103
;v0.2	MOV	AH,25H	;'%'
;v0.2	MOV	AL,8
	lds	dx,CS:oldInt8_103	;old Int 8 vector		v0.2
	mov	ax,2508H		;set Int 8 vector back		v0.2
	INT	21H

	STI
	MOV	AH,49H			;free allocated memory
	PUSH	CS
	POP	ES
	INT	21H
	CALL	Buzzer_On_1B6		;turn buzzer on
	MOV	CX,0FFFFH		;a delay value
Delay_1AB:
	LOOP	Delay_1AB		;delay a bit
	CALL	Buzzer_Off_1CB		;buzzer off
Pop_Jmp8_1B0:
	POP	ES
	POP	DS
	POP	CX
	POP	BX
	JMP	SHORT	Jmp_OldInt8	;on to orig Int 8 code

NewInt8_112	endp


Buzzer_On_1B6	proc	near
	IN	AL,61H			;read chip
	MOV	CS:bstat10D,AL		;save status
	MOV	CS:bflag10C,1		;flag buzzer on
	MOV	DX,word ptr CS:ctrlrbytes_10E	;lsb, msb to reset cntrlr ?
	CALL	Reset_Ctrlr_1D8		;reset interrupt controller?
	RET	;_NEAR
Buzzer_On_1B6	endp


Buzzer_Off_1CB	proc	near
;Turns buzzer off
	MOV	CS:bflag10C,0		;flag buzzer off
	MOV	AL,CS:bstat10D		;get old value
	OUT	61H,AL			;reset chip
	RET	;_NEAR
Buzzer_Off_1CB	endp


;Reset int controller? Internal modem? Sound chip?
Reset_Ctrlr_1D8	proc	near
	MOV	AL,0B6H
	OUT	43H,AL
	MOV	AX,DX
	OUT	42H,AL			;lsb
	MOV	AL,AH
	OUT	42H,AL			;msb
	IN	AL,61H
	OR	AL,3
	OUT	61H,AL			;reset
	RET	;_NEAR
Reset_Ctrlr_1D8	endp


Install_1EB	proc	near

	CALL	Buzzer_On_1B6		;clear modem status of any ring,
					;buzzer on
	MOV	CX,0FFFFH		;delay value
Delay_1F1:
	LOOP	Delay_1F1		;delay a bit

	CALL	Buzzer_Off_1CB		;turn buzzer off

	MOV	SI,80H			;PSP cmdline
	CLD
	LODSB				;cmdline length
	CMP	AL,2			;min 2 chars
	JB	Usage_Term_21A		;not enough, usage, die

CmdLup_1FF:
	LODSB
	CMP	AL,0DH			;CR terminates cmdline
	JZ	Usage_Term_21A		;usage, die

	CMP	AL,20H	;' '
	JZ	CmdLup_1FF		;gobble spaces
	CMP	AL,'1'
	JB	CmdLup_1FF		;below legals
	CMP	AL,'4'
	JA	CmdLup_1FF		;above legals
	SUB	AL,'1'			;deasciify
	XOR	AH,AH			;clear msb
	MOV	CS:wcommnr_107,AX	;save port nr as word
	JMP	SHORT	L0223

Usage_Term_21A:
	MOV	DX,OFFSET usage$283	;Intro msg, usage
Msg_Term:				;common code			v0.2
	MOV	AH,9			;display msg
	INT	21H
	INT	20H			;terminate

L0223:	MOV	SI,wcommnr_107		;port nr
	SHL	SI,1			;*2 for words
	MOV	AX,40H			;BIOS data area
	MOV	DS,AX			;into DS
	MOV	DX,[SI]			;snarf current COMx port address
	PUSH	CS
	POP	DS			;restore DS
;v0.2	Old code
;v0.2	CMP	DX,0
;	JZ	PortProb_240		;yep, not assigned
;
;	ADD	DX,6			;bump to status port???
;	MOV	wport109,DX		;save as port address
;	JMP	SHORT	GoTsr_249
;
;PortProb_240:
;v0.2	New code:
	or	dx,dx			;port not assigned?		v0.2
	jnz	GoTsr_249		;nope, assigned, continue	v0.2
					;else fall thru to...		v0.2
;v0.2	MOV	AH,9			;display msg
	MOV	DX,OFFSET initprob$41A	;'Problem initializing port'
;v0.2	INT	21H
;v0.2	INT	20H			;terminate
	jmp	Msg_Term		;display msg, terminate		v0.2

GoTsr_249:
;v0.2	New code:
	add	dx,6			;bump to status port		v0.2
	mov	wport109,dx		;save as port address		v0.2

;v0.2	MOV	AL,8
;v0.2	MOV	AH,35H
	mov	ax,3508H		;get Int 8 vector		v0.2
	INT	21H
	MOV	word ptr CS:oldInt8_103 +2,ES	;save seg
	MOV	word ptr CS:oldInt8_103,BX	;and offset
	MOV	DX,OFFSET NewInt8_112		;our new Int 8 svc
;v0.2	MOV	AL,8
;v0.2	MOV	AH,25H	;'%'
	mov	ax,2508H		;set new Int 8 vector
	INT	21H

;v0.2	MOV	BX,OFFSET portnr_416	;'com1' string
;v0.2	MOV	AX,wcommnr_107		;our port value
;v0.2	ADD	[BX],AL			;bump to 'com2', etc.
	mov	al,byte ptr wcommnr_107	;our port value			v0.2
	add	portnr_416,al		;bump 'com1' to 'com%'		v0.2

	MOV	DX,OFFSET msg3DE	;'PhonRing resident..'
	MOV	AH,9			;display msg
	INT	21H
;v0.2	MOV	AX,DS:2CH	;','
;v0.2	MOV	ES,AX
	mov	ES,envseg		;PSP environment seg		v0.2
	MOV	AH,49H			;free environment
	INT	21H
	MOV	DX,OFFSET Install_1EB	;use install code as buffer
;v0.2	MOV	freeseg_110,DX		;pointer to first free seg
	INT	27H			;release memory from DX, go TSR

Install_1EB	endp

usage$283	DB	CR,LF
;DB ' Phonring.com  v0.1  03/10/91   '
db ' Phonring v0.2  03/15/91   '		;v0.2
db 'Monitor phone-ring via modem and beep speaker',CR,LF
DB '  (c) Copyright 1991 by Bruce Desmond (1:203/6.9) - All rights reserved.'
db CR,LF,CR,LF
DB ' Syntax:  Phonring.com  [port#] ',CR,LF,CR,LF

DB ' [port#] = # of serial port with modem/phone line. 1,2,3,4 are valid.'
db CR,LF,CR,LF
DB ' Scroll-lock: on=disable off=enable    '
db 'Alt+LShift+RShift unloads if possible.',CR,LF,'$'

msg3DE	DB	CR,LF
	DB	9,'PhonRing resident and watching for phone rings on com'
portnr_416	DB	'1'
		db	CR,LF,'$'
initprob$41A	DB	CR,LF,9,'Error: Problem initializing modem',CR,LF,'$'

CSEG	ENDS
	END	PhonRing
