#ifndef __COLORS_H_    // System constants for colors and proportions
#define __COLORS_H_    // of diffferent screen types

#include <stdio.h>
#include "mouse.h"

#include "global.h"
#include "graphpp.h"
#include "simple.h"

enum { MEDIUM_ICON = 1, SMALL_ICON, LARGE_ICON };  // Icon types

struct Colors
    {
    uchar  HILITE_COLOR,     // Hilite frame when window becomes active
           BAK_COLOR,        // Window background
           FILL_COLOR,       // USED with BAK_COLOR if PATTERN != SOLID_FILL
	   ATTR_COLOR,       // For output to window
	   SHADOW_COLOR,     // Shadow color
           HDR_BAK_COLOR,    // Header background
           HDR_ATTR_COLOR,   // Header text color
           MARK_COLOR,       // Text block hilite color
           MARK_BAK_COLOR,   // Text block background hilite color
           BORDER_COLOR1,    // Border colors. For nice-look border output
	   BORDER_COLOR2,    // we need at least 3 colors.
	   BORDER_COLOR3,
           PATTERN;          // Fill style
    };

struct ColorSet
    {
    int color_set_number;  // Number of current color set
    Colors colors;

    ColorSet();
    void loadColorSet(int number = 0);         // load from "colors.set"
    };
extern ColorSet* pColorSet;

struct ScreenSet
    {
    uchar cell_height;        // Height of cells of the screen (25 x 80)
    uchar log2cell_width;
    uchar cell_width;         // Width of cells of the screen (25 x 80)

    uchar standart_width;         // Char dimentions, not connected with
    uchar standart_height;        // cells. Used as default for screen output.
    uchar sub_interval;

    loc ICON_PIXELS_1;     // Type 1 icon size in pixels
    loc ICON_PIXELS_2;     // Type 2 icon size in pixels
    loc ICON_PIXELS_3;     // Type 3 icon size in pixels

    loc icon_types[4];     // Array of loc(0, 0), ICON_TEXT_1, 2, 3.

    int g_driver;           // BGI driver and mode
    int g_mode;

    ScreenSet(int gdriver, int gmode);
    int* get_cells(rect cur_rect);
    };
extern ScreenSet* pScreenSet;
///////////////////////////////////////

/*
      Calculates monitor mode - dependent coordinates, like cell_height,
      log2cell_width (cell_width  = 1 << log2cell_width),
      ICON_Y1, ICON_Y2, ICON_Y3, ICON_X1, ICON_X2, ICON_X3 - size of
      icons of different types (pixels).
*/
/////////////////////////
/* This function initializes KNOW-HOW and graphics.
       Arguments: graphics driver and number of color set loaded
           from file COLORS.SET
       Return value: 1 - success, 0 - error.
*/
int init_KNOW_HOW(int driver = DETECT, int macros = 0);
///////////////////////////////////////
// This function call global_remove(), and deletes Screen and Color Sets.
void close_KNOW_HOW();

#endif __COLORS_H_
