#ifndef __MOUSE_H
#define __MOUSE_H
#ifndef __GEOM
#include "geom.h"
#endif

enum MBUTTONSTATE {MOUSELEFT=1,MOUSERIGHT=2,MOUSECENTER=4,MOUSEANY=7};

struct mousestatus
  {
   int buttonstate, //  see MBUTTONSTATE ( bit 0 - left 1 -right 2 - middle)
   x, y;

   loc where() const {return loc(x,y);}
   int pressed (int button) const {return (buttonstate & button);}
 };

  typedef void huge  mousehandlerfunc();


 int mouseType(); /*

    Use this function, to check for mouse presence and the number
    of buttons

    0 - no mouse , 2,3

  */

 void mouseReset();
 /*
      Reinitialize mouse driver and re-register handler.


 */

mousestatus mouseGetStatus();
   /*
       The main working routine.
       Present mouse position and which buttons are down ?


   */

void mouseSetPosition(loc at);
  /*


  */

void mouseSetRange(const rect& range);
  /*
      limit mouse cursor motion
  */

void mouseDefaultRange(); // Graphic-mode only !

   void mouseSetSpeed(const loc& speed); // mickeys / 8 pixels
   void mouseDefaultSpeed();


   void mouseSetDoublingSpeed(int speed); //  mickeys /second
    /*
      When mouse is moved faster , then  pixel/mickey  ratio is doubled

    */

   void mouseDefaultDoublingSpeed();

   void mouseDoublingOff();

   unsigned mouseStateStorageSize();
   void mouseSaveState(char far * buffer);
   void mouseRestoreState(char far * buffer);



  void mouseSetHandler (mousehandlerfunc handler);


  void mouseDisableHandler ();


   void mouseShowCursor();

   void mouseHideCursor();
  /* Always hide cursor, when drawing something on screen */


void mouseSuspend();
  /*
     Hide cursor and turn off mouse handler

  */

void mouseResume();
  /*
    Display cursor and restore mouse handler

  */


 /////////////////////////////
 ////  The classes below are for system purposes
 ////////////////////////////

struct mouseeventlow //low-level
 {
    enum EVT {MSMOVE=0x1,
	      MSLP=0x02,MSLR=0x04,
	      MSRP=0x08,MSRR=0x10,
	      MSCP=0x20,MSCR=0x40,
	      MSNONE=0x00,MSALL=0x7f };
    unsigned evtype;
    unsigned buttonstatus;
    unsigned x,y;
    int mx,my;

 };

class mousemanager;

class mousehandler
    {
      static mousemanager *   manager;
      mousehandler * next;
      rect * domain;
      unsigned EventMask;

      friend mousemanager;
      public:
      mousehandler(unsigned callmask,rect * area=0);


      virtual void handle(mouseeventlow& ev)=0;
	 // function can set evtype field to 0  for terminating
	 // this event processing in handler's chain

      int covers(loc point) const
	 {return domain ? domain->contains(point) : 1;}
      virtual ~mousehandler();

    };


 class mousehole : mousehandler
       {
	 int isinside;
	 rect door;
	 virtual void handle(mouseeventlow& ev);
	 int covers(loc& pos) const;  // incompatible with
	 public:                      //         mousehandler::covers
	  mousehole(rect hole);
	  virtual void enter()=0;
	  virtual void leave()=0;

       };



class mousemanager
  {   mousehandler * handlist;
      volatile locked;
      static Nbuttons;  // 0 - mouse not avail

   static void huge _saveregs  mainmousehandler();
      friend int mouseType();
      public:
      mousemanager();
      void reset();
      void attach ( mousehandler * handler);
      void detach (mousehandler * handler);
      ~mousemanager(); // unset handler proc !
  };



#endif  //__MOUSE_H
