#ifndef __SLANG_TABLE_H_
#define __SLANG_TABLE_H_

enum { DELIMITER = 1,     // '\0'(end),/*,*/,\r,<>=,' ',+-^/*%=;(),<>[]
       VARIABLE,          // Symbolic name of variable, like x, k1 and so on
       NUMBER,            // Double value
       COMMAND,           // See "commands TABLE[]" later in this file
       STRING,            // Remarked blocks or quoted text
       QUOTE,             // Quote
       ALPHA };           // @ (gosub) or ! (label) symbol


enum { IF = 1, THEN, FOR, NEXT, TO, GOTO, EOL, DELETE,
       FINISHED, GOSUB, LABEL, PLAYEX, RETURN, END, REMARK,
       REMARK_BLOCK,
       SIN, COS, TAN, ASIN, ACOS, ATAN, ABS, EXP, LOG, LG,
       PRINT, INPUT, PAUSE,

       USER
#include "user1.inc"
       };  // All functions after this are user-defined in Slang childs

struct commands
    {
    char command[20];
    char tok;
    };

static commands TABLE[] =  {
	    { "if",     IF       },
	    { "then",   THEN     },
	    { "delete", DELETE   },
	    { "for",    FOR      },
	    { "next",   NEXT     },
	    { "to",     TO       },
	    { "@",      GOSUB    },
	    { "goto",   GOTO     },
	    { "!",      LABEL    },
	    { "return", RETURN   },
	    { "end",    END      },
	    { "&", REMARK   },
	    { "/*", REMARK_BLOCK },
	    { "play",   PLAYEX     },
	    { "sin",    SIN      },
	    { "cos",    COS      },
	    { "lg",     LG       },

	    { "print",  PRINT    },
	    { "input",  INPUT    },
	    { "pause", PAUSE     },

/* The following trick could be used to expand this list of SLANG functions
   and add user-defined ones, which are used by Slang child classes.
*/
#include "userlang.inc"

	    { "",       END      }     // Marker of end of the table
	    };


static char* error_string[] =
	{
	"Syntax error",                            //  0
	"Symbol '(' or ')' expected",              //  1
	"Not an expression",                       //  2
	"Symbol '=' expected",                     //  3
	"Not a variable",                          //  4
	"Too many subroutines",                    //  5
	"Duplicated subroutines",                  //  6
	"Undefined subroutine",                    //  7
	"Expected THEN operator",                  //  8
	"Expected TO operator",                    //  9
	"Number of nested FOR cycles too big",     //  10
	"NEXT without FOR",                        //  11
	"Number of nested GOSUB calls too big",    //  12
	"RETURN without GOSUB",                    //  13
	"Quote expected",			   //  14
	"Wrong arguments number",                  //  15
	"Out of range",                            //  16
	"It is no file",                           //  17
	"Symbol '=' or ARRAY expected",            //  18
	"Symbol '[' or ']' expected",              //  19
	"Name is already used ",                   //  20
	"File error",                              //  21
	"Memory allocation error",                 //  22
	"User break",                              //  23
	"USER ERROR"
	};



#endif __SLANG_TABLE_H_