// Virtual BGI functions

#include <stdlib.h>
#include <gbuf.h>

unsigned char s_fill[8];

inline int pixel_color(loc p, int attr, int bak)          // put pixel with
    {                                                     // attr or bak
    div_t sx, sy;                                         // color, using fill
    sx = div(p.X, 8);
    sy = div(p.Y, 8);
    int col = s_fill[sy.rem] & (1 << sx.rem) ? attr : bak;
    return col;
    }


void bar(GrafBuffer* buf, rect coord)
    {
    int start_bound = coord.origin.Y / buf->bound_size.Y;
    int end_bound = coord.corner.Y / buf->bound_size.Y + 1;
    loc dis(1, 4);
    getfillpattern(s_fill);
    int attr = getcolor();
    struct fillsettingstype fillinfo;
    getfillsettings(&fillinfo);
    int bak = fillinfo.color;

    for(int i = start_bound; i < end_bound; i++)
	{
	int shift = buf->bound_size.Y * i;
	buf->get_bound(i);
	int start = 0, end = buf->bound_size.Y;
	if(i == start_bound)
	    start = coord.origin.Y - i * buf->bound_size.Y;
	if(i == end_bound - 1)
	    end = coord.corner.Y - i * buf->bound_size.Y;
	for(int y = start; y < end; y++)
	    for(int x = coord.origin.X; x < coord.corner.X; x++)
		image_put_pixel(buf->image, loc(x, y),
		    pixel_color(loc(x, y + shift), attr, bak), dis.X, dis.Y);
	buf->put_bound(i);
	}


    }