//
//(C) Copyright 1995, Diego Ernesto Malpica Chauvet.
//              All rights reserved.
#include "btypes.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
char  DEF_CODE=LDR_CODE; //Default code metod (LDR)
								 //you can change it at run time
								 //or before compiling in this file
								 //use XDR_CODE or LDR_CODE to modify it.

class a_BAS {
public:
gen_B a;
virtual int fun1() {return 1;}
};

#define VTBP_SIZE (sizeof(a_BAS)-sizeof(gen_B))


void chknew(void* param)
{
  if (!param) 
	  throw memory_except_C(NO_MEMORY_EXCEPT);
}

int dll_BAS_type_C::find(char* name)
{
	out();
	while(next())
		if (!strcmp(item()->name,name))
	 return 1;
	return 0;
}

class extra_C {
public:
	gen_P gen;
	info_C* info;
	int  i;
	char flag1;
	void clear();
	void init(gen_P gen,int i=0);
	extra_C();
	~extra_C();
};

class dll_BAS_extra_C:public dll_BAS<extra_C> {
public:
	int find (int i);
};

int dll_BAS_extra_C::find(int i)
{
	out();
	while(next())
		if (item()->i==i)
	 return 1;
	return 0;
}


dll_BAS_type_C::dll_BAS_type_C()
{
  DEL_ITEM=0;
}




typedef extra_C*  extra_P;

extra_C::extra_C()
{
	clear();
}

void extra_C::init(gen_P gen_param,int i_param)
{
	clear();
	gen=gen_param;
	info=gen->info;
	i=i_param;
	gen->info->extra=this;
}

extra_C::~extra_C()
{
	if (info)  {
		info->extra=NULL;
		if (!info->ptr)
			delete info;
	}
}

void extra_C::clear()
{
	gen=NULL;
	info=NULL;
	i=0;
	flag1=0;
}


info_C::info_C()
{
	references=0;
	secure=0;
	elements=1;
	ptr=NULL;
	extra=NULL;
}

type_C::type_C()
{
   flags=0;
	name=NULL;
	s_new=NULL;
	s_delete=NULL;
	s_lsize=NULL;
	s_ecode=NULL;
}

dll_BAS_type_C types_C::TYPES;
long int types_C::n_bt=0;

int types_C::s_no_bt(void* gen_param)
{
	gen_P gen=(gen_P)gen_param;
	return gen->type->s_lsize()/sizeof(gen_B)*gen->info->elements;
}

int types_C::s_cmp(void* a,void* b)
{
	if (((gen_P)a)->info->elements!=((gen_P)b)->info->elements) return 0;
	int tot=((gen_P)a)->type->s_lsize()*((gen_P)a)->info->elements;
	for (int n=0;n<tot;n++)
		 if(((char*)((gen_P)a)->info->ptr)[n]!=((char*)((gen_P)b)->info->ptr)[n])
			  return 0;
	return 1;
}


int types_C::s_clone(void* a,void* b)
{
  try {
	  char_B data;
	  gencode_C gencode;
	  gencode.operation=ENCODE;
	  gencode.DR=LDR_CODE;
	  s_code(b,&data,gencode);
	  gencode.operation=DECODE;
	  s_code(a,&data,gencode);
	  return 1;
  }
  catch(memory_except_C& memory_except)
  {
     gencode_C gencode;
	  if (memory_except.extra_info==NO_MEMORY_EXCEPT) {
		 FILE*file=tmpfile();
		 if (!file) throw file_except_C(OPEN_FILE_EXCEPT);
		 gencode.operation=ENCODE;
		 gencode.DR=LDR_CODE;
		 gencode.file=file;
		 s_code(a,NULL,gencode);
		 gencode.operation=DECODE;
		 fseek(file,0,0);
		 s_code(a,NULL,gencode);
	  }
	  else throw memory_except;
  }

  return 1;
}


int types_C::s_equal(void* a, void* b)
{
	dll_BAS_extra_C lista;
	return s_equal_real(a, b,&lista);
}


int types_C::s_equal_real   (void *a,void *b,void* lista_param)
{

	gen_P a_bt_p=(gen_P)a;
	gen_P b_bt_p=(gen_P)b;
	extra_P extra;
	dll_BAS_extra_C* lista=(dll_BAS_extra_C*)lista_param;

	extra_C lista_ele;
	if (!(a_bt_p->bt&BT_CA)) return 1;
	if (!a_bt_p->info || !b_bt_p->info)
		if (a_bt_p->info!=b_bt_p->info)
	 return 0;
		else
	 return 1;


	if (!a_bt_p->info->extra) {
		chknew(extra= new extra_C);
		extra->init(a_bt_p);
		lista->insert_r(extra);
	}
	else
		return 1;


	if(a_bt_p->bt&(BT_BA)) {
	return s_cmp(a_bt_p,b_bt_p);
	}
	if(a_bt_p->bt&BT_BT) {
		int n,tot;
		tot=s_no_bt(a_bt_p);
		if(tot!=s_no_bt(b_bt_p)) return 0;
		gen_P a_bt_p2=(gen_P)(a_bt_p->info->ptr);
		gen_P b_bt_p2=(gen_P)(b_bt_p->info->ptr);
		if(a_bt_p->type->flags&BT_VI_F) {
			((char*)a_bt_p2)+=VTBP_SIZE;
			((char*)b_bt_p2)+=VTBP_SIZE;
		}
		for (n=0;n<tot;n++)
			if(!s_equal_real(&a_bt_p2[n],&b_bt_p2[n],lista))
				return 0;
	}
	return 1;

}




int types_C::s_code(void* a,void* dump,gencode_C& gencode)
{
	int size;
	char_B * data=(char_B *)dump;
	if (gencode.operation==ENCODE) {
		gencode_C gencodel;
		gencodel.DR=gencode.DR;
		gencodel.operation=ENSIZE;
		s_code(a,NULL,gencodel);
		size=gencodel.size;
		gencodel.end();
		if(!gencode.file) {
			if (data->is_void())
				data->create(size);
			else
				if (data->info->elements<size)
					data->redim(size);
			gencode.dump_base=gencode.dump_pt=(char*)data->info->ptr;
		}
	}
	if (gencode.operation==DECODE) {
		s_forget(a);
		if(!gencode.file)
			gencode.dump_base=gencode.dump_pt=(char*)data->info->ptr;
	}

	dll_BAS_extra_C lista;
	gencode.lista=&lista;
	gencode.dr_code(size);
	s_code_real(a,gencode);
	return gencode.size;
}

int types_C::s_code_real (void *a,gencode_C& gencode)
{
 dll_BAS_extra_C* lista=(dll_BAS_extra_C*)gencode.lista;
 gen_P bt_p=(gen_P)a;
 extra_P extra;
 int size=0;
 int elements=1;
 if(!(bt_p->bt&BT_CA)) return 0;
 if(gencode.operation==DECODE) {
	int key;
	gencode.dr_code(key);
	if(!key) return size;
	gencode.dr_code(bt_p->init_bt);
	gencode.dr_code(bt_p->bt);
	if(lista->find(key)) {
		bt_p->info=lista->item()->gen->info;
		bt_p->info->references++;
		return size;
	}

	if(bt_p->type->name) {
		 int name_size;
		 char *name;
		 gencode.dr_code(name_size);
		 chknew( name = new char[name_size]);
		 gencode.dr_code(name[0],name_size);
		 if(strcmp(name,bt_p->type->name))
			 if (!TYPES.find(name))
				 throw types_except_C(TYPE_NOT_REGISTRED_TYPES_EXCEPT);
			 else
				 bt_p->type=TYPES.item();
			 delete name;
	}

	if(bt_p->bt&BT_AR)
		gencode.dr_code(elements);
	if(bt_p->type->flags&ECODE_F) {
		if (!s_create(a,elements)) return NULL;
		chknew(extra=new extra_C);
		extra->init(bt_p,key);
		if (!lista->insert_r(extra)) return NULL;
			 bt_p->type->s_ecode((char*)bt_p->info->ptr,elements,gencode);
		return 1;
	}
	if(bt_p->bt&BT_BT) {
		int n,tot;
		if (!s_create(a,elements)) return NULL;
		chknew(extra= new extra_C);
		extra->init(bt_p,key);
		if(!lista->insert_r(extra)) return NULL;
		tot=s_no_bt(bt_p);
		gen_P  bt_p2=(gen_P)(bt_p->info->ptr);
		if(bt_p->type->flags&BT_VI_F) ((char*)bt_p2)+=VTBP_SIZE;
		for (n=0;n<tot;n++)
			s_code_real(&(bt_p2[n]),gencode);
	}
	if(bt_p->type->flags&ECODEA_F) {
		if (!s_create(a,elements)) return NULL;
		chknew(extra=new extra_C);
		extra->init(bt_p,key);
		if (!lista->insert_r(extra)) return NULL;
			 bt_p->type->s_ecode((char*)bt_p->info->ptr,elements,gencode);
		return 1;
	}

 }
 else {// ENCODE ENSIZE
	if(bt_p->info)  {
		if (!bt_p->info->extra) {
			 chknew(extra=new extra_C);
			 extra->init(bt_p,lista->n_elements+1);
			 lista->insert_r(extra);
			 gencode.dr_code(extra->i);
		}
		else  {
			extra=(extra_P) bt_p->info->extra;
			gencode.dr_code(extra->i);
			gencode.dr_code(bt_p->init_bt);
			gencode.dr_code(bt_p->bt);
			return 1;
		}
	}
	else {
		int paso=0;
		gencode.dr_code(paso);
		return 1;
	}
	gencode.dr_code(bt_p->init_bt);
	gencode.dr_code(bt_p->bt);
	if(bt_p->type->name) {
		 int name_size;
		 name_size=strlen(bt_p->type->name)+1;
		 gencode.dr_code(name_size);
		 gencode.dr_code(bt_p->type->name[0],name_size);
	}
	if(bt_p->bt&BT_AR)  {
		gencode.dr_code(bt_p->info->elements);
		elements=bt_p->info->elements;
	}

	if(bt_p->type->flags&ECODE_F) {
		bt_p->type->s_ecode((char*)bt_p->info->ptr,elements,gencode);
		return 1;
	}
	if(bt_p->bt&BT_BT) {
		int n,tot;
		tot=s_no_bt(bt_p);
		gen_P bt_p2=(gen_P)(bt_p->info->ptr);
		if(bt_p->type->flags&BT_VI_F) ((char*)bt_p2)+=VTBP_SIZE;
		for (n=0;n<tot;n++)
			s_code_real(&bt_p2[n],gencode);
	}
	if(bt_p->type->flags&ECODEA_F) {
		bt_p->type->s_ecode((char*)bt_p->info->ptr,elements,gencode);
		return 1;
	}
 }

 return 1;
}


int types_C::s_create(void* a, int n)
{
	gen_P bt_p=(gen_P)a;
	s_forget(a);
	chknew(bt_p->info = new info_C);
	if(!bt_p->info) return 0;
	bt_p->info->elements=n;
	bt_p->info->references = 1;
	chknew(bt_p->info->ptr =bt_p->type->s_new(n));
	if(!bt_p->info->ptr) return 0;
	n_bt++;
#ifdef DEBUG_BT
	printf("BT:%d\n",n_bt);
#endif
	return 1;
}


int types_C::s_insert_r(void* a,void* b,int pos)
{
	gen_P bt_p_a=(gen_P)a;
	gen_P bt_p_b=(gen_P)b;
	if(pos>bt_p_a->info->elements) return 0;
	int size=bt_p_a->type->s_lsize();
	int tot=s_no_bt(a);
	char* gts;
	chknew(gts=new char[(bt_p_a->info->elements+bt_p_b->info->elements)*size]);
	int i,j,k;
	for(i=0;i<(pos+1)*size;i++)
	  gts[i]=((char*)bt_p_a->info->ptr)[i];
	for(k=i,j=0;j<bt_p_b->info->elements*size;j++,i++)
	  gts[i]=((char*)bt_p_b->info->ptr)[j];
	for(;k<bt_p_a->info->elements*size;i++,k++)
	  gts[i]=((char*)bt_p_b->info->ptr)[k];
	bt_p_a->info->elements+=bt_p_b->info->elements;
	delete (char*)bt_p_a->info->ptr;
	bt_p_a->info->ptr=gts;
	if(bt_p_a->bt&BT_BT) {
		size=bt_p_b->info->elements;
		bt_p_b=(gen_P)bt_p_b->info->ptr;
		for (i=0;i<size;i++) {
			 if(bt_p_a->type->flags&BT_VI_F) ((char*)bt_p_b)+=VTBP_SIZE;
			 for (j=0;j<tot;j++) {
				 if(bt_p_b->info) bt_p_b->info->references++;
				 bt_p_b++;
			 }
		}
	}
	return 1;
}

int types_C::s_insert_l(void* a,void* b,int pos)
{
	gen_P bt_p_a=(gen_P)a;
	gen_P bt_p_b=(gen_P)b;
	if(pos>bt_p_a->info->elements) return 0;
	int size=bt_p_a->type->s_lsize();
	int tot=s_no_bt(a);
	char* gts;
	chknew(gts=new char[(bt_p_a->info->elements+bt_p_b->info->elements)*size]);
	int i,j,k;
	for(i=0;i<(pos)*size;i++)
	  gts[i]=((char*)bt_p_a->info->ptr)[i];
	for(k=i,j=0;j<bt_p_b->info->elements*size;j++,i++)
	  gts[i]=((char*)bt_p_b->info->ptr)[j];
	for(;k<bt_p_a->info->elements*size;i++,k++)
	  gts[i]=((char*)bt_p_b->info->ptr)[k];
	bt_p_a->info->elements+=bt_p_b->info->elements;
	delete (char*)bt_p_a->info->ptr;
	bt_p_a->info->ptr=gts;
	if(bt_p_a->bt&BT_BT) {
		size=bt_p_b->info->elements;
		bt_p_b=(gen_P)bt_p_b->info->ptr;
		for (i=0;i<size;i++) {
			 if(bt_p_a->type->flags&BT_VI_F) ((char*)bt_p_b)+=VTBP_SIZE;
			 for (j=0;j<tot;j++) {
				 if(bt_p_b->info) bt_p_b->info->references++;
				 bt_p_b++;
			 }
		}
	}
	return 1;
}

int types_C::s_del(void* a,int pos,int n)
{
	gen_P bt_p=(gen_P)a;
	if (pos+n>bt_p->info->elements) return 0;
	int size=bt_p->type->s_lsize();
	char* gts;
	char* gtd;
	chknew(gts=new char[(bt_p->info->elements-n)*size]);
	chknew(gtd=new char[n*size]);
	int i,j,k;
	for (i=0;i<pos*size;i++)                  gts[i]=((char*)bt_p->info->ptr)[i];
	for (j=i,k=0;i<(pos+n)*size;i++,k++)      gtd[k]=((char*)bt_p->info->ptr)[i];
	for(;i<bt_p->info->elements*size;i++,j++) gts[j]=((char*)bt_p->info->ptr)[i];
	bt_p->info->elements-=n;
	delete (char*)bt_p->info->ptr;
	bt_p->info->ptr=gts;
	bt_p->type->s_delete((void*)gtd);
	return 1;
}


int types_C::s_redim(void* a, int n)
{
	gen_P bt_p=(gen_P)a;
	gen_P a_bt_p,b_bt_p;
	gen_B();
	void* ptr;
	int min;

	chknew(ptr=bt_p->type->s_new(n));

	if (n>bt_p->info->elements) min=bt_p->info->elements;
	else min=n;
	if (bt_p->bt&BT_BA) {
		int l;
		int size=min*bt_p->type->s_lsize();
		for(l=0;l<size;l++)
			((char*)ptr)[l]=((char*)bt_p->info->ptr)[l];
	}
	if (bt_p->bt&BT_BT) {
		int l;
		int size=min*(bt_p->type->s_lsize()/sizeof(gen_B));
		a_bt_p=(gen_P) bt_p->info->ptr;
		b_bt_p=(gen_P) ptr;
		if(bt_p->type->flags&BT_VI_F) {
			((char*)a_bt_p)+=VTBP_SIZE;
			((char*)b_bt_p)+=VTBP_SIZE;
		}

		for(l=0;l<size;l++)
			b_bt_p[l]=a_bt_p[l];
	}

	bt_p->type->s_delete(bt_p->info->ptr);
	bt_p->info->ptr=ptr;
	bt_p->info->elements=n;
	return 1;
}

void types_C::s_forget(void *a)
{
	dll_BAS_extra_C lista;
	gen_P bt_p=(gen_P) a;
	s_direct_externals(bt_p,&lista);
	if (lista.first())
	do {
		if(lista.item()->i)
			 s_propagate(lista.item()->gen);
	} while(lista.next());
	s_delete_bt(bt_p);
}


void types_C::s_direct_externals(void *a,void* lista_param)
{
	dll_BAS_extra_C* lista=(dll_BAS_extra_C*)lista_param;
	gen_P bt_p=(gen_P) a;
	extra_P extra;
	if (!bt_p->info) return;
	if (!bt_p->info->extra) {
		chknew(extra= new extra_C);
		extra->init(bt_p,bt_p->info->references-1);
		lista->insert_r(extra);
		if(bt_p->bt&BT_BT) {
			int n,tot;
			tot=s_no_bt(bt_p);
			gen_P bt_p2=(gen_P)(bt_p->info->ptr);
			if (bt_p->type->flags&BT_VI_F) ((char*)bt_p2)+=VTBP_SIZE;
			for (n=0;n<tot;n++)
				s_direct_externals(&bt_p2[n],lista);
		}
	}
	else
		((extra_P)bt_p->info->extra)->i--;
}


void types_C::s_propagate(void *a)
{
	gen_P bt_p=(gen_P) a;
	if (!bt_p->info) return;
	if (((extra_P)bt_p->info->extra)->flag1) return;
	((extra_P)bt_p->info->extra)->flag1=1;
	if(bt_p->bt&BT_BT) {
		int n,tot;
		gen_P bt_p2=(gen_P)(bt_p->info->ptr);
		if (bt_p->type->flags&BT_VI_F) ((char*)bt_p2)+=VTBP_SIZE;
		tot=s_no_bt(bt_p);
		for (n=0;n<tot;n++)
			s_propagate(&bt_p2[n]);
	}
	return;
}


void types_C::s_delete_bt(void *a)
{
	gen_P bt_p=(gen_P) a;
	if (!bt_p->info ) return;
	if (!((extra_P)bt_p->info->extra)->flag1 && bt_p->info->ptr) {
		 void* paso=bt_p->info->ptr;
		 bt_p->info->ptr=NULL;
		 bt_p->type->s_delete(paso);
		 n_bt--;
		#ifdef DEBUG_BT
		 printf("BT:%d\n",n_bt);
		#endif
	}
	bt_p->info->references--;
	bt_p->info=NULL;
}


int types_C::is_void()
{
	return !info;
}

int types_C::elements()
{
	if (!info) return 0;
	else return info->elements;
}



int types_C::redim(int n)
{
  if (info) {
	  if(n>1) set_bt(BT_AR);
	  else    clear_bt(BT_AR);
	  return s_redim(this,n);
  }
  else
	  return 0;
}


void types_C::put_bt(char param)
{
	bt=param;
}

void types_C::set_bt(char param)
{
	bt=bt|param;
}

void types_C::reset_bt()
{
	bt=init_bt;
}

void types_C::clear_bt(char param)
{
	bt=bt&~param;
}

void types_C::secure()
{
	if (!secure_f && info) {
		info->secure++;
		secure_f=1;
	}
}


void types_C::release()
{  if (secure_f && info) {
		if(info) info->secure--;
		secure_f=0;
	}
}

int types_C::size(int op)
{
	gencode_C gencode;
	gencode.operation=ENSIZE;
	gencode.DR=op;
	s_code(this,NULL,gencode);
	gencode.end();
	return gencode.size;

}

int types_C::encode(void* dump ,int op)
{
  gencode_C gencode;
  gencode.operation=ENCODE;
  gencode.DR=op;
  s_code(this,dump,gencode);
  gencode.end();
  return gencode.size;
}

int types_C::decode(void* dump ,int op)
{
  gencode_C gencode;
  gencode.operation=DECODE;
  gencode.DR=op;
  s_code(this,dump,gencode);
  gencode.end();
  return gencode.size;
}

int types_C::encode(FILE* file ,int op)
{
  gencode_C gencode;
  gencode.operation=ENCODE;
  gencode.DR=op;
  gencode.file=file;
  s_code(this,NULL,gencode);
  gencode.end();
  return gencode.size;
}

int types_C::decode(FILE* file ,int op)
{
  gencode_C gencode;
  gencode.operation=DECODE;
  gencode.DR=op;
  gencode.file=file;
  s_code(this,NULL,gencode);
  gencode.end();
  return gencode.size;
}

