                      ---------------------------------
                      DOCUMENTATION FOR PROGRAM 'FIELDS'
                      ---------------------------------

                      Version 1.01 - Copyright 1991/1992
                          Solar Terrestrial Dispatch


     The program FIELDS is powerful utility program included on the BCAST
distribution disk.  This program lets you customize the extraction of data
from the BCAST database file so that the data can be stored in a textual form
which can be read directly by other external data processors such as
spreadsheets, statistical processors, or graphical analysis packages such as
GLE, etc.

     FIELDS operates by extracting specific data values (or fields) from the
database file and displaying them or placing them in another text ASCII file
in a format of your choosing.

     In order for FIELDS to operate properly, it must know the name of the
file containing the format it is to use to create the textual data file.
This format file can be created using a simple text editor.  The contents of
a simple example format file is given below.  It consists of a single line of
text containing four acronyms beginning with a percent sign (%) and separated
by blank spaces:

%a %d %e %f

FIELDS scans this sample format file and replaces each of the acronyms with a
value from each record in the database file.  In this example, the acronyms
are defined as:

          %a = Record Number
          %d = 10.7 cm Solar Radio Flux
          %e = Sunspot Number
          %f = 90-Day Average Solar Flux

After FIELDS processes this sample format file, it reads each of the records
in the database file created by BCAST and extracts the four values given
above.  It then either displays these values on-screen or creates another
text file and writes the values there.  Here is a sample output from FIELDS:

     1 204.2 254 198
     2 208.6 267 198
     3 212.8 272 199
     4 215.1 270 200
     5 214.7 260 200

This is the output which FIELDS would produce with the sample format file
above, provided five records (or datasets) existed in your BCAST database
file.  Notice that each line produced by FIELDS is in the same format as the
format file given above.  The values are also all separated by a single blank
space, as they are in the format file.

     FIELDS is not limited to handling simple single-line format files such
as the example given above.  Indeed, things can become significantly more
complex.  The following format file shows you just how complex the format
specification can become.  It should be noted that this next example lists
almost all of the acronyms which FIELDS can process.  A formalized definition
of the available acronyms will be discussed shortly.

----------------------------  File: EXAMPLE.FMT  ----------------------------
RECORD NUMBER: %a, Date=%i/%j/%k, DOY=%l
Flux=%d, SSN=%e, 90AVG=%f, BAI=%g, PAI=%h
Boulder K-Indices: %m, Planetary K-Indices: %n
BGXRAY=%o, Fluence(1Mev)=%p, Fluence(10MeV)=%q,
3-Hr Boulder Deviations=%s, Avg Deviation=%r
SWF episodes=%t, SWF Duration=%u, Boulder Total Field Avg=%y
Avg Xray Flux=%v, Neutron Avg=%w%%, PCA Avg=%x
Xray Max=%za, Xray Min=%zb, Neu-Max=%zc%%, Neu-Min=%zd %%
PCA-Max=%ze, PCA-Min=%zf, Total Field Max=%zg, Total Field Min=%zh
GOES-7 AVg Par=%zi, Avg Earth=%zj, Avg Perp=%zk, Max=%zl, Min=%zm
GOES-6 AVg Par=%zn, Avg Earth=%zo, Avg Perp=%zp, Max=%zq, Min=%zr

----------------------------     End of File     ----------------------------

This file (excluding the first and last dashed lines) may be found with the
BCAST distribution disk under the filename "EXAMPLE.FMT".  Note that there is
a blank line at the end of the file (following the GOES-6 statistics line).
Without this blank space, all of the data for each record in the database
file would be squished together.  By placing a single blank line at the end
of the file, each record output by FIELDS is separated by a blank line.

With the format file give above, FIELDS would produce an output as follows:

---------------------------  Sample FIELDS Output  --------------------------
RECORD NUMBER:     1, Date=09/04/91, DOY=247
Flux=171.0, SSN=219, 90AVG=207, BAI= 12, PAI= 15
Boulder K-Indices: 2 3 4 3 3 2 1 2, Planetary K-Indices: 3 3 4 3 3 2 2 2
BGXRAY=0.00000100, Fluence(1Mev)=2.2E+05, Fluence(10MeV)=8.9E+03,
3-Hr Boulder Deviations= 18  21  45  30  26  14   8  19, Avg Deviation= 22
SWF episodes= 3, SWF Duration= 26, Boulder Total Field Avg=55301
Avg Xray Flux=0.00000170, Neutron Avg=  0.7%, PCA Avg= -0.1
Xray Max=0.00001500, Xray Min=0.00000085, Neu-Max=   3%, Neu-Min=  -1 %
PCA-Max=  0.0, PCA-Min= -0.4, Total Field Max=55317, Total Field Min=55272
GOES-7 AVg Par=   70, Avg Earth=   62, Avg Perp=    2, Max=  106, Min=  -39
GOES-6 AVg Par=   79, Avg Earth=   24, Avg Perp=   14, Max=  106, Min=   -6

RECORD NUMBER:     2, Date=09/05/91, DOY=248
Flux=164.0, SSN=204, 90AVG=206, BAI= 25, PAI= 29
Boulder K-Indices: 5 4 5 4 3 3 2 3, Planetary K-Indices: 5 4 5 4 4 3 3 3
BGXRAY=0.00000086, Fluence(1Mev)=2.7E+05, Fluence(10MeV)=8.3E+03,
3-Hr Boulder Deviations= 93  51  73  60  23  30  12  21, Avg Deviation= 45
SWF episodes= 5, SWF Duration= 79, Boulder Total Field Avg=55301
Avg Xray Flux=0.00000250, Neutron Avg=  0.5%, PCA Avg= -0.1
Xray Max=0.00004400, Xray Min=0.00000080, Neu-Max=   3%, Neu-Min=  -2 %
PCA-Max=  0.7, PCA-Min= -0.2, Total Field Max=55331, Total Field Min=55263
GOES-7 AVg Par=   67, Avg Earth=   63, Avg Perp=    2, Max=  113, Min=  -52
GOES-6 AVg Par=   73, Avg Earth=   26, Avg Perp=   14, Max=  101, Min=  -10
---------------------------     End of Output      --------------------------

Notice how the blank line at the end of the format file produces a break
between records as output by FIELDS.  Also notice that each acronym is
replaced with a properly formatted output, right-justified to fit within the
field and padded with blank spaces.

     Each of the available acronyms are discussed below.  Acronyms are
identified by a preceding percent sign.  All acronyms used by FIELDS must be
labelled in this manner.  If the leading percent sign is not included, FIELDS
will treat the acronym as part of the text within the format file and will
not process it.  The acronyms are case insensitive.  You may therefore use
either lower or upper case acronyms.


                          LIST OF AVAILABLE ACRONYMS
                          --------------------------

%a = The record number of the dataset within the database file.
%b = A general integer counter.  Each time FIELDS encounters this acronym, it
     replaces it with the current value of the counter and then increments
     the counter by one.  This may be useful for counting subsets of data
     such as K-indices.
%c = When FIELDS encounters this acronym, it resets the general integer
     counter (%b) to one (1).
%d = FIELDS replaces this acronym with the 10.7 cm solar radio flux value.
%e = This is the acronym for the sunspot number.
%f = Average 90-day solar flux value.
%g = Boulder A-Index.
%h = Planetary A-Index.
%i = Month of the dataset (from 1 to 12).
%j = Day of the dataset.
%k = Year of the dataset.
%l = The day of year of the dataset (from 1 to 365).
%m = Boulder K-Indices.  FIELDS replaces this acronym with eight K-indices
     separated by a single blank space.
%n = Planetary K-Indices.  The output format is the same as with %m.
%o = Background x-ray flux.  These values are given in watts / meter^2.
%p = Daily proton fluence at greater than 1 MeV.
%q = Daily proton fluence at greater than 10 MeV.
%r = Average daily maximum deviation of the Boulder USGS magnetometer.
%s = The eight daily maximum deviation values of the Boulder magnetometer.
     These values are related to the Boulder K-Indices.
%t = Estimated maximum number of daily Short Wave Fadeout (SWF) episodes.
%u = Estimated maximum combined daily duration of the SWFs in minutes.
%v = Average daily x-ray flux (given in watts / meter^2).
%w = Average daily neutron monitor count.
%x = Average daily Polar Cap Absorption (PCA) value.
%y = Average Total Field value of the geomagnetic field at Boulder, Colorado.
%z = FIELDS uses this acronym as an extension.  In order for FIELDS to
     process other acronyms in addition to those given above, this acronym
     must be followed by another letter.  The extended list of acronyms are:
%za = Observed daily maximum x-ray flux (in watts / meter^2).
%zb = Observed daily minimum x-ray flux (in watts / meter^2).
%zc = Observed daily maximum neutron monitor count.
%zd = Observed daily minimum neutron monitor count.
%ze = Observed daily maximum PCA value.
%zf = Observed daily minimum PCA value.
%zg = The daily maximum total field value over Boulder.
%zh = The daily minimum total field value over Boulder.
%zi = Daily average value of the parallel magnetic component as observed by
      the GOES-7 geosynchronous satellite.
%zj = Daily average value of the earthward magnetic component at GOES-7.
%zk = Daily average value of the perpendicular magnetic component at GOES-7.
%zl = Observed daily maximum magnetic field value of either of the three
      magnetic components at GOES-7.
%zm = Observed daily minimum magnetic field value of either of the three
      magnetic components at GOES-7.
%zn = Daily average value of the parallel magnetic component as observed by
      the GOES-6 geosynchronous satellite.
%zo = Daily average value of the earthward magnetic component at GOES-6.
%zp = Daily average value of the perpendicular magnetic component at GOES-6.
%zq = Observed daily maximum magnetic field value of either of the three
      magnetic components at GOES-6.
%zr = Observed daily minimum magnetic field value of either of the three
      magnetic components at GOES-6.
%%  = This is a special acronym used by FIELDS.  Since the percent-sign (%)
      is already used by FIELDS to denote a processable acronym, FIELDS uses
      this %% acronym to output a single percent-sign.  So, for example, by
      placing "%%%%" in the format file, FIELDS will output two percent
      signs.


     The power of FIELDS comes from the use of these acronyms.  Using FIELDS,
you can develop custom versions of the BCAST database which can be more
easily imported by other external software processing programs.  A good
example is the professional scientific GLE program, which will read in data
in textual format and produce publishable graphs or other images in a variety
of formats (ex. dot-matrix, LaTeX, or PostScript).  GLE was not developed by
the Solar Terrestrial Dispatch, but may be freely downloaded from the STD
computer BBS in the Utilities file section.

     To run FIELDS, make sure an appropriate format file exists.  You need
not be in the same directory as the BCAST database file "DATASETS.DAT" to
execute FIELDS, provided the "BCAST" environment variable points to the
location of the database file.  The syntax for FIELDS is:

                       FIELDS format_file > output_file

If the redirection command "> output_file" is not included, FIELDS will
display the output on-screen.  In order to produce an output file, the
redirection command must be included on the command line.

     For example, to process the BCAST database file using the sample format
file "EXAMPLE.FMT" (which is included with this software package), simply
execute FIELDS with the following command at the DOS prompt:

                       FIELDS EXAMPLE.FMT > OUTPUT.TXT

Provided data actually exists in the database file, FIELDS will produce an
output file named "OUTPUT.TXT" similar in format to what was shown earlier in
this manual.

     It should be noted that in order to generate a BCAST database file which
FIELDS can process, you must register your version of BCAST with the Solar
Terrestrial Dispatch (see the file "REGISTER.DOC" for more information).

