#!C:/Perl/bin/perl.exe
#!/usr/bin/perl


######################################################################################
# LICENSE No: #???????
######################################################################################
#
#
#MySQL(TM) Data Manager v1.43
#
#Copyright  2001 Ioannis Livassov
#
#Licence agreement and limited warranty
#
#MySQL Data Manager (Software) is protected by Copyright Law and
#International Treaty.
#
#You should carefully read the terms and conditions of this agreement
#before purchasing and installing the Software.  
#
#If you do not agree to any of the terms of this License, then do not
#purchase, install, or use this Software.  
#
#One purchased copy of the Software may be only used or installed on
#a single computer used by many people. This is not a concurrent use
#license. If you need another copy of the Software to be installed
#you must purchase another license.
#
#You may access this program through a network by a number of remote
#computers.  
#
#This Software is distributed as it is and with no warranties of any
#kind, whether expressed or implied. Experience dictates that any
#program be thoroughly tested with non-critical data before relying on
#it.  The user must assume the risk of using the program.  This
#disclaimer of warranty constitutes an essential part of this License
#Statement. 
#
#Any liability of the distributor will be limited exclusively to
#refund of purchase price.  In no event shall the distributor, or its
#officers, employees, affiliates, contractors, subsidiaries, or parent
#organizations, be liable for any incidental, consequential, or punitive
#damages whatsoever relating to the use of this Software.
#
#This Agreement is the complete statement of the Agreement between the
#parties on the subject matter, and merges and supersedes all other or
#prior understandings, purchase orders, agreements and arrangements.
#
#You may not sell, rent, lease or redistribute the Software in any form
#without prior written consent. You may create derivative works using its
#code partially providing an appropriate references, assuming the purpose
#of the resulting product will be completely different from that of initial
#program. You may of course modify or improve a reasonably small part of
#the code of this Software in order to fit better to your needs provided
#the Software logo,  its look and feel and the text of this license
#agreement  remain intact.
#
# 
#
#MySQL is a trademark of TcX DataKonsultAB
#
######################################################################################
use CGI::Carp qw(fatalsToBrowser carpout);
use File::Copy;
use CGI;
use DBI;
use strict;
my $q = new CGI;


my $host			= $ENV{HTTP_HOST};
my $full_url 		= $q->url();
my $driver 			= 'mysql';
my $WIN32 			= 1 if ($^O =~ /win32/i);
my $delim			= $WIN32 ? "\\" : '/';
my ($HOME,$SelectRows,$UpdateRows,$DEFAULTHOST,$SOCKET,$MYSQL,$configFile, $HELP,
	$OTHER_MYSQL,$USER_DIR,$MAX_BACKUP_SIZE,$MAX_SCRIPT_SIZE,$CONTACT_EMAIL,
	$COMPRESS,$ALLOW_ZIP,$ALLOW_GZIP,$ZIP,$ZIPLOG,$ERRLOG,$ERROR_LOG, $PRINT_POP_UP );
######################################################################################
# INSTALLATION (Refer to http://www.edatanew.com/about/)
######################################################################################
#
# Path to Configuration File:
# It can be either full or relative path.
# On Linux/Unix systems chmod mdmConfig directory to 777
$configFile = './mdmConfig/mdmConfig.conf';
# To disable interactive setup remark or delete the line above:
#####################################################################################



if ($configFile and -e $configFile){
	open FH, $configFile or die $!;
	flock (FH,2) unless $WIN32;
	my @config;
	while(<FH>){
		push @config, $_;
	}
	flock (FH,8) unless $WIN32;
	close FH;
	my @default			= ();
	my $config 			= readconfig(\@config);
	push @default, "host=$config->{defaultHost}" if $config->{defaultHost};
	push @default, "port=$config->{defaultPort}" if $config->{defaultPort};
	$DEFAULTHOST		= join (';', @default);
	$HOME				= $config->{homeURL};
	$SOCKET 			= $config->{defaultSocket};
	$MYSQL				= $config->{mysql};
	$OTHER_MYSQL		= $config->{otherMysql};
	$USER_DIR			= $config->{userDirectory};
	$MAX_BACKUP_SIZE	= $config->{backupMax};
	$MAX_SCRIPT_SIZE	= $config->{SQLMax};
	$CONTACT_EMAIL		= $config->{adminEmail};
	$COMPRESS			= $config->{compressCommand};
	$ALLOW_ZIP			= $config->{allowZIP};
	$ALLOW_GZIP			= $config->{allowGZIP};
	$ZIP				= $config->{zipSyntax};
	$ZIPLOG				= $config->{zipLog};
	$PRINT_POP_UP		= $config->{printPopUp};
	$HELP				= $config->{helpURL};
	
# NUMBER OF ROWS TO BE SHOWN INITIALLY IN "SELECT" AND "UPDATE" FUNCTIONS
	$SelectRows			= '10';
	$UpdateRows 		= '10';
	
	
}
else {

######################################################################################
#							INITIAL SETTING											 #
######################################################################################

# NUMBER OF ROWS TO BE SHOWN INITIALLY IN "SELECT" AND "UPDATE" FUNCTIONS
	$SelectRows			= '10';
	$UpdateRows 		= '10';


# HOME PAGE FULL URL
	$HOME				= "http://$host";

# COMMON CONNECTION PARAMETERS:

# PATH TO SOCKET FILE AND DEFAULT HOST. THE STRINGS ARE USED WHEN THE FIELD 'HOST' (LOGIN PAGE)IS BLANK.
# (CORRECT THIS VALUE AS NEEDED. FOR EXAMPLE UNDER WINDOWS IT MAY BE SOMETHING
# LIKE: 	$DEFAULTHOST	= 'host=localhost:3306';
#			$SOCKET = '';

	$DEFAULTHOST		= 'host=localhost:3313';
	$SOCKET 			= '/tmp/mysql.livassov';

# OTHER PARAMETERS USED TO RUN mysql UTILITY ONLY

# PATH TO mysql CLIENT (CORRECT THIS VALUE AS NEEDED. FOR EXAMPLE UNDER WINDOWS 
# IT WILL BE SOMETHING LIKE: 
# $MYSQL = 'c:\mysql\bin\mysql.exe';
	$MYSQL 				= '/usr/local/mysql/bin/mysql';

# (SUBSTITUTE THESE VALUES WITH CORRECT ONES):
# FOR EXAMPLE: SET 'SILENT' AND 'COMPRESS': my $OTHER_MYSQL = '-s -C';
# FOR MORE OPTIONS RUN 'mysql -?' IN COMMAND LINE.
	$OTHER_MYSQL 				= '';


# PATH TO USER DIRECTORY (CORRECT THIS VALUE AS NEEDED.)
# CAUTION! If you created some backup files as user 'Username' connected to a location
# 'Location1' and then connect different location 'Location2',
# the program will treat you as different user (even if you use the same user name)
# and created earlier files will be unreachable.
# Each user 'username' connected the location 'locationname' will be provided with his
# own subdirectories:
#  /path/to/user_directory/usename.locationname/sql
#  /path/to/user_directory/usename.locationname/backup  
# or under Windows
# D:\path\to\user_directory\usename.locationname\sql
# D:\path\to\user_directory\usename.locationname\backup 
# It also works if you put something like this (under Windows)
# \path\to\usr - the program treats it as: 
# C:\path\to\usr if the current disk drive is C: (D:\... if the current disk drive is D:, etc.)
# 
# the directories usename.locationname/sql and usename.locationname/backup will be created
# by the program
	$USER_DIR 					= '/home/myrootname/data/usr';

# MAXIMUM TOTAL SIZE OF BAKUP FILES PER USER/HOST (kilobytes). UNLIMITED IF EQUALS ZERO.
	$MAX_BACKUP_SIZE 			= 200;

# MAXIMUM TOTAL SIZE OF USER SCRIPTS
	$MAX_SCRIPT_SIZE 			= 50;

# CONTACT EMAIL(TO BE USED IN SOME ERROR MESSAGES
	$CONTACT_EMAIL 				= 'my@address.com';

# MANUAL COMPRESSING: zip OR gzip ?
	$COMPRESS 					= 'gzip';

# SET ZERO IF ZIP UTILITY IS NOT INSTALLED (to be used for backup file compressing);
	$ALLOW_ZIP 					= 1;

# SET THIS VARIABLE ZERO IF GZIP UTILITY IS NOT INSTALLED. (used for backup file compressing)
	$ALLOW_GZIP 				= 1;

# "zip -qj" - ZIP UTILITY CALL UNDER UNIX/LINUX.
# "Wzzip -Pr" OR "Wzzip" ZIP UTILITY CALL UNDER WINDOWS.
# (WinZip COMMAND LINE UTILITY - SEE http://www.winzip.com).
# USUALLY UNDER UNIX/LINUX THIS UTILITY IS ALREADY INSTALLED.
# IF ANY OTHER ZIP UTILITY IS USED UNDER WINDOWS OR ANOTHER OPERATION SYSTEM,
# CORRECT THE LINE BELOW ACCORDINGLY. (used for backup file compressing)
# IF $ALLOW_ZIP =0 YOU CAN LEAVE IT BLANK: $ZIP = '';

#$ZIP = 'Wzzip -Pr'; 
#$ZIPLOG = "1>NUL"}    #Win32
	$ZIP 						= 'zip -qj';	#UNIX/LINUX 

# UNDER WINDOWS IT CAN LOOK LIKE:
#	 $ZIP = 'Wzzip'; # OR $ZIP = 'Wzzip -Pr'
#	 $ZIPLOG = "1>NUL";
# THE VARIABLE $ZIPLOG IS USED TO REDIRECT THE OUTPUTOF THE UTILITY Wzzip.

# SET THIS VARIABLE EQUALS TO 0 IF YOUR WEB BROWSER DOES NOT SUPPORTS window.print() 
# JAVASCRIPT FUNCTION.
	$PRINT_POP_UP 				= 0 ;

#SET URL OF 'HELP' DIRECTORY:
	$HELP 						= "../help";
#------------------------------------------------------------------------------------#
# END OF MANUAL SETTING
#####################################################################################
}

my ($query, @ary);
my @selectlike = (
					'select',
					'show',
					'explain',
					'describe',
					'desc'
);

#++++++++++++++++++++++++++++++++++++++

my @typelist = (   	'TINYINT',
					'SMALLINT',
					'INT',
					'MEDIUMINT',
					'BIGINT',
					'FLOAT',
					'DECIMAL',
					'DOUBLE',
					'CHAR',
					'VARCHAR',
					'ENUM',
					'SET',
					'TINYBLOB',
					'TINYTEXT',
					'BLOB',
					'TEXT',
					'MEDIUMBLOB',
					'MEDIUMTEXT',
					'LONGBLOB',
					'LONGTEXT',
					'DATE',
					'TIME',
					'TIMESTAMP',
					'DATETIME',
					'YEAR'
  

);

my %auto_type = (
					TINYINT		  	  =>1,
					SMALLINT		  =>1,
			   		INT	  		  	  =>1,
					MEDIUMINT		  =>1,
					BIGINT			  =>1,
					FLOAT			  =>1,
					NUMERIC			  =>1,
					REAL			  =>1,
					DOUBLE		  	  =>1,
					DECIMAL			  =>1,
					CHAR			  =>1,
					VARCHAR			  =>1,
);
my @textdata = (	'TINYBLOB',
					'BLOB',
					'MEDIUMBLOB',
					'LONGBLOB',
					'TINYTEXT',
					'TEXT',
					'MEDIUMTEXT',
					'LONGTEXT'
);

my $page = $q->param('page');


if (($page eq 'logout') or !$page){
	&logout();
	&printparam();
	exit;
}
elsif ($page eq 'setup') {
	&setup();
	&printparam();
	exit;
}

my $NO_HEADER = 1 if (( $q->param('downloadBackup') 
				and ($q->param('func') =~ /backup/i) 
				or $q->param('downloadFile')));

my ($user, $password, $MySQLhost, $usedefault, $database);

$DEFAULTHOST = "mysql_socket=$SOCKET;".$DEFAULTHOST if $SOCKET;
if ($q->param('login')) {
	$user 		= $q->param('user');
	$password	= $q->param('password');
	unless  ($q->param('host')) {
		$MySQLhost			= $DEFAULTHOST;
		$usedefault			= 1;
	}
	else {
		$MySQLhost			= 'host='.$q->param('host');
		$usedefault			= 0;
	}
	if ($q->param('host')	=~ /database=([a-zA-Z0-9_]*)/){$database=$1}
	else {$database 		= $q->param('dbname')}

    my $cookies = $q->cookie(	
							-name=>'db_manager',
    						-value=>[$user, $password, $MySQLhost, $usedefault],
    						-secure=>0
    						);
    print 	$q->header(-cookie=>$cookies, -expires=>0);
	$page = 'select_db'	if ($database and ($page eq 'connect')); 
		  
} #IF
else {
	$database 									= $q->param('dbname');
	($user, $password, $MySQLhost, $usedefault) = $q->cookie('db_manager');
	if (defined $q->param('change_password')){
		$password 	= $q->param('change_password');
		
    	my $cookies = $q->cookie(	
							-name=>'db_manager',
    						-value=>[$user, $password, $MySQLhost, $usedefault],
    						-secure=>0
    						);
    	print 	$q->header(-cookie=>$cookies, -expires=>0);		
		
	}
	else {print $q->header(-expires=>0) unless $NO_HEADER}
	$MySQLhost	= $DEFAULTHOST if ($usedefault);
} #ELSE

#++++++++++++++++++++++++++++++++++++++

my $print = "print" if ($q->param('func') =~ /print/i);
&startpage($user, $database) unless $NO_HEADER;
my (%attr) =
(
					PrintError => 0,
					RaiseError => 0,
					#AutoCommit => 0
);


my $dsn					= "DBI:$driver:$database;$MySQLhost";
my $dsn_ 				= $dsn;
$dsn_ 					= "DBI:$driver:$database:defaulthost" if ($usedefault);
my $dbh 				= DBI->connect($dsn, $user, $password,\%attr)
	or &bail_out("(DSN, user, password): $dsn_, $user, $password");

undef $dsn_; 
my $connected 			= 1;

{
	my ($sth, $res)		= prepare_execute("SELECT VERSION()");
	my $version 		= $sth->fetchrow_array();
	$sth->finish();
	sub check_version {
	#input: version number NN.NN.NNanythyng
	#returns undef if current version is lower then required
	#returns 1 if OK;
		my (@v,@x);
		if ($version =~ /^(\d*)\.(\d*)\.(\d*).*/)	{@v = ($1,$2,$3)}
		if ($_[0] =~ /^(\d*)\.(\d*)\.(\d*)/)	{@x = ($1,$2,$3)}
		if ($v[0] < $x[0]){return undef} elsif ($v[0] > $x[0]){return 1}
		if ($v[1] < $x[1]){return undef} elsif ($v[1] > $x[1]){return 1}
		if ($v[2] < $x[2]){return undef} else {return 1} ;
	}
	sub get_version{$version}
 
}
if (check_version('3.23.00')){
   push @selectlike, ('optimize','check','analyze','repair');
   undef $auto_type{'VARCHAR'}; undef $auto_type{'CHAR'};
}

if ($page eq 'admin'){
    my $back					= {page => "admin"};
	$back->{dbname}	  			= "$database" if $database;
	$back->{selectdbname_}		= $q->param('selectdbname_') if $q->param('selectdbname_');
	my $func = $q->param('func');
	if		($func =~ /flush/i)				{&execFlush($back);&loadAdmin()}
	elsif	($func =~ /show/i)				{&execShow($back)}
	elsif	($func =~ /backup/i)			{&execBackup();&loadAdmin()}
	elsif	($func =~ /(restore)|(file)/i)	{&loadRestore()}
	elsif	($func =~ /analyze/i)			{&execCheckRepair($back, 'ANALYZE')}
	elsif	($func =~ /check/i)				{&execCheckRepair($back, 'CHECK')}
	elsif	($func =~ /repair/i)			{&execCheckRepair($back, 'REPAIR')}	
	elsif	($func =~ /optimize/i)			{&execCheckRepair($back, 'OPTIMIZE')}
	elsif	($func =~ /access/i)			{&loadAccessControl($back)}
	else {&loadAdmin()}
}
elsif ($page eq 'select_db') {
   if 	($q->param('tableops') =~ /execute/i) {execExecuteQuery({'page' => 'connect'})}
   elsif ($q->param('cancel')){&loadSelectDB()}
   elsif ($q->param('tableops') =~ /drop/i) {dropcreatedb('drop')}
   elsif ($q->param('tableops') =~ /create/i) {dropcreatedb('create')}
   elsif ($q->param('func') eq 'stat') {&loadDBstat()}
   else  {&loadSelectTables()}
}
elsif (!$database) {
	if ($page eq 'ddl') {
		execExecuteQuery()  if ($q->param('apply'));
	}
	   &loadSelectDB();
}
elsif ($page eq 'tables') {
    my $func = $q->param('func');
	if 	  ($func =~ /describe/i){&execDescribeTables()}
	elsif ($func =~ /(alter)|(create)/i){&loadAlterTable()}
	elsif ($func =~ /(insert)|(search)/i){&loadInsertForm()}
	elsif ($func =~ /update/i){&loadUpdateForm()}
	elsif ($func =~ /select/i){&execSelectFromTable()}
	elsif ($func =~ /drop/i){&loadDropPreview()}
	elsif ($func =~ /delete/i){&loadDeletePreview()}
	elsif ($func =~ /generate/i){&execGenerateDDL()}
	elsif ($q->param('script')){&loadexecscript()}
	else  {print "<P>Select something!"}
}
elsif ($page eq 'search') {
	my $func = $q->param('func');
	if ($func =~ /return/i){&loadInsertForm()}
	else {&execSearch}
}elsif ($page eq 'searchresult') {
	my $func = $q->param('func');
	if		(($func =~ /prev/i) or ($func =~ /next/i)){&searchresult()}
	elsif	($func =~ /back/i){&loadInsertForm()}
	elsif	($func =~ /edit/i){&loadInsertForm()}
	elsif	($func =~ /new/i){&loadInsertForm()}
	elsif	($func =~ /return/i){&searchresult()}
	elsif	($func =~ /insert/i){&execInsertData()}
	elsif	($func =~ /delete/i){&searchresult()}
	elsif	($print){&searchresult()}
	else	{&execSearch}
}

elsif ($page eq 'insert') {&execInsertData}
elsif ($page eq 'alter') {&execAlterTable}
elsif ($page eq 'update') {&execUpdateData}
elsif ($page eq 'updateAfterPreview') {&execUpdateAfterPreview}
elsif ($page eq 'alterAfterPreview') {&execAlterAfterPreview}
elsif ($page eq 'drop') {&execDropTable}
elsif ($page eq 'delete') {&execDeleteFromTable}
elsif ($page eq 'ddl') {&execExecuteQuery() if ($q->param('apply'));
	  &loadSelectTables();
}

#++++++++++++++++++++++++++++++++++++++

else {print "<B>WRONG DATA</BR>"}
print "\n\n<!-- END OF PROCEDURE BODY -->\n\n";
print "\n\n\t\t</TD>\n\t</TR>\n</TABLE><!-- END OF MARGIN TABLE -->\n\n\n\n" unless $print;


print $q->end_html;
$dbh->disconnect;

&printparam;
printPopUp() if $print;
exit;
####################################################
#-----------------S U B R O U T I N S--------------#
####################################################
sub quoteit {
	my @output = @_;
	for (my $i=0; $i<@output; $i++) {
		$output[$i] =~ s{(.)}{
			if    ($1 eq '<')		{ '&lt;'    }
			elsif ($1 eq '>')		{ '&gt;'    }
			elsif ($1 eq '&')		{ '&amp;'   }
			elsif ($1 eq '"')		{ '&quot;'  }
			elsif ($1 eq "\x8b")	{ '&#139;'  }
			elsif ($1 eq "\x9b")	{ '&#155;'  }
			else					{ $1        }
       }gsex;
	}
	if (wantarray) {return (@output)}
	else {return $output[0];}
}

sub printparam {
	return;
	my @x=$q->param();
	my @values;
	print "\n\n\n\n<!-- PARAMETERS -->\n\n";
	print "<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=2 BGCOLOR='#CCCCCC'>\n\t<TR VALIGN=TOP>";
	my $max=1;
	for (my $i=0; $i<@x; $i++) {
		my @y = $q->param($x[$i]);
		$values[$i] = \@y;
		$max = scalar (@y) if (@y>$max);
		print "\n\t\t<TD BGCOLOR='#DDDDDD'>&nbsp;$x[$i]</TD>";
	}
	print "</TR>\n";
	for (my $j=0; $j<$max; $j++) {
		print "\t<TR VALIGN=TOP>\n";
		for (my $i=0; $i<@x; $i++) {
			${$values[$i]}[$j] =~ s/&/&amp;/g;
			${$values[$i]}[$j] =~ s/</&lt;/g;
			${$values[$i]}[$j] =~ s/>/&gt;/g;
			print "\t\t<TD BGCOLOR='#DDDDDD'>&nbsp;". ${$values[$i]}[$j] . "</TD>\n";
		}
		print "\t</TR>\n";
	}
print	"</TABLE>\n";
}
sub myhost {
	my ($host,$port);
	if ($MySQLhost =~ /host=(.*):(\d*)/){$host = $1; $port = $2} #a ...;host=hostname:3306...
	elsif ($MySQLhost =~ /host=([^;]*);/){$host = $1;}			 #b ...;host=hostname;...
	elsif ($MySQLhost =~ /^(.*):(\d*)/){$host = $1; $port = $2}	 #c hostname:3306...
	elsif ($MySQLhost =~ /^(.*);/){$host = $1}					 #d hostname;...
	elsif ($MySQLhost =~ /host=(\S+)\s*$/){$host = $1;}			 #b+ ...;host=hostname;...
	elsif ($MySQLhost =~ /=/){$host = ''}						 #e no hostname, but other params
	else {$host = $MySQLhost}									 #f hostname only
	if ($MySQLhost =~ /port=(\d*)/){$port = $1}
	if (wantarray){return($host, $port)}
	else {return($host)}
}
sub printPopUp {
	#if ($ENV{HTTP_USER_AGENT} =~ /MSIE/i){
		print "<script language=\"JavaScript1.2\">window.print()</script>" if $PRINT_POP_UP;
	#}
}
sub startpage {
	my $user_				= "USER:&nbsp;$_[0]" if ($page and ($page ne 'logout' and $page ne 'setup'));
	my $dbname_ 			= 'DATABASE: '.$database if ($page and $page ne 'logout' and $page ne 'connect' and $page ne 'setup');
	my ($hostname,$port) 	= myhost();
	$hostname 				.= ":$port" if $port;
	my $demomarker; 
#++++++++++++++++++++++++++++++++++++++

	my $host_ = "HOST: $hostname" if ($page and ($page ne 'logout' and $page ne 'setup'));
	
	my $title = $print ? quoteit($q->param('title')) : 'MySQL DATA MANAGER';
	$title = "Untitled" if ($title =~ /^\s*$/);
print <<EndOfHead
<HTML>
<HEAD>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=ISO-8859-1">
<TITLE>$title</TITLE>
</HEAD>

EndOfHead
;
#
unless ($print){
print <<EndOfStyle
<STYLE TYPE="text/css">
<!--
TD.header {height: 35px}
P.headh5 			{color: white; font-size: 16px; font-weight: bold; font-family: "Verdana", "Tahoma", "Arial", "Geneva"}
A.button			{color: white; font-size: 10px; font-weight: bold; font-family: "Verdana", "Tahoma", "Arial", "Geneva"}
A.button:hover		{color: white; text-decoration: none}
A.button:visited	{color: white; text-decoration: none}
body		{background: #CCCCCC; font-size: 11px; font-family: "Verdana", "Tahoma", "Arial", "Geneva"}
P,BR		{font-family: "Verdana", "Tahoma", "Arial", "Geneva"; font-size: 11px}
A			{color: #CC0000; font-weight: bold; text-decoration: none}
A:hover		{color: #CC0000; font-weight: bold; text-decoration: none}
A:visited	{color: #CC0000; font-weight: bold; text-decoration: none}
select		{font-family: "Verdana", "Tahoma", "Arial", "Geneva"; font-size: 11px}
textarea    {font-family: "Verdana", "Tahoma", "Arial", "Geneva"; font-size: 11px}
input       {font-family: "Verdana", "Tahoma", "Arial", "Geneva"; font-size: 11px}
TD,UL       {font-family: "Verdana", "Tahoma", "Arial", "Geneva"; font-size: 11px}
TR			{font-family: "Verdana", "Tahoma", "Arial", "Geneva"; font-size: 11px}
TH			{font-family: "Verdana", "Tahoma", "Arial", "Geneva"; font-weight: bold; font-size: 11px; color: #003466}
CODE		{font-family: "Verdana", "Tahoma", "Arial", "Geneva"; font-weight: bold; font-size: 12px}
H5			{font-family: "Verdana", "Tahoma", "Arial", "Geneva"; font-weight: bold; font-size: 16px; color: #ffffff}
H3			{font-family: "Verdana", "Tahoma", "Arial", "Geneva"; font-weight: bold; font-size: 12px; color: #003466}
EM			{font-family: "Verdana", "Tahoma", "Arial", "Geneva"; font-size: 10px}
-->
</STYLE>
EndOfStyle
;
}
	else {
		print <<EndOfStyle
<STYLE TYPE="text/css">
<!--
body		{background: #FFFFFF; font-family: "Verdana", "Tahoma", "Arial", "Geneva"; font-size: x-small}
P,BR		{font-family: "Verdana", "Tahoma", "Arial", "Geneva"; font-size: x-small}
TD,UL       {font-family: "Verdana", "Tahoma", "Arial", "Geneva"; font-size: x-small}
TR			{font-family: "Verdana", "Tahoma", "Arial", "Geneva"; font-size: x-small}
TH			{font-family: "Verdana", "Tahoma", "Arial", "Geneva"; font-weight: bold; ; font-size: x-small}
CODE		{font-family: "Verdana", "Tahoma", "Arial", "Geneva"; font-size: small}
H5			{font-family: "Verdana", "Tahoma", "Arial", "Geneva"; font-size: medium}
H3			{font-family: "Verdana", "Tahoma", "Arial", "Geneva"}
EM			{font-family: "Verdana", "Tahoma", "Arial", "Geneva"}
-->
</STYLE>
<BODY bgcolor="#FFFFFF">
EndOfStyle

;
		return;
	}
print <<HeadTable
<BODY bgcolor="#CCCCCC" link="#CC0000" vlink="#CC0000" alink="#CC0000" text="#000000" TOPMARGIN=0 LEFTMARGIN=0 MARGINWIDTH=0 MARGINHEIGHT=0>
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=100%>
	<TR BGCOLOR='#336699'>
		<TD WIDTH=20 HEIGHT=15 BGCOLOR='#336699'>&nbsp;</TD>
		<TD BGCOLOR='#336699'>&nbsp;</TD>
	</TR>
	<TR>
		<TD COLSPAN=2 BGCOLOR='#336699'>
<!-- LOGO TABLE -->
	<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=700>
		<TR>
			<TD WIDTH=20>&nbsp;</TD>
			<TD  ALIGN=LEFT HEIGHT=35 WIDTH=630><P CLASS="headh5"><FONT COLOR="#FFFFFF"><B>&nbsp;MySQL DATA MANAGER&nbsp;</B></FONT></P></TD>
			<TD WIDTH=50><B>$demomarker&nbsp;</B></TD>
		</TR>
	</TABLE>
		</TD>
	</TR>
	<TR BGCOLOR='#003366'>
		<TD COLSPAN=2 BGCOLOR='#003366' HEIGHT=17>
<!-- INFO TABLE -->
	<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=700>
		<TR>
			<TD WIDTH=20>&nbsp;</TD>
			<TD WIDTH=630><FONT COLOR="#336699">&nbsp;$user_ &nbsp;&nbsp;&nbsp;$dbname_ &nbsp;&nbsp;&nbsp;$host_ </FONT></TD>
			<TD WIDTH=50>&nbsp;</TD>
		</TR>
	</TABLE>
		</TD>
	</TR>
	<TR>
		<TD WIDTH=20 HEIGHT=15>&nbsp;</TD>
		<TD>&nbsp;</TD>
	</TR>
	<TR>
		<TD COLSPAN=2>
HeadTable
;
	printlinks();
	print <<EOT
		</TD>
	</TR>
	<TR>
		<TD WIDTH=20>&nbsp;</TD>
		<TD><BR>
<!-- PROCEDURE BODY STARTS HERE -->
EOT
;


#++++++++++++++++++++++++++++++++++++++
}#startpage

sub printlinks {
	my ($url1, $url2, $url3, $url4, $url5, $url6);
	my $func = $q->param('func');
	if ($page and ($page ne 'logout') and $page ne 'setup'){
    	if ($database) {
    		$url2 = "<A HREF=\"$full_url?page=select_db&tableops=show&dbname=$database\">SELECT TABLES</A>\n";
    	}
    	else {
    		$url2 = "<FONT COLOR='#999999'>SELECT TABLES</FONT>\n";
    	}
		my $selectdbname_ = "&selectdbname_=".$q->param('selectdbname_') if $q->param('selectdbname_');
		$url1 = "<A HREF=\"$full_url?page=connect\">SELECT DATABASE</A>\n";
		$url3 = "<A HREF=\"$full_url?page=logout\">LOG OUT</A>\n";
		$url5 = "<A HREF=\"$full_url?page=admin&dbname=$database$selectdbname_\">ADMINISTRATION</A>\n";
		$url4 = "<A HREF=\"http://www.edatanew.com\">HOME</A>\n";
		$url6 = "<A HREF=\"$HELP\" TARGET='_blank'>HELP</A>\n" if $HELP;
	}
	elsif($configFile) {
		$url1 = "<A HREF=\"http://www.edatanew.com\">HOME</A>\n" if $HOME;
		$url6 = "<A HREF=\"$HELP\" TARGET='_blank'>HELP</A>\n" if $HELP;
		$url2 = "<A HREF=\"$full_url?page=setup\">SETUP</A>\n";
		$url5 = "<A HREF=\"$full_url?page=logout\">EXIT SETUP</A>\n" if ($page eq 'setup');
	}
	else {
		$url1 = "<A HREF=\"http://www.edatanew.com\">HOME</A>\n" if $HOME;
		$url2 = "<A HREF=\"$HELP\" TARGET='_blank'>HELP</A>\n" if $HELP;
	}
print <<EOT

<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>
	<TR>
		<TD WIDTH="20">&nbsp;</TD>
		<TD WIDTH="140">$url1</TD>
		<TD WIDTH="130">$url2</TD>
		<TD WIDTH="140">$url5</TD>
		<TD WIDTH="100">$url3</TD>
		<TD WIDTH="100">$url4</TD>
		<TD WIDTH="160">$url6</TD>
	</TR>
</TABLE>

EOT
;
}

sub dropcreatedb{
	my $back = {page => "connect"};
	if ($_[0] eq 'drop') {
		if ($q->param('confirm')) {
			bail_out("Database is not selected",$back) unless $q->param('dbdrop');
#++++++++++++++++++++++++++++++++++++++
			my $query = "DROP DATABASE ".$q->param('dbdrop');
			bail_out("Cannot do query:\n$query", $back) unless ($dbh->do($query));
			&loadSelectDB();     
		}
		else {
			bail_out("Database is not selected",$back) unless $database;
			print "<BR><BR><B>Database $database will be dropped.</B><BR>\n";
  			print "<BR><B><FONT COLOR='#FF0000'><U>CAUTION!</U> SELECTED DATABASE IS NOT EMPTY</FONT></B><BR>\n" 
    			if (@{getTablelist($database)});
			print <<EndOfDrop
		<FORM METHOD=POST ACTION="$full_url">
		<INPUT TYPE=SUBMIT NAME='confirm' VALUE="CONFIRM">
		<INPUT TYPE=SUBMIT NAME='cancel' VALUE="CANCEL">
		<INPUT TYPE=HIDDEN NAME='page' VALUE="select_db">
		<INPUT TYPE=HIDDEN NAME='dbdrop' VALUE="$database">
		<INPUT TYPE=HIDDEN NAME='tableops' VALUE="drop">
		
		</FORM>
EndOfDrop
;
 		 
  		}
     
     }
	 elsif($_[0] eq 'create'){
		my $query = "CREATE DATABASE ".$q->param('newDB');
		bail_out("Cannot do query:\n$query", $back) unless ($dbh->do($query));
		&loadSelectDB();	 
	 }
}

sub getuserlist{
	my $query		= "SELECT host, user FROM mysql.user ORDER BY user";
	my $back 		= {page => 'connect'};
	$back 			= {page => 'select_db', dbname => $database} if $database;
	my $sth 		= $dbh->prepare($query) || bail_out ("Cannot prepare query:\n$query", $back);
	my $res 		= $sth->execute();
	my @userlist	= ();
	my $labelhash	= ();
	if ($DBI::err){push @userlist, '1'; $labelhash->{'1'} = 'ACCESS DENIED'}
	elsif ($DBI::err) {	bail_out ("Cannot execute:\n$query", $back)	}
	else {
		while (my $usersref		= $sth->fetchrow_arrayref) {
			my $label = $usersref->[1].'@'.$usersref->[0];
			$usersref->[0]	= $dbh->quote($usersref->[0]);
			$usersref->[1]	= $dbh->quote($usersref->[1]);
			my $value = $usersref->[1].'@'.$usersref->[0];
			push @userlist, $value;
			$labelhash->{$value} = $label;
		}
	}
	$sth->finish;
	if (@userlist == 0){$userlist[0] = '0'; $labelhash->{'0'} = "User List is empty"}
	if (wantarray){return \@userlist, $labelhash}
	else {return \@userlist}
}
sub getdblist {
	my $back				= {page => 'select_db', dbname => $q->param('dbname')} if $q->param('dbname');
	my $driversref			= $dbh->selectcol_arrayref("SHOW DATABASES");
	if ($DBI::err){
		if ($DBI::errstr =~ /access/i){$driversref->[0]	= $database if $database}
		else {bail_out("Cannot select Databases", $back)}
	}
	
	#unless ($driversref->[0]) {$driversref->[0]	= ''};
	return $driversref
}
sub getTablelist {
	my $query 				= "SHOW TABLES";
	$query 					.= " FROM $_[0]" if ($_[0]);
	my $back;
	unless ($back = $_[1]){$back = {page => 'connect'}}
	return  $dbh->selectcol_arrayref($query) || bail_out("Failed to execute:\n$query", $back);
}

sub getlimit {
	#input: $tabs - number of selected tables
	#output (for each table):
	# limit x,y  - arrayref
	# offset x - arrayref
	# rows y - arrayref
	my $tabs = shift;
	my (@limit, @offset, @rows);
	unless (defined $q->param('limit')) {
		@offset		= $q->param('offset');
        @rows 		= $q->param('rows');
		for(my $i=0; $i<$tabs; $i++) {
			$rows[$i]		= $rows[0] unless defined $rows[$i];
			$offset[$i]		= $offset[0] unless defined $offset[$i];
			$limit[$i]		= "$rows[$i]" if (($rows[$i] ne '') and ($offset[$i] eq ''));
			$limit[$i]		="$offset[$i], $rows[$i]" if (($rows[$i] ne '') and ($offset[$i] ne ''));
		}
	}
	else {
		@limit = $q->param('limit');
		for(my $i=0; $i<$tabs; $i++) {
			$limit[$i] = $limit[0] unless defined $limit[$i];
			if ($limit[$i] =~ /^(.+),(.+)$/){
			   $offset[$i] = $1;
			   $rows[$i] = $2;
			}
			elsif ($limit[$i] !~ /,/) {
			   $offset[$i] = '';
			   $rows[$i] = $limit[$i];
			}
		}	
	}
	return (\@limit, \@offset, \@rows)
}

sub bail_out {
# $_[0] - error message
# $_[1] - link back if $_[2] is not defined or zero or HIDDEN INPUTs leading back if $_[2]
# $_[2] - if zero $_[1] is interpreted as part of URL, if set $_[1] is HIDDEN INPUTs
	if ($NO_HEADER){
		print $q->header(-expire=>0);
		&startpage($user, $database);	
	}
	my $message = quoteit($_[0]);
	$message =~ s/$/<BR>/mg;
	print "\n\n<!--   ------BAIL_OUT------   -->";
    print "\n\n<P><B>$message</B><BR>";
	if ($DBI::err){
		my $message_ = quoteit($DBI::errstr);
		$message_ 	 =~ s/^/<BR>/mg;
		print "Error  $DBI::err ($message_)\n</P>\n" ;
	}
	if ($_[2] eq 2){
		print qq!</FORM><FORM METHOD=POST ACTION=$full_url>\n!;
	}
	elsif (!$_[2]){
		print qq!<FORM METHOD=POST ACTION=$full_url>\n!;
	}
	my $input = $_[1];
	print qq!<INPUT TYPE=SUBMIT VALUE="Back">\n! unless ($_[2] == 3);
	foreach (keys %$input){
		print $q->hidden(-name=>$_, -value=>$_[1]->{$_}, -override=>1),"\n";
	}
	print "\n\t\t</FORM></TD>\n\t</TR>\n</TABLE>\n\n\n\n" unless $print;
	print $q->end_html;
#---errlog---
#++++++++++++++++++++++++++++++++++++++
	

    $dbh->disconnect() if ($connected);
	&printparam();
	exit 0;
}

sub ErrMessage {
    print $_[0];
	print "<BR><B><FONT COLOR='#FF0000'>Error $DBI::err (", quoteit($DBI::errstr),")</FONT></B><P>" if ($DBI::err);
	print "\n</FORM>" if $_[1];
	print "\n</TD></TR></TABLE>" if ($_[1] == 2);
	
#++++++++++++++++++++++++++++++++++++++

}

sub printresult {
#input:
# $_[0] - \$sth
# $_[1] - offset (running number)
# $_[2] - if set - mark primary keys
    my $sthref		= $_[0];
    my $sth 		= $$sthref;
	my $offset 		= ($_[1] + 0);
	my $array;
	$array->[0][0]	= qq!<TD BGCOLOR='#CCCCCC'>No</TD>\n! if (defined $_[1] and !$print);
	my $pri			= $sth->{mysql_is_pri_key};
	my ($bgcolorH, $bgcolor, $bgcolorL, $bordercolor, $cellspacing, $rowheight, $headerheight);
	my ($border, $bordercolorlight, $bordercolordark, $printtitle);
	if ($print){
		$bgcolor=$bgcolorH=$bgcolorL='#FFFFFF';
		$bordercolor				='#000000';
		$cellspacing 				= 0;
		$rowheight					= $q->param('rowheight');
		$headerheight				= $q->param('headerheight');
		$bordercolorlight 			= "bordercolorlight='#000000'";
		$bordercolordark  			= "bordercolordark='#000000'";
		$border						= '1';
		my $title					= quoteit($q->param('title'));
		$printtitle				= "<DIV ALIGN=LEFT><CODE>MYSQL DATA MANAGER (Unregistered Version)</CODE></DIV><P>";
		
		if ($title){
			my $align				= $q->param('align');
			my @style				= $q->param('style');
			
			foreach(@style){
				$title = "<$_>$title</$_>"
			}
			$printtitle				.= "<DIV ALIGN=$align><CODE>$title</CODE></DIV><P>" if $printtitle;
		}
	}
	else {

		$bgcolor  					= '#EEEEEE';
		$bgcolorH 					= '#EEEEEE';
		$bgcolorL 					= '#CCCCCC';
		$bordercolor 				= '#CCCCCC';
		$cellspacing 				= 2;
		$border						= '0';
		$bordercolorlight 			= "";
		$bordercolordark  			= "";

	}
    for(my $i=0; $i < $sth->{NUM_OF_FIELDS}; $i++) {

        if ($_[2] and $pri->[$i] and !$print){
			$array->[0][$i+1] = qq!<TH BGCOLOR='$bgcolorH'><FONT COLOR='#FF0000'>$sth->{NAME}[$i]</FONT></TH>!;
		}
		else{
			$array->[0][$i+1] = qq!<TH BGCOLOR='$bgcolorH'><FONT COLOR='#000000'>$sth->{NAME}[$i]</FONT></TH>!;
		}
    }
	my $j=1;
    while (@ary = $sth->fetchrow_array ())	{

		@ary			= quoteit(@ary);
		$array->[$j][0] = qq!<TD BGCOLOR='$bgcolorL'>!.$offset++ .qq!</TD>! if (defined $_[1] and !$print);
		@ary 			= map {$_='&nbsp;' unless $_} @ary;
		for (my $i = 0; $i < @ary; $i++) {
			$ary[$i] =~ s/(\r\n)|\n/<BR>/mg;
			$array->[$j][$i+1] = qq!<TD BGCOLOR='$bgcolor'>$ary[$i]</TD>!;
		}
		$j++;
	}
	my $result =  "\n<!-- printresult subroutine -->\n";
	$result    .=  "$printtitle\n";
	$result    .=  "\n\<TABLE BORDER=0  BGCOLOR='$bordercolor' CELLSPACING=0 CELLPADDING=0><TR BGCOLOR='$bordercolor'><TD BGCOLOR='$bordercolor'>";
	$result	   .=  "<TABLE BORDER=$border $bordercolorlight $bordercolordark CELLSPACING=$cellspacing CELLPADDING=1>\n";
	$result    .= "<TR $headerheight>@{$array->[0]}</TR>\n";
	#print 
	for (my $i = 1; $i < @$array; $i++)
	{$result .=  qq!\t<TR $rowheight>@{$array->[$i]}</TR>\n!;}
	$result    .= "</TABLE></TD>";
	$result	   .= "</TR></TABLE>\n";
	$result    .= "\n<!-- end of printresult subroutine -->\n";
	return ($result);
}
sub loadSelectDB {
	my $databasesref	= getdblist();
	my $DBlist;
	if ((not defined $databasesref) and $DBI::err){
		$DBlist 		= $q->scrolling_list(
						-labels		=> {'' => 'ACCESS DENIED'},
                		-name		=>'dbname',
                		-values		=>[''],
                		-default	=>'',
                		-size		=>15,
						-title		=>'Select database'
					);
	}
	else {
		if ((not defined $databasesref) or !$databasesref->[0]){
			$DBlist 	= $q->scrolling_list(
						-labels		=> {'' => 'List is emplty'},
                		-name		=>'dbname',
                		-values		=>[''],
                		-size		=>15,
						-title		=>'Select database'
					);
		}
		else {
			$DBlist 		= $q->scrolling_list(
                		-name		=>'dbname',
                		-values		=>['',@$databasesref],
                		-default	=>'',
                		-size		=>15,
						-title		=>'Select database'
					);
		}
	}
	my $headtab = {
		name	=> 'SELECT DATABASE'
	};
	my $SQL = quoteit($q->param('SQL'));
	print "<FORM METHOD=POST ACTION=\"$full_url\">";
	printHeaderTable($headtab);			
print <<EndSelectDB		
         <INPUT TYPE=HIDDEN NAME="page" VALUE="select_db">
         <TABLE BORDER=0 CELLSPACING=1 CELLPADDING=1>
             <TR VALIGN=TOP ALIGN=LEFT>
                 <TD>
    <!-- internal BIG table -->
	<TABLE BORDER=0 BGCOLOR='#AAAAAA' CELLPADDING=1 CELLSPACING=0><TR><TD>	
	<TABLE BORDER=0 WIDTH=100% BGCOLOR='#CCCCCC' CELLPADDING=2 CELLSPACING=0>
 		<TR HEIGHT=220>
   			<TD VALIGN=TOP HEIGHT=220>
<!-- database list  -->
$DBlist
			</TD>             
       		<TD VALIGN=TOP HEIGHT=220>
         <!-- control table -->
        <TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH=100%>
         	<TR VALIGN=TOP>
          		<TD VALIGN=TOP><INPUT TYPE=SUBMIT NAME='tableops' VALUE='  Show Tables  ' style='Width: 150px' TITLE='Show tables in selected database'><BR>
				<HR SIZE=1></TD>
          	</TR>
         	<TR>
          		<TD VALIGN=TOP><A><INPUT TYPE=SUBMIT NAME='tableops' VALUE='   Drop Database    ' style='width: 150px; color=#CC0000' TITLE='DROP SELECTED DATABASE'></A><BR>
				<HR SIZE=1></TD>
				</TD>
          	</TR>
         	<TR>
          		<TD VALIGN=TOP><INPUT TYPE=SUBMIT NAME='tableops' VALUE='  Create Database  ' style='width: 150px' TITLE='Create new database'></TD>
          	</TR>
         	<TR>
          		<TD VALIGN=TOP><INPUT TYPE=TEXT SIZE=25 NAME='newDB' TITLE='Type the name of the new database to create'></TD>
          	</TR>
			<TR><TD HEIGHT=4></TD></TR>
         </TABLE>
   <!-- end of control table -->
			</TD>
		</TR>
  	</TABLE>
	</TD></TR></TABLE>
	
                 </TD>
				 <TD>
<!-- query table -->
	<TABLE BORDER=0 BGCOLOR='#AAAAAA' CELLPADDING=1 CELLSPACING=0><TR><TD>	
	<TABLE BORDER=0 BGCOLOR='#CCCCCC'CELLPADDING=1 CELLSPACING=0>
		<TR HEIGHT=220 VALIGN=TOP><TD HEIGHT=220 VALIGN=TOP>	
         	
			<TABLE BORDER=0>
			<TR>
          		<TD><INPUT TYPE=SUBMIT NAME='tableops' VALUE='    Execute Query    ' style='width: 150px;' TITLE='Execute SQL Statement'></TD>
			</TR>
			<TR><TD><TEXTAREA WRAP=PHYSICAL NAME='SQL' ROWS=8 COLS=45 TITLE='Type SQL Statement to execute'>$SQL</TEXTAREA></TD>
          	</TR>
			</TABLE>
				
			
	</TD></TR></TABLE>
	</TD></TR></TABLE>

<!-- end of query table -->				 
				 </TD>
             </TR>
		</TABLE>
</FORM>
EndSelectDB
;		
}

sub belongsb {
#	syntax: &belong($ref_array, value)	
	my ($list, $value, $found);
	$list		= $_[0];
	$value		= $_[1];
	foreach (@$list){if ($value eq $_){$found = 1; last}}
return $found;
}
sub belongs {
#	syntax: &belong($ref_array, value)	
my ($list, $value, $found);
	$list 		= $_[0];
	$value 		= $_[1];
	foreach (@$list){if (uc $_ eq uc $value){$found = 1; last}}
return $found;
}

sub prepare_execute {
	my $query 	= $_[0];
	my $sth		= $dbh->prepare($query) || bail_out ("Cannot prepare query:\n$query", $_[1], $_[2]);
	my $res		= $sth->execute() 		|| bail_out ("Can not execute query:\n$query", $_[1], $_[2]);
return ($sth, $res)
}

sub count_rows {
#input: $table = @_[0];
	my $query	= 'SELECT COUNT(*) FROM '.$_[0];
	my $count	= $dbh->selectrow_array($query, \%attr);
	my $msg 	= "WRONG PARAMETERS.";
	$msg 		.= " CHECK YOUR INPUTS!\n\n" if $page =~ /[(insert)|(search)]/;
	if ($DBI::errstr){
		my $back;
		if ($_[1]){bail_out($msg, $_[1],$_[2])}
		elsif($database) {bail_out($msg, {page => 'select_db', dbname => "$database"})}
		else {bail_out($msg, {page => 'connect'})}
	}
	
	return ($count)
}

sub loadSelectTables {
	my $back;
	if ($database) 		{$back = {page => "select_db", dbname => $database}}
    else 				{$back = {page => "connect"}}
	my $userhost		= myhost();
	my $userdir 		= "$USER_DIR$delim$user.$userhost";
	my $errmsg			= "";
	
    unless ((-e $userdir) and (-d $userdir)) {mkdir $userdir, 0777 || {$errmsg = $!}}
	unless ($errmsg ){
		unless ((-e $userdir) and (-d $userdir)){$errmsg = $!}
		unless ($errmsg ){
			$userdir .= $delim."sql";
			unless ((-e $userdir) and (-d $userdir)) {mkdir $userdir, 0777 || {$errmsg = $!}}
			unless (!$errmsg and (-e $userdir) and (-d $userdir)) {$errmsg = $!}
		}
	}
	my (@files,$tsize);
	my $selectscript;
	unless ($errmsg){
		foreach (<$userdir/*>){
			unless (-d){
				my @stat = stat;
				my $size = $stat[7];
				$tsize += $size;
				my $date = scalar localtime ($stat[9]);
				$date =~ s/^\s*\w\w\w\s*(.*)/$1/;
				s/^(.*\/)*(.*)$/$2/;
				$_ = quoteit($_);
				$selectscript .= qq!\t<OPTION VALUE="$_">$_ \/$size\/ $date\n!;
			}
		}
	}
	else {$selectscript = "\t<OPTION VALUE=''>CANNOT CREATE DIRECTORY\n\t<OPTION VALUE=''>$errmsg\n";}
	unless ($selectscript){$selectscript = "\t<OPTION VALUE=''>Script list is empty\n"}
	$selectscript = "<SELECT NAME='selectscript' MULTIPLE SIZE=4 TITLE='Select table'>\n".$selectscript;
	$selectscript .= "</SELECT>\n";
	$tsize = int($tsize / 1024 * 100) / 100;
	
	my ($selectedscript, $SQL);
	if ($q->param('script')		=~ /Edit/i ){
	   $selectedscript 			= quoteit($q->param('selectscript'));
	
	}
	elsif ($q->param('script')	=~ /save\sas/i ){
		  my $saveasname 		= $q->param('saveasname');
		  my $newname 			= "$userdir$delim$saveasname";
		  $selectedscript		= quoteit($q->param('saveasname')) if (-e "$newname");
	}
	elsif ($q->param('script')	=~ /close/i ){}
	else {$selectedscript		= quoteit($q->param('selectedscript'))}
	my $selectedscriptname		= "LOADED&nbsp;SCRIPT:&nbsp;<B><U>$selectedscript</U></B>" if $selectedscript;
	my $closebutton				= "<INPUT TYPE=SUBMIT NAME='script' VALUE=' Close ' style='width: 60px' TITLE=\"Close the script &quot;$selectedscript&quot;\">" if $selectedscript;
	unless (($SQL = $_[0]) or (defined $_[0])){
		$SQL = quoteit($q->param('SQL')); 
	}

	$query						= "SHOW TABLES";
	my ($sth, $res)				= &prepare_execute($query, $back);
	my $table;
	my $i=0;
	while (my ($y) = $sth->fetchrow_array ())	{
		$table .= qq!<OPTION VALUE=$y>$y\n!;
		$i++;
	}
	$sth->finish();

	if ($i == 0){$table .= qq!<OPTION VALUE="">Table list is empty\n!;}
	print $q->start_multipart_form(-action=>$full_url,
		  						   -method=>"post");
	print qq!<INPUT TYPE=HIDDEN NAME="page" VALUE="tables">\n!;
	print qq!<INPUT TYPE=HIDDEN NAME="dbname" VALUE="$database">!;
	print qq!<INPUT TYPE=HIDDEN NAME="userhost" VALUE="$userhost">\n!;
	print qq!<INPUT TYPE=HIDDEN NAME="selectedscript" VALUE="$selectedscript">\n!;
	
	print qq?\n<TABLE BORDER=0><!-- main table -->\n?;
	print qq?\n\t<TR>\n\t\t<TD VALIGN=TOP>?;	
	
	print qq?\n\t<TABLE BORDER=0 WIDTH=100%><!-- left table -->\n?;
	print qq?\t\t<TR><TH ALIGN=LEFT>&nbsp;TABLES IN \"$database\"</TH></TR>\n?;
	print qq!\t\t<TR><TD><SELECT NAME='tables' SIZE=11 MULTIPLE>\n!;
	print $table;
	print qq!</SELECT></TD></TR>\n!;		
	print qq!\t\t</TABLE><BR>\n\n!;
	my $shownscript = "&quot;".$selectedscript."&quot;" if $selectedscript;
	print qq!
		  	<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH=285>			
				<TR>
					<TD>
$selectscript
			 		</TD>
				</TR>
			</TABLE>
			<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>
				<TR>
					<TD VALIGN=BOTTOM><INPUT TYPE=SUBMIT NAME='script' VALUE=" Edit " style='width: 60px' TITLE='Load selected script to view and edit'></TD>
					<TD VALIGN=BOTTOM><INPUT TYPE=SUBMIT NAME='script' VALUE="  Run " style='width: 60px' TITLE='Execute selected script'></TD>
					<TD VALIGN=BOTTOM>$closebutton</TD>
					<TD VALIGN=BOTTOM><INPUT TYPE=SUBMIT NAME='script' VALUE=" Delete " style='width: 60px; color=#CC0000' TITLE='DELETE SELECTED SCRIPT'></TD>
					<TD VALIGN=BOTTOM WIDTH=50>&nbsp;</TD>
				</TR>
				<TR>
				<TD COLSPAN=5 HEIGHT=20 VALIGN=BOTTOM><P>$selectedscriptname</TD>
				</TR>
			</TABLE>
		</TD>
!;

	print <<InnerTable
		<TD  VALIGN=TOP>
<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH=100%><!-- right table-->
	<TR>
		<TD>
		
<!-- SEARCH-MODIFY -->

	 	<!-- BORDER START -->
		<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' WIDTH=100%>
			<TR>
				<TD width=100%><TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0 BGCOLOR='#CCCCCC' WIDTH=100%><TR><TD>


			<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH=100%>
				<TR>
					<TD WIDTH=100><INPUT TYPE=SUBMIT NAME='func' VALUE='   SEARCH / MODIFY   '  style='width: 200px' TITLE='Search/Modify records in selected table'></TD>
				</TR>
			</TABLE>
			<!-- BORDER END --></TD></TR></TABLE></TD></TR></TABLE>
			
<!-- END OF SEARCH-MODIFY -->
		
		</TD>
	</TR>
	<TR>
		<TD HEIGHT=2></TD>
	</TR>
	<TR>		
		<TD>
		
		
<!-- DESCRIBE, INSERT, ALTER, CREATE -->
		<!-- BORDER START -->
		<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' WIDTH=100%>
			<TR>
				<TD WIDTH=100%><TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0 BGCOLOR='#CCCCCC' WIDTH=100%><TR><TD>

			
			<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>		
				<TR><TD><INPUT TYPE=SUBMIT NAME='func' VALUE='DESCRIBE'  style='width: 100px' TITLE='List columns for selected tables'></TD>
					<TD><INPUT TYPE=SUBMIT NAME='func' VALUE='  INSERT  ' style='width: 100px' TITLE='Insert new record into selected table'></TD>
					<TD><INPUT TYPE=SUBMIT NAME='func' VALUE='   ALTER  '  style='width: 100px' TITLE='Alter selected table'></TD>
					<TD><INPUT TYPE=SUBMIT NAME='func' VALUE='  CREATE  '  style='width: 100px' TITLE='Create new table'></TD>
				</TR>
			</TABLE>
			<!-- BORDER END --></TD></TR></TABLE></TD></TR></TABLE>
			
<!-- END OF DESCRIBE, INSERT, ALTER, CREATE -->			
		</TD>
	</TR>
	<TR>
		<TD HEIGHT=2></TD>
	</TR>
	<TR>		
		<TD>
<!-- UPDATE -->

		<!-- BORDER START -->
		<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' WIDTH=100%>
			<TR>
				<TD WIDTH=100%><TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0 BGCOLOR='#CCCCCC' WIDTH=100%><TR><TD>


			<TABLE BORDER=0  CELLPADDING=0 CELLSPACING=0 WIDTH=100%>
				<TR><TD WIDTH=100><INPUT TYPE=SUBMIT NAME='func' VALUE='  UPDATE '  style='width: 100px'  TITLE='Edit records in selected table'></TD>
					<TD>&nbsp;where&nbsp;<INPUT TYPE=TEXT NAME='updateWhere' VALUE="" SIZE=25 TITLE='Define which records to display for editing'></TD>
					<TD>&nbsp;limit&nbsp;<INPUT TYPE=TEXT NAME="updateLimit" VALUE="0,10" SIZE=8 TITLE='Define start record and number of records to be displayed'></TD>
				</TR>
			</TABLE>
			<TABLE BORDER=0  CELLPADDING=0 CELLSPACING=0 WIDTH=100%>
				<TR><TD HEIGHT=2 COLSPAN=3></TD>
				</TR> 

			<!--	<TR><TD WIDTH=10>&nbsp;</TD>
					<TD>&nbsp;order&nbsp;by&nbsp;<INPUT TYPE=TEXT NAME='updateOrder' VALUE="" SIZE=10>&nbsp;</TD>
					<TD>&nbsp;offset&nbsp;<INPUT TYPE='TEXT' NAME='updateStart' VALUE='0' SIZE=5>&nbsp;rows&nbsp;<INPUT TYPE=TEXT NAME='updateRows' VALUE="$UpdateRows" SIZE=5 MAXLENGTH=3></TD>
				</TR> -->
			</TABLE>
			
			 <!-- BORDER END --></TD></TR></TABLE></TD></TR></TABLE>
			
<!-- END OF UPDATE -->
		</TD>
	</TR>
	<TR>
		<TD HEIGHT=2></TD>
	</TR>
	<TR>
		<TD>
<!-- SELECT -->	
	 	<!-- BORDER START -->
		<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' WIDTH=100%>
			<TR>
				<TD width=100%><TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0 BGCOLOR='#CCCCCC' WIDTH=100%><TR><TD>
		
			<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH=100%  BGCOLOR='#CCCCCC'>
				<TR>
					<TD WIDTH=100><INPUT TYPE=SUBMIT NAME='func' VALUE='SELECT all' style='width: 100px'  TITLE='Show records in selected tables'></TD>
					<TD>&nbsp;where&nbsp;<INPUT TYPE=TEXT NAME="where" VALUE="" SIZE=25 TITLE='Define which records to be displayed'></TD>
					<TD>&nbsp;limit&nbsp;<INPUT TYPE=TEXT NAME='limit' VALUE='0,$SelectRows' SIZE=8 TITLE='Define start record and number of records to be displayed'></TD>
				</TR>
			</TABLE>
			<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH=100% BGCOLOR='#CCCCCC'>
				<TR><TD HEIGHT=2 COLSPAN=5></TD>
				</TR> 
			<!--	<TR><TD WIDTH=10>&nbsp;</TD>
					<TD ALIGN=RIGHT>group&nbsp;by&nbsp;</TD>
					<TD><INPUT TYPE=TEXT NAME='groupby' SIZE=11  TITLE='Define the columns to group selected records by'>&nbsp;</TD>
					<TD ALIGN=RIGHT>order&nbsp;by&nbsp;</TD>
					<TD><INPUT TYPE=TEXT NAME='orderby' SIZE=11 TITLE='Define the columns to order selected records by'>&nbsp;</TD>
					<TD>limit&nbsp;</TD>
					<TD>&nbsp;</TD>
				</TR>	-->
			</TABLE> <!-- BORDER END --></TD></TR></TABLE></TD></TR></TABLE>
<!-- END OF SELECT -->
		</TD>
	</TR>				
	<TR><TD HEIGHT=2></TD>
	</TR>
	<TR>
		<TD>
<!-- DELETE -->

	 	<!-- BORDER START -->
		<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' WIDTH=100%>
			<TR>
				<TD width=100%><TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0 BGCOLOR='#CCCCCC' WIDTH=100%><TR><TD>


			<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH=100%>
				<TR>
					<TD WIDTH=100><INPUT TYPE=SUBMIT NAME='func' VALUE='  DELETE  ' style='width: 100px; color: #CC0000'  TITLE='DELETE RECORDS FROM SELECTED TABLE'></TD>
					<TD>&nbsp;where&nbsp;<INPUT TYPE=TEXT NAME='wheredelete' VALUE='' TITLE='Define which record to delete from selected table.\nIF THIS FIELD IS BLANK, ALL RECORDS WILL BE DELETED' SIZE=38></TD>
				</TR>
			</TABLE>
			<!-- BORDER END --></TD></TR></TABLE></TD></TR></TABLE>
<!-- END OF DELETE -->
		</TD>
	</TR>
	<TR><TD HEIGHT=2></TD>
	</TR>
	<TR>
		<TD>
<!-- DROP -->

	 	<!-- BORDER START -->
		<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' WIDTH=100%>
			<TR>
				<TD width=100%><TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0 BGCOLOR='#CCCCCC' WIDTH=100%><TR><TD>


			<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH=100%>
				<TR>
					<TD WIDTH=100><INPUT TYPE=SUBMIT NAME='func' VALUE='   DROP   '  style='width: 100px; color: #CC0000' TITLE='DROP SELECTED TABLES'></TD>
				</TR>
			</TABLE>
			<!-- BORDER END --></TD></TR></TABLE></TD></TR></TABLE>
<!-- END OF DROP -->
		</TD>
	</TR>
	<TR><TD HEIGHT=2></TD>
	<TR>			
		<TD>
<!-- EXECUTE SCRIPT CONTROL -->

	 	<!-- BORDER START -->
		<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' WIDTH=100%>
			<TR>
				<TD width=100%><TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0 BGCOLOR='#CCCCCC' WIDTH=100%><TR><TD>


			<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH=100%>
				<TR>
					<TD COLSPAN=3><TEXTAREA WRAP=PHYSICAL NAME='SQL' ROWS=4 COLS=50  TITLE='SQL script editor.\n'>$SQL</TEXTAREA></TD>
				</TR>
				<TR>
					<TD><INPUT TYPE=SUBMIT NAME='script' VALUE='Execute Query' style='width: 100px'  TITLE='Execute SQL commands'></TD>
					<TD><INPUT TYPE=RESET VALUE='   Reset   ' style='width: 100px' TITLE='Reset form'></TD>
					<TD WIDTH=250>&nbsp;</TD>
				</TR>
			</TABLE>

			<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH=100%>
				<TR><TD HEIGHT=2></TD>
				<TR>
					<TD COLSPAN=2><INPUT TYPE=SUBMIT NAME='script' VALUE='Save'  TITLE='Save SQL script $shownscript'>
									<INPUT TYPE=SUBMIT NAME='script' VALUE='Save as'  TITLE='Save SQL script as ...'>
									<INPUT TYPE=TEXT NAME='saveasname' SIZE=30 TITLE='Type name to save as'></TD>
				</TR>
			</TABLE>
			<!-- BORDER END --></TD></TR></TABLE></TD></TR></TABLE>
<!-- END OF EXECUTE SCRIPT CONTROL -->			
		</TD>
	</TR>
</TABLE> <!-- END OF RIGHT INNER TABLE -->

		</TD>
	</TR>
</TABLE><!-- END OF MAIN TABLE -->
</FORM>
InnerTable
;

	return
}

sub execDescribeTables {
	print "\n<!-- Describe procedure starts here -->\n";
	my $headtab = {
		name 	=> 'DESCRIBE'
	};
	printHeaderTable($headtab);
	my @tabs = $q->param('tables');
	if (@tabs == 0 or !$tabs[0]){
		returntotab ("<p><B>ERROR:</B> Table is not specified.<P>");
		return;
	}
	
AA:	foreach my $table (@tabs) {
		print "<CODE TITLE='Colums and keys info on table &quot;$table&quot;'>TABLE:&nbsp;&nbsp;$table</CODE><BR>";
		my @query = ("DESCRIBE $table", "SHOW INDEX FROM $table");
		foreach (@query) {
			my $sth = $dbh->prepare($_);
			my $res = $sth->execute();
			if ($DBI::err) {
				print "<BR><B>Error $DBI::err (", quoteit($DBI::errstr),")</B><P>";
				$sth->finish;
				next AA;
			}
			print &printresult(\$sth);
			if ($DBI::err) {ErrMessage ("(Table $table)Print Result Error. $DBI::err $DBI::errstr")}
			print "<BR>";
			$sth->finish;
		}
		print "\n<HR SIZE=\"1\" LENGTH=\"700\"><P>\n"	
	}
  print "\n<!-- Describe procedure ends here -->\n";

	return;
}
	
sub	loadInsertForm {
# INSERT DATA
	#-----------------------------------------------------------
	# Field | INSERT DATA |Type | Null | Key | Default | Extra |
	#-----------------------------------------------------------
	#NAME 1 | -INPUT DATA-|  X  |   X  |  X  |    X    |    X  |  
	#-----------------------------------------------------------
	print "<!-- Insert/Search/Modify procedure starts here -->" unless $q->param('update');
	my @tabs = $q->param('tables');
	my $array;
	if ((@tabs == 0) or !$tabs[0]){
		returntotab("<p><b>ERROR:</B> Table is not specified.<BR>\n");
		return;
	}
	elsif  (@tabs >=2) {
		returntotab("<p><b>ERROR:</B> Too many tables.<BR>\n");
		return;
	}
	my $back = {
	   dbname	 => "$database",
 	   tables 	 => "$tabs[0]",
	   func 	 => 'return' 
	};
	
	my $ProcName;
	my $func = $q->param('func');
	my $editdata;
	my $goback;
	my ($hiddeninput, $hiddeninput1);
	my $msg 		= $_[0];
	my @selectrow		= $q->param('SelectRow');
	my $rowhint;
	
	if ($page eq 'searchresult')  {
		my @fields 		= $q->param('fields');
		my $where 		= $q->param('where');
		my $order 		= $q->param('order');
		my $start 		= $q->param('start');
		my $rows  		= $q->param('rows');
		my $where_		= quoteit($where);
		my $count		= $q->param('count');
		$hiddeninput = $q->hidden(-name=>'fields', -value=>\@fields, -override=>1);
		$hiddeninput .= <<EndOfInsHidden
<INPUT TYPE=HIDDEN NAME='order' VALUE="$order">
<INPUT TYPE=HIDDEN NAME='where' VALUE="$where_">
<INPUT TYPE=HIDDEN NAME='start' VALUE="$start">
<INPUT TYPE=HIDDEN NAME='rows' VALUE="$rows">
<INPUT TYPE=HIDDEN NAME='count' VALUE="$count">
EndOfInsHidden
;
 		$hiddeninput1 = $hiddeninput unless ($func =~ /back/i);

		$back->{page}	= 'searchresult';
		$back->{start}	= "$start";
		$back->{rows} 	= "$rows";
		$back->{fields}	= \@fields;
		$back->{where}	= "$where";
		$back->{order}	= "$order";

		$goback = <<EndGoBack
<FORM ACTION="$full_url" METHOD=POST>
<INPUT TYPE=SUBMIT VALUE='Back to search result' TITLE='Go back to Search Result page'>
<INPUT TYPE=HIDDEN NAME='tables' VALUE="$tabs[0]">
<INPUT TYPE=HIDDEN NAME='dbname' VALUE="$database">
<INPUT TYPE=HIDDEN NAME='func' VALUE="return">
<INPUT TYPE=HIDDEN NAME='page' VALUE="searchresult">
$hiddeninput
</FORM>
EndGoBack
;
#<INPUT TYPE=HIDDEN NAME='page' VALUE='searchresult'>
		
		if ($func =~ /^\s*edit/i){
			bail_out('Please select a row', $back) unless (@selectrow);
			$rowhint = 'Edit this value';
			if ($q->param('update')){
				execSearchupdate($back, $q->param('updatewhere'));
				shift @selectrow;
				unless (@selectrow) {searchresult(); return}
			}
			if (@selectrow and !$msg){
				$msg = "<CODE>ROW No $selectrow[0]</CODE>"
			} 


			$ProcName 		= 'EDIT RECORD';
			$func 	  		= 'edit';
			my @updatewhere;
			my $queryedit	= "SELECT * FROM $tabs[0] $where $order";
			my $query 		= "$queryedit LIMIT $selectrow[0],1";
			my($sth,$res)	= prepare_execute($query, {page=>'select_db', dbname=>"$database"});
			bail_out("The many results. Check the code", $back ) if ($res > 1);
			$editdata = $sth->fetchrow_hashref();
			
			my @pri;		
			my $primary = $sth->{mysql_is_pri_key};
			for (my $i=0; $i<@$primary; $i++){
				if ($primary->[$i]){push @pri, $sth->{NAME}[$i]}
			}
			unless (@pri){@pri = @{$sth->{NAME}}}
			$sth->finish;
			foreach (@pri){
				my $data = $dbh->quote($editdata->{$_});
				if (uc $data eq 'NULL') {push @updatewhere, "$_ IS NULL"}
				else 					{push @updatewhere, "$_ = $data"}
			}	
			@updatewhere = quoteit(@updatewhere);
			$hiddeninput1 .= "<INPUT TYPE=HIDDEN NAME='updatewhere' VALUE=\"(".join (') AND (',@updatewhere).")\">";
			$hiddeninput1 .= $q->hidden(-name=>'SelectRow', -value=>\@selectrow, -override=>1);
			$hiddeninput1 .= "<INPUT TYPE=HIDDEN NAME='update' VALUE='1'>"; 
		}
		elsif ($func =~ /new/i){$func = 'insert'}
		elsif ($func =~ /back/i){$func = 'search'; $page='search';}
	}
	elsif ($page eq 'tables'){
		if($func =~ /insert/i){$func='insert'; $page='insert';}
		if($func =~ /search/i){$func='search'; $page='search';}
	}
	if($func eq 'insert'){
		$ProcName = 'INSERT DATA';
		$rowhint  = 'Type new value to insert'; 
	}
	elsif ($func =~ /^\s*search/i or $page eq 'search'){
		$ProcName = 'SEARCH RECORDS';$func='search';
		$rowhint  = 'Type search pattern or values (delimited by comma, if applicable)';
	}
	
	my $query 		= "DESCRIBE $tabs[0]";
	my $sth			= $dbh->prepare($query) || bail_out("Cannot prepare query:\n$query",{page => 'select_db', dbname => "$database"});
	my $res			= $sth->execute 		|| bail_out("Cannot execute query:\n$query",{page => 'select_db', dbname => "$database"});
	my $count		= count_rows($tabs[0],{page => 'select_db', dbname => "$database"});
	my $textsize	= 31;
	my $namelist;
	my $insertOptions;
	my $showfields;
	my $delayed		= qq!<I>Delayed</I><INPUT TYPE=RADIO NAME='insert_option1' VALUE = 'DELAYED' TITLE='Delayed Insertion'>!	if $func eq 'insert';
	
	$array->[0][0]	= qq!<TH ALIGN=LEFT>&nbsp;$sth->{NAME}->[0]</TH>!;

	# CORRECT THIS LINE TO USE UNQUOTED DATA FOR SEARCHING (DELETE unless CONDITION).
	$array->[0][1]	= qq!<TH>&nbsp;Unquoted&nbsp;<BR>Data<BR>(funcion)</TH>! 			unless ($func eq 'search');

	$array->[0][2]	= qq!<TH>&nbsp;Upload&nbsp;</TH>! 									unless ($func eq 'search');
	$array->[0][3]	= qq!<TH ALIGN=CENTER>I n s e r t&nbsp;&nbsp;D a t a</TH>! 			if $func eq 'insert';
	$array->[0][3]	= qq!<TH ALIGN=CENTER>S e a r c h&nbsp;&nbsp;P a t t e r n</TH>! 	if $func eq 'search';
	$array->[0][3]	= qq!<TH ALIGN=CENTER>M o d i f y&nbsp;&nbsp;D a t a</TH>! 			if $func eq 'edit';
	
	my $i;
	if ($func eq 'search'){
		$array->[0][5]	= qq!<TH ALIGN=CENTER COLSPAN=2 ALIGN=TOP>Advanced search</TH>!;
		$textsize		= 25;
		$namelist		= qq!<SELECT NAME="sort" TITLE='Select column to sort by'>\n<OPTION VALUE=''>\n!;
	}
	else {
		for ($i=1; $i<($sth->{NUM_OF_FIELDS}-1); $i++) {
			$array->[0][$i+3] = qq!<TH ALIGN=CENTER> $sth->{NAME}->[$i] </TH>\n!;
		}
	}
	my $textflag;
	my $bottomMessage;
	my $j = 1;
	while (@ary = $sth->fetchrow_array ())	{
		my $k=$j-1;
		($ary[1],$ary[4],$editdata->{$ary[0]}) = quoteit($ary[1],$ary[4],$editdata->{$ary[0]});
		$array->[$j][0]= qq!<TD>&nbsp;<B>$ary[0]&nbsp;</B></TD>!;
		if ($ary[1] =~ /^\s*enum/ or $ary[1] =~ /^\s*set/){
		   $array->[$j][1]= qq!<TD ALIGN=CENTER>&nbsp;-&nbsp;</TD>!;
		}
		else {
			$array->[$j][1]= qq!<TD ALIGN=CENTER>&nbsp;<INPUT TYPE=CHECKBOX NAME='unquote' VALUE='$ary[0]' TITLE='Check to insert Functions'>&nbsp;</TD>!;
		}
		my $ary1 = $ary[1];
		$ary1 =~ s/^\s*//;
		$ary1 =~ s/\W.*//g;
		my $type = $ary[1];
		if (belongs(\@textdata, $ary1)){
			if ($func eq 'search'){
				$array->[$j][3]= qq!<TD>&nbsp;<TEXTAREA NAME="$ary[0]_data" COLS=25 ROWS=1 WRAP=OFF TITLE='$rowhint'></TEXTAREA>&nbsp;</TD>\n!;
			}
			else {
				$array->[$j][2]	= qq!<TD ALIGN=CENTER>&nbsp;<INPUT TYPE = CHECKBOX \t NAME = "upload"\tVALUE = "$ary[0]" TITLE='Check to upload file'>&nbsp;</TD>!;
				$array->[$j][3]	= qq!<TD>&nbsp;<TEXTAREA NAME="$ary[0]_data" COLS=30 ROWS=3 WRAP=OFF TITLE='$rowhint'>$editdata->{$ary[0]}</TEXTAREA>&nbsp;<BR>\n!;
				$array->[$j][3] .= qq!&nbsp;<INPUT TYPE=FILE \t\t NAME="$ary[0]_data_upload" \tVALUE="" TITLE='Select file to upload'>&nbsp;</TD>!;
				$textflag = 1;
			}
		} 
		elsif($ary[1] =~ /^\s*enum\s*\((.*)\)/){
			$type = 'enum';
			$array->[$j][2]		= qq!<TD ALIGN=CENTER>&nbsp;-&nbsp;</TD>!;
			$array->[$j][3]		= qq!<TD>&nbsp;<SELECT NAME="$ary[0]_data" TITLE='Select value'>\n!;
			$array->[$j][3] 	.= qq!\t<OPTION VALUE="">\n!;
			my @enumval = split ',',$1;
			foreach (@enumval){
				s/^'(.*)'$/$1/;
				s/''/'/g;
				my $selected	= 'SELECTED' if (($_ eq $editdata->{$ary[0]}) and ($func eq 'edit'));
				$array->[$j][3]	.= qq!\t<OPTION VALUE="$_" $selected>$_\n!;
			}
			$array->[$j][3]		.= qq!</SELECT>&nbsp;</TD>!;
		}
		else {
			 $array->[$j][2]	= qq!<TD ALIGN=CENTER>&nbsp;-&nbsp;</TD>!;
			 $array->[$j][3]	= qq!<TD>&nbsp;<INPUT TYPE=TEXT \t\t NAME="$ary[0]_data"\tVALUE="$editdata->{$ary[0]}" SIZE=$textsize TITLE='$rowhint'>&nbsp;</TD>!;
		}
		if ($func eq 'search'){
			
			#DELETE THIS LINE IF YOU NEED TO SEARCH BY UNQUOTED DATA
			$array->[$j][1] = ''; 
			
			#THE REMARKED 'OPTIONS' ARE SUPPORTED BY THE PROGRAM. UNREMARK THEM IF NEEDED.
			
			$array->[$j][6]		= qq!<TD ALIGN=LEFT>&nbsp;<EM>$type</EM>&nbsp;</TD>!;
			my $typename		= $ary[1];
			$typename			=~ s/^\s*([a-zA-z])\s*\W.*//i;
			$namelist			.= qq!<OPTION VALUE="$ary[0]">$ary[0]\n!;
			$showfields			.= qq!<OPTION VALUE="$ary[0]" SELECTED>$ary[0]\n!;
			my $oper_options	= qq!<OPTION VALUE="">\n!;
			$oper_options 		.= qq!<OPTION VALUE="start">Starts with\n!	unless ($type eq 'enum');
			$oper_options 		.= qq!<OPTION VALUE="end">Ends with\n!		unless ($type eq 'enum');
			$oper_options 		.= qq!<OPTION VALUE="AND">AND (ALL)\n!		unless ($type eq 'enum');
			$oper_options 		.= qq!<OPTION VALUE="OR">OR (ANY)\n!		unless ($type eq 'enum');
			$oper_options 		.= qq!<OPTION VALUE="&gt;">&gt;\n!;
#			$oper_options 		.= qq!<OPTION VALUE="&gt;=">&gt;=\n!;
			$oper_options 		.= qq!<OPTION VALUE="&lt;">&lt;\n!;
#			$oper_options 		.= qq!<OPTION VALUE="&lt;=">&lt;=\n!;
			$oper_options 		.= qq!<OPTION VALUE="=">=\n!;
			$oper_options 		.= qq!<OPTION VALUE="BETWEEN">BETWEEN\n!	unless (($type eq 'enum') or (!check_version("3.21.2")));
			$oper_options 		.= qq!<OPTION VALUE="IN">IN\n!				unless ($type eq 'enum');
#			$oper_options 		.= qq!<OPTION VALUE="REGEXP">REGEXP\n!		unless ($type eq 'enum');
#			$oper_options 		.= qq!<OPTION VALUE="LIKE">LIKE\n!;
			$oper_options 		.= qq!<OPTION VALUE="NULL">NULL\n!;
#			$oper_options 		.= qq!<OPTION VALUE="FUNCTION">FUNCTION\n!;

			$array->[$j][$i+4] =
			qq!<TD>&nbsp;<SELECT NAME="operator_$ary[0]" TITLE='Select search criterion'>$oper_options</SELECT>&nbsp;</TD>!;
		
 		   	my $matchcase		= qq!<INPUT TYPE=CHECKBOX NAME="case_$ary[0]" TITLE='Case sensitive searching'>match&nbsp;case&nbsp;! if check_version("3.23.00");
			$array->[$j][$i+5]	= qq!<TD><INPUT TYPE=CHECKBOX NAME="not_$ary[0]" TITLE='Inverse search criterion'>not&nbsp;$matchcase</TD>!;
		}		
		else {
			my $i;
			$array->[$j][4]		= qq!<TD ALIGN=LEFT>&nbsp;<EM>$type</EM>&nbsp;</TD>!;
			for (my $i=2; $i<(@ary - 1); $i++){
				my $color1;
				my $color2		= "</FONT>";
				my $font1		= '<EM>';
				my $font2		= '</EM>';
				if (($i==3 and ($ary[3] =~ /PRI/)) or ($i == 5 and ($ary[5] =~ /auto/i))){
					$color1		= qq!<FONT COLOR = '#CC0000'>!;
					$font1		= '';
					$font2		= '';
				}
				$array->[$j][$i+3] = qq!<TD>&nbsp;$font1$color1$ary[$i]$color2$font2&nbsp;</TD>!;
			}
		}
		
		$j++;
	} #WHILE
	$sth->finish();
	if ($func eq 'search'){
		my $rowspan 			= $j + 1;
		my $size 				= $j - 1;
		$namelist 				.= qq!</SELECT>&nbsp;\n!;
		$showfields 			= qq!<SELECT MULTIPLE NAME='fields' SIZE=$size TITLE='Select columns to be displayed in the result'>\n!.$showfields;
		$showfields 			.= qq!</SELECT>&nbsp;\n!;
		$bottomMessage 			= "<LI>The Arguments are <U>comma separated</U>.";
		my $criterion 			= <<EndOfCriterion
<TABLE BORDER=0 CELLPADDIND=2 CELLSPACING=1>
	<TR>
		<TD>&nbsp;
		</TD>
	</TR>
	<TR>
		<TD ALIGN=RIGHT>Sort by&nbsp;<BR>$namelist</TD>
	</TR>
	<TR>
		<TD ALIGN=RIGHT>Sort&nbsp;Order&nbsp;<BR><SELECT NAME="sortorder" TITLE='Select between ascending and descending ordering'>
<OPTION VALUE="ASC">Ascending
<OPTION VALUE="DESC">Descending
</SELECT>&nbsp;</TD>
	</TR>
	<TR>
		<TD ALIGN=RIGHT HEIGHT=6></TD>
	</TR>
	<TR>
		<TD ALIGN=RIGHT>Start&nbsp;<INPUT TYPE=TEXT SIZE=4 NAME="start" VALUE=0 TITLE='Define record search result displaing will start from'>&nbsp;</TD>
	</TR>
	<TR>
		<TD ALIGN=RIGHT>Hits&nbsp;<INPUT TYPE=TEXT SIZE=4 NAME="rows" VALUE=10 TITLE='Define number of records per page to be displayed'>&nbsp;</TD>
	</TR>
	<TR>
		<TD ALIGN=RIGHT TITLE='Select logical operator OR or AND'>logical&nbsp;<SELECT NAME="andor" TITLE='Select logical operator OR or AND'>
<OPTION VALUE="OR" SELECTED>OR
<OPTION VALUE="AND">AND
</SELECT>&nbsp;</TD>
	</TR>
	<TR>
		<TD ALIGN=RIGHT>Show&nbsp;columns&nbsp;<BR>in&nbsp;search&nbsp;result&nbsp;<BR>$showfields</TD>
	</TR>

</TABLE>
EndOfCriterion
;
		push @{$array->[0]},"<TD ROWSPAN=$rowspan VALIGN=TOP>$criterion </TD>";
		push @{$array->[0]},"<TH ALIGN=CENTER> $sth->{NAME}->[1] </TH>\n";

	}
	else {
		my $word = 'UPDATE';
		 
		if ($func eq 'insert'){
			$word =  'INSERT';
		}
		my $ignore = qq![<I> Ignore</I><INPUT TYPE=CHECKBOX NAME="insert_option2" VALUE = "IGNORE" TITLE='Ignore rows that duplicate values for unique keys'>]! if (($func eq 'insert') or check_version('3.23.16'));
		$insertOptions = <<EndOfInsertOptions
		  	 $word [<I> Low_Priority</I><INPUT TYPE=RADIO NAME="insert_option1" VALUE = "LOW_PRIORITY" TITLE='Defer the statement until no clients are reading from the table'>
			$delayed ]
			$ignore
EndOfInsertOptions
;
		$bottomMessage = <<EndOfBM
		
<LI>To import data into<B> Text </B>and <B>Blob</B> fields from local file, select the checkbox "Upload".<BR>
Otherwise use textatrea to insert data (any information in the file field will be ignored).
<LI>Check "Unquoted Data" to use SQL functions or numeric values. <BR><U>NEVER USE IT IF YOU ARE NOT SURE WHAT IT DOES</U><BR>&nbsp;

EndOfBM
;
	
	}
	my $headtab = {
		name	=> "$ProcName",
		table	=> "TABLE&nbsp;\"$tabs[0]\"",
		rows	=> "Total&nbsp;rows:&nbsp;$count",
		msg		=> "$msg"
	};
	printHeaderTable($headtab);
	print <<InsertHead
	

<FORM ACTION="$full_url" METHOD="POST"  ENCTYPE="multipart/form-data">

<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 BGCOLOR='#AAAAAA'>
			<TR>
				<TD WIDTH=100%>
				
<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=1 BGCOLOR='#AAAAAA' WIDTH=100%><!-- Insert Form Table -->

InsertHead
;

	foreach (@$array) {
		${$_}[2] = '' unless $textflag;
		print qq!\t<TR BGCOLOR='#CCCCCC' HEIGHT=22>@{$_}</TR>\n!;

	}
	print <<InsertBottom

</TABLE>
</TD></TR></TABLE>
<P>
<INPUT TYPE = HIDDEN NAME="tables" VALUE="$tabs[0]">
<INPUT TYPE = HIDDEN NAME="page" VALUE="$page">
<INPUT TYPE = HIDDEN NAME="func" VALUE="$func">
<INPUT TYPE=HIDDEN NAME="dbname" VALUE="$database">
$hiddeninput1

<!-- Option Table -->

<TABLE BORDER=0>
	<TR>
		<TD><INPUT TYPE = SUBMIT NAME="submit" VALUE="Submit" TITLE='Submit'>&nbsp;</TD>
		<TD><INPUT TYPE=RESET TITLE='Reset form'>&nbsp;</TD>
		<TD>$insertOptions</TD>
	</TR>
</TABLE>
<!--End of Option Table -->
</FORM>
$goback
<UL>
$bottomMessage
<!-- loadInsertForm procedure ends here -->
</UL>
InsertBottom
;
	return;
}

sub loadZoom {
	my ($table)			= $q->param('tables');
	my @fields 			= $q->param($table.'_fields');
	my $dbname 			= $q->param('dbname');
	my $updateWhere 	= $q->param('updateWhere');
	my $updateOrder 	= $q->param('updateOrder');
	$updateWhere 		= '' unless ($updateWhere =~ /\S/);
	$updateOrder 		= '' unless ($updateOrder =~ /\S/);
	my $updateRows 		= $q->param('updateRows');
	my $updateStart 	= $q->param('updateStart');
	my $zoomselect 		= $q->param('zoomselect');
	my $where 			= $q->param('where');
	my $order 			= $q->param('order');
	my $start 			= $q->param('SelectRow') + 0;
	my $rows 			= 1;
	$updateRows 		= '' if ($updateRows =~ /ALL/i);

	my $back = {
		dbname			=> "$database",
		tables			=> $table,
		page			=> "tables",
		func			=> "update",
		updateStart		=> $q->param('start'),
		updateRows		=> $q->param('rows'),
		updateWhere		=> "$where",
		updateOrder		=> "$order",
	};
	my @hidfields 		= $q->param('fields');
	$back->{"$table\_fields"} = \@hidfields;
	
    my $query 			= "SELECT $zoomselect FROM $table";
    $query 				.= " WHERE $where" if $where;
	$query 				.= " ORDER BY $order" if $order;
    $query 				.= " LIMIT $start, $rows ";
	my ($sth,$res) 		= prepare_execute($query,$back);
	my ($array) 		= $sth->fetchrow_array() or bail_out ("(zoom) Retrieve Error", $back);
	$sth->finish();
	($array,$updateOrder,$updateWhere,$order,$where) = quoteit($array,$updateOrder,$updateWhere,$order,$where);

	print qq?\n\n<!-- loadZoom Procedure starts here -->\n\n?;
	print qq?<FORM METHOD=POST METHOD="$full_url">?;
	my $headtab = {
		name	=> "UPDATE (Zoom)",
		table	=> "TABLE:&nbsp;$table",
		rows	=> 'row# = '."$start",
		title2	=> "This is column $zoomselect, row number $start"
	};
	printHeaderTable($headtab);
	print <<EOT
<!-- Update Table -->
<TABLE BORDER=0>
	<TR BGCOLOR='#cccccc'>
		<TH BGCOLOR='#EEEEEE'>$zoomselect</TH>
	</TR>
	<TR VALIGN=TOP>
		<TD><TEXTAREA ROWS=15 COLS=90 NAME="n0_0" WRAP=OFF TITLE='Edit this value'>$array</TEXTAREA></TD>
	</TR>
</TABLE>

<!-- Submit Buttons Table -->
	<TABLE BORDER=0>
		<TR>
			<TD><INPUT TYPE=SUBMIT NAME="update" VALUE="Update"  TITLE='Save changes'></TD>
			<TD><INPUT TYPE=SUBMIT NAME="reload" VALUE="Zoom Out" TITLE='Go back to Update Page'></TD>
			<TD><INPUT TYPE=RESET TITLE='Reset form'></TD>
			<TD WIDTH=15></TD>
			<TD>UPDATE&nbsp;[&nbsp;low priority<INPUT TYPE=CHECKBOX NAME="update_option1" VALUE="LOW_PRIORITY" TITLE='Defer the statement until no clients are reading from the table'>&nbsp;]&nbsp;[
		   				   ignore&nbsp;<INPUT TYPE=CHECKBOX NAME="update_option2" VALUE="IGNORE"  TITLE='Ignore rows that duplicate values for unique keys'>&nbsp;]</TD>
		</TR>
	</TABLE>

<INPUT TYPE=HIDDEN NAME="page" VALUE="update">
<INPUT TYPE=HIDDEN NAME="dbname" VALUE="$dbname">
<INPUT TYPE=HIDDEN NAME="tables" VALUE="$table">
<INPUT TYPE=HIDDEN NAME="updateStart" VALUE="$updateStart">
<INPUT TYPE=HIDDEN NAME="updateRows" VALUE="$updateRows">
<INPUT TYPE=HIDDEN NAME="updateWhere" VALUE="$updateWhere">
<INPUT TYPE=HIDDEN NAME="updateOrder" VALUE="$updateOrder">
<INPUT TYPE=HIDDEN NAME="where" VALUE="$where">
<INPUT TYPE=HIDDEN NAME="order" VALUE="$order">
<INPUT TYPE=HIDDEN NAME="start" VALUE="$start">
<INPUT TYPE=HIDDEN NAME="rows" VALUE="$rows">
<INPUT TYPE=HIDDEN NAME="fields" VALUE="$zoomselect">
EOT
;
	print $q->hidden(	-name=>"$table\_fields",
		  				-default=>[@fields],
						-override=>1);

	print "\n\n</FORM>\n\n<!-- loadZoom Procedure ends here -->\n\n";
	return
}
sub loadUpdateForm {
	print "<!-- loadUpdateForm Procedure starts here -->\n\n";
	my @tabs = $q->param('tables');
    if  (@tabs >=2) {
		returntotab("<P><B>ERROR:</B>Too many tables!<BR>\n");
		return;
    }
    if ((@tabs == 0) or !$tabs[0]){
		returntotab("<P><b>ERROR:</B>Table is not specified.<BR>\n");
		return;
    }
	my $back;
	if ($page eq 'tables') {$back = {page => 'select_db', dbname => "$database"}}
	elsif ($page eq 'update'){
		$back->{dbname}				= "$database";
		$back->{tables}				= "$tabs[0]";
		$back->{page}				= "update";
		$back->{reload}				= "Reload";
		$back->{updateStart}		= $q->param('start');
		$back->{updateRows}			= $q->param('rows');
		$back->{updateWhere}		= $q->param('where');
		$back->{updateOrder}		= $q->param('order');
		my @hidfields 				= $q->param('fields');
		$back->{"$tabs[0]\_fields"}	= \@hidfields;
	}
	
	my $order = $q->param('updateOrder');
	$order = '' unless ($order =~ /\S/);
	my $where = $q->param('updateWhere');
	$where = '' unless ($where =~ /\S/);
	my $rows; my $start;
	if (defined $q->param('updateLimit')) {
		($start, $rows) = split ',',$q->param('updateLimit')
	}
	else {
		$rows = $q->param('updateRows');
		$start = $q->param('updateStart');
	}

	my $count = count_rows($tabs[0]);
	$rows = '' if ($rows =~ /ALL/i);
		
	my @fields = $q->param("$tabs[0]\_fields");
	@fields = $q->param("fields") if $q->param('error');
	my $fields = join (', ', @fields);
	my $query = "DESCRIBE $tabs[0]";
	my ($sth,$res) = prepare_execute($query, $back);

	my @descrlist;
	my @printType;
	my @names;
	my @types;
	my $enums;
	my @fullname;
	my $primary_flag;
	while (@descrlist = $sth->fetchrow_array()) {
		$primary_flag = '1' if ($descrlist[3] =~ /pri/i ) ;
		if (belongs(\@fields,$descrlist[0]) or @fields == 0) {
			push @printType,$descrlist[1];
			if (($descrlist[1] =~ /^\s*\w*blob/i) or ($descrlist[1] =~ /^\s*\w*text/i)){push @types, "-1"}
			elsif($descrlist[1] =~ /^\s*enum\s*\((.*)\)/){
				push @types,'enum';
				my @enumval = ('',split ',',$1);
				@enumval = quoteit(@enumval);
				for (my $i = 0; $i < @enumval; $i++){
					$enumval[$i] =~ s/^'(.*)'$/$1/;
					$enumval[$i] =~ s/''/'/g;
					$enums->{$descrlist[0]}[$i] = $enumval[$i];
				}
			}
			else {push @types, 0}
			push @names,$descrlist[0];
		}
		push @fullname,$descrlist[0];
	}
	$sth->finish();
	
	my $types = \@types;
	my $size = scalar @fullname;
	if (!$fields or ($size == scalar @fields)){$fields = '*'; @fields = @fullname}

	my ($where_, $order_) = quoteit($where, $order);
	print $q->start_multipart_form(-method=>"POST",
		  						   -action=>$full_url);

	my $headtab = {
		name	=> 'UPDATE',
		table	=> "TABLE:&nbsp;$tabs[0]",
		rows	=> "Total&nbsp;rows:&nbsp;$count",
		msg		=> "$_[0]"
		
	};
	printHeaderTable($headtab);
	print qq?
<TABLE BORDER=0><TR><TD>


    <!-- Parameter Table -->
    <TABLE BORDER=0 CELLPADDING=2 WIDTH=100%>
    	<TR>
    		<TD>&nbsp;where&nbsp;<INPUT TYPE=TEXT NAME="updateWhere" VALUE="$where_" SIZE=20 TITLE='Specify records to display'></TD>
    		<TD>&nbsp;order&nbsp;by&nbsp;<INPUT TYPE=TEXT NAME="updateOrder" VALUE="$order_" SIZE=15 TITLE='Specify column to order the records by'></TD>
    		
    		<TD>&nbsp;offset&nbsp;<INPUT TYPE=TEXT NAME="updateStart" VALUE="$start" SIZE=5 TITLE='Specify start record'></TD>
    		<TD>&nbsp;rows&nbsp;<INPUT TYPE=TEXT NAME="updateRows" VALUE="$rows" SIZE=3 MAXLENGTH=3 TITLE='Specify number of records to be displayed'></TD>
    		<TD>&nbsp;<INPUT TYPE=SUBMIT NAME="reload" VALUE="Reload" TITLE='Reload the page applying new display options only.'></TD>
    	</TR>
    	<TR>
    		<TD COLSPAN=5 ALIGN=LEFT HEIGHT=6></TD>
    	</TR>
    </TABLE>
</TD></TR></TABLE>
?;

print qq?		
<INPUT TYPE=HIDDEN NAME="dbname" VALUE="$database">
<INPUT TYPE=HIDDEN NAME="tables" VALUE="$tabs[0]">
<INPUT TYPE=HIDDEN NAME="page" VALUE="update">
<INPUT TYPE=HIDDEN NAME="start" VALUE="$start">
<INPUT TYPE=HIDDEN NAME="rows" VALUE="$rows">
<INPUT TYPE=HIDDEN NAME="where" VALUE="$where_">
<INPUT TYPE=HIDDEN NAME="order" VALUE="$order_">
?;
	foreach (@fields){
		last if ($fields eq '*');
		print "<INPUT TYPE=HIDDEN NAME=\"fields\" VALUE=\"$_\">\n";
	}
	my $priref;
	if (($start =~ /[\D]/) or ($rows =~ /[\D]/)) {
		ErrMessage("<P><B>The values OFFSET and ROWS must be numeric!</B><P>");
		print $q->hidden(-name=>'error', -value=>'1');
	}
	else {


		$query  = "SELECT $fields FROM $tabs[0]";
		$query .= " WHERE $where" if $where;
		$query .= " ORDER BY $order" if $order;
    	$query .= " LIMIT $start, $rows"			if ($start and ($rows or ($rows eq '0')));
    	$query .= " LIMIT $rows" 					if (!$start and ($rows or ($rows eq '0')));
    	$query .= " LIMIT $start, ".($count-$start)	if ($start and (!$rows and ($rows ne '0')));

		$sth = $dbh->prepare($query) || do {print $q->hidden(-name=>'error', -value=>'1'); ErrMessage("Something wrong")};
		$res = $sth->execute		 || do {print $q->hidden(-name=>'error', -value=>'1'); ErrMessage("Wrong parameters")};


		$priref = $sth->{mysql_is_pri_key};

		print "<P><B>The Table contains no Data!</B><BR>\n\n" if ($count == 0);
	}
	print "<!-- Update Table -->\n\n";
	print "<TABLE BORDER=0>\n";
	print "\t<TR BGCOLOR=\"#cccccc\">\n\t\t<TD>&nbsp;&nbsp;</TD>\n\t\t<TD>&nbsp;&nbsp;&nbsp;&nbsp;</TD>\n";
	my $i = 0;
	my $zoom_ok = '';
	foreach (@fields) {
		my $color = '#000000';
		$color = '#ff0000' if $priref->[$i];
		my $zoomselect = '';
		if ($types[$i] == -1) {
		   $zoomselect = "<INPUT TYPE=RADIO NAME=\"zoomselect\" VALUE=\"$_\" TITLE='Select column to zoom'>" ;
		   $zoom_ok = 1;
		}
		print 	"\t\t<TH BGCOLOR=\"#EEEEEE\"><FONT COLOR=\"$color\"> $zoomselect $_</TH>\n";
		$i++;
	}
	print "\t</TR>\n";

	$i = 0;
	my $j;
	while (@ary = $sth->fetchrow_array()) {
		print "\t<TR VALIGN=TOP>\n\t\t<TD>".($i+$start)."</TD>\n";
		print "\t\t<TD><INPUT TYPE=\"CHECKBOX\" NAME=\"SelectRow\" VALUE=\"".($i+$start)."\" TITLE='Select row (to zoom or delete)'></TD>\n";
		my $jj=0;
		for ($j=0; $j<@ary; $j++) {
			$ary[$j] = quoteit($ary[$j]);
			if ($types[$jj] == -1){
				print "\t\t<TD ALIGN=CENTER>";
				print "<TEXTAREA ROWS=2 COLS=30 NAME=\"n".$i."_".$jj."\" WRAP=PHYSICAL TITLE='Edit this value'>$ary[$j]</TEXTAREA></TD>\n";
			}
			elsif ($types[$jj] eq 'enum'){
				print "\t\t<TD ALIGN=CENTER><SELECT NAME=\"n".$i."_".$jj."\" TITLE='Select another value'>\n";
				foreach (@{$enums->{$names[$j]}}) {
					my $selected = 'SELECTED' if ($_ eq "$ary[$j]");
					print qq!<OPTION VALUE="$_" $selected>$_\n!;
				}
				print "</SELECT></TD>\n";
			}
			else {
				print "\t\t<TD ALIGN=CENTER><INPUT TYPE=TEXT NAME=\"n".$i."_".$jj."\" VALUE = \"$ary[$j]\" TITLE='Edit this value'></TD>\n";
			}
			$jj++	
		}#for
		print "\t</TR>\n";
		$i++;
	}#while
	$sth->finish();
	my $DBIerr 				= $DBI::err;
	$DBIerr 				+= 0;
	$DBIerr == 0 or bail_out ("Retrieve Error");
		
	print "\t<TR>\n\t\t<TD COLSPAN=\"". (scalar (@$types)+2) ."\"><HR SIZE=\"1\"></TD>\n\t</TR>\n";
	print "\t<TR>\n\t\t<TD COLSPAN=\"". (scalar (@$types)+2) ."\">Insert new row:</TD>\n\t</TR>\n";
	print "\t<TR>\n\t\t<TD>&nbsp;</TD>\n\t\t<TD>&nbsp;</TD>\n";
	@printType = quoteit(@printType);
	foreach (@printType) {
		s/^\s*enum.*/enum/i;
		print "\t\t<TD ALIGN=CENTER>$_</TD>\n";		
	}
	print "\t</TR>\n";
		
	print "\t<TR>\n\t\t<TD>$count</TD>\n\t\t<TD>&nbsp;</TD>\n";
	$i = 0;	
	foreach (@types) {
		if ($_ == -1){
		   print "\t\t<TD ALIGN=CENTER><TEXTAREA WRAP=PHISICAL ROWS=2 COLS =30 NAME=\"$fields[$i]\_data\" TITLE='Insert value'></TEXTAREA></TD>\n";
		}
		elsif ($_ eq 'enum'){
			print "\t\t<TD ALIGN=CENTER><SELECT NAME=\"$fields[$i]\_data\">\n";
			foreach (@{$enums->{$names[$i]}}) {
				print qq!<OPTION VALUE="$_">$_\n!;
			}
				print "</SELECT></TD>\n";
		}
		else {
			print "\t\t<TD ALIGN=CENTER><INPUT TYPE=TEXT NAME=\"$fields[$i]\_data\" TITLE='Insert value'></TD>\n";
		}	
		$i++;
	}#foreach
	my $zoombutton = '<INPUT TYPE=SUBMIT NAME="zoom" VALUE="Zoom" TITLE="Zoom selected value">' if $zoom_ok;
	
	print <<EndSubmit
	</TR>
		 </TABLE>
	

		
<!-- Footer Table Starts Here -->

<TABLE BORDER=0>
	<TR>
		<TD ALIGN=LEFT VALIGN=TOP>
<!-- PREVIEW -->	
    <TABLE BORDER=0>
    	<TR>
    		<TD><P><INPUT TYPE=CHECKBOX NAME="preview" TITLE='Check to preview generated command'></TD>
    		<TD VALIGN=MIDDLE TITLE='Check to preview generated command'>Preview SQL query.</TD>
    	</TR>
    </TABLE><BR>		
		
<!-- Submit Buttons -->	
	<TABLE BORDER=0>
		<TR>
	   	   <TD><INPUT TYPE=SUBMIT NAME="update" VALUE="Update" TITLE='Update the table'></TD>
		   <TD><INPUT TYPE=SUBMIT NAME="insert" VALUE="Insert" TITLE='Insert new row'></TD>
		   <TD>$zoombutton</TD>
		   <TD><INPUT TYPE=SUBMIT NAME="delete" VALUE="Delete" style="color: #CC0000" TITLE='Delete selected rows'></TD>
		   <TD><INPUT TYPE=RESET TITLE='Reset changes'></TD>
		</TR>
	</TABLE>

	<TABLE BORDER=0>
		<TR>
			<TD>UPDATE&nbsp;[&nbsp;low priority<INPUT TYPE=CHECKBOX NAME="update_option1" VALUE="LOW_PRIORITY" TITLE='Defer the statement until no clients are reading from the table'>&nbsp;]&nbsp;[
		   				   ignore&nbsp;<INPUT TYPE=CHECKBOX NAME="update_option2" VALUE="IGNORE"  TITLE='Ignore rows that duplicate values for unique keys'>&nbsp;]</TD>
		</TR>
		<TR>
			<TD>INSERT&nbsp;[&nbsp;low priority<INPUT TYPE=RADIO NAME="insert_option1" VALUE="low_priority" TITLE='Defer the statement until no clients are reading from the table'>/
		   				   delayed&nbsp;<INPUT TYPE=RADIO NAME="insert_option1" VALUE="DELAYED" TITLE='Delayed Insertion'>&nbsp;]&nbsp;[
						   ignore&nbsp;<INPUT TYPE=CHECKBOX NAME="insert_option2" VALUE="IGNORE"  TITLE='Ignore rows that duplicate values for unique keys'>&nbsp;]</TD>
		</TR>
		<TR>
			<TD>DELETE&nbsp;[&nbsp;low priority<INPUT TYPE=CHECKBOX NAME="delete_option1" VALUE="LOW_PRIORITY" TITLE='Defer the statement until no clients are reading from the table'>&nbsp;]</TD>
		</TR>

	</TABLE>
	</TD><TD VALIGN=TOP>
<!-- Select columns Table -->
	 <TABLE><TR><TD TITLE='Select columns to display'><B>Select columns</B><BR>
	 
EndSubmit
;	
	print "<SELECT SIZE=$size NAME=$tabs[0]\_fields MULTIPLE>\n";
	foreach (@fullname){
		my $selected = 'SELECTED' if (belongs(\@fields, $_) or !@fields);
		print qq!<OPTION VALUE="$_" $selected>$_ \n!;
	}
	print "\t\t</SELECT></TD>\n\t\t</TR>\n\t</TABLE>\n\n";
	print "\t\t</TD>\n\t</TR>\n</TABLE><!-- Footer Table Ends Here -->\n\n";
	print $q->end_form;
	print "\n\n<!-- loadUpdateForm Procedure ends here -->\n\n";	
	
}
sub execSelectFromTable {
	my @tabs = $q->param('tables');
	if ((@tabs == 0) or !$tabs[0]){
		returntotab("<P><b>ERROR:</B> Table is not specified.<BR>\n");
		return
	}
	print "\n\n<!-- Select from Table procedure starts here -->\n\n";
	my $dbname		= $q->param ('dbname');
	my @where 		= $q->param ('where');
	for (my $i=0; $i<@where; $i++){
		$where[$i] = '' unless ($where[$i] =~ /\S/);
	}

    my @groupby 	= $q->param ('groupby');
    my @orderby 	= $q->param('orderby');
	my @select 		= $q->param('select');
	my @limitref 	= getlimit(scalar @tabs);
	
	my @limit 		= @{$limitref[0]};
	my @offset 		= @{$limitref[1]};
	my @rows 		= @{$limitref[2]};
	my $back 		= {page => 'select_db', dbname => $database};
	my @exclude = $q->param('exclude');
	if ((@tabs - @exclude) > 1){
		print qq!\n<FORM METHOD=POST ACTION="$full_url">!;
		print qq!\n<INPUT TYPE=HIDDEN NAME="dbname" VALUE="$dbname">\n!;
		print qq!\n<INPUT TYPE=HIDDEN NAME="page" VALUE="tables">\n!;
		print qq!\n<INPUT TYPE=HIDDEN NAME="func" VALUE="select">\n!;
	}
	my $i = -1;
	foreach (@tabs) {
		$i++;
		next if (belongs (\@exclude, $_));
		my $fieldsref;
		my @total;
		my $query 		= "SELECT * FROM $_ WHERE 1=0";
		my ($sth,$res)	= prepare_execute($query, $back);
		$fieldsref 		= $sth->{NAME};
		my $tables		= $sth->{mysql_table} or bail_out("Can not read table names");
		$sth->finish();
		my $tabs;
		my $size		= $sth->{NUM_OF_FIELDS};
		if ($tabs[$i] =~ /\W/){ 
			my @unitabs;
			for (my $j=0; $j<$size; $j++){
				$fieldsref->[$j] = "$tables->[$j]\.$fieldsref->[$j]" ;
				unless (belongs(\@unitabs,$tables->[$j])) {
					push @unitabs, $tables->[$j];
					push @total, count_rows($tables->[$j]);
				}
				
			}
			$tabs = join(', ', @unitabs);
		}
		else {push @total, count_rows($tabs[$i]); $tabs = $tabs[$i]}
		my $total		= join(', ',@total);		
		my @fields 		= $q->param("fields_$tabs[$i]");
		my $fields 		= join (', ', @fields);
		$fields = '*' if (!$fields or ($size == scalar @fields));
		if ($select[$i]) {$query = "SELECT $select[$i] FROM $tabs[$i] "}
		else {$query = "SELECT $fields FROM ".$tabs[$i]}
		unless (defined $where[$i]) {$where[$i] = $where[0]}
		$query .= " WHERE $where[$i]"		  if ($where[$i]);
		unless (defined $groupby[$i]) {$groupby[$i] = $groupby[0]}
		$query .= " GROUP BY $groupby[$i]" 	  if ($groupby[$i]);
		unless (defined $orderby[$i]) {$orderby[$i] = $orderby[0]}
		$query .= " ORDER BY $orderby[$i]" 	  if ($orderby[$i]);

		$query .= " LIMIT $limit[$i]" if  ($limit[$i] ne '');
		my ($where_, $query_) = quoteit($where[$i],$query);
		
		($orderby[$i],
		$groupby[$i],
		$limit[$i],
		$select[$i],
		$tabs[$i]) = quoteit(
				   	 		 $orderby[$i],
							 $groupby[$i],
							 $limit[$i],
							 $select[$i],
							 $tabs[$i]
							 );
		
		unless ((@tabs - @exclude) > 1){
			printform($query_);

		 	print qq!\n<FORM METHOD=POST ACTION="$full_url">!;
			print qq!\n<INPUT TYPE=HIDDEN NAME="dbname" VALUE="$dbname">\n!;
			print qq!\n<INPUT TYPE=HIDDEN NAME="page" VALUE="tables">\n!;
			print qq!\n<INPUT TYPE=HIDDEN NAME="func" VALUE="select">\n!;
		}
		print "<P TITLE='Executed statement'>$query_</P>\n";

		print $q->table({-border=>'0'},
			  $q->Tr(
			  	$q->td(["\n<INPUT TYPE=\"SUBMIT\" VALUE=\"Go\" TITLE='Reload page.'>\n",
    					"select\n",
						#"&lt;columns&gt;",
						"<INPUT TYPE=\"TEXT\" SIZE=\"10\" NAME=\"select\" 	VALUE=\"$select[$i]\" TITLE='List of columns and aliases'>\n",
						"from\n",
						"<INPUT TYPE=\"TEXT\" SIZE=\"10\" NAME=\"tables\"	VALUE=\"$tabs[$i]\" TITLE='List of tables and aliases.'>\n",
                		"where\n",
						"<INPUT TYPE=\"TEXT\" SIZE=\"10\" NAME=\"where\"	VALUE=\"$where_\" TITLE='Specify conditions of WHERE clause'>\n",
                		"group&nbsp;by\n",
						"<INPUT TYPE=\"TEXT\" SIZE=\"10\" NAME=\"groupby\"	VALUE=\"$groupby[$i]\" TITLE='Specify columns to group by'>\n",
                		"order&nbsp;by\n",
						"<INPUT TYPE=\"TEXT\" SIZE=\"10\" NAME=\"orderby\"	VALUE=\"$orderby[$i]\" TITLE='Specify columns to order by'>\n",
                		"limit\n",
						"<INPUT TYPE=\"TEXT\" SIZE=\"10\" NAME=\"limit\"	VALUE=\"$limit[$i]\" TITLE='Limit the output'>\n"
			  			])
			  )
		);# if ($total > 1);
		my $exclude = qq!&nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE=CHECKBOX NAME='exclude' VALUE="$_" TITLE='Exclude this table next time the page is reloaded'> Exclude! if ((@tabs - @exclude) > 1);

		$sth = $dbh->prepare($query) || ErrMessage; 
		$res = $sth->execute		 || ErrMessage;
    	print "
<TABLE BORDER=0>
	<TR>
		<TD COLSPAN=2>
			<TABLE WIDTH=700 BORDER=0>
				<TR>
					<TD><CODE>TABLE:&nbsp;&nbsp;$tabs</CODE>$exclude</TD>	
					<TD WIDTH=30 ALIGN=RIGHT>&nbsp;</TD>
					<TD WIDTH=270><CODE>Total Rows:&nbsp;&nbsp;$total</CODE></TD>
				</TR>
			</TABLE>
		</TD>
	</TR>
	<TR VALIGN=TOP>
		<TD VALIGN=TOP><!-- printresult -->
";
		print &printresult(\$sth, $offset[$i], 1) unless $DBI::err;
		
		$sth->finish();
		
		print "\n\n <!-- /endprintresult -->\n";
		print "\t\t</TD>\n";
  		print "\t\t<TD VALIGN=TOP>\n\n";
		print "<TABLE><TR><TD TITLE='List of selected columns.\nThe columns can alternatively be selected from this list'><B>SHOW COLUMNS</B></TD></TR>";
		print "<TR><TD>\n<SELECT MULTIPLE NAME='fields_$tabs[$i]' SIZE=$size>\n";
		for (my $j=0; $j<$size; $j++){
			my $selected = "SELECTED" if (belongs(\@fields, $fieldsref->[$j]) or !@fields);
			print qq!<OPTION VALUE="$fieldsref->[$j]" $selected>$fieldsref->[$j] \n!;
		}
		print "\n</SELECT></TD></TR></TABLE>";
		print "\n\t\t</TD>\n\t</TR>\n</TABLE>";
		print "\n<BR><HR SIZE=1><BR>\n";
		unless ((@tabs - @exclude) > 1){
			print "\n</FORM>";
		}
	}
	print "\n</FORM>" if ((@tabs - @exclude) > 1);
	print "\n\n<!-- Select from Table procedure endss here -->\n\n";

return

}



sub execExecuteQuery {

	my $userhost = myhost();
	my $userdir = "$USER_DIR$delim$user.$userhost$delim"."sql";
	my ($selectedscript, $SQL);
	if ($q->param('script') =~ /Edit/i ){$selectedscript = quoteit($q->param('selectscript'))}
	elsif ($q->param('script') =~ /save as/i ){
		my $saveasname		= $q->param('saveasname');
		my $newname			= "$userdir$delim$saveasname";
		$selectedscript		= quoteit($q->param('saveasname')) if (-e "$newname");
	}
	else {$selectedscript	= quoteit($q->param('selectedscript'))}
	my $selectedscriptname	= "LOADED&nbsp;SCRIPT:&nbsp;<B><U>$selectedscript</U></B>" if $selectedscript;
	

	$SQL 					= quoteit($q->param('SQL'));
	print <<ENDOFFILETAB
<FORM METHOD=POST ACTION="$full_url">
<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>
	<TR>
		<TD>
<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH=100%>	
	<TR>			
		<TD>
		<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH=100%>
			<TR>
				<TD COLSPAN=4><TEXTAREA WRAP=PHYSICAL NAME='SQL' ROWS=10 COLS=70 TITLE='SQL script editor'>$SQL</TEXTAREA></TD></TR>
			<TR>
				<TD><INPUT TYPE=SUBMIT NAME='script' VALUE='Execute Query' style='width: 100px' TITLE='Execute SQL script'></TD>
				<TD><INPUT TYPE=SUBMIT VALUE='     Back     ' style='width: 100px' TITLE='Go back to previous page'></TD>
				<TD><INPUT TYPE=RESET VALUE='   Reset   ' style='width: 100px' TITLE='Reset form'></TD>
				<TD WIDTH=400>&nbsp;</TD>
			</TR>
		</TABLE></TD>
	</TR>				
	<TR><TD HEIGHT=2></TD>
	</TR>
	<TR>			
		<TD><P>
		<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH=100%>
			<TR VALIGN=BOTTOM>
				<TD VALIGN=BOTTOM><INPUT TYPE=SUBMIT NAME='script' VALUE='Save' TITLE='Save SQL script &quot;$selectedscript&quot;'></TD>
				<TD VALIGN=BOTTOM><INPUT TYPE=SUBMIT NAME='script' VALUE='Save as' TITLE='Save SQL script as ...'></TD>
				<TD VALIGN=BOTTOM><INPUT TYPE=TEXT NAME='saveasname' SIZE=30 TITLE='Type name to save as'></TD>
				<TD WIDTH=350  VALIGN=BOTTOM><ALIGN=BOTTOM></TD>
			</TR>
			<TR>
				<TD COLSPAN=4 HEIGHT=20><P>$selectedscriptname
				</TD>
			</TR></TABLE>
		</TABLE></TD>
	</TR>
</TABLE>
		
ENDOFFILETAB
			unless ($page eq 'select_db' or $print);

	my $back1;
	my $back;
	foreach (keys %{$_[0]}){
		$back1 .= "<INPUT TYPE=HIDDEN NAME=\"$_\" VALUE=\"".quoteit(${$_[0]}{$_})."\">\n";
		$back->{$_} = quoteit(${$_[0]}{$_});
	}
	
	#GET QUERIES:
	my $queries;
	if ($q->param('script') =~ /run/i) {
		my $scriptname 		= $q->param('selectscript');
		my $file 			= "$userdir$delim$scriptname";
		open (FH, "$file")||bail_out("Can not open file $scriptname $!", $back,'1');
		flock (FH,2) unless $WIN32;
		my $i;
		while(<FH>){
			$queries .= $_;
			if ($i++ > 10000) {bail_out("OVERCYCLED!", $back,'1')} 
		}
		flock (FH,8) unless $WIN32;
		close FH;
	}
	else {$queries = $q->param('SQL')}
	unless ($print){
		print "\n<!-- EXECUTE QUERY starts here -->\n";
		print "\n<FORM ACTION=$full_url METHOD=POST>\n\n" if ($page eq 'select_db');
	}	
	bail_out ("Query was empty!", $back, '1') unless ($queries =~ /\S/);
	
	$queries 		=~ s/\/\*.*\*\///sg;
	$queries		=~ s/^\s*#.*$//mg;
	my @queryarray	= split (';',$queries);
	bail_out ("Query was empty!", $back, '1')if (@queryarray == 0);
	unless ($print){
		print $back1;
		$back->{'SQL'} = $SQL;
		print "</FORM>\n" unless ($page eq 'select_db');;
		print "Script Name: ", quoteit($q->param('selectscript')) if ($q->param('script') =~ /run/i);
	}
	for (my $i = 0; $i < @queryarray; $i++){
		#if ($i){$back = {}};
		$query = $queryarray[$i];
		next unless ($query =~ /\w./);
   		my $keyword = '';
   		$query =~ /^\s*(\w*)\s.*/; $keyword = $1;
#++++++++++++++++++++++++++++++++++++++
    	my $sth = $dbh->prepare ($query);
    	my $res = $sth->execute;
		if ($DBI::err){
			bail_out ("Cannot execute query $query", $back);
		}
		$query = quoteit($query);
		
        if (belongs(\@selectlike,$keyword)) {
		  	printform($query) unless ($print or ($page eq 'select_db'));
 		 	print &printresult(\$sth,undef,1);
			ErrMessage("Print Result Error $DBI::errstr") if $DBI::err;
		} 

		$query =~ s/^\s*$//mg;
		$query =~ s/^/<BR>/mg;
		$query =~ s/\t/&nbsp;&nbsp;&nbsp;&nbsp;/g;
		print <<EOT
<P>Executed Query:<b>$query</b><BR>
Result: $res <P>
<HR SIZE=1 LENGTH=100%><BR>

EOT
unless $print;
	}
	if ($page eq 'select_db'){
		print "<INPUT TYPE=SUBMIT VALUE='Back'>";
		print "<INPUT TYPE=HIDDEN NAME='SQL' VALUE=\"$SQL\">";
		print "</FORM>\n";
	}
	print "<!-- End of EXECUTE QUERY -->\n\n" ;
	return;
}# END EXECUTE

sub loadDropPreview {
	print "\n\n<!-- loadDropPreview Procedure starts here -->\n\n";
	my @tabs = $q->param('tables');
    if (@tabs == 0){
       returntotab("<p><b>ERROR:</B> Table is not specified.<P>");
       return;
    }
	print qq!<FORM METHOD=POST ACTION="$full_url">!;

	printHeaderTable({name => "DROP"});
	
	print qq!<TABLE BORDER=0>\n!;
    foreach (@tabs){
    	print qq!<TR><TD><B>DROP TABLE $_</B></TD>!;
		print qq!<TD><INPUT TYPE=CHECKBOX NAME='tables' VALUE="$_" CHECKED></TD></TR>\n!;
    }
    print qq!</TABLE><P>!;
    print qq!<INPUT TYPE=SUBMIT NAME='drop' VALUE='Submit'>\n !;
	print qq!<INPUT TYPE=HIDDEN NAME='dbname' VALUE="!.$q->param('dbname').qq!">\n!;
	print qq!<INPUT TYPE=SUBMIT NAME='return' VALUE='Return'>\n!;
   	print qq!<INPUT TYPE=HIDDEN NAME='page' VALUE='drop'>\n!;
	print qq?\n\n<!-- loadDropPreview Procedure ends here -->\n\n?;
	print qq!</FORM>!;
	return;
}


sub execDropTable {
	if ($q->param('drop')){ 
    	my @tabs = $q->param('tables');
    	if (@tabs == 0){
    		returntotab("<p><b>ERROR:</B> Table is not specified.<P>");
			return;
    	}
    	foreach (@tabs){
    		my $query = "DROP TABLE $_";
    		$dbh ->do($query) || bail_out("Cannot drop table", {page=>'select_db', dbname=>"$database"});
    	}
	}
	
	&loadSelectTables();
	
	return;
}

sub loadDeletePreview {
	print "\n\n<!-- loadDeletePreview Procedure starts here -->\n\n";
	print qq!<FORM METHOD=POST ACTION="$full_url">!;
	printHeaderTable({name => "DELETE"});
	my @tabs = $q->param('tables');

	if (@tabs == 0){
		returntotab("<p><b>ERROR:</B> Table is not specified.<P>\n");
		return;
	}
	if (@tabs >= 2) {
		returntotab("<p><b>ERROR:</B> Too Many Tables.<P>\n");
		return;		  
	}

    my $where = quoteit($q->param('wheredelete'));
    my $query;
    if ($where) {$query = "DELETE FROM $tabs[0] WHERE $where"}
    else {$query = "DELETE FROM $tabs[0] WHERE 1=1"}

    print "<BR>QUERY:<B> $query</B><P>\n";
    print "<INPUT TYPE=\"SUBMIT\" NAME=\"delete\" VALUE=\"Submit\">\n";
	print "<INPUT TYPE=\"SUBMIT\" NAME=\"return\" VALUE=\"Return\">";
    print "<INPUT TYPE=\"HIDDEN\" NAME=\"tables\" VALUE=\"$tabs[0]\">\n";
    print "<INPUT TYPE=\"HIDDEN\" NAME=\"wheredelete\" VALUE=\"$where\">\n";
	print "\n<INPUT TYPE=\"HIDDEN\" NAME=\"dbname\" VALUE=\"".$q->param('dbname')."\">\n";
   	print "<INPUT TYPE=\"HIDDEN\" NAME=\"page\" VALUE=\"delete\">\n";
	print "</FORM>";
	print "<!-- loadDeletePreview Procedure endss here -->";

	return;
}
sub loadAlterTable {
	my $back = {page => 'select_db', dbname => "$database"}; 
	print "\n<!-- Alter procedure starts here -->\n";
	my (@tabs, $del, $hr, $newcolumn, $sth, $res);
	unless (@tabs = $q->param('newtablename')) {@tabs = $q->param('tables')};
	if ($q->param('func')=~/create/i){
		@tabs=();
	}
	elsif (@tabs >=2) {
		returntotab("<P><B>ERROR:</B>Too many tables!<BR>\n");
		return;
	}
	elsif (!$tabs[0]){
		bail_out("Table is not selected.", $back) if ($q->param('func')=~/ALTER/);
		@tabs=();
	}
	my $autoincr;
#	my $tabletype;
	if ($tabs[0]){
#		($sth, $res) = prepare_execute("SHOW TABLE STATUS FROM $database", $back);
#		while (my @row = $sth->fetchrow_array()){
#			if ($row[0] eq $tabs[0]){$tabletype = $row[1]; last}
#		}
		($sth, $res) = prepare_execute("DESCRIBE $tabs[0]", $back);
		$autoincr = '<B>Auto<BR>Increment</B>';
		$del = "Del.";
		$newcolumn = "NEW COLUMN:";
		$hr = "<HR SIZE=1>";
	}
#	my $tabletypeselect;
	
	
	my $typeoptionlistref = sub  {
		my @optionlist;
		my $type = shift;
		$type =~ s/^\s*(\w*)(\(.*\))?(.*)/$1/;
		
		my $symbols = $2; 
		my $therest = $3;
		$symbols =~ s/^\((.*)\)/$1/ if $symbols;
		
		my $unsigned = '';
		my $zerofill = '';
		my $binary = '';
		$symbols = quoteit($symbols);
		$unsigned = 'CHECKED' if ($therest =~ /unsign/i);
		$zerofill = 'CHECKED' if ($therest =~ /zerofill/i);
		$binary = 'CHECKED' if ($therest =~ /binary/i);
		for (my $i=0; $i<@typelist; $i++) {
			my $selected = 'SELECTED' if ($typelist[$i] =~ /^($type)$/i);
			push @optionlist, qq!\t\t\t<OPTION VALUE="$typelist[$i]" $selected>$typelist[$i] \n!;
		}

return (\@optionlist, $type, $symbols, $unsigned, $zerofill, $binary) if wantarray;
return (\@optionlist) if defined wantarray;
};
	print qq!<FORM METHOD=POST ACTION="$full_url">!;
	my ($procname, $tabtitle, $colnametitle, $saveastitle, $saveas1);
	if (@tabs) {
		$procname 		= qq!ALTER TABLE!;
		$tabtitle 		= qq!Edit table name.\nAlphanumeric characters and underscore only!;
		$colnametitle 	= qq!Edit column name.\nAlphanumeric characters and underscore only!;
		$saveastitle 	= qq!Type the name of a new table.\nAlphanumeric characters and underscore only!;
		$saveas1		= qq!<INPUT TYPE=SUBMIT NAME='saveas' VALUE='Save as' TITLE='Create new table with the same structure. All changes will be applied to new table'>!;
	}
	else {
		$procname 		= "CREATE NEW TABLE";
		$tabtitle 		= "Type the name of new table.\nAlphanumeric characters and underscore only";
		$colnametitle 	= "Type column name in this field.\nAlphanumeric characters and underscore only";
	} 
	print <<EOT
<!-- Header Table -->
<TABLE BORDER=0 CELLSPACING=1 CELLPADDING=2>
	<TR><TH ALIGN=LEFT>$procname</TH><TD>&nbsp;$_[0]</TD><TR>
	<TR VALIGN=MIDDLE>
		<TD><nobr><CODE>TABLE&nbsp;NAME:&nbsp;</CODE><INPUT TYPE=TEXT NAME='newtablename' VALUE="$tabs[0]" SIZE=30 TITLE='$tabtitle'>&nbsp;</nobr></TD>
		<TD>&nbsp;</TD>
	</TR>
<!-- <TR><TH COLSPAN=5 ALIGN=LEFT HEIGHT=0></TH><TR> -->
</TABLE>
<!-- End of Header Table -->
EOT
;
	print <<EOT
<BR>
<TABLE ID='MAIN' BORDER=0 CELLPADDING=2 CELLSPACING=2>	
	<TR>
		<TD><B>$del</B></TD>
		<TD TITLE='$colnametitle'><B>COLUMN NAME</B></TD>
		<TD TITLE='Select column type'><B>Type</B></TD>
		<TD TITLE="Type column length or values of ENUM or SET types (quoted and comma separated)"><B>Length or<BR>enum/set elements</B></TD>
		<TD TITLE="This attribute disallows negative values.\n(Numerics only)"><B>Unsigned</B></TD>
		<TD TITLE="This attribute causes the displayed value to be padded with leading zeros to the display width.\n(Nimerics only)"><B>Zerofill</B></TD>
		<TD TITLE="This attribute causes column value to be treated as binary string and case sensitive in comparation and sorting operations.\n(String types only)"><B>Binary</B></TD>
		<TD TITLE="This attribute specifies whethere or not the column may contain NULL values. If not specified, NULL is the default."><B>Not Null</B></TD>
		<TD TITLE="Specifies the default value for the column. This can not be used for BLOB or TEXT types."><B>Default</B></TD>
		<TD TITLE='Selected column will be turned into Autocolumn.\nOnly one column can be Autocolumn'>$autoincr</TD>
	</TR>
EOT
;
	my @columns;
	my $pri_flag;
	if (@tabs > 0){
    	while (my @row = $sth->fetchrow_array()) {
    		push @columns, $row[0];
    				my $notnull_selected = 'CHECKED' unless ($row[2] =~ /yes/i);
    		my ($typeoptionref, $type, $symbols, $unsigned_selected, $zerofill_selected, $binary_selected, $autoincrement_selected) = &$typeoptionlistref($row[1]);
    		$autoincrement_selected = 'CHECKED' if ($row[5] =~ /^.*auto.*increment.*$/i);
    		$row[4] = quoteit($row[4]);
    		my $auto = '';
    		if ($row[3] =~ /PRI/i){
    			$auto = "<INPUT TYPE=CHECKBOX NAME='autoincrement' VALUE=\"$row[0]\" $autoincrement_selected TITLE='Selected column will be turned into Autocolumn.\nOnly one column can be Autocolumn'>" if $auto_type{uc $type};
    			$pri_flag = 1;
    		};
    		print <<EndOfMainRow

	<TR><TD><INPUT TYPE=CHECKBOX NAME="drop_column" VALUE="$row[0]" TITLE='Select column to drop'></TD>
		<TD><INPUT TYPE=TEXT NAME="colname" VALUE="$row[0]" TITLE='Edit column name'></TD>
		<TD TITLE='Select column type'><SELECT NAME="type" TITLE='Select column type'>
@$typeoptionref
			</SELECT></TD>
		<TD><INPUT TYPE=TEXT NAME="length" SIZE=10 VALUE="$symbols"  TITLE='Type column length or values of ENUM or SET types (quoted and comma separated)'></TD>	
		<TD><INPUT TYPE=CHECKBOX NAME="unsigned" VALUE="$row[0]" $unsigned_selected TITLE='This attribute disallows negative values.\n(Numerics only)'></TD>
		<TD><INPUT TYPE=CHECKBOX NAME="zerofill" VALUE="$row[0]" $zerofill_selected TITLE="This attribute causes the displayed value to be padded with leading zeros to the display width.\n(Nimerics only)"></TD>
		<TD><INPUT TYPE=CHECKBOX NAME="binary" VALUE="$row[0]" $binary_selected TITLE="This attribute causes column value to be treated as binary string and case sensitive in comparation and sorting operations.\n(String types only)"></TD>
		<TD><INPUT TYPE=CHECKBOX NAME="notnull" VALUE="$row[0]" $notnull_selected TITLE="This attribute specifies whethere or not the column may contain NULL values. If not specified, NULL is the default."></TD>
		<TD><INPUT TYPE=TEXT NAME='default' VALUE="$row[4]" SIZE=15 TITLE="Specifies the default value for the column. This can not be used for BLOB or TEXT types."></TD>
		<TD>$auto</TD>		
	<TR>
EndOfMainRow
;
		}#WHILE
    	$sth->finish();
	}#if tabs>0
	print "\t<TR><TD COLSPAN=10>$hr</TD></TR>\n";
	print "\t<TR><TD COLSPAN=10><B>$newcolumn</B></TD></TR>\n";
	my $newcoltyperef = &$typeoptionlistref();
	my $auto_new = '';
	print <<EOT
	<TR>
		<TD></TD>
		<TD><INPUT TYPE=TEXT NAME="newcolname" VALUE="" TITLE='Type new column name. The name must be unique and consist of alphanumeric and underscore characters only.'></TD>
		<TD TITLE='Select column type'><SELECT SIZE=1 NAME="newcoltype" TITLE='Select column type'>
		<OPTION VALUE='' SELECTED> 
@$newcoltyperef
		</SELECT></TD>
		<TD><INPUT TYPE=TEXT NAME="newcollength" SIZE=10 VALUE="" TITLE='Type column length or values of ENUM or SET types (quoted and comma separated)'></TD>
		<TD><INPUT TYPE=CHECKBOX NAME="unsigned_new" TITLE='This attribute disallows negative values.\n(Numerics only)'></TD>
		<TD><INPUT TYPE=CHECKBOX NAME="zerofill_new" TITLE="This attribute causes the displayed value to be padded with leading zeros to the display width.\n(Nimerics only)"></TD>
		<TD><INPUT TYPE=CHECKBOX NAME="binary_new" TITLE="This attribute causes column value to be treated as binary string and case sensitive in comparation and sorting operations.\n(String types only)"></TD>
		<TD><INPUT TYPE=CHECKBOX NAME="notnull_new" TITLE="This attribute specifies whethere or not the column may contain NULL values. If not specified, NULL is the default."></TD>
		<TD><INPUT TYPE=TEXT NAME='newcoldefault' VALUE="" size=15 TITLE="Specifies the default value for the column. This can not be used for BLOB or TEXT types."></TD>
		<TD>$auto_new</TD>		
	</TR>
EOT
;	
# first / after
	if (@tabs > 0){  	
		print <<EOT
	<TR>
		<TD></TD>
		<TD ALIGN=RIGHT><SELECT NAME='firstafter' SIZE=1>
<OPTION VALUE='' SELECTED>
<OPTION VALUE='FIRST'>FIRST
<OPTION VALUE='AFTER'>AFTER
</SELECT></TD>
		<TD COLSPAN=7 TITLE='Define where to place new column'><SELECT NAME='firstafterwhat' SIZE=1 TITLE='Define where to place new column'>
EOT
;
    	foreach (@columns){
    		print qq!<OPTION VALUE="$_">$_ \n!;
    	}
    	
    	print "</SELECT></TD></TR>\n";
    
    	print "</TABLE>";
    
    	print "\n<HR SIZE=\"1\" LENGTH=\"700\">\n";
# KEYS

		$query = "SHOW INDEX FROM $tabs[0]";
		($sth, $res)= prepare_execute($query, $back,'2');
		if ($res > 0){
        	print "<BR><CODE>Drop the Key:</CODE><BR>";
        	print "<TABLE ID='MAIN' BORDER=0 CELLPADDING=2 CELLSPACING=2>\n";
        	print "<TR><TD><B>Select</B></TD><TD><B>KEY NAME</B></TD><TD><B>KEY</B></TD><TD><B>COLUMN NAME (SUB PART)</B></TD></TR>";
    		my $matrix_ref = $sth->fetchall_arrayref();
	    	$sth->finish();
    		my ($rows) = (!defined($matrix_ref)? 0: scalar(@{$matrix_ref}));
    		my ($cols) = 10;
    	
    		my @matrix = @{$matrix_ref};
    		my $k = 0;
    		my $ref;
    		while (scalar  @matrix){
    			my %hashmatrix = ();
    			my $thekey = $matrix[0][2];
    			for (my $j = 0; $j < @matrix; $j++){
    				if ($matrix[$j][2] eq $thekey) {
    					$hashmatrix{$matrix[$j][3]} = $matrix[$j];
    					$ref = splice (@matrix, $j, 1);
    					$j--;
    				}#IF 
    			}#FOR
    			if ((keys %hashmatrix) > 0) {
    				my @row =  @{$hashmatrix{1}};
            		my $keytype;
					if ($row[1] == 0){
						if ($row[2] =~ /^\s*primary\s*$/i){$keytype = 'PRIMARY KEY'}
						else {$keytype = 'UNIQUE'}
					}
					else {
						if ($row[9] =~ /^\s*FULLTEXT\s*$/i){$keytype = 'FULLTEXT';}
						else {$keytype = 'INDEX' }
					}
    			
    				my $options;
        			foreach (sort {$a <=> $b}(keys %hashmatrix)) {
        				my @row = @{$hashmatrix{$_}};
        				my $subpart = "($row[7])" if ($row[7]);
    					$options .= "<OPTION VALUE=''>$row[4]$subpart\n";
        			}#FOREACH
					print qq!
	<TR><TD><INPUT TYPE=CHECKBOX NAME='drop_key' VALUE="$row[2]" TITLE='Select key to drop'></TD>
		<TD BGCOLOR='#EEEEEE'>$row[2]</TD>
		<TD BGCOLOR='#EEEEEE'>$keytype</TD>
		<TD BGCOLOR='#EEEEEE'><SELECT SIZE=1>$options</SELECT></TD>
	</TR>\n!;
				}#IF

				bail_out("Counter Overflow. Sorry!") if ($k++ > 100000);
			}#WHILE
    	print "</TABLE>\n<HR SIZE=1 LENGTH=700><BR>";
		}#if res > 0
		my $fulltext = "<OPTION VALUE='FULLTEXT'>FULLTEXT" if (check_version('3.23.23'));
		print <<EndNewIndex

<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=2>
	<TR>
		<TD COLSPAN=3><CODE>Add New Key:</CODE></TD>
    <TR>
		<TD><B>KEY NAME</B></TD>
		<TD><B>KEY</B></TD>
		<TD><B>COLUMN NAMES</B><i> comma separated</i></TD>
	</TR>
	<TR>
		<TD><INPUT TYPE=TEXT NAME="keyname" VALUE="" SIZE=12 TITLE='Type key name. Alphanumeric and underscore characters only'></TD>
		<TD TITLE='Select the key type'><SELECT SIZE=1 NAME='keytype' TITLE='Select the key type'>
			<OPTION VALUE=''>
			<OPTION VALUE='PRIMARY KEY'>PRIMARY
			<OPTION VALUE='UNIQUE'>UNIQUE
			<OPTION VALUE='INDEX'>INDEX
			$fulltext
			</SELECT></TD>
		<TD><TEXTAREA ROWS=3 COLS=30 NAME='indcolname' TITLE='Type the column names comprising the key.\nComma separated'></TEXTAREA></TD>
	</TR>
</TABLE>
<HR SIZE=1 LENGTH=700>
EndNewIndex
;
    
	}#if @tabs>0 (for keys)
	else {print "</TABLE><P>";}
    print <<EOT
<INPUT TYPE=HIDDEN NAME="tables" VALUE="$tabs[0]">
<INPUT TYPE=HIDDEN NAME="dbname" VALUE="$database">
<INPUT TYPE=HIDDEN NAME="page" VALUE="alter">
<TABLE BORDER=0 CELLPADDIND=2 CELLSPACING=0>
	<TR>
		<TD COLSPAN=4 TITLE='Check to preview generated command'>
		<INPUT TYPE=CHECKBOX NAME='preview' 
		TITLE='Check to preview generated command'>&nbsp;Preview&nbsp;SQL&nbsp;query.</TD>
	</TR>
	<TR>
		<TD>&nbsp;<INPUT TYPE=SUBMIT VALUE='Submit' TITLE='Apply changes'>&nbsp;</TD>
		<TD>&nbsp;<INPUT TYPE=RESET TITLE='Reset form'>&nbsp;</TD>
		<TD WIDTH=25>&nbsp;&nbsp;</TD>
		<TD>&nbsp;$saveas1&nbsp;</TD>

	</TR>
</TABLE>
</FORM>
<!-- Alter procedure ends here -->
EOT
;
	return;

}

sub execAlterTable {
	my $table 			= $q->param('tables');
	my $back 			= {page => 'tables', func => 'alter', dbname => $database};
	$back->{tables} 	= "$table" if $table;
	
	my @alter;
	my $newtablename 	= $q->param('newtablename');
	$newtablename		=~ s/^\s*(\S.*\S)\s*$/$1/g;
	$table				=~ s/^\s*(\S.*\S)\s*$/$1/g;
	my $saveas;
	if ($table) {
		#if ($q->param('reload')){loadAlterTable(); return}
		if ($newtablename ne $table) {
			if ($q->param('saveas')){
				my $include		= $q->param('savewhat');
				$include		= 'both' if ($include eq 'data');
				
				my $hashref	 = {
					newtablelist	=> [$newtablename],
					tablelist 		=> [$table],
					include			=> 'structure',
					dropifexists	=> '0',
					back			=> '$back',
					comments		=> '0',
					lock			=> '0'
				};
				$saveas			= getdatanstructure($hashref);
				$saveas			=~ s/^(.*)\s*;$/$1/m;
				
			}
			else{
    			push @alter, "RENAME AS $newtablename "
			}
    	}
		
	
    	elsif ($newtablename ne $table) {
    			push @alter, "RENAME AS $newtablename "
    	}
    	my @dropcolumns = $q->param('drop_column');
    	foreach (@dropcolumns) {
    		push @alter, "DROP COLUMN $_ "	
    	}
    	my @colname 		= $q->param('colname');
    	my @type 			= $q->param('type');
    	my @length 			= $q->param('length');
    	my @unsigned 		= $q->param('unsigned');
    	my @zerofill 		= $q->param('zerofill');
    	my @binary 			= $q->param('binary');
    	my @notnull 		= $q->param('notnull');
    	my @default 		= $q->param('default');
    	my @autoincrement 	= $q->param('autoincrement');
    
    	my $query 			= "DESCRIBE $table";
    	my ($sth, $res) 	= prepare_execute($query,{page=>'select_db', dbname=>"$database"});
		if ($res > 5){
			my $unregmes = unrgversion1();
			bail_out ($unregmes, $back);
		}
    	my $typeref 		= sub  {
    		my $type 			= shift;
    		$type 				=~ s/^\s*(\w*)(\(.*\))?(.*)/$1/;
    		my $symbols 		= $2; 
    		my $therest 		= $3;
    		$symbols 			=~ s/^\((.*)\)/$1/ if ($symbols);
    		my $unsigned 		= '';
    		my $zerofill 		= '';
    		my $binary 			= '';
    		$symbols 			= quoteit($symbols);
    		$unsigned 			= '1' if ($therest =~ /unsign/i);
    		$zerofill 			= '1' if ($therest =~ /zerofill/i);
    		$binary 			= '1' if ($therest =~ /binary/i);
    		return ($type, $symbols, $unsigned, $zerofill, $binary);
    	};
    	my $i 				= 0;
    		
    	while (my @row = $sth->fetchrow_array()) {
    		unless (belongs(\@dropcolumns, $row[0])){
    			my ($type, $length, $unsigned, $zerofill, $binary) = &$typeref($row[1]);
    			my $autoincrement 	= '1' if ($row[5] =~ /^.*auto.*increment.*$/i);
    		   	my $notnull 		= '';
    			$notnull 			= 1 unless ($row[2] =~ /yes/i);
        		my $default 		= $row[4];
        		my $unsigned_ 		= belongs(\@unsigned,$row[0]);
        		my $zerofill_ 		= belongs(\@zerofill,$row[0]);
        		my $binary_ 		= belongs(\@binary,$row[0]);
        		my $notnull_ 		= belongs(\@notnull,$row[0]);
        		my $autoincrement_ 	= belongs(\@autoincrement,$row[0]);
        		if (
        			   	($colname[$i] ne $row[0]) 
        			or	($type[$i] !~ /^($type)$/i)
        			or	($length[$i]		ne $length)
        			or	($default[$i]		ne $default)
        			or	($unsigned_			xor $unsigned)
        			or	($zerofill_			xor $zerofill)
        			or	($binary_			xor $binary)
        			or	($notnull_			xor $notnull)
        			or	($autoincrement_ 	xor $autoincrement)
        			)
        		{
        			if ($unsigned_) {$unsigned_ 			= ' UNSIGNED'} else {$unsigned_ = ''}
        			if ($zerofill_) {$zerofill_ 			= ' ZEROFILL'} else {$zerofill_ = ''}
        			if ($binary_)   {$binary_ 				= ' BINARY'} 	else {$binary_ = ''}
        			if ($notnull_)  {$notnull_ 				= ' NOT NULL'}	else {$notnull_ = ''}
        			if ($autoincrement_) {$autoincrement_ 	= ' AUTO_INCREMENT'} else {$autoincrement_ = ''}
        			if ($default[$i]) {$default = " DEFAULT ".$dbh->quote($default[$i])} else {$default = ''}; 
        			$length[$i] = '('.$length[$i].')' if $length[$i];
        			push @alter, "CHANGE COLUMN $row[0] $colname[$i] $type[$i]$length[$i]"."$unsigned_"."$zerofill_"."$binary_"."$notnull_"."$default"."$autoincrement_";
        		}		
    					
    		}#unless
    		$i++;

    	}
    	$sth->finish();
	} #if table

	if (my $newcolname 		= $q->param('newcolname')) {
		my $newcoltype 			= $q->param('newcoltype');
		my $newcollength 		= $q->param('newcollength');
		$newcollength 			= '('.$newcollength.')' if $newcollength;
		
		my $unsigned_new 		= ' UNSIGNED' if ($q->param('unsigned_new'));
		my $zerofill_new 		= ' ZEROFILL' if ($q->param('zerofill_new'));
		my $binary_new 			= ' BINARY'     if ($q->param('binary_new'));
		my $notnull_new 		= ' NOT NULL'  if ($q->param('notnull_new'));
		my $newcoldefault 		= ' DEFAULT '.$dbh->quote($q->param('newcoldefault')) if ($q->param('newcoldefault'));


		my $addwhere 			= $q->param('firstafter');
		if ($table) {
    		if ($addwhere eq 'AFTER') {
    			$addwhere 			.= " ".$q->param('firstafterwhat');
    		}
    
    		push @alter, "ADD COLUMN $newcolname $newcoltype$newcollength$unsigned_new$zerofill_new $binary_new$notnull_new$newcoldefault $addwhere";
		}
		else {push @alter, " ($newcolname $newcoltype$newcollength$unsigned_new$zerofill_new $binary_new$notnull_new$newcoldefault) "}
	}
	
#THE KEYS

	my @dropind 				= $q->param('drop_key');

	foreach (@dropind){

	 	push @alter,((/^\s*primary\s*/i)? "DROP PRIMARY KEY" : "DROP INDEX $_");

	}

	my @queries 				= ();
	if ($table) {
		if ($saveas){
			push @queries, $saveas ;
			$table 				= $newtablename;
		}
	   	if (@alter) {
		   $query 				= "ALTER TABLE $table ". join(', ', @alter);
		   push @queries, $query;
		}
	}
	else {
		$query 					= "CREATE TABLE $newtablename ". join(', ', @alter);
		push @queries, $query;
	}
	
# ADD NEW INDEX:
	my $keyname 				= $q->param('keyname');
	my $keytype 				= $q->param('keytype');
	my $indcolname 				= $q->param('indcolname');

	if ($keytype){
		my $table 				= $q->param('newtablename');
		$query 					= "ALTER TABLE $table ADD ";
		if ($keytype =~ /^primary$/i) {
			$query				.= "PRIMARY KEY "
		}
		else {
			$query 					.= "$keytype $keyname ";
		}
#		$query 					.= "UNIQUE $keyname " if ($keytype =~ /^unique$/i);
#		$query 					.= "INDEX $keyname " if ($keytype =~ /^index$/i);
		
		$query 					.= "($indcolname)";
		push @queries, $query	;
	}

		if ($q->param('preview') and @queries) {
			my $back = {
				page			=> 'alterAfterPreview',
				newtablename	=> $q->param('newtablename')
			};
			printpreview(\@queries, $back);
			return;
    	}
		else {
			foreach (@queries) {
    			$dbh->do($_) or bail_out("ALTER FAIL\nQUERY: $_", $back);
   			}
		}
		my $msg;
		unless (@queries){$msg = "<FONT COLOR='#FF0000'>No Changes!</FONT>"}
	&loadAlterTable($msg)
}
sub execDeleteFromTable {
	print "<!-- DeleteFromTable Procedure starts here -->";
	my $back = {
		page		=> 'select_db',
		dbname		=> "$database",
	};
	if ($q->param('delete')) {
    	my @tabs = $q->param('tables');
    	if (@tabs == 0){print "<p><b>DELETE ERROR:</B> Table is not specified.<P>\n"}
    	elsif  (@tabs >= 2) {print "<p><b>DELETE ERROR:</B> TOO MANY TABLES.<P>\n"}
    	else {
    		my $where = $q->param('wheredelete');
        	my $query;
        	if ($where) {$query = "DELETE FROM $tabs[0] WHERE $where"}
        	else {$query = "DELETE FROM $tabs[0] WHERE 1=1"}
        	my $res = $dbh -> do($query) or bail_out ("ERROR: CAN NOT DELETE FROM $_ \nQUERY: $query", $back);
		}
	}
	&loadSelectTables();
	print "<!-- DeleteFromTable Procedure ends here -->";
	return;
}
sub getCreateTableSQL {
	my $text;
	my $tabsref 		= $_[0];
	my $dropifexists 	= $_[1];
	my @newtabs 		= @{$_[2]} if defined $_[2];
	my @tabs 			= @$tabsref;
	my $newtabind		= 0;
	foreach my $table (@tabs) {
		$text 					.= "DROP TABLE IF EXISTS $table; \n" if  $dropifexists;
		my $col_declaration 	= '';
		my @col_declaration 	= ();		
		
		my $query 				= "DESCRIBE $table";
		my ($sth, $res) 		= prepare_execute($query, {page => 'connect'});
		my $i = 0;
		while (my @column = $sth->fetchrow_array()) {
			  
			  $col_declaration[$i] .= "\t$column[0] $column[1]";
			  $col_declaration[$i] .= " NOT NULL" unless ($column[2] eq 'YES');
			  $col_declaration[$i] .= " DEFAULT ".$dbh->quote($column[4]) unless  ($column[4] eq '');
			  $col_declaration[$i] .= " AUTO_INCREMENT" if  ($column[5] =~ /AUTO_INCREMENT/i);
			  $i++;
		}
		$sth->finish or ErrMessage("Cannot finish STH (DDL-describe)");
		$col_declaration = join (",\n", @col_declaration);
		$query = "SHOW INDEX FROM $table";
		($sth, $res) = prepare_execute($query, {page => 'connect'});
		
		my $index;
		my $fulltext; 
		my %primary;
		my $unique;
		
		while (my @opt = $sth->fetchrow_array) {

			if ($opt[1] eq '0'){
			  	if ($opt[2] =~ /^PRIMARY$/i){
			  		$primary{$opt[3]} = $opt[4];
					$primary{$opt[3]} .= "($opt[7])" if ($opt[7]);
				}
				else{
					my $colname = $opt[4];
					$colname .= "($opt[7])" if ($opt[7]);
			  		$unique->{$opt[2]}{$opt[3]}=$colname;
				}
			}
			else {
				my $colname = $opt[4];
				$colname .= "($opt[7])" if ($opt[7]);
				if ($opt[9] =~ /FULLTEXT/i){$fulltext->{$opt[2]}{$opt[3]}=$colname;}
				else {$index->{$opt[2]}{$opt[3]}=$colname;}
			}
		}
		$sth->finish or ErrMessage("Cannot finish STH (DDL-show index)");

		my @primary_key;
		my @unique;
		my @index;
		my @fulltext; 
		
		foreach (sort keys (%primary)){
			push @primary_key, $primary{$_};
		}
		my $unique_key;
		foreach (keys %$unique) {
			my $hash = $unique->{$_};
			$unique_key .= ",\n\tUNIQUE $_ ";
			
			foreach (sort keys %$hash){
			 	push @unique, $hash->{$_};
			} 
			$unique_key .= "(".join(', ', @unique).")";
			@unique = ();
		}
		my $index_key;
		foreach (keys %$index) {
			my $hash = $index->{$_};
			$index_key .= ",\n\tINDEX $_ ";
			
			foreach ( sort keys %$hash){
				push @index, $hash->{$_};
			} 
			$index_key .= "(".join(', ', @index).")";
			@index = ();
		}
		my $fulltext_key;
		foreach (keys %$fulltext) {
			my $hash = $fulltext->{$_};
			$fulltext_key .= ",\n\tFULLTEXT $_ ";
			
			foreach ( sort keys %$hash){
				push @fulltext, $hash->{$_};
			} 
			$fulltext_key .= "(".join(', ', @fulltext).")";
			@fulltext = ();
		}
		
		my $primary_key = ",\n\n\tPRIMARY KEY (".join(', ',@primary_key).")" if (scalar(%primary));
		my $create_definition = 
            $col_declaration.
            $primary_key.
            $index_key.
			$fulltext_key.
            $unique_key
            ;

       my $table_options = "";
  	   if (check_version('3.23.00')) {
   
    		$query = "SHOW TABLE STATUS";
    		($sth, $res) = prepare_execute($query, {page => 'connect'});
LABLE1:	while (my @row = $sth->fetchrow_array()) {
    			if ($table eq $row[0]){
    			   if ($row[1]) {$table_options .= "\tTYPE=$row[1]\n" unless ($row[1] =~ /myisam/i)}
    			   my $opt = $row[-2];
    			   my $i = 0;
    			   while ($opt =~ /^\s*(\S*=\S*)\s*(.*)$/){
    					 my $first = $1;
    					 my $second = $2;
    					 if ($first =~ /^\s*format\s*=/) {$first = "ROW_$first"}
    					 $table_options .= "\t$first\n";
    					 $opt = $second;
    					 if ($i++ > 100) {
    					 	$table_options = '';
    						print "Table_options fail! ($i)<br>";
    						last LABLE1;
    					 }
    			   }#while
    			   if ($row[-1]) {$table_options .= "\tCOMMENT=\"$row[-1]\"\n";}
    			}#if		
    		}#while
			$sth->finish();
		} #if version = 3.23#
		$table = $newtabs[$newtabind] if $newtabs[$newtabind];
		$text .= <<EOT
CREATE TABLE $table 
(
 $create_definition
)
 $table_options
;

EOT
;
	$newtabind++;
	}
	return $text;
}
sub execGenerateDDL {

	print "<!-- GenerateDDL procedure starts here -->";
	my @tabs = $q->param('tables');
	if (@tabs == 0){
	   returntotab ("<p><b>ERROR:</B> Table is not specified.<P>");
	   return;
	}
	my $dropifexists = $q->param('dropifexists');
	my $text = getCreateTableSQL(\@tabs, $dropifexists);
	

	($user, $password, $MySQLhost, $usedefault) = $q->cookie('db_manager');
	
	my $dbname = $q->param('dbname');
	print <<DDLTable
<FORM METHOD=POST ACTION="$full_url">
<TABLE BORDER=0 CELLPADDING=4>
	   <TR>
	   	   <TD><TEXTAREA WRAP=OFF ROWS=22 COLS=70 NAME='SQL'>$text</TEXTAREA></TD>
		   <TD VALIGN=TOP><P><CODE>APPLY TO:</CODE><P>
		   User name:<BR>
		   <INPUT TYPE=TEXT SIZE=20 NAME="user" VALUE="$user"><BR>
		   Password:<BR>
		   <INPUT TYPE=PASSWORD SIZE=20 NAME="password" VALUE="$password"><BR>
		   Database Name:<BR>
		   <INPUT TYPE=TEXT SIZE=20 NAME="dbname" VALUE=""><BR>
		    host [localhost]<BR>
		   <INPUT TYPE=TEXT SIZE=20 NAME="host" VALUE=""><P>
		   <INPUT TYPE=SUBMIT SIZE=20 NAME="apply" VALUE="Apply">
		   <INPUT TYPE=RESET>
		   </TD>
		</TR>
</TABLE>
<INPUT TYPE=HIDDEN NAME="page" VALUE="ddl">   
<INPUT TYPE=HIDDEN NAME="login" VALUE="1">   
</FORM>
DDLTable
;
	print "\n\n<!-- GenerateDDL procedure ends here -->\n\n";

return;
}
sub execInsertData  {
	my $table = $q->param('tables');
	my $back = {dbname => $database, tables => $table};

	if ($page =~ /insert/i){
		$back->{func} = "INSERT";
		$back->{page} = "tables";
	}
	elsif ($page =~ /update/i) {
		$back->{page} = "tables";
		$back->{func} = "UPDATE";
		$back->{updateStart} = $q->param('start');
		$back->{updateRows} = $q->param('rows');
		$back->{updateWhere} = $q->param('where');
		$back->{updateOrder} = $q->param('order');

  	}
	elsif ($page eq 'searchresult'){
		my @fields = $q->param('fields');
		$back->{page} = "searchresult";
		$back->{func} = "new";
		$back->{where} = $q->param('where').'';
		$back->{start} = $q->param('start').'';
		$back->{rows} = $q->param('rows').'';
		$back->{order} = $q->param('order').'';
		$back->{count} = $q->param('count').'';
		$back->{fields} = \@fields;
	}

	my $count1 = count_rows($table, $back);
	
	my $query = "SELECT * FROM $table LIMIT 0";
	my($sth, $res)= prepare_execute ($query, $back);

	my (@insert_list, @insert_data, $set, $data); #test it
	my @names = @{$sth->{NAME}};
	
	$sth->finish();

	foreach (@names) {
		my @up_list = $q->param('upload');
		if (belongs(\@up_list,$_)){
			$data = $q->param($_.'_data_upload');
			my $buf;
			if (-B $data) {binmode $data}
			my $line = '';
			while (read ($data, $buf, 1024)) {$line .= $buf}
			close $data or bail_out("$!", $back);
			$data = $line;
		}
		else {$data = $q->param($_.'_data')};
		if ($data ne ''){
			push @insert_list, $_;		

			my @unquote = $q->param('unquote');
			$data = $dbh->quote($data) unless belongsb(\@unquote, $_);
			push @insert_data, $data;
		}#if ($data...

		
	}#foreach...
	
	if (@insert_list == 0){
		my @datum;
		foreach (@names) {push @datum, "''"}	
		$query = "INSERT ".$q->param('insert_option1')." ".$q->param('insert_option2').
			   " INTO $table \n (".join (', ', @names).") \n VALUES (".join (', ', @datum).")";
	}#End   -  empty @insert_list
	
	else {
    	$set = "\n".$insert_list[0].'='.$insert_data[0];
    	for (my $i=1; $i<@insert_list; $i++){
    		$set = $set.",\n".$insert_list[$i].'='.$insert_data[$i]
    	}
		$query = "INSERT ".$q->param('insert_option1')." ".$q->param('insert_option2')." INTO $table \n SET $set";
	}

	if ($q->param('preview')) {printpreview([$query]); return }
	my $unregmes = unrgversion();
	bail_out ($unregmes, $back);
	return;
}
sub getdeletequery {
	my ($pri, @queryArray, @pri, @priNum);
	my $input		= shift;
	my $count		= $input->{count};
	my $table		= $input->{table};
	my $start		= $input->{start};
	my $rows		= $input->{rows};
	my $query		= $input->{query};
	my $back		= $input->{back};
	$query .= ' LIMIT '.$start.', '.$rows			if ($start and $rows);
	$query .= ' LIMIT '.$rows 						if (!$start and $rows);
	$query .= ' LIMIT '.$start.', '.($count-$start)	if ($start and !$rows);
	my ($sth,$res) = prepare_execute($query, $back);
		
	my $primary = $sth->{mysql_is_pri_key};
	for (my $i=0; $i<@$primary; $i++){
		if ($primary->[$i]){push @priNum,$i; push @pri, $sth->{NAME}[$i]}
	}

	if (@pri == 0){
	    @pri = @{$sth->{NAME}};
		@priNum = (0..(scalar(@pri)-1));
	}
	my $i = $start;
	my @selectrows = $q->param('SelectRow');
	my $where;
	while (my @ary = $sth->fetchrow_array ()) {
		if (&belongs(\@selectrows, $i)) {
		   	$where .= ' OR ' if ($where);
			my $data = $dbh->quote($ary[$priNum[0]]);
			if (uc($data) eq 'NULL'){$where .= "($pri[0] IS NULL)"}
			else {$where .= "($pri[0] = $data)"}
   			for (my $jj = 1; $jj < @pri; $jj++) {
				my $data = $dbh->quote($ary[$priNum[$jj]]);
				if (uc($data) eq 'NULL'){$where .= " AND ($pri[$jj] IS NULL)"}
    			else {$where .= " AND ($pri[$jj] = $data)"}
    		}
		}
		$i++
	}
	$sth->finish();
	return $where;
	
	
} # end of getdeletequery

sub execUpdateData {
	my $rows = $q->param('rows');
	my $start = $q->param('start')+0;
	my $where = $q->param('where');
	my $order = $q->param('order');
	my $count = &count_rows($q->param('tables'));
	my $table = $q->param('tables');
	my $back = {
			dbname			=> "$database",
			tables			=> "$table",
			page			=> "tables",
			func			=> "UPDATE",
			updateStart		=> "$start",
			updateRows		=> "$rows",
			updateWhere		=> "$where",
			updateOrder		=> "$order"
	};
	my @hidfields 				= $q->param('fields');
	if ($q->param('update') eq 'Update'){
		@hidfields = $q->param('$table\_fields');
		$back->{updateStart} = $q->param('updateStart');
		$back->{updateRows} = $q->param('updateRows');
	}
	$back->{"$table\_fields"}	= \@hidfields;
	my $wrongparam = "<FONT COLOR='#FF0000'><B>WRONG PARAMETERS!</B></FONT>";

	if ($q->param('insert')) {
		my $insert_result;
		unless ($q->param('error')) {
			$insert_result = execInsertData();
			return if $q->param('preview');
		}
		else {$insert_result = $wrongparam}
		&loadUpdateForm($insert_result);
    	return;	
	}
	if ($q->param('reload')) {
    	&loadUpdateForm;
    	return;	
	}
	if ($q->param('zoom')){

		if ($q->param('error')){&loadUpdateForm($wrongparam); return}

		unless ($q->param('zoomselect') and defined $q->param('SelectRow')) { # if nothing was selected to zoom
			my $msg = "<FONT COLOR='#FF0000'><B>PLEASE SELECT ONE ROW AND ONE COLUMN TO ZOOM</B></FONT>";
			&loadUpdateForm($msg)
		}
		else {&loadZoom()}
	   return;
	}
	my ($pri, @queryArray, @pri, @priNum);
	if ($q->param('delete')) {

		if ($q->param('error')){&loadUpdateForm($wrongparam); return}
		unless (defined $q->param('SelectRow')) {
		   	  my $msg = "<FONT COLOR='#FF0000'><B>Nothing was selected</B></FONT>";
           	  &loadUpdateForm($msg);
			  return;
		}
		my $query = "SELECT * FROM $table";		
		my $where =$q->param('where');
		$query .= " WHERE $where" if $where;
		$query .= " ORDER BY $order" if $order;
		my $calldelete = {
			count => "$count", table => "$table", start => "$start", rows => "$rows", query => "$query", back => $back
		};
		$query = "DELETE ".$q->param('delete_option1')." FROM  $table WHERE ";
		$query .= getdeletequery($calldelete);

	    if ($q->param('preview')) {
		   printpreview([$query]);
    	}

		else {
			my $unregmes = unrgversion();
			bail_out ($unregmes, $back);
		}
    	return;	
	
	}

#update


	if ($q->param('error')){&loadUpdateForm($wrongparam); return}

	my @fields = $q->param('fields');
	my $fields = join (', ', @fields);
	if (@fields == 0) {$fields = '*'}
	my $query = '';
	$query = "SELECT * FROM $table";		
	$query .= " WHERE $where" if $where;
	$query .= " ORDER BY $order" if $order;
	$query .= " LIMIT $start, $rows"			if ($start and $rows);
	$query .= " LIMIT $rows" 					if (!$start and $rows);
	$query .= " LIMIT $start, ".($count-$start)	if ($start and !$rows);

	my ($sth, $res) = prepare_execute($query, $back);
	
	my $primary = $sth->{mysql_is_pri_key};
	for (my $i=0; $i<@$primary; $i++){
		if ($primary->[$i]){push @priNum, $i; push @pri, $sth->{NAME}[$i]}
	}
	

#---selected---------
	my $i = 0;		#Rows
	my $j;			#Columns
	my $k = 0;
	my @queries; 
  	if (@pri == 0){
       @pri = @{$sth->{NAME}};
       @priNum = (0..(scalar(@pri)-1));
    }
    

#++++++++++++++++++++++++++++++++++++++
	while (@ary = $sth->fetchrow_array ()) {
		$query = "UPDATE ".$q->param('update_option1')." ".$q->param('update_option2')." $table SET ";
		my $ii = 0;
		for ($j=0; $j<@ary; $j++) {
			next unless(belongs(\@fields,${$sth->{NAME}}[$j]) or $fields eq '*');
			my $value = $q->param('n'.$i.'_'.$ii);
			$ii++;
#++++++++++++++++++++++++++++++++++++++
			if ($ary[$j] ne $value) {
				push @queryArray, ${$sth->{NAME}}[$j]." = ".$dbh->quote($value);
				$k=1;
			}
		}#for
		if ($queryArray[0]){
			my $data = $dbh->quote($ary[$priNum[0]]);
			my $where;
			if (uc($data) eq 'NULL'){$where = " WHERE $pri[0] IS NULL"}
			else {$where = " WHERE $pri[0] = $data"}
			my $jj;
			for ($jj = 1; $jj < @pri; $jj++) {
				my $data = $dbh->quote($ary[$priNum[$jj]]);
				if (uc($data) eq 'NULL'){$where .= " AND $pri[$jj] IS NULL"}
				else {$where .= " AND $pri[$jj] = $data"}
			}
			$query .= join(", ",@queryArray)." $where";
			push @queries, $query;
		}#if($query...
		else {$query = ''}
		$i++;
		@queryArray = ();
	}#while
	$sth->finish ();
	if ($k==0) {
		my $nochanges = "<FONT COLOR=\"#FF0000\"><b>Nothing was changed</b></FONT>";
		&loadUpdateForm($nochanges);	
	}
	#UPDATE
	elsif ($q->param('update')) {
#++++++++++++++++++++++++++++++++++++++
	
	    if ($q->param('preview')) {
			printpreview(\@queries);
    	}# end preview
		else {
			my $unregmes = unrgversion();
			bail_out ($unregmes, $back);
		}  
	}
	return;

} # END UPDATE

#++++++++++++++++++++++++++++++++++++++

sub execUpdateAfterPreview {
	my $res;
	my $msg;
	my @queries = $q->param('queries');
	my $i = 0;
	my $table = $q->param('tables');
	my $back = {
			dbname			=> "$database",
			tables			=> "$table",
			page			=> "tables",
			func			=> "UPDATE",
			updateStart		=> $q->param('updateStart')."",
			updateRows		=> $q->param('updateRows')."",
			updateWhere		=> $q->param('updateWhere')."",
			updateOrder		=> $q->param('updateOrder')."",
	};
	my $unregmes = unrgversion();
	bail_out ($unregmes, $back);
	return;
}
sub execAlterAfterPreview {
	my $table = $q->param('tables');
	my $dbname = $q->param('dbname');
	my $back = {
		page => 'tables',
		func => 'alter',
		dbname => "$dbname",
		tables => "$table"
	};
	my $msg;
	my @queries = $q->param('queries');
#++++++++++++++++++++++++++++++++++++++

	foreach $query (@queries) {
		next unless ($query =~ /\w/);
		$dbh->do($query) or bail_out("ALTER FAIL.\nQUERY:\n$query", $back);
	}
	if (@queries==0) {
			$msg = "<B><FONT COLOR='#FF0000'>No query was selected</FONT></B>" ;
	}

    	   &loadAlterTable($msg);	
	return;
}

sub logout {
	my @value = ('','','','');
	my $cookies = $q->cookie(-name=>'db_manager',
							 -value=>\@value,
							 -secure=>0);
	print 	$q->header(-cookie=>$cookies);
	&startpage();
	print <<IndexBody
<BR>

<FORM METHOD=POST ACTION="$full_url">
<INPUT TYPE=HIDDEN NAME="page" VALUE="connect">
<INPUT TYPE=HIDDEN NAME="login" VALUE="1">
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0>
    <TR HEIGHT=100>
     <TD WIDTH=20 HEIGHT=100>&nbsp;</TD>
     <TD WIDTH=150 HEIGHT=100>&nbsp;</TD>
        <TD WIDTH=120 HEIGHT=100>&nbsp;</TD>
        <TD WIDTH=201 HEIGHT=100>&nbsp;</TD>
    </TR>

    <TR>
     <TD WIDTH=20>&nbsp;</TD>
     <TD WIDTH=150>&nbsp;</TD>
        <TD WIDTH=120>USER</TD>
        <TD WIDTH=201>
            <INPUT  TYPE=TEXT NAME="user" VALUE="" SIZE=23 MAXLENGTH=23 TITLE='User name'>&nbsp;</TD>
    </TR>
    <TR>
     <TD WIDTH=20>&nbsp;</TD>
     <TD WIDTH=150>&nbsp;</TD>
        <TD WIDTH=120>PASSWORD</TD>
        <TD WIDTH=201><INPUT TYPE=PASSWORD NAME="password" VALUE="" SIZE=23 MAXLENGTH=23 TITLE='Password'>&nbsp;</TD>
    </TR>
    <TR>
     <TD WIDTH=20>&nbsp;</TD>
     <TD WIDTH=150>&nbsp;</TD>
        <TD WIDTH=120>DATABASE</TD>
        <TD WIDTH=201><INPUT TYPE=TEXT NAME="dbname" VALUE="" SIZE=23 TITLE='Database name'>&nbsp;</TD>
    </TR>
    <TR>
     <TD WIDTH=20>&nbsp;</TD>
     <TD WIDTH=150>&nbsp;</TD>
        <TD WIDTH=120>HOST:PORT</TD>
        <TD WIDTH=201><INPUT TYPE=TEXT NAME="host" VALUE="" SIZE=23 TITLE='Host name:Port number'>&nbsp;</TD>
    </TR>

    <TR>
     <TD WIDTH=20>&nbsp;</TD>
     <TD WIDTH=150>&nbsp;</TD>
        <TD WIDTH=120>&nbsp;</TD>
        <TD WIDTH=201>&nbsp;</TD>
    </TR>

    <TR>
     <TD WIDTH=20>&nbsp;</TD>
     <TD WIDTH=150>&nbsp;</TD>
        <TD WIDTH=120>&nbsp;</TD>
        <TD WIDTH=201>&nbsp;</TD>
    </TR>                        
    <TR>
     <TD WIDTH=20>&nbsp;</TD>
     <TD WIDTH=150>&nbsp;</TD>
        <TD WIDTH=120>&nbsp;</TD>
        <TD WIDTH=201><INPUT TYPE=SUBMIT VALUE=SUBMIT TITLE='Log in'></TD>
    </TR>                                                
    
</TABLE>
</FORM>

</TD></TR></TABLE>

</BODY>
</HTML>	
IndexBody
;
	

return;

}


sub printpreview {
# QUERIES_ref = $_[0];
# WAY BACK = $_[1];
	print $q->start_multipart_form(-action=>$full_url,
		  						   -method=>"POST");
	print <<EndPreviewHeader
<TABLE WIDTH=100% BORDER=0 CELLSPACING=0 CELLPADDING=0>
	   <TR><TH COLSPAN=2 ALIGN=LEFT>PREVIEW</TH></TR>
	   <TR><TD COLSPAN=2 HEIGHT=8></TD></TR>
EndPreviewHeader
;
 	my $queriesref = $_[0];
	foreach (@$queriesref) {
	
			$_ = quoteit($_);
			
			print <<EndPreviewHere
		  <TR>
		  	  <TD VALIGN=BOTTOM><B>Statement: </B><BR>
		<TEXTAREA NAME="queries" COLS=65 ROWS=4 WRAP=ON>$_</TEXTAREA></TD>
			<TD VALIGN=BOTTOM> &nbsp<!--  <INPUT TYPE=CHECKBOX NAME="ok" VALUE="ok">Ok? --> </TD>
		   </TR>
		   <TR>
			   <TD COLSPAN=2 HEIGHT=8></TD>
		  </TR>
EndPreviewHere
;
	}


	print qq!
		   <TR>
		   	   <TD HEIGHT=35 VALIGN=BOTTOM><INPUT TYPE=SUBMIT VALUE="Submit"></TD>
			   <TD HEIGHT=35 VALIGN=BOTTOM></TD>
		   </TR>
</TABLE>

<INPUT TYPE=HIDDEN NAME="dbname" VALUE="!, $q->param('dbname'), qq!">
<INPUT TYPE=HIDDEN NAME="tables" VALUE="!, $q->param('tables'), qq!">
!;
	unless ($_[1]){
		my $updateWhere = quoteit($q->param('where'));
		my $updateOrder = quoteit($q->param('order'));
		print qq!
<INPUT TYPE=HIDDEN NAME="page" VALUE="updateAfterPreview">
<INPUT TYPE=HIDDEN NAME="updateStart" VALUE="!, $q->param('start'), qq!">
<INPUT TYPE=HIDDEN NAME="updateRows" VALUE="!, $q->param('rows'), qq!">	
<INPUT TYPE=HIDDEN NAME="updateWhere" VALUE="$updateWhere">	
<INPUT TYPE=HIDDEN NAME="updateOrder" VALUE="$updateOrder">	
	!;}
	else {
		foreach (keys(%{$_[1]})){
			print $q->hidden(-name=>$_, -value=>$_[1]->{$_}, -override=>1),"\n";
		}
	}
	my $table = $q->param('tables');
	my @fields = $q->param('fields');
	foreach (@fields){
		print "<INPUT TYPE=HIDDEN NAME=\"fields\" VALUE=\"$_\">";
	}
	@fields = $q->param($table.'_fields');
	foreach (@fields){
		print "<INPUT TYPE=HIDDEN NAME=\"$table\_fields\" VALUE=\"$_\">";
	}
	print "\n</FORM>\n"
}

sub returntotab {
    print qq!\n<FORM METHOD=POST ACTION="$full_url">\n!;
	print $_[0];
    print qq!\n<INPUT TYPE=HIDDEN NAME='dbname' VALUE="$database">\n! if $database;
	print "<INPUT TYPE='HIDDEN' NAME='page' VALUE='select_db'>\n";
    print "<P><INPUT TYPE=SUBMIT NAME='return' VALUE='Return'>";
    print "</FORM>";
    return
}
sub loadRestore {
	my $databasesref = getdblist();
	my @databases; my $dberr;
	if ($DBI::err and (not defined $databasesref)){$dberr = 1}
	else {@databases = @$databasesref} 
	my $selectdbname_   = $q->param('selectdbname_');
	$selectdbname_  = $database unless $selectdbname_;
	my $userhost = myhost();
    my $userdir = "$USER_DIR$delim$user.$userhost$delim"."backup";
	my $back = {page => 'admin', func => 'restore', userhost => "$userhost"};
	$back->{dbname} = "$database" if $database;
	$back->{selectdbname_} = "$selectdbname_" if $selectdbname_;
	my @files = $q->param('selectfilelist');
	if ((@files == 1)and !$files[0]){@files = ()}
	
	my $pageHead =  sub {
	print qq!
<FORM METHOD=POST ENCTYPE="multipart/form-data" ACTION="$full_url">
<TABLE BORDER=0 WIDTH=700 ID='BIG_TABLE'>
	<TR><TH ALIGN=LEFT>ADMINISTRATION -> RESTORE DATABASE$_[0] $_[1]</TH>
	</TR>
	<TR><TD>
!;
	return undef;
	};
	
	my $pageBottom = <<EndOfBottom
		</TD>
	</TR>
</TABLE><!-- END OF BIG TABLE -->
<INPUT TYPE=HIDDEN NAME='func' VALUE='restore'>
<INPUT TYPE=HIDDEN NAME='page' VALUE='admin'>
<INPUT TYPE=HIDDEN NAME='dbname' VALUE="$database">

</FORM>
EndOfBottom
;

	if ($q->param('delete') and !$q->param('cancel')){
		bail_out("File(s) not selected", $back) unless @files;
		my @filestodelete;
		foreach (@files){
			s/^(.*)\s\/\d*\/\s.*/$1/;
			push @filestodelete, $_;			
		}
		unless ($q->param('deleteconfirm')) {
			&$pageHead(" $selectdbname_", 'DELETE FILES');
			print "<BR><P TITLE='List of files to be deleted'><B>THESE FILES WILL BE DELETED:</B></P>\n";
			foreach (@filestodelete){
				$_ = quoteit($_);
				print qq!<INPUT TYPE=CHECKBOX NAME="selectfilelist" VALUE="$_" CHECKED TITLE='Uncheck to keep this file'> $_ <BR>\n!;
			}
			print "<BR><INPUT TYPE=SUBMIT NAME='deleteconfirm' VALUE='DELETE' TITLE='Delete selected files'>&nbsp;\n";
			print "<INPUT TYPE=SUBMIT NAME='cancel' VALUE='CANCEL' TITLE='Go back to previous page without deletion'>\n";
			print "<INPUT TYPE=HIDDEN NAME='delete' VALUE='1'>\n";
			print qq!<INPUT TYPE=HIDDEN NAME='selectdbname_' VALUE="$selectdbname_">\n!;
			print $pageBottom;
			return;			
		}
		else {
			foreach (@files){
				my $file = "$userdir/$_";
				unlink ($file) ||bail_out("Could not unlink $_ : $!", $back) ;
				
			}
		}
	}

	if ($q->param('downloadFile')){
		if (scalar @files > 1){
			bail_out("Too many files", $back);
		}
		elsif (!@files){
			bail_out("Please select a file.", $back);
		}
		
		$files[0] =~ s/^(.*)\s\/\d*\/\s.*/$1/;
		my $file = "$userdir$delim$files[0]";
		my @stat = stat $file;
		my $size = $stat[7];
		
		$file =~ /^.*\.([a-zA-Z]*)$/;
		my $ext = $1 ;
		my $mimetype = 'application/x-perl';

		$mimetype = 'application/x-gzip' if (($ext eq 'gz') or ($ext eq 'gzip'));
		$mimetype = 'application/zip' if ($ext eq 'zip');
		$| = 1; 
		$SIG{CHLD} = 'IGNORE';	
		open FH, $file or bail_out("$! $file", $back);
		flock(FH, 2) unless $WIN32;
		
		binmode FH;
        
        print "Content-disposition: inline; filename=$files[0]\n";
        print "Content-length: $size\n";
		print "Content-type: $mimetype; name=\"$files[0]\"\n\n";

		binmode STDOUT;
		
        my $data;
		while (read FH, $data, 1024) {
			print $data
		}
		flock(FH, 8) unless $WIN32 ;
		close FH;
		$dbh->disconnect if $connected;
		exit 0;
	}
	if ($q->param('upload')){
		my $back = {
			page			=> 'admin',
			func			=> 'restore',
			selectdbname_	=> "$selectdbname_",
			dbname			=> "$database",
			userhost		=> "$userhost"
		};
		
		if (my $sourse = $q->param('localfile')) {
			my $dest = $sourse;
			$dest =~ s/^(.*[\/|\\])*(.*)/$2/;
			my $dest_ = $dest;
			if ($dest =~ /^(.*)\.([a-zA-Z]*)$/){
				$dest_ =$1 if (($2 eq 'gz') or($2 eq 'gzip') or($2 eq 'zip'));
			}
			my $filexist = sub {
				if ($q->param('overwrite')){
					unlink $_[0]
				}
				else {
					close $sourse or bail_out("$!");
					bail_out("File $dest_ already exists",$back)
				}	
			};
			my $size_ = 0;
			if (-e "$userdir$delim$dest_") 
			{&$filexist("$userdir$delim$dest_"); $size_ = -s "$userdir$delim$dest_"}
			if (-e "$userdir/$dest_.gz")
			{&$filexist("$userdir$delim$dest_.gz"); $size_ = -s "$userdir$delim$dest_.gz"}
			if (-e "$userdir/$dest_.gzip")
			{&$filexist("$userdir$delim$dest_.gzip"); $size_ = -s "$userdir$delim$dest_.gzip"}
			if (-e "$userdir/$dest_.zip")
			{&$filexist("$userdir$delim$dest_.zip"); $size_ = -s "$userdir$delim$dest_.zip"}

    		if ($MAX_BACKUP_SIZE){
        		my $size = 0;
            	foreach (<$userdir/*>){
            		unless (-d){
            			my @stat = stat;
            			$size += $stat[7];
            		}
            	}
    			$size += (-s $sourse) - $size_;
            	if ($size > ($MAX_BACKUP_SIZE*1024)) {
        			my $errmsg = "Total size of backup files is limited to $MAX_BACKUP_SIZE kb.";
        			$errmsg .= "\nPlease delete some files before uploading.";			
        			bail_out("$errmsg",$back);
        		}
    		}

			$dest = "$userdir$delim$dest";
			
			open (DEST, ">$dest") || bail_out ("$! $dest_", $back);
			flock (DEST,2) unless $WIN32;
			if (-B $sourse) {binmode $sourse; binmode DEST;};
			
			my $data;
			while (read $sourse,$data,1024) {
				print DEST $data;
	    	}
			flock (DEST,8) unless $WIN32;
			close DEST;
			close $sourse or bail_out($!);
		}
		else {bail_out("Please select file to upload", $back)}
		
	}
	if ($q->param('compressFile')){
		my @files_;
		bail_out("File(s) not selected", $back) unless @files;
		foreach(@files){
			s/^(.*)\s\/\d*\/\s.*/$1/;
			my $file = "$userdir/".$_;
			my @stat = stat;
			my $size = $stat[7];
			/^.*\.([a-zA-Z]*)$/;
			my $ext = $1;
			bail_out("File $_ is already comressed", $back) if (($ext eq 'gz')or($ext eq 'zip'));
			push @files_,$file;
		}
		foreach (@files_){
    		if (($COMPRESS eq 'zip') and $ALLOW_ZIP){
				my $outfile = $_.'.zip';
    			if (system ("$ZIP $outfile $_ $ZIPLOG")){
    				bail_out("ZIP FAILED: $? $!", $back);
        		}
				unlink $_ if (-e and (-e $outfile)) || bail_out("Could not unlink the sourse $!", $back);    		
    		}
			elsif (($COMPRESS eq 'gzip') and $ALLOW_GZIP){
				if (system ("gzip -fq $_")){
					bail_out("GZIP FAILED: $? $!", $back);
				}
			}
			else {bail_out("\$COMPRESS Variable was not set up properly.", $back)}
		}

	} #COMPRESS
	if ($q->param('preview') or $q->param('runremote')){
	
		if (@files >1){bail_out "Too many files.", $back}
		if (@files == 0){bail_out "Please select a file", $back}
		my ($ext, $file, $ungzip, $unzip);
		$files[0] =~ s/^(.*)\s\/\d*\/\s.*/$1/;
		if ($files[0] =~ /^(.*)\.([a-zA-Z]*)$/){
		   $file = $1; $ext = $2
		}
		elsif ($files[0] =~ /^(.*)\.$/){
		   $file = $files[0]; $ext = '';
		}
		else {$file = $files[0]}
		my @all = <$userdir/*>;
		my $filename = "$userdir$delim$file";
		my $fullname = "$userdir$delim$files[0]";
		bail_out ("File $files[0] not found", $back) unless (-e $fullname);
		if ($ext =~ /^gz$/i){
			if (system ("gzip -fdv $fullname")) {bail_out("Failed to ungzip $fullname - $? . $! ", $back)} 
			$ungzip = 1;
		}
		elsif ($ext =~ /^zip$/i){
#check for available temp. file name	- 
			my $i="0E0";
			my $tempcopy;
			my $tempzip;
			do {
				$tempcopy = $userdir.$delim.'temcopy'.$i;
				$tempzip = $tempcopy.'.zip';
				$i++; bail_out("Overcycled! ($i)", $back) if ($i>999);
			}
			while ((-e "$tempzip") or (-e "$tempcopy\.gz") or (-e "$tempcopy"));

			copy("$fullname", "$tempzip") or bail_out("Cannot copy file $files[0] to tempcopy\.zip $!", $back);
			if (system ("gzip -df -S .zip $tempzip")) {
				unlink "$tempzip" if -e $tempzip;
				my $message = 
				"Failed to uncompress temporary file - $? . $! \n".
				"Be sure that ZIP archive contains only ONE compressed file";
				bail_out($message, $back);
			} 
			
			$unzip = 1;
			$filename = $tempcopy;
#			chmod 0777, "$filename";
		}
		else {$filename = $fullname}
# now the file of any format is prepared to read.	
		preview($filename,$file,$back, $pageHead) if $q->param('preview');
		
#runremote
		my $result = runremote($filename) if ($q->param('runremote'));
		
		if ($ungzip){
			if (system ("gzip -fq $filename")) {
				bail_out("Failed to gzip $file. $? . $! ", $back)
			} 
		}
		if ($unzip){
			unlink $filename if (-e $filename);
		}
		
		bail_out($result, $back) if $result;
		
		if ($q->param('preview')){print "
<INPUT TYPE=SUBMIT NAME='runremote' VALUE='APPLY TO SELECTED DATABASE' TITLE='Apply this file to database &quot;$selectdbname_&quot;'>
&nbsp;<INPUT TYPE=SUBMIT NAME='back' VALUE='BACK' TITLE='Go back to previous page'>
<INPUT TYPE=HIDDEN NAME='selectdbname_' VALUE='".$q->param('selectdbname_')."'>
<INPUT TYPE=HIDDEN NAME='selectfilelist' VALUE='".quoteit($q->param('selectfilelist'))."'>

"
	   ;
		print $pageBottom;
		return;
		}
		

	}
	push @databases,'' unless $q->param('selectdbname_');
	my $back_ = $back;
	undef $back_->{selectdbname_};
	my $tablelistref = getTablelist($selectdbname_,$back) if $q->param('selectdbname_');
	my $selectDBlist;
	
	$selectDBlist = $q->scrolling_list(
                		-name=>'selectdbname_',
                		-values=>[@databases],
                		-default=>[$database],
                		-size=>1,
						-onChange=>'this.form.submit()',
						-title=>'Databases available on this server'
					);
	if ($dberr) {
		$selectDBlist = $q->scrolling_list(
                		-name=>'selectdbname_',
                		-values=>[''],
                		-default=>[''],
                		-size=>1,
						-title=>'Databases available on this server',
						-labels=>{''=>'ACCESS DENIED'}
					);
	}
	my $tablelist = join ('<BR>', @$tablelistref) if ref $tablelistref;
    unless ((-e $userdir) and (-d $userdir)) {
		mkdir $userdir, 0777 or bail_out("Cannot create directory. $!", {page => 'connect'})
	}
	my $tsize;
	@files = ();
	foreach (<$userdir/*>){
		unless (-d){
			my @stat = stat;
			my $size = $stat[7];
			$tsize += $size;
			my $date = scalar localtime ($stat[9]);
			$date =~ s/^\s*\w\w\w\s*(.*)/$1/;
			s/^(.*\/)*(.*)$/$2/;
			$_ .= " /$size/ $date";
			push @files, $_;
		}
	}
	$tsize = int($tsize / 1024 * 100) / 100;
	
	my $selectfilelist = "\n<SELECT NAME='selectfilelist' SIZE=8 MULTIPLE  TITLE='Select file'>\n";
	if (@files == 0){$selectfilelist .=  "\t<OPTION VALUE=\"\">FILE LIST IS EMPTY"}
	else{foreach (@files) {$_ = quoteit($_); $selectfilelist .= "\t<OPTION VALUE=\"$_\">$_\n"} }
	$selectfilelist .= "<SELECT>\n";
	
	print "\n<!-- Admin (Restore)procedure starts here -->\n\n";

	&$pageHead(" $selectdbname_");
	my $max_size = "Max.&nbsp;allowed&nbsp;size $MAX_BACKUP_SIZE&nbsp;kb" if $MAX_BACKUP_SIZE;
	my $compress_button = "<INPUT TYPE=SUBMIT NAME='compressFile' VALUE='COMPRESS' TITLE='Compress selected file'>" if ($ALLOW_GZIP or $ALLOW_ZIP);
	print <<ENDOFRESTORE
	
	
			<INPUT TYPE=SUBMIT VALUE='RELOAD' TITLE='Update page'>
	
<TABLE WIDTH=100% BORDER=0 ID='FRAMES' CELLPADDING=4 >
	<TR VALIGN=TOP>
		<TD VALIGN=TOP>


<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' WIDTH=100% >
			<TR>
				<TD width=100%><!-- BORDER START -->

<TABLE WIDTH=100% BORDER=0 ID='FUNC_TABLE3' CELLPADDING=4 CELLSPACING=0 BGCOLOR='#AAAAAA'>
	<TR>
		<TD BGCOLOR='#CCCCCC' TITLE='Databases available on the server'>APPLY&nbsp;TO&nbsp;DATABASE:<BR>
$selectDBlist&nbsp;<INPUT TYPE=SUBMIT VALUE='<-' TITLE='Show tables in selected database'>
		</TD>
	</TR>
	<TR>
		<TD BGCOLOR='#CCCCCC' TITLE='Tables in selected database'><U>TABLE LIST:</U><BR>
$tablelist
		</TD>
	</TR>

</TABLE>
				
				</TD><!-- BORDER END -->
			</TR>
</TABLE>
		
		
		</TD><TD VALIGN=TOP><!-- END OF FIRST COLUMN -->
		
		
		
		
<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' WIDTH=100% >
			<TR>
				<TD width=100%><!-- BORDER START -->

<TABLE WIDTH=100% BORDER=0 ID='REMOTE_LOCATION' CELLPADDING=4 CELLSPACING=0 BGCOLOR='#AAAAAA'>
	<TR>
		<TD BGCOLOR='#CCCCCC'>
			<NOBR>
			<INPUT TYPE=SUBMIT NAME='runremote' VALUE='       RUN SCRIPT       ' TITLE='Apply selected file to database &quot;$selectdbname_&quot;'>
			<INPUT TYPE=SUBMIT NAME='preview' VALUE='PREVIEW HEADER' TITLE='Preview header of selected file'></NOBR><BR>
<I>Run plain text, .zip and .gz files only</I>
		</TD>
	</TR>
	<TR>
		<TD BGCOLOR='#CCCCCC'>
		<TABLE BORDER=0>
			<TR>
				<TD VALIGN=TOP TITLE='Select file'><P>
$selectfilelist</TD>
				<TD VALIGN=TOP><P>Total size:<BR>$tsize kb<P>
				$max_size</TD>				
			</TR>
		</TABLE>
		</TD>
	</TR>
	<TR>
		<TD BGCOLOR='#CCCCCC'>
<INPUT TYPE=SUBMIT NAME='delete' VALUE='DELETE' TITLE='DELETE SELECTED FILE'>
<INPUT TYPE=SUBMIT NAME='downloadFile' VALUE='DOWNLOAD' TITLE='Download selected file'>
$compress_button
		</TD>
	</TR>
</TABLE>
				
				</TD><!-- BORDER END -->
			</TR>
</TABLE>	<BR>	
<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' width=100%>
			<TR>
				<TD width=100%><!-- BORDER START -->

<TABLE WIDTH=100% BORDER=0 ID='FUNC_TABLE3' CELLPADDING=4 CELLSPACING=0 BGCOLOR='#AAAAAA'>
	<TR>
		<TD BGCOLOR='#CCCCCC'>
		<INPUT TYPE=FILE NAME='localfile' TITLE='Select file to upload'>
		<INPUT TYPE=SUBMIT NAME='upload' VALUE='UPLOAD FILE' TITLE='Upload file'>
		<BR><INPUT TYPE=CHECKBOX NAME='overwrite' TITLE='Overwrite existing file'>Overwrite if exists.</TD>
	</TR>

</TABLE></TD><!-- BORDER END -->
			</TR>
</TABLE><BR>


		</TD>
	</TR>
</TABLE><!-- END OF FRAME TABLE -->


		</TD>
	</TR>
	<TR>
		<TD>&nbsp;
$pageBottom		


<!-- Admin (Restore) procedure ends here -->

		
ENDOFRESTORE
;
}
sub loadAdmin {
	my $databasesref = getdblist();
	my @databases;
	my $selectdbname_   = $q->param('selectdbname_');
	$selectdbname_  = $database unless $selectdbname_;
	my $DBlist; my $selectDBlist;
	if ($DBI::err and !$database){
		$DBlist = $q->scrolling_list(
                		-name		=>'dbname_',
                		-values		=>[''],
                		-size		=>1,
						-labels		=>{'' => 'ACCESS DENIED'},
						-title		=> 'Select database to use with TABLE STATUS option'
					);
		$selectDBlist = $q->scrolling_list(
                		-name   =>'selectdbname_',
 						-labels	=>{'' => 'ACCESS DENIED'},
               			-values =>[''],
                		-size   =>1,
					);
	}
	else {
		@databases = @$databasesref;
		$DBlist = $q->scrolling_list(
                		-name		=>'dbname_',
                		-values		=>[@databases,''],
                		-default	=>[$database],
                		-size		=>1,
						-title		=> 'Select database to use with TABLE STATUS option'
					);
					
		push @databases,'' unless $selectdbname_;					
		$selectDBlist = $q->scrolling_list(
                		-default=>[$database],
                		-name=>'selectdbname_',
                		-values=>[@databases],
                		-size=>1,
						-onChange=>'this.form.submit()'
					);
	}
	my $tablelist = "\n<SELECT NAME='tablelist' SIZE=13 MULTIPLE>\n";
	my $tablelistref;
	if ($selectdbname_) {
		my $query 				= "SHOW TABLES FROM $selectdbname_";
		unless ($tablelistref = $dbh->selectcol_arrayref("SHOW TABLES FROM $selectdbname_")) {
			my $back;
			my $msg = "Failed to execute:\n$query";
			if ($DBI::err == 1044) {
				$back = {page => 'admin'};
				$back->{dbname} = $database if $database;
				$msg = "CANNOT SHOW TABLES!";
			}
			else {$back = {page => 'connect'}}
			bail_out($msg, $back);
		}
		unless ((defined $tablelistref) and (@$tablelistref > 0)){
			$tablelist .= "<OPTION VALUE=''>Table list is empty\n";
		}
		else{
			my @tblist = $q->param('tablelist');
			foreach (@$tablelistref){
				my $selected = 'SELECTED' if belongs(\@tblist, $_);
				$tablelist .= "<OPTION VALUE=\"$_\" $selected>$_"
			}
		}
	}
	else {
		$tablelist .= "<OPTION VALUE=''>SELECT DATABASE\n";
	}
	$tablelist .= "</SELECT>\n";
	my ($users, $labels) = getuserlist();
	unshift @$users, ''; $labels->{''} = '';
	my $userlist	 = $q->scrolling_list(
		   		  	 			   		-name		=> 'username',
										-value		=> $users,
										-labels		=> $labels,
										-size		=> 1,
										-default	=> '',
										-title		=> 'Select user\@hostname to use with GRANTS option'
								);
	
	
#--suggest file name---------------------
	my ($remotefile, $suggest, $remfileurl);
    my $back					= {page => 'connect'};
	my $userhost				= myhost();
	my $userdir					= "$USER_DIR$delim$user.$userhost";
    unless ((-e $userdir) and (-d $userdir)) {mkdir $userdir, 0777 || bail_out("Cannot create directory. $!", $back)}
	unless ((-e $userdir) and (-d $userdir)){bail_out("Cannot create directory user.host. $!", $back)}
	$userdir 					= "$USER_DIR$delim$user.$userhost$delim"."backup";
    unless ((-e $userdir) and (-d $userdir)) {mkdir $userdir, 0777 || bail_out("Cannot create directory user.host/backup. $!", $back)}
	unless ((-e $userdir) and (-d $userdir)){bail_out("Cannot create directory user.host/backup. $!", $back)}
    $back						= {page => "admin"};
    $back->{dbname}				= "$database" if $database;
    $back->{selectdbname_}		= "$selectdbname_" if $selectdbname_;
	
	
	if (($q->param('func') =~ /suggest/i) ) {
		bail_out("Select a database first") unless ($selectdbname_);
		my @files = <$userdir/*>;
		
		my $n = 0;
		for (0..$#files){
			$files[$_] =~ s/^(.*\/)*(.*)$/$2/;
			if ($files[$_] =~ /^(.+)(\.[a-zA-Z]*)$/){$files[$_] = $1};
					
					
		}
		$remotefile = "$user.$userhost.$selectdbname_.0";		
		for (0..$#files){
			if (belongs(\@files, $remotefile)){
				$n++;
				$remotefile = "$user.$userhost.$selectdbname_.$n";
			}
		}
	}
	if ($selectdbname_){
	   $suggest = "<INPUT TYPE=SUBMIT NAME='func' VALUE='Suggestion' TITLE='Ask the program to propose an appropriate name for backup file'>";
	}
	my $gzipchecked = 'CHECKED' if (($q->param('type') eq 'gzip') or  !$q->param('type'));
	my $zipchecked = 'CHECKED' if ($q->param('type') eq 'zip');
	
	my $zipselect = "<INPUT TYPE=RADIO NAME='type' VALUE='zip' $zipchecked TITLE='Select to create compressed backup file (ZIP format)'><I>zip</I>" if $ALLOW_ZIP;
	my $targzselect = "<INPUT TYPE=RADIO NAME='type' VALUE='gzip' $gzipchecked TITLE='Select to create compressed backup file (GZIP format)'><I>gzip</I>" if $ALLOW_GZIP;
	my $textchecked = 'CHECKED' if ((!$ALLOW_GZIP and !$q->param('type')) or ($q->param('type') eq 'text'));

	my $downloadcheck = 'CHECKED' if $q->param('downloadBackup');
	my $keepcheck = 'CHECKED' if ($q->param('keep') or (!$q->param('downloadBackup') and !$q->param('keep')));
	my $dropcheck = 'CHECKED' if $q->param('dropifexists');
	my $selectallcheck = 'CHECKED' if $q->param('selectalltables');
	my ($bothcheck, $structurecheck, $datacheck);
	if ($q->param('include') eq 'structure'){$structurecheck = 'CHECKED'}
	elsif ($q->param('include') eq 'data'){$datacheck  = 'CHECKED'}
	else {$bothcheck = 'CHECKED'}
	
	print <<ENDOFADMIN	
<!-- Admin procedure starts here -->

<FORM METHOD=POST ACTION="$full_url">
<TABLE BORDER=0 WIDTH=700 ID='BIG_TABLE'>
	<TR><TH ALIGN=LEFT>ADMINISTRATION</TH></TR>
	<TR><TD>
	
<TABLE WIDTH=100% BORDER=0 ID='FRAMES'>
	<TR VALIGN=TOP>
		<TD VALIGN=TOP>

<!-- COLUMN 1 START -->
<!-- ACCESS CONTROL	-->
<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' >
			<TR>
				<TD WIDTH=100%><!-- BORDER START -->
	<TABLE BORDER=0 CELLPADDING=4 CELLSPACING=0 BGCOLOR='#AAAAAA' WIDTH=200>
		<TR>
			<TD BGCOLOR='#CCCCCC'><INPUT TYPE=SUBMIT NAME='func' VALUE='ACCESS CONTROL'></TD>
		</TR>
	</TABLE>
				</TD><!-- BORDER END -->
			</TR>
</TABLE>
		
		

<BR>	


<!-- -------------------- SHOW--------------- -->

<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' >
			<TR>
				<TD width=100%><!-- BORDER START -->

<TABLE WIDTH=200 BORDER=0 ID='FUNC_TABLE1'CELLPADDING=3 CELLSPACING=0 BGCOLOR='#AAAAAA'>
	<TR>
		<TD BGCOLOR='#CCCCCC' TITLE='Show selected option'>
		<INPUT TYPE=SUBMIT NAME='func' VALUE='   SHOW   ' TITLE='Show selected option'></TD></TR>
	<TR BGCOLOR='#CCCCCC'>
		<TD BGCOLOR='#CCCCCC' HEIGHT=20 VALIGN=TOP TITLE='Select option to show'>
<SELECT NAME='show'>
<OPTION VALUE=''>
<OPTION VALUE='STATUS'>STATUS
<OPTION VALUE='VARIABLES'>VARIABLES
<OPTION VALUE='PROCESSLIST'>PROCESSLIST
<OPTION VALUE='GRANTS'>GRANTS
<OPTION VALUE='TABLE STATUS'>TABLE STATUS
</SELECT><BR></TD>
	</TR>
	<TR>
		<TD BGCOLOR='#CCCCCC'>[LIKE] <BR><INPUT TYPE=TEXT NAME='LIKE' SIZE=10 TITLE='Specify pattern to show result'></TD>
	</TR>
	<TR>
		<TD BGCOLOR='#CCCCCC' TITLE='Select database to use with TABLE STATUS option'>[FROM DATABASE]<BR>
$DBlist
	   </TD>
	</TR>
	<TR>
		<TD BGCOLOR='#CCCCCC' TITLE='Select user\@hostname to use with GRANTS option'>FOR USER<BR>
$userlist
		<BR></TD>
	</TR>

</TABLE>


				</TD><!-- BORDER END -->
			</TR>
</TABLE><BR>
<!-- FLUSH -->
<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' >
			<TR>
				<TD width=100%><!-- BORDER START -->
				
<TABLE BORDER=0 BGCOLOR='#AAAAAA' CELLSPACING=0 CELLPADDING=3 WIDTH=200 >
    <TR VALIGN=TOP>
        <TD BGCOLOR='#CCCCCC' HEIGHT=25 TITLE='Select option to flush' VALIGN=TOP>
		<INPUT TYPE=SUBMIT NAME="func" VALUE="   FLUSH   " TITLE='Flush selected option'><BR></TD>
		<TD HEIGHT=15  BGCOLOR='#CCCCCC'  TITLE='Select option to flush'>
		<SELECT NAME="flush" TITLE='Select option to flush'>
			<OPTION VALUE='' SELECTED>
			<OPTION VALUE='HOSTS'>HOSTS
			<OPTION VALUE='LOGS'>LOGS
			<OPTION VALUE='PRIVILEGES'>PRIVILEGES
			<OPTION VALUE='TABLES'>TABLES
<!-- 		<OPTION VALUE='TABLES WITH READ LOCK'>TABLES WITH READ LOCK -->
			<OPTION VALUE='STATUS'>STATUS
		</SELECT></TD>
	</TR>
<!-- <TR HEIGHT=35  HEIGHT=15  BGCOLOR='#CCCCCC'  ><TD HEIGHT=15  BGCOLOR='#CCCCCC'  VALIGN=TOP>&nbsp;</TD></TR> -->
</TABLE>

				</TD><!-- BORDER END -->
			</TR>
</TABLE>



			<!-- COLUMN 1 END -->
			</TD><TD VALIGN=TOP><P>
			
	
	
<!-- COLUMN 2 START -->

<!-- ANALYZE, CHECK, REPAIR -->
<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' >
			<TR>
				<TD WIDTH=100%><!-- BORDER START -->
<TABLE WIDTH=255 BORDER=0 ID='FUNC_TABLE3' CELLPADDING=4 CELLSPACING=0 BGCOLOR='#AAAAAA'>
	<TR>
		<TD BGCOLOR='#CCCCCC'><INPUT TYPE=SUBMIT NAME='func' VALUE='OPTIMIZE' TITLE='Optimize selected tables'></TD>

		<TD BGCOLOR='#CCCCCC' WIDTH=20>&nbsp;</TD>

		<TD BGCOLOR='#CCCCCC'><INPUT TYPE=SUBMIT NAME='func' VALUE=' CHECK ' TITLE='Check selected tables'></TD>
	</TR>
	<TR>
		<TD BGCOLOR='#CCCCCC'><INPUT TYPE=SUBMIT NAME='func' VALUE='ANALYZE ' TITLE='Analyze selected tables'></TD>

		<TD BGCOLOR='#CCCCCC' WIDTH=20>&nbsp;</TD>

		<TD BGCOLOR='#CCCCCC'><INPUT TYPE=SUBMIT NAME='func' VALUE=' REPAIR ' TITLE='Repair selected tables'></TD>
	</TR>
</TABLE>
				</TD><!-- BORDER END -->
			</TR>
</TABLE><BR>

<!-- ----------BACKUP----------- -->



<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' >
			<TR>
				<TD width=100%><!-- BORDER START -->
				
<TABLE WIDTH=255 BORDER=0 ID='FUNC_TABLE2' CELLPADDING=3 CELLSPACING=0 BGCOLOR='#AAAAAA' >
	<TR><TD BGCOLOR='#CCCCCC'><INPUT TYPE=CHECKBOX NAME='downloadBackup' $downloadcheck TITLE='Download created backup file'>&nbsp;Download&nbsp;
			<INPUT TYPE=CHECKBOX NAME='keep' $keepcheck TITLE='Save created backup file on the server'>&nbsp;Save</TD>
	</TR>
	<TR>
		<TD BGCOLOR='#CCCCCC'><INPUT TYPE=CHECKBOX NAME='dropifexists' $dropcheck TITLE='Include SQL query "DROP TABLE IF EXISTS tablename" for each table into backup '>&nbsp;Add&nbsp;'DROP&nbsp;TABLE'</TD>
	</TR>
	<TR>
		<TD BGCOLOR='#CCCCCC'>Include:&nbsp<INPUT TYPE=RADIO NAME='include' VALUE='structure' $structurecheck TITLE='Include only "CREATE TABLE..." SQL query into backup'
		><I>Structure</I><INPUT TYPE=RADIO NAME='include' VALUE='data' $datacheck TITLE='Include only "INSERT INTO TABLE..." SQL query into backup'
		><I>Data</I><INPUT TYPE=RADIO NAME='include' VALUE='both' $bothcheck TITLE='Include both "CREATE TABLE..." and "INSERT INTO TABLE ... " SQL queries into backup'><I>Both</I></TD>
	</TR>
	<TR>
		<TD BGCOLOR='#CCCCCC'>Output&nbsp;file:&nbsp;$suggest<BR>
		<INPUT TYPE=TEXT NAME='remotefile' VALUE="$remotefile" SIZE=24 TITLE='Type name for backup file'></TD>
	</TR>
	<TR>
		<TD BGCOLOR='#CCCCCC'>Type:&nbsp;$zipselect&nbsp;$targzselect&nbsp;<INPUT TYPE=RADIO NAME='type' VALUE='text' $textchecked TITLE='Select to create plain text backup file'><I>text</I>&nbsp;</TD>
	</TR>
	<TR>
		<TD BGCOLOR='#CCCCCC' ><INPUT TYPE=SUBMIT NAME='func' VALUE='CREATE BACKUP FILE' style='width: 200px' TITLE='Create backup file'></TD>
	</TR>
</TABLE>


<TABLE WIDTH=255 BORDER=0 ID='FUNC_TABLE3' CELLPADDING=4 CELLSPACING=0 BGCOLOR='#AAAAAA'>
	<TR>
		<TD BGCOLOR='#CCCCCC'><INPUT TYPE=SUBMIT NAME='func' VALUE='        SELECT FILE       ' style='width: 200px' TITLE='Backup file manager'></TD>

		
	</TR>
</TABLE>
				</TD><!-- BORDER END -->
			</TR>
</TABLE><BR>
<!-- COLUMN 2 END -->
	
		</TD><TD VALIGN=TOP>
	

<!-- -----select database, select tables-------- -->

<!-- COLUMN 3 START -->

<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' >
			<TR>
				<TD width=100%><!-- BORDER START -->

<TABLE WIDTH=200 BORDER=0 ID='FUNC_TABLE3' CELLPADDING=4 CELLSPACING=0 BGCOLOR='#AAAAAA'>
	<TR>
		<TD BGCOLOR='#CCCCCC' TITLE='Databases available on this server'>SELECT DATABASE:<BR>
$selectDBlist&nbsp;<INPUT TYPE=SUBMIT VALUE='<-' TITLE='Show tables in selected database'>
		</TD>
	</TR>
	<TR>
		<TD BGCOLOR='#CCCCCC' TITLE='Select tables to use with Check, Repair, Analyze, Optimize or Backup functions'>SELECT TABLE:<BR>
$tablelist
		</TD>
	</TR>
	<TR>
		<TD BGCOLOR='#CCCCCC' TITLE='Select all tables'><INPUT TYPE=CHECKBOX NAME='selectalltables' $selectallcheck TITLE='Select all tables'> SELECT ALL TABLES</TD>
	</TR>
</TABLE>
				
				</TD><!-- BORDER END -->
			</TR>
</TABLE>

<!-- COLUMN 3 END -->
</TD></TR></TABLE><!-- END OF FRAME TABLE -->


		</TD>
	</TR>
	<TR>
		<TD>&nbsp;</TD>
	</TR>
</TABLE><!-- END OF BIG TABLE -->

<INPUT TYPE=HIDDEN NAME='page' VALUE='admin'>
<INPUT TYPE=HIDDEN NAME='dbname' VALUE="$database">
</FORM>


<!-- Admin procedure ends here -->
	
ENDOFADMIN
;
}
sub execBackup {

	my $ERRMSG = <<EndERRMSG
THE FOLLOWING MUST BE SELECTED:

DATABASE,
TABLES,
BACKUP FILE DESTINATION (save and/or download),
BACKUP FILE TYPE (zip, gzip, plain text),
BACKUP FILE NAME
EndERRMSG
;
	
	my $dbname				= $q->param('selectdbname_');
	my $back				= {page => "admin"};
	$back->{dbname}			= "$database" if $database;
	$back->{selectdbname_}	= "$dbname" if $dbname;
	bail_out($ERRMSG,$back) unless $dbname;
	my $DOWNLOAD			= $q->param('downloadBackup');
	my $KEEPFILE			= $q->param('keep');
	bail_out($ERRMSG,$back) unless ($KEEPFILE or $DOWNLOAD);
	my $fyletype			= $q->param('type');
	bail_out($ERRMSG,$back) unless $fyletype;	
	my $filename			= $q->param('remotefile');
	bail_out($ERRMSG,$back) unless $filename;	
	unless ($dbh->do("USE $dbname")){bail_out("Can not use $dbname", {page => 'connect'})}
	if (($filename =~ /[\\\/]/g) or ($filename =~ /[\/]/g)){
		bail_out("File name is incorrect", $back)
	}
    my $userhost = myhost();
    my $userdir = "$USER_DIR$delim$user.$userhost$delim"."backup";
	my $file = "$userdir$delim$filename";
	bail_out ("File $filename already exists.", $back) if (-e $file);
	bail_out ("File $filename already exists.", $back) if (-e $file.'.gz');
	bail_out ("File $filename already exists.", $back) if (-e $file.'.zip');
	
		
	my $tablelistref;
	my @tablelist;
	if ($q->param('selectalltables')) {
	   my $query = "SHOW TABLES";
	   $tablelistref = $dbh->selectcol_arrayref($query) || bail_out("Cannot SHOW TABLE", $back);
	   @tablelist = @$tablelistref;
	}
	else {@tablelist = $q->param('tablelist'); $tablelistref = \@tablelist}
	bail_out ($ERRMSG,$back) unless scalar @tablelist;
	my $dropifexists = $q->param('dropifexists');
	my $include = $q->param('include');
	my $filecontent = "#\tDATABASE '$dbname' \n";
	$filecontent .= "#\tUser: $user\@$userhost\n#\n";
	$filecontent .= "#\tServer Version: ".get_version()."\n";
	$filecontent .= "#\n";
	$filecontent .= "#\tBACKUP CREATED ". scalar gmtime()." (GMT)\n";
	$filecontent .= "#\tby MYSQL DATA MANAGER (Unregistered Version)\n";
	$filecontent .= "#\tPlease visit http://www.edatanew.com/order to register\n";
	$filecontent .= "#\tand download the latest release of the program\n";
	$filecontent .= "#\n";
	$filecontent .= "#\t----------------------------------------------------\n#\n";
	$filecontent .= "#\tOPTIONS:\n";
	$filecontent .= "#\t- \"DROP TABLE IF EXISTS\" added\n" if ($dropifexists and ($include ne 'data'));
	$filecontent .= "#\t- Only tables structure included\n" if ($include eq 'structure') ;
	$filecontent .= "#\t- Only data included\n" if ($include eq 'data');
	$filecontent .= "#\t----------------------------------------------------\n";
# get table list
	
	$filecontent .= "#\n#\tTABLE LIST:\t\t\n#\t".join("\n#\t", @tablelist);
	$filecontent .= "\n#\n#\n#EndOfHeader\n\n";
	my $hashref	 = {
		tablelist 		=> \@tablelist,
		include			=> $include,
		dropifexists	=> $dropifexists,
		back			=> $back,
		comments		=> 1,
		lock			=> 1
	};
	$filecontent .= getdatanstructure($hashref);
	
	open (FH, "+> $file") || bail_out ("Can not open $file $!", $back);
	#binmode FH;
	flock(FH, 2) unless $WIN32;
	print FH $filecontent;
	flock(FH, 8) unless $WIN32;
	close FH;
	undef $filecontent;
	#chmod 0777, "$file";
	my ($outfile, $outfilename, $mimetype);
	my $i=0;
	if ($q->param('type') eq 'zip'){
		$outfile = $file.'.zip';
		$mimetype = 'application/zip';
		if (system ("$ZIP $outfile $file $ZIPLOG")){
			unlink $file if (-e $file);
			bail_out("$? zip $!", $back);
    	}
		
		$outfilename = $filename.'.zip';

    }
	elsif ($q->param('type') eq 'gzip'){
	my $i=0;
		if (system ("gzip -fq $file")){
			unlink "$file" if (-e $file);
			bail_out("$? $! gzip ");
		}
		$outfile = $file.'.gz';
		$outfilename = $filename.'.gz';
		$mimetype = 'application/x-gzip';
	}
	else {
		$mimetype = 'application/x-perl';
		$outfile = $file;
		$outfilename = $filename;
	}
#	chmod 0777, "$outfile";
	unless ($q->param('type') eq 'text') {
		if (-e $file){unlink $file || bail_out("Cannot unlink $file $!", $back)}
	}	
	if ($q->param('keep') and $MAX_BACKUP_SIZE){
		my $size = 0;
        foreach (<$userdir/*>){
        	unless (-d){
        		my @stat = stat;
        		$size += $stat[7];
        	}
        }#foreach
        if ($size > ($MAX_BACKUP_SIZE*1024)) {
    		my $errmsg = "Total size of backup files is limited to $MAX_BACKUP_SIZE kb.\n";
    		$errmsg .= "New backup file can only be downloaded.\n";
    		$errmsg .= "Please delete some files if you neen to keep new backup file on the server.\n";			
    		unlink $outfile || bail_out("Cannot unlink $outfilename $! \n$errmsg", $back);
    		print "SIZE: $size<BR>";
    		bail_out("$errmsg",$back);
    	}
	}#if keep

	if ($q->param('downloadBackup')){
		$| = 1; 
		$SIG{CHLD}  = 'IGNORE';	
	

		my $size = -s "$outfile" or bail_out("$! $outfile", $back);
    	open FHN, $outfile or bail_out("$! $outfile", $back);
		flock (FHN,2) unless $WIN32;
    	binmode FHN;
    	
    	print "Content-disposition: inline; filename=$outfilename\n";
    	print "Content-length: $size\n";
		print "Content-type: $mimetype; name=\"$outfilename\"\n\n";

		binmode STDOUT;
    	my $data;
    	while (read FHN, $data, 1024) {
    		print $data
    	}
		flock (FHN,8) unless $WIN32;
    	close FHN;
	
		unless ($q->param('keep')) {unlink $outfile || bail_out("Cannot unlink $outfile $!", $back)}
		$dbh->disconnect if $connected;
		exit 0;
	} # if download
	
}
sub execShow {
	my $show		= $q->param('show');
	my $back		= $_[0];
    my $errmsg;
	my $like		= $q->param('LIKE');
	my $username	= $q->param('username');
	my $db			= $q->param('dbname_');
    if ($show =~ /table\s*status/i) {
		$errmsg = 
		"Current version (".get_version().") of MYSQL SERVER does not support SHOW TABLE STATUS syntax."    
 		unless check_version('3.23.00');
	}
    elsif (($show eq 'STATUS') and  ($like ne '')) {
		$errmsg = 
		"Current version (".get_version().") of MYSQL SERVER does not support SHOW STATUS LIKE syntax."
 		unless check_version('3.23.00');
	}
    elsif ($show eq 'GRANTS') {
		$errmsg = 
		"Current version (".get_version().") of MYSQL SERVER does not support SHOW GRANTS syntax."
		unless check_version('3.23.4');
	}
#++++++++++++++++++++++++++++++++++++++
	bail_out($errmsg, $back) if $errmsg; 
	if ($show){
		my $username	= $q->param('username');
		my $db			= $q->param('dbname_');
		my $query = "SHOW ".$show;
		$query .= ' LIKE '.$dbh->quote($like) if ((($show eq 'STATUS') or ($show eq 'VARIABLES'))	and ($like ne ''));
		if ($show eq 'GRANTS'){
			bail_out("Please select a username", $back) unless ($username =~/@/);
			$username =~/^\s*('\S*')@('\S*')$/;
			if ($2 eq "''"){$username = "$1\@'\%'"}
			$query .= " FOR $username";
		}
		if ($show eq 'TABLE STATUS'){
			$query .= " FROM $db" if $db;
			$query .= ' LIKE '.$dbh->quote($like) if ($like ne '');
		}
		my ($sth,$res) = prepare_execute($query, $back);
		$query = quoteit($query);
		print "<P>Executed query: $query <BR>";
		
		print &printresult(\$sth);
		ErrMessage ("Print Result Error. $DBI::errstr") if $DBI::err;
		print qq!<FORM ACTION="$full_url" METHOD=POST>\n!;
		print "<P><INPUT TYPE=SUBMIT VALUE='Back'>\n";
		foreach (keys %$back){print qq!<INPUT TYPE=HIDDEN NAME="$_" VALUE="$back->{$_}">\n!}
		print "</FORM>";

									   
	}
	else  {loadAdmin()} 
}
sub execFlush {
	my $back = $_[0];
	if ($q->param('flush')) {
		my $query = "FLUSH ".$q->param('flush');
		unless ($dbh->do($query)){bail_out("Failed to Flush", $back)}
	}
#	else{bail_out("Can not Flush. Nothing was selected", $back)}
}

sub execCheckRepair {
	my $back = $_[0];
    my $func = $_[1];
	bail_out("Database is not selected.", $back) unless ($q->param('selectdbname_'));
	my @tablelist;
	if ($q->param('selectalltables')) {
		my $tablelistref = getTablelist($q->param('selectdbname_'));
		@tablelist = @$tablelistref;
	}
	else {@tablelist = $q->param('tablelist')}
	bail_out("Table list is not selected.", $back) unless (@tablelist and $tablelist[0]);
	
	
	my $errmsg = 
	"Current version (".get_version().") of MYSQL SERVER does not support $func TABLES syntax.";    
	if ($func eq 'ANALYZE'){
 		bail_out($errmsg,$back)	unless check_version('3.23.22')
	}
	elsif ($func eq 'CHECK'){
 		bail_out($errmsg,$back)	unless check_version('3.23.13')
	}
	elsif ($func eq 'REPAIR'){
   		bail_out($errmsg,$back)	unless check_version('3.23.14');
	}
	elsif ($func eq 'OPTIMIZE'){
   		bail_out($errmsg,$back)	unless check_version('3.22.7');
		bail_out("Too many tables selected for current version Mysql (".get_version().")") 
					  if (!check_version('3.23.00') and (@tablelist > 1));
	}
	unless ($q->param('selectdbname_')){loadAdmin(); return}
	unless ($q->param('selectdbname_') eq $database){
		my $query = "USE ".$q->param('selectdbname_');
		$dbh->do($query) || bail_out ("Cannot use secected database.", $back);
	}
	unless (@tablelist) {loadAdmin(); return}
	my $query = "$func TABLE ";
	$query .= join (', ', @tablelist);
	my ($sth, $res) = prepare_execute($query, $back);
	print "<P>Executed query:\n$query <BR>";
	if (belongs(\@selectlike,$func)){
	   print &printresult(\$sth);
	   ErrMessage ("Print Result Error. $DBI::errstr") if $DBI::err;
	}
	print qq!<FORM ACTION="$full_url" METHOD=POST>\n!;
	print "<P><INPUT TYPE=SUBMIT VALUE='Back'>\n";
	foreach (keys %$back){print qq!<INPUT TYPE=HIDDEN NAME="$_" VALUE="$back->{$_}">\n!}
	print "</FORM>";
}
sub preview {
		my ($filename, $file, $back, $pageHead) = @_;
		open (FH, "$filename") || bail_out("Can not open file$!", $back);
		flock (FH,2) unless $WIN32;
		&$pageHead(" ".$q->param('selectdbname_'));
		print "<BR><B>FILE HEADER PREVIEW (",quoteit($file),")</B><BR>\n";
		print "<TEXTAREA COLS=70 ROWS=15 TITLE='Header of selected file'>\n";
		
		my $data; my $i;
		while(<FH>){
			last unless ((/^#/) or ($i<12));
			$_ = quoteit($_);
			print;
			if ($i++ > 10000) {bail_out("OVERCYCLED!", $back)} 
		}
		print "</TEXTAREA><BR>\n";
		flock (FH,8) unless $WIN32;
		close FH;
}

sub runremote  {
	my ($filename) = shift;
	return ("Database is not selected") unless (my $selectdbname_ = $q->param('selectdbname_'));
	if ($WIN32) {
		$filename =~ s/\//\\/g;
	}
# Syntax:
# DBI:mysql:db_name:host_name:port,user,password
# DBI:mysql:db_name;host=host_name:port,user,password
# DBI:mysql:database=db_name;host_name:port,user,password
# DBI:mysql:database=db_name;host=host_name:port,user,password
# DBI:mysql:database=db_name;host=host_name;port=port,user,password
# DBI:mysql:database=db_name;param_name=param_value;host=host_name;port=port,user,password

# other parameters:
# mysql_compression=1
# mysql_read_default_file=file_name;
# mysql_read_default_group=group_name;
# mysql_socket=socket_name
# 
		

#-----port:
		my $back = {
			page => 'admin',
			func => 'restore'
		};
		$back->{selectdbname_}	= $q->param('selectdbname_') if $q->param('selectdbname_');
		$back->{dbname}			= $q->param('dbname')		 if $q->param('dbname');
		my $query 				= "SHOW VARIABLES LIKE 'port' ";
		my ($sth,$res) 			= prepare_execute($query,$back);
		my @row 				= $sth->fetchrow_array();
		$sth->finish;
		my $portnum 			= $row[1];
		my $hostname 			= myhost();

#connection parameters
		$hostname				= " -h $hostname"	if $hostname;
		$portnum				= " -P $portnum"	if $portnum;
		my $username 			= " -u $user"		if $user;
		my $ppassword 			= " -p$password"	if $password;
		my $options 			= $hostname 		if $hostname;
		$options 				.= $portnum 		if $portnum;
		$options 				.= $username 		if $username;
		$options 				.= $ppassword 		if $ppassword;
		$options 				.= " -S $SOCKET" 	if $SOCKET;
		$options 				.= " $OTHER_MYSQL" 	if $OTHER_MYSQL;
		my $command = "EXECUTED COMMAND:\n$MYSQL $options $selectdbname_ \< $filename";
	
#++++++++++++++++++++++++++++++++++++++

	CGI::Carp::carpout(\*STDOUT);
	if (system("$MYSQL $options $selectdbname_ \< $filename")){return ("\n$command\n")}
	return undef;

}

#++++++++++++++++++++++++++++++++++++++

sub loadexecscript  {
	my @files 				= $q->param('selectscript');
	my $userhost 			= myhost();
	my $userdir = "$USER_DIR$delim$user.$userhost$delim"."sql";
	
	my $SQL = quoteit($q->param('SQL'));
	
	my $back = {
			dbname				=> "$database",
			page				=> "tables",
			userhost			=> $userhost,
			SQL					=> $SQL,
			selectedscript		=> quoteit($q->param('selectedscript'))
	};
			
	my $readscript = sub {
		my $script;
		my $file 	= "$userdir$delim$_[0]";
		open (FH, "$file") || bail_out("Can not open file $_[0]$!", $back);
		flock (FH,2) unless $WIN32;
		my $i;
		while(<FH>){
			$_ = quoteit($_);
			$script .= $_;
			if ($i++ > 10000) {bail_out("OVERCYCLED!", $back)} 
		}
		flock (FH,8) unless $WIN32;
		close FH;
		return $script;
	};

	my $printSaveAs = sub {
		my $file = quoteit($_[0]);
		my $var = qq!\n<FORM METHOD=POST ACTION="$full_url">\n!;
		$var .= qq!<BR><P><INPUT TYPE=SUBMIT NAME="script" VALUE="SAVE AS">&nbsp;\n!;
		$var .= qq!<INPUT TYPE=TEXT NAME="saveasname" SIZE=40 VALUE="$file"><P>\n!;
		$var .= qq!<INPUT TYPE=SUBMIT NAME="script" VALUE=" CANCEL">\n!;
		$var .= qq!<INPUT TYPE=HIDDEN NAME="overwrite" VALUE="1">\n!	if ($_[1] eq '1');	
		$var .= qq!<INPUT TYPE=HIDDEN NAME="dbname" VALUE="$database">\n!;
		$var .= qq!<INPUT TYPE=HIDDEN NAME="page" VALUE="tables">\n!;
		$var .= qq!<INPUT TYPE=HIDDEN NAME="userhost" VALUE="$userhost">\n!;
		$var .= qq!<INPUT TYPE=HIDDEN NAME="SQL" VALUE="$SQL">\n! if $SQL;
		$var .= qq!<INPUT TYPE=HIDDEN NAME="selectedscript" VALUE="!.quoteit($q->param('selectedscript')).qq!">\n! if $q->param('selectedscript');
		$var .= qq!</FORM>!;
	};
	if ($q->param('script') =~ /save/i){
		my $size = 0;
        foreach (<$userdir/*>){
        	unless (-d){
        		my @stat = stat;
        		$size += $stat[7];
        	}
        }#foreach
		$size += length($q->param('SQL')); 
        if ($MAX_SCRIPT_SIZE and ($size > ($MAX_SCRIPT_SIZE*1024))) {
    		my $errmsg = "Total size of user scripts is limited to $MAX_SCRIPT_SIZE kb.\n";
    		$errmsg .= "Please delete some files or contact us ($CONTACT_EMAIL) if you need more disk space.\n";			
     		bail_out("$errmsg",$back);
    	}

	
	}
	if ($q->param('script') =~ /Edit/i){
		$back->{script} = 'Back';
		bail_out("Too many files", $back) if (@files > 1);
		bail_out("Please select a file", $back) if (@files == 0);
		bail_out("Script list is empty",$back) unless ($files[0]);
		loadSelectTables(&$readscript($files[0]));
	}
	elsif ($q->param('script') =~ /run/i){
		$back->{script} = 'Back';
		bail_out("Too many files", $back) if (@files > 1);
		bail_out("Please select a file", $back) if (@files == 0);
		bail_out("Script list is empty",$back) unless ($files[0]);
		execExecuteQuery({	page				=> 'tables', 
							selectedscript		=> $q->param('selectedscript').'', 
							dbname				=> "$database",
							script				=> 'back'})
	}
	elsif ($q->param('script') =~ /execute/i){
		execExecuteQuery({	
							page				=> 'tables', 
							selectedscript		=> $q->param('selectedscript').'', 
							dbname				=> "$database",
							script				=> 'back'})
	}

	elsif ($q->param('script') =~ /delete/i){
		if ($q->param('confirm')){
			foreach ($q->param('filedelete')){
				if ($WIN32) {$_ = $userdir."\\$_"}
				else {$_ = $userdir."\/$_"}
				bail_out("Can not delete file $_ . $!", $back) unless unlink ;
			}
			loadSelectTables();
		}
		elsif ($q->param('cancel')){loadSelectTables();}
		else {
			bail_out("Please select a file", $back) if (@files == 0);
			bail_out("Script list is empty",$back) unless ($files[0]);

			print qq!\n<FORM METHOD=POST ACTION="$full_url">\n!;
			print "<BR><P><B>THESE FILES WILL BE DELETED:</B><P>\n";
			foreach (@files){
				s/^(.*[\/|\\])*(.*)/$2/;
				$_ = quoteit($_);
				print "<INPUT TYPE=CHECKBOX NAME=\"filedelete\" VALUE=\"$_\" CHECKED> $_ <BR>\n";
			}
			print qq!<BR>!;
			print qq!<INPUT TYPE=SUBMIT NAME="confirm" VALUE="DELETE">&nbsp;\n!;
			print qq!<INPUT TYPE=SUBMIT NAME="cancel" VALUE="CANCEL">\n!;
			print qq!<INPUT TYPE=HIDDEN NAME="dbname" VALUE="$database">\n!;
			print qq!<INPUT TYPE=HIDDEN NAME="script" VALUE="delete">\n!;
			print qq!<INPUT TYPE=HIDDEN NAME="page" VALUE="tables">\n!;
			print qq!<INPUT TYPE=HIDDEN NAME="userhost" VALUE="$userhost">\n!;
			print qq!<INPUT TYPE=HIDDEN NAME="SQL" VALUE="$SQL">\n!;
			print qq!<INPUT TYPE=HIDDEN NAME="selectedscript" VALUE="!.quoteit($q->param('selectedscript')).qq!">\n!;
			print qq!</FORM>!;	
	
	
		}
	}
	elsif ($q->param('script') eq 'Save'){
		my $filename = $q->param('selectedscript');
		unless ($filename) {
			print &$printSaveAs()
		}
		else{
			my $file = "$userdir$delim$filename";
    		open (FH, ">$file") || bail_out ("Can not open file $filename\n$!", $back);
        	flock(FH, 2) unless $WIN32;
        	print FH $q->param('SQL');
        	flock(FH, 8) unless $WIN32;
        	close FH;
    		loadSelectTables()
		}
	}
	elsif ($q->param('script') =~ /save\sas/i){
		my $filename	= $q->param('saveasname');
		$filename		=~ s/^\s*(.*)/$1/;
    	if (($filename =~ /[\\\/]/g) or ($filename =~ /[\/]/g)){
    		bail_out("File name is incorrect", $back)
    	}
        my $file		= "$userdir$delim$filename";
		
		unless ($filename) {
			print "<BR><B>PLEASE SELECT FILE NAME</B><P>";
			print &$printSaveAs()
		}
		elsif ((-e $file) and !$q->param('overwrite')){
			print "<BR><B>THIS FILE NAME ALREADY EXISTS</B><P>";
			print "<B>CLICK <U>'SAVE AS'</U> TO OVERWRITE</B><P>";
			print &$printSaveAs($filename,'1');
		
		
		}
		else{
    		open (FH, ">$file") || bail_out ("Can not open file $filename\n$!", $back, '1');
        	flock(FH, 2) unless $WIN32;
        	print FH $q->param('SQL');
        	flock(FH, 8) unless $WIN32;
        	close FH;
    		loadSelectTables()
		}
	
	
	}
	else {loadSelectTables()};


}
sub execSearch {
	my ($table)		= $q->param('tables');
	my $back =		   {
	   page =>			'tables',
	   dbname =>		"$database",
	   tables =>		"$table",
	   func =>			"search"	 
	};
#		$back->{func}	= "return";
#		$back->{page} 	= "searchresult";
#		$back->{order}	= "$order";
#		$back->{where}	= "$where";
#		$back->{fields}	= \@fields;
#		$back->{start}	= "$start";
#		$back->{rows}	= "$rows";
	my $query 		= "SELECT * FROM $table WHERE 1=0";
	my ($sth,$res)	= prepare_execute($query, {page => 'select_db', dbname => "$database"});
	my @names 		= @{$sth->{NAME}};
	my $null 		= $sth->{NULLABLE};
	$sth->finish;
	my @fields		= $q->param('fields');
	my @where;
	my @unquote		= $q->param('unquote');
	my $j 			= 0;
	sub regescape {
		$_ = shift;
		s{(.)}{
				if ($1 eq '\\')			{ '\\\\\\\\' }
				elsif ($1 eq '%')		{ '\%' }
				elsif ($1 eq "'")		{ "\\'" }
				elsif ($1 eq '^')		{ '\^' }
				elsif ($1 eq '$')		{ '\$' }
				elsif ($1 eq '.')		{ '\.' }
				elsif ($1 eq '[')		{ '\[' }
				elsif ($1 eq ']')		{ '\]' }
				elsif ($1 eq '*')		{ '\*' }
				elsif ($1 eq '+')		{ '\+' }
				elsif ($1 eq '?')		{ '\?' }
				elsif ($1 eq '|')		{ '\|' }
				elsif ($1 eq '{')		{ '\{' }
				elsif ($1 eq '}')		{ '\}' }
				elsif ($1 eq ')')		{ '\)' }
				elsif ($1 eq '(')		{ '\(' }
				else					{ $1   }
			}gsex;
		return $_;
	}
	for(my $i=0; $i<@names; $i++){
		my $data 	= $q->param("$names[$i]\_data");
		my $oper 	= $q->param("operator\_$names[$i]");
		next if (($data eq '') and !$oper);
		my $not 	= ' NOT' 	if $q->param("not\_$names[$i]");
		my $case 	= ' BINARY' if $q->param("case\_$names[$i]");
		my $unquote;
		my $likexpr = sub {
			if (belongsb(\@unquote,$names[$i])){
				$unquote = 1;
				return ['REGEXP', $case, '', $data, '', '']
			}
			else {
				$case = '' unless check_version('3.23.4');
				return ['LIKE', $case, "'%", regescape($data), "%'", "'"]
			}
		} ;#if (!$oper or ($oper eq 'AND') or ($oper eq 'OR'));
		if (!$oper) {
			my $expr	= &$likexpr;
			$where[$j]	= "$names[$i]$not $expr->[0]$expr->[1] $expr->[2]$expr->[3]$expr->[4]";
		}
		elsif ($oper eq 'start') {
			my $expr	= &$likexpr;
			my @data	= split ',', $expr->[3];
			my @where_;
			for(my $k=0; $k<@data; $k++){
				$data[$k] =~ s/^\s*(.*)\s*$/$1/;
				push @where_, "$names[$i]$not $expr->[0]$expr->[1] $expr->[5]$data[$k]$expr->[4]"; 
			}
			$where[$j]	= join " OR \n", @where_;
		}
		elsif ($oper eq 'end') {
			my $expr	= &$likexpr;
			my @data	= split ',', $expr->[3];
			my @where_;
			for(my $k=0; $k<@data; $k++){
				$data[$k] =~ s/^\s*(.*)\s*$/$1/;
				push @where_, "$names[$i]$not $expr->[0]$expr->[1] $expr->[2]$data[$k]$expr->[5]"; 
			}
			$where[$j]	= join " OR \n", @where_;
		}
		elsif (($oper eq 'AND') or ($oper eq 'OR')){
			my $expr	= &$likexpr;
			my @data	= split ',', $expr->[3];
			my @where_;
			for(my $k=0; $k<@data; $k++){
				$data[$k] =~ s/^\s*(.*)\s*$/$1/;
				push @where_, "$names[$i]$not $expr->[0]$expr->[1] $expr->[2]$data[$k]$expr->[4]"; 
			}
			$where[$j]	= join " $oper \n", @where_;
		}
		elsif ($oper eq '>'){
			$oper 		= '<=' if $not;
			$data		= "'". regescape($data) ."'" unless (DBI::looks_like_number($data) or $unquote);
			$where[$j]	= "$case $names[$i] $oper $data ";
			
		}
		elsif ($oper eq '>='){
			$oper 		= '<' if $not;
			if (($data eq '') and $null->[$i] and !$not) {$where[$j] = " OR $names[$i] IS NULL"}
			$data		= "'". regescape($data) ."'" unless (DBI::looks_like_number($data) or $unquote);
			$where[$j]	= "$case $names[$i] $oper $data $where[$j] ";
		}
		elsif ($oper eq '<'){
			$oper		= '>=' if $not;
			if (($data eq '') and $null->[$i] and $not) {$where[$j] = " OR $names[$i] IS NULL"}
			$data		= "'". regescape($data) ."'" unless (DBI::looks_like_number($data) or $unquote);
			$where[$j]	= "$case $names[$i] $oper $data $where[$j] ";
		}
		elsif ($oper eq '<='){
			$oper		= '>' if $not;
			$data		= "'". regescape($data) ."'" unless (DBI::looks_like_number($data) or $unquote);
			$where[$j]	= "$case $names[$i] $oper $data ";
		}
		elsif ($oper eq '='){
			$oper		= '<>' if $not;
			if (($data eq '') and $null->[$i] and !$not) {$where[$j] = " OR $names[$i] IS NULL"}
			$data		= "'". regescape($data) ."'" unless (DBI::looks_like_number($data) or $unquote);
			$where[$j]	= "$case $names[$i] $oper $data $where[$j] ";
		}
		elsif ($oper eq 'BETWEEN'){
			my @data	= split ',', $data;
			bail_out("\"BETWEEN\" option requires TWO arguments to be comma separated.",$back) 
				if ((@data > 2) or (@data < 2));
			for(my $k=0; $k<2; $k++){
				$data[$k]	=~ s/^\s*(\S*)\s*$/$1/g;
				$data[$k]	= "'". regescape($data[$k]) ."'" unless (DBI::looks_like_number($data[$k]) or $unquote);
			}
			$where[$j] = "$case $names[$i]$not BETWEEN $data[0] AND $data[1]";
		}
		elsif ($oper eq 'IN'){
			my $expr 	= &$likexpr;
			my @data	= split ',', $expr->[3];
			
			for(my $k=0; $k<@data; $k++){
				$data[$k]	=~ s/^\s*(\S*)\s*$/$1/g;
				$data[$k]	= "$expr->[5]$data[$k]$expr->[5]";
			}
			$where[$j]		= join ' ,',@data;
			$where[$j]		= "$case $names[$i]$not IN ($where[$j])";
 		
		}
		elsif ($oper eq 'REGEXP'){
			my $expr		= &$likexpr;
			$where[$j]		= "$case $names[$i]$not REGEXP $expr->[5]$expr->[3]$expr->[5]";
		}
		elsif ($oper eq 'LIKE') {
			my $expr 		= &$likexpr;
			$where[$j] 		= "$names[$i]$not $oper$expr->[1] $expr->[5]$expr->[3]$expr->[5]";
		}
		elsif ($oper eq 'NULL'){
			$where[$j] 		= "$names[$i] IS $not NULL";
		}
		elsif ($oper eq 'FUNCTION'){
			$where[$j] 		= "$names[$i] $data";
		}
		$where[$j]	= "($where[$j])";
		$j++;
	} 
	my $andor			= $q->param('andor');
	my $where 			= join " $andor ", @where;
	$where 				= "WHERE $where" if $where;
	my $sort 			= $q->param('sort');
	my $sortorder 		= $q->param('sortorder');
	my $order 			= "ORDER BY $sort $sortorder" if $sort;
	searchresult($where, $order);

return;
}

sub searchresult {
#input:
# $_[0] - where
# $_[1] - order

	my $where 		= defined $_[0] ? $_[0] : $q->param('where');
	my $order 		= defined $_[1] ? $_[1] : $q->param('order');
	my ($table)		= $q->param('tables');
	my $start 		= $q->param('start');
	my $rows 		= $q->param('rows');
	my $func 		= $q->param('func');
	my @fields		= $q->param('fields');
	my $selectfrom	= "SELECT ". join (', ', @fields). " FROM $table";
	my $query_ 		= "$selectfrom $where $order";
	my $deletepreview = '1' if (($func =~ /delete/i) and !$q->param('back') and !$q->param('confirm'));
	my $hidden		= $q->hidden(-name=>'fields', -value=>\@fields, -override=>1);
	my $back = 	{
		tables 		=> "$table",
		dbname 		=> "$database"
	};

	if ($page eq 'search'){
		$back->{func}	= "search";
		$back->{page} 	= "tables";
	}
	else {
		$back->{func}	= "return";
		$back->{page} 	= "searchresult";
		$back->{order}	= "$order";
		$back->{where}	= "$where";
		$back->{fields}	= \@fields;
		$back->{start}	= "$start";
		$back->{rows}	= "$rows";
	}
	unless ($start =~ /^\s*\d*\s*$/){bail_out("Please check the 'Start' row number",$back)}
	unless ($rows =~ /^\s*\d*\s*$/){bail_out("Please check the number of 'hits' to be displayed",$back)}
	if	($q->param('confirm') and ($func =~ /delete/i)){
		my $query = $q->param('deletequery');
		my $unregmes = unrgversion();
		bail_out ($unregmes, $back);
		
		bail_out("Cannot delete records", $back) unless $dbh->do($query);
		#DELETE query:
		$query = quoteit($query);
	}

	my $count		= count_rows("$table $where", $back);
	if (($func 		=~ /next/i) and (($start + $rows)<$count)) {$start = ($start + $rows)}
	elsif (($func 	=~ /prev/i) and ($start > $rows)) {$start = ($start - $rows)}
	elsif (($func	=~ /prev/i) and ($start <= $rows)) {$start = '0'}
	
	my $deletequery;
	my $limit;

	if ($deletepreview) {
		bail_out("Please select rows to delete!", $back) unless defined $q->param('SelectRow');
		my $query 		= "SELECT *  FROM $table $where $order";
		my $calldelete = {
			count => "$count", table => "$table", start => "$start", rows => "$rows", query => "$query", back => $back
		};
		$deletequery 		= "DELETE ".$q->param('delete_option1')." FROM  $table ";
		my $deletewhere 	= getdeletequery($calldelete);
		$deletewhere 		= "WHERE $deletewhere" if $deletewhere;
		$deletequery 		.= $deletewhere;
		$query_		 		= "$selectfrom $deletewhere $order";
		$deletequery 		= quoteit($deletequery);
	}
	elsif ($q->param('printpage') ne 'full'){
		if ($start and ($rows ne ''))	{$limit = "LIMIT $start, $rows"}
		elsif ($start and ($rows eq '')){$rows = $count - $start; $limit = "LIMIT $start, $rows"}
		elsif (!$start and $rows ne '') {$limit	= "LIMIT $rows"}
		else {$rows = $count - $start}
		$query_ 			.= " $limit";	
	}
	$query 					= quoteit($query_);
	my ($sth,$res) 			= 	prepare_execute($query_, $back);
	
	if ($print) {print &printresult(\$sth, 0, 1);return}
	
	my $offset 				= ($start + 0);
	my $i 					= 0;
	my $array;
	$array->[0][0] 			= qq!<TD BGCOLOR='#CCCCCC'>No</TH>!;
	$array->[0][1]			= qq!<TD BGCOLOR='#CCCCCC'>Select</TD>! unless ($deletepreview);
	my $pri 				= $sth->{mysql_is_pri_key};
	my $bgcolorH			= $print ? '#FFFFFF' : '#EEEEEE';
	my $bgcolor				= $print ? '#FFFFFF' : '#EEEEEE';
	my $pricolor 			= $print ? '#000000' : '#ff0000';
	foreach (my $i = 0; $i < $sth->{NUM_OF_FIELDS}; $i++) {
		my $color = '#000000';
		if ($pri->[$i]){
			$array->[0][$i+2] = qq!<TH BGCOLOR='$bgcolorH'><FONT COLOR='$pricolor'>$sth->{NAME}->[$i]</TH>!;
		}
		else {
			$array->[0][$i+2] = qq!<TH BGCOLOR='$bgcolor'><FONT COLOR='#000000'>$sth->{NAME}->[$i]</TH>!;
		}
	}
	my $j=1;
	my @offset = $deletepreview ? $q->param('SelectRow') : ($start..($start+$rows));
	while (@ary = $sth->fetchrow_array)	{
		@ary 	= quoteit(@ary);
		$offset = $offset[$j-1];
		unless ($print) {
			$array->[$j][0] = qq!<TD BGCOLOR='#CCCCCC'>$offset</TD>!;
			$array->[$j][1] = qq!<TD BGCOLOR='#CCCCCC'><INPUT TYPE=CHECKBOX NAME='SelectRow' VALUE="$offset" TITLE='Select record'></TD>! unless
					($deletepreview);
		}
		@ary = map {$_='&nbsp;' unless $_} @ary;
		for (my $i = 0; $i < @ary; $i++){
			$ary[$i] =~ s/(\r\n)|\n/<BR>/mg;
			$array->[$j][$i+2]= qq!<TD BGCOLOR='$bgcolor'>$ary[$i]</TD>!;
		}
		$j++;
		$offset++;
	}
	my ($controlbar, $title, $confirmation, $conftitle, $printpage, $pr_res_up, $pr_res_down);
	if ($deletepreview){
		$hidden .= qq!\n<INPUT TYPE=HIDDEN NAME='func' VALUE='DELETE'>\n!;
		$hidden .= qq!\n<INPUT TYPE=HIDDEN NAME='deletequery' VALUE="$deletequery">\n!;
		$title = 'DELETE RECORDS';
		$confirmation = "Selected records will be deleted:";
		$controlbar = <<EndOfControlbarDelete
			<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>
				<TR>
					<TD><INPUT TYPE=SUBMIT NAME='confirm' VALUE=' CONFIRM ' style='color=#CC0000' TITLE='Confirm deletion'></TD>
					<TD><INPUT TYPE=SUBMIT NAME='back' VALUE='  BACK  ' TITLE='Cancel and return back'></TD>
				</TR>
				<TR>
					<TD COLSPAN=2 HEIGHT=6></TD>
				</TR>
			</TABLE>		

EndOfControlbarDelete
;
	}
	else  {
		my $prev 	= "<INPUT TYPE=SUBMIT NAME='func' VALUE='<<Prev' TITLE='Show previous hits'>" if ($start > 0);
		my $next 	= "<INPUT TYPE=SUBMIT NAME='func' VALUE='Next>>' TITLE='Show next hits'>" if ((($start + $rows) < $count) and $rows);
		if ($prev or $next){
			$printpage ="Full&nbsp;result&nbsp;<INPUT TYPE=RADIO NAME='printpage' VALUE='full' TITLE='Print all found hits'>&nbsp;Current&nbsp;Page&nbsp;<INPUT TYPE=RADIO NAME='printpage' VALUE='this' CHECKED TITLE='Print only shown hits'>";
		}
		$title = 'SEARCH&nbsp;RESULT';
		$confirmation = "Records&nbsp;found:&nbsp;$count";
		$conftitle	=  "TITLE='Totally $count hits were found with given search criteria'";
		$controlbar = <<EndOfControlbar
			<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH=650>
				<TR>
					<TD WIDTH=120>
					<TABLE CELLPADDING=0 CELLSPACING=0 WIDTH=120 BORDER=0>
						<TR>
							<TD>
								<TABLE CELLPADDING=0 CELLSPACING=0 WIDTH=60 BORDER=0>
									<TR>
										<TD WIDTH=60>$prev</TD>
									</TR>
								</TABLE>
							</TD>
							<TD WIDTH=60>
								<TABLE CELLPADDING=0 CELLSPACING=0 WIDTH=60 BORDER=0>
									<TR>
										<TD WIDTH=60>$next</TD>
									</TR>
								</TABLE>
							</TD>
						</TR>
					</TABLE>
					</TD>
					<TD WIDTH=20>&nbsp;</TD>
					<TD>
						<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>
							<TR>
								<TD WIDTH=68><INPUT TYPE=SUBMIT NAME='func' VALUE='  BACK  ' TITLE='Go back to select search criteria'></TD>
								<TD WIDTH=120 ALIGN=LEFT><INPUT TYPE=SUBMIT NAME='func' VALUE='EDIT RECORD ' TITLE='Edit selected records'></TD>
								<TD WIDTH=120 ALIGN=LEFT><INPUT TYPE=SUBMIT NAME='func' VALUE=' NEW RECORD ' TITLE='Insert new records'></TD>
								<TD WIDTH=118 ALIGN=LEFT><INPUT TYPE=SUBMIT NAME='func' VALUE='DELETE RECORD' TITLE='Delete selected records'></TD>
							</TR>
						</TABLE>
					</TD>
				</TR>
				<TR>
					<TD COLSPAN=3 HEIGHT=6></TD>
				</TR>
			</TABLE>		

EndOfControlbar
;

	$pr_res_up = <<EOPR
<INPUT TYPE=SUBMIT NAME='func' VALUE='Print result' TITLE='Generate printer friendly report'></TD>
		<TD>$printpage</TD>
		<TD>&nbsp;</TD>
		<TD>Title:&nbsp;<INPUT TYPE=TEXT SIZE=20 NAME='title' TITLE='Type page title to place on printout'>
EOPR
;
$pr_res_down = <<EOPR
Height:</TD>
		<TD>Rows:&nbsp;<SELECT NAME='rowheight' TITLE='Select height of table rows for printout'>
		<OPTION VALUE='' SELECTED>min
		<OPTION VALUE='HEIGHT=20'>20
		<OPTION VALUE='HEIGHT=30'>30
</SELECT>&nbsp;Header:&nbsp;<SELECT NAME='headerheight' TITLE='Select height of table header for printout'>
		<OPTION VALUE=''>min
		<OPTION VALUE='HEIGHT=20'>20
		<OPTION VALUE='HEIGHT=30' SELECTED>30
</SELECT></TD>
		<TD>&nbsp;</TD>
		<TD>Align:&nbsp;<SELECT NAME='align' TITLE='Select alignment of page title'>
<OPTION VALUE='LEFT' SELECTED>left
<OPTION VALUE='CENTER'>center
<OPTION VALUE='RIGHT'>right
</SELECT>&nbsp;<B>B</B>&nbsp;<INPUT TYPE=CHECKBOX NAME='style' 
VALUE='B' TITLE='Style of page title - Bold'>&nbsp;<B><I>I</I></B><INPUT TYPE=CHECKBOX NAME='style' 
VALUE='I' TITLE='Style of page title - Italic'>&nbsp;<B><U>U</U></B><INPUT TYPE=CHECKBOX NAME='style' VALUE='U' TITLE='Style of page title - Underline'>

EOPR
;
}
	print <<SR_Header
<FORM METHOD=POST ACTION="$full_url" TARGET=_blank>
<TABLE BORDER=0><!-- Header Table -->
	<TR><TH ALIGN=LEFT>$title</TH>
			<TD>&nbsp;</TD>

		<TD $conftitle>&nbsp;<CODE>$confirmation</CODE>&nbsp;</TD>

		<TD>$pr_res_up</TD>
	</TR>
	<TR>
		<TD COLSPAN=3><CODE>TABLE&nbsp;"$table"&nbsp;</CODE></TD>
		<TD ALIGN=CENTER>$pr_res_down</TD>



	</TR>
<!-- <TR><TH COLSPAN=6 ALIGN=LEFT HEIGHT=0></TH><TR> -->
</TABLE>
<INPUT TYPE=HIDDEN NAME="dbname" VALUE="$database">
<INPUT TYPE=HIDDEN NAME="page" VALUE="searchresult">
<INPUT TYPE=HIDDEN NAME="count" VALUE="$count">
<INPUT TYPE=HIDDEN NAME="tables" VALUE="$table">
<INPUT TYPE=HIDDEN NAME="start" VALUE="$start">
<INPUT TYPE=HIDDEN NAME="rows" VALUE="$rows">
<INPUT TYPE=HIDDEN NAME="where" VALUE="$where">
<INPUT TYPE=HIDDEN NAME="order" VALUE="$order">
$hidden

</FORM>
<!-- End of Header Table -->
SR_Header
unless $print;
	my $bordercolor = '#AAAAAA';
	print <<SR_Header
		  <!-- Search Result -->
<FORM METHOD=POST ACTION="$full_url">
<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH=100%>
	<TR>
		<TD WIDTH=100%>
<!-- Control Bar starts here -->
$controlbar
<!-- Control Bar ends here -->
		</TD>
	</TR>
	<TR>
		<TD WIDTH=100%>
			<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0>
				<TR>
					<TD BGCOLOR='$bordercolor'>
						<TABLE BORDER=0 CELLSPACING=1 CELLPADDING=2>
SR_Header
;

	#my $firstrow  ;
	my $rowheight = $q->param('rowheight');
	my $headerheight = $q->param('headerheight');
	print qq!\t<TR $headerheight>!, @{shift (@$array)}, qq!</TR>\n!;
	foreach (@$array){print qq!\t<TR $rowheight>@{$_}</TR>\n!}
	$where = quoteit($where);
	print <<SR_Header1
						</TABLE>
					</TD>
				</TR>
			</TABLE>
		</TD>
	</TR>
</TABLE>
<INPUT TYPE=HIDDEN NAME="dbname" VALUE="$database">
<INPUT TYPE=HIDDEN NAME="page" VALUE="searchresult">
<INPUT TYPE=HIDDEN NAME="count" VALUE="$count">
<INPUT TYPE=HIDDEN NAME="tables" VALUE="$table">
<INPUT TYPE=HIDDEN NAME="start" VALUE="$start">
<INPUT TYPE=HIDDEN NAME="rows" VALUE="$rows">
<INPUT TYPE=HIDDEN NAME="where" VALUE="$where">
<INPUT TYPE=HIDDEN NAME="order" VALUE="$order">
$hidden
</FORM>
		 <!-- end of printresult subroutine -->
SR_Header1
;


}
sub execSearchupdate {
	my ($back, $updatewhere) = @_;
	$updatewhere 	= $q->param('updatewhere') unless $updatewhere;
	my $table 		= $q->param('tables');
	my $err_msg;
	$updatewhere 	= "WHERE $updatewhere" if $updatewhere;
	my $query 		= "SELECT * FROM $table $updatewhere";
	my ($sth,$res)	= prepare_execute($query,$back);
	if ($res > 1){bail_out("Too many results. Check the code", $back)}
	my @names		= @{$sth->{NAME}};
	my @ary 		= $sth->fetchrow_array();#||bail_out("",$back);
	my @unquote		= $q->param('unquote');
	my @upload		= $q->param('upload');
	my $num			= $sth->{NUM_OF_FIELDS};
	$sth->finish;
	my @setarray;
	for (my $i = 0; $i<$num; $i++) {
		my $data;
		if (belongs(\@upload, $names[$i])){
			$data = $q->param("$names[$i]\_data_upload")||bail_out("No file entered ('$names[$i]' column).",$back);
			
			my $buf;
			$err_msg .= "File not found or is empty. $! - column '$names[$i]'\n" unless (-s $data);
			binmode $data if -B $data;
			my $line = '';

			while (read $data, $buf, 1024) {$line .= $buf; bail_out("$!", $back) if $! }
			close $data;
			bail_out("$!", $back) if $!;
			$data = $line;	
		}
		else {$data = $q->param("$names[$i]\_data").''}

#++++++++++++++++++++++++++++++++++++++

		if (belongs(\@unquote, $names[$i])){
			my $data_	= "SELECT $data";
			my $sth 	= $dbh->prepare("SELECT $data");
			my $res 	= $sth->execute() || bail_out("CHECK YOUR INPUT. WRONG UNQUOTED PARAMETERS IN COLUMN: '$names[$i]'\n\n$data\n\n", $back);
			($data_)	= $sth->fetchrow_array();
			unless ($data_ eq $ary[$i]){
				push @setarray, "$names[$i]=$data"; 
			}
		}
		else {
			unless ($data eq $ary[$i]){
				$data = $dbh->quote($data);
				push @setarray, "$names[$i]=$data";
			}
		}
	}#for
	bail_out($err_msg, $back) if $err_msg;
	unless (@setarray == 0) {
		my $set 		= join (', ', @setarray);
		my  $updatequery = 'UPDATE '.$q->param('insert_option1').' '.$q->param('insert_option2');
		$updatequery 	 .= " $table SET $set $updatewhere";
		my $unregmes = unrgversion();
		bail_out ($unregmes, $back);
	}#end update
}#execSearchupdate





						
sub printHeaderTable {
	my $headtab = $_[0];
# $_[0]->{name} - the name of proc.
# $_[1]->{title1} - table name
# $_[2]->{title2} - count rows
# $_[3]->{msg} - message

	my $total = qq!<CODE>$headtab->{rows}</CODE>! if (defined $headtab->{rows});
	my $table = qq!<CODE>$headtab->{table}</CODE>! if $headtab->{table};
	print <<EndOfHeaderTable
<TABLE BORDER=0><!-- Header Table -->
	<TR><TH COLSPAN=5 ALIGN=LEFT>$headtab->{name}</TH><TR>
	<TR>
		<TD TITLE='$headtab->{title1}'>$table</TD>
		<TD>&nbsp;&nbsp;&nbsp;</TD>
		<TD TITLE='$headtab->{title2}'>&nbsp; $total &nbsp;</TD>
		<TD>&nbsp;&nbsp;&nbsp;&nbsp;</TD>
		<TD>$headtab->{msg}</TD>
	</TR>
<!-- <TR><TH COLSPAN=5 ALIGN=LEFT HEIGHT=0></TH><TR> -->
</TABLE><!-- End of Header Table -->

EndOfHeaderTable
;
}
sub printform {
	print <<PrintForm
<FORM ACTION=$full_url METHOD=POST TARGET=_blank>
<INPUT TYPE=HIDDEN NAME='SQL' VALUE="$_[0]">
<INPUT TYPE=HIDDEN NAME='dbname' VALUE='$database'>
<INPUT TYPE=HIDDEN NAME='page' VALUE='tables'>
<INPUT TYPE=HIDDEN NAME='script' VALUE='execute'>

<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=2>
	<TR>
		<TD><INPUT TYPE=SUBMIT NAME='func' VALUE='Print Result' TITLE='Generate printer friendly report'></TD>
		<TD>&nbsp;</TD>
		<TD>Heights:</TD>
		<TD>Rows&nbsp;<SELECT NAME='rowheight' TITLE='Select height of table rows for printout'>
<OPTION VALUE='' SELECTED>min
<OPTION VALUE='HEIGHT=20'>20
<OPTION VALUE='HEIGHT=30'>30
</SELECT></TD>
		<TD>Header&nbsp;<SELECT NAME='headerheight' TITLE='Select height of table header for printout'>
<OPTION VALUE=''>min
<OPTION VALUE='HEIGHT=20'>20
<OPTION VALUE='HEIGHT=30' SELECTED>30
</SELECT></TD>
		<TD>Title:&nbsp;<INPUT TYPE=TEXT SIZE=20 NAME='title' TITLE='Type page title to place on printout'></TD>
		<TD><NOBR>Align:&nbsp;<SELECT NAME='align' TITLE='Select alignment of page title'>
<OPTION VALUE='LEFT' SELECTED>left
<OPTION VALUE='CENTER'>center
<OPTION VALUE='RIGHT'>right
</SELECT>&nbsp;<B>B</B>&nbsp;<INPUT TYPE=CHECKBOX NAME='style' 
VALUE='B' TITLE='Style of page title - Bold'>&nbsp;<B><I>I</I></B><INPUT TYPE=CHECKBOX NAME='style' 
VALUE='I' TITLE='Style of page title - Italic'>&nbsp;<B><U>U</U></B><INPUT TYPE=CHECKBOX NAME='style' VALUE='U' TITLE='Style of page title - Underline'></NOBR></TD>
	</TR>
</TABLE></FORM>

PrintForm
;
}
sub removeUser {
	my $back = {page => 'admin', func =>'access', dbname => "$database"};
	bail_out("Access denied to database 'mysql'", $back) if defined $q->param('add');
	my @userlist = $q->param('userlist');
	unless (@userlist and ($userlist[0] =~/@/)){bail_out "Please select from user list", $back}
	if ($q->param('confirm')){
		my @tables = ('mysql.user', 'mysql.columns_priv', 'mysql.db', 'mysql.tables_priv');
		foreach (@tables) {
			my $query = "DELETE FROM $_ WHERE ";
			my @where = ();
			foreach (@userlist){
				/^\s*('\S*.*')\@('.*\S*')\s*$/;
				push @where, "((User = $1) AND (Host = $2))";
			}
			$query .= join (' OR ', @where);
			$dbh->do($query) || bail_out("Can not do query:/n$query",$back);
		}
		$dbh->do("FLUSH PRIVILEGES") || bail_out("Can not flush privileges",$back);
		return
	}
	else {
		my $accounts;
		foreach (@userlist){
			$accounts .= qq!<INPUT TYPE=CHECKBOX NAME="userlist" VALUE="$_" CHECKED> $_ <BR>\n!;
		}
		my $message;
		my $buttons;
		unless (@userlist){
			$message = "Please select from user list";
			$buttons = "<INPUT TYPE=SUBMIT NAME='' VALUE='Back'>\n";
		}
		else {
			$message = 'You are going to remove the folowing accounts';
			$buttons = "<INPUT TYPE=SUBMIT NAME='action' VALUE='REMOVE' style='color=#CC0000'>";
			$buttons .= "&nbsp;<INPUT TYPE=SUBMIT NAME='' VALUE='Cancel'>\n";
		}
		print <<EOT
<FORM ACTION="$full_url" METHOD=POST>
<B>$message</B><BR>
$accounts<P>
$buttons
<INPUT TYPE=HIDDEN NAME='page' VALUE='admin'>
<INPUT TYPE=HIDDEN NAME='func' VALUE='access'>
<INPUT TYPE=HIDDEN NAME='dbname' VALUE='$database'>
<INPUT TYPE=HIDDEN NAME='confirm' VALUE='1'>
</FORM>
EOT
;
	}

}
sub showGrants {
	my $back = {page => 'admin', func =>'access', dbname => "$database"};
	unless (check_version('3.23.4')){
		my $version = get_version();
		bail_out("Current version of mysql server ($version) does not allow this operation.\nYou need to upgrade mysql installation.", $back);
	}
	my @userlist = get_user_host();
	if (@userlist == 0){bail_out ("Please select from user list", $back)}
	foreach (@userlist){

		print "SHOW GRANTS FOR $_ <BR>";
		my ($sth, $res) = prepare_execute("SHOW GRANTS FOR $_", $back);
		print &printresult(\$sth), "<BR>";
		ErrMessage ("<BR>Print Result Error. $DBI::errstr") if $DBI::err;
	}
	bail_out('',$back);
}
sub getAnotherUser {
	my $user_  = $q->param('user1');
	my $host_  = $q->param('host1');
	my $add	   = ($host_ ne '') ? '@' : $q->param('add');
	$host_	   = $dbh->quote($host_) if $add;
	$user_	   = $dbh->quote($user_);
	return ($user_.$add.$host_)
}
sub get_user_host {
	my @userlist;
	if (defined $q->param('add')){
		$userlist[0] = getAnotherUser();
	}
	else {
		@userlist = $q->param('userlist');
	}
	return @userlist;
}
sub changePassword {
	my $back = {page => 'admin', func =>'access', dbname => "$database"};
#++++++++++++++++++++++++++++++++++++++

	my $new_password; 
	my $password_	 = $q->param('new_password');
	if ($password_ =~/\S/){
		$password_ = $dbh->quote($password_);
		$new_password = "PASSWORD($password_)"
	}
	else {$new_password = "''"}
	my $for;
	my $message;
	unless ($q->param('for') eq 'self'){
		my @userlist = get_user_host;
		bail_out ("Please select only one user name", $back) if (@userlist > 1);
		bail_out ("Please select from user list", $back) if (@userlist == 0);
		$for = "FOR $userlist[0]";
		$message = quoteit("New password was set for $userlist[0]")
	}
	else {$message = "My password was changed"}
	my $query = "SET PASSWORD $for = $new_password";
	$dbh->do($query) || bail_out("Can not set password.\n$query",$back);
	print $query;
#++++++++++++++++++++++++++++++++++++++
	bail_out ($message, $back);

}
sub loadAccessControl {

#++++++++++++++++++++++++++++++++++++++



	my $action				= $q->param('action');
	my $back				= $_[0];
	if ($action =~ /SHOW/i){showGrants();return}
	elsif ($action =~ /REMOVE/i){removeUser();return unless $q->param('confirm')}
	elsif ($action =~ /(GRANT)|(REVOKE)|(NEXT)|(CREATE)/i){loadGrantTables(); return}
	elsif ($action =~ /CHANGE/i){changePassword();return unless $q->param('confirm')}
	my $show_grants_button = "<INPUT TYPE=SUBMIT NAME='action' VALUE='SHOW GRANTS' style='Width: 150px' TITLE='Show grants for selected users'>";
	my $selectdbname_ 		= $q->param('selectdbname_');
	my ($userlist, $labels) = getuserlist();
#	unshift @$userlist, ''; 
	my $num_of_acc; my $myuser;
	if ($userlist->[0] =~/@/){$num_of_acc  = "<B>".(scalar @$userlist)." accounts found</B>"}
	else {
		if ($userlist->[0] == 1){
			$myuser = <<EOT
<TABLE WIDTH=100% BORDER=0 CELLPADDING=0 CELLSPACING=0>
	<TR>
		<TD ALIGN=CENTER>user</TD><TD>&nbsp;</TD><TD ALIGN=CENTER>host</TD>
	</TR>
	<TR>
		<TD><INPUT TYPE=TEXT NAME='user1' SIZE=10 TITLE='User name.'></TD>
		<TD><SELECT NAME='add'>
					<OPTION VALUE=''>
					<OPTION VALUE='\@' SELECTED>@
			</SELECT></TD>
		<TD><INPUT TYPE=TEXT NAME='host1' SIZE=10 TITLE='Host name'></TD>
	</TR>
</TABLE>
EOT
;
		}
		$num_of_acc = ''}
	
	my $SelectUser	= $q->scrolling_list(
		   		  	 			   		-name		=> 'userlist',
										-value		=> $userlist,
										-labels		=> $labels,
										-multiple	=> 1,
										-size		=> 8
								);
	my ($other_users, $alt_hostname, $reload);
	my $apply		= 'NEXT>>';
	my $new_num		= $q->param('new_num');
	my $uh 			= $q->param('alt_hostname');
	$new_num =~ s/^\s*(.+)\s*$/$1/;
	if (($new_num =~ /\d+/) and ($new_num > 0)){
		$other_users = <<EOT
		<TABLE BORDER=0>
			<TR>
				<TD>USER</TD><TD>PASSWORD</TD><TD>HOST</TD><TD></TD>
			</TR>
EOT
;
		$reload			= qq!<INPUT TYPE=SUBMIT VALUE='Reload'><INPUT TYPE=RESET>!;
		my @un 			= $q->param('user_name');
		my @up 			= $q->param('user_password');
		my @uh;
		my $uh			= quoteit($uh);
		$apply			= 'Apply';
		if ($q->param('apply_alt_host')){for(1..$new_num){push @uh, $uh}}
		else {@uh = $q->param('user_host');@uh = quoteit @uh}
		@un 	= quoteit @un;
		@up 	= quoteit @up;
		for(0..$new_num-1){
			my $create_button = "<INPUT TYPE=SUBMIT NAME='action' VALUE='NEXT>>' TITLE='Show privileges'>" 
			unless $_;
			my $n = $_ + 1;
			$other_users .= <<EOT
			<TR>
				<TD>$n&nbsp;<INPUT TYPE=TEXT SIZE=20 NAME='user_name' VALUE="$un[$_]" TITLE='User name'></TD>
				<TD><INPUT TYPE=TEXT SIZE=20 NAME='user_password' VALUE="$up[$_]" TITLE='Password'></TD>
				<TD><INPUT TYPE=TEXT SIZE=20 NAME='user_host' VALUE="$uh[$_]" TITLE='Host name or IP'></TD>
				<TD>$create_button</TD>
			</TR>
EOT
;

		}
		$other_users .=	"\n\t\t</TABLE>\n";	

	}
	elsif($new_num =~ /\S/){
		$other_users .= "<FONT COLOR='#FF0000'>\"Number of accounts\" field must contain a number &gt; 0</FONT>";
		$new_num = '';
	}
	else {$other_users = "&nbsp;"; $new_num = '';}
	unless (defined $new_num){$new_num = 1}
	$alt_hostname =<<EOT
&nbsp;&nbsp;&nbsp;
			<I>Use this host name for all accounts</I>&nbsp;
			<INPUT TYPE=TEXT NAME='alt_hostname' VALUE="$uh" SIZE=20 TITLE="Type host name and click '$apply'">&nbsp;
			<INPUT TYPE=SUBMIT NAME='apply_alt_host' VALUE='$apply' TITLE="Click here to apply this host name to all accounts">
$reload
EOT
;

	print <<EOT

<!-- MAIN TABLE1 STARTS -->
<TABLE WIDTH=100% BORDER=0>
	<TR><TH ALIGN=LEFT>ADMINISTRATION -> ACCESS CONTROL</TH></TR>
	<TR>
		<TD><FORM ACTION="$full_url" METHOD=POST>
	<TABLE WIDTH=100% BORDER=0 CELLPADDING=0 CELLSPACING=0>
		<TR><!-- Grant, Revoke, Show -->
			<TD VALIGN=TOP ALIGN=RIGHT WIDTH=50%><P>
		<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' WIDTH=100% >
			<TR>
				<TD width=100%><!-- BORDER START -->
    		<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0 ALIGN=LEFT BGCOLOR='#CCCCCC' WIDTH=100% >
				   <TR><TD><P><BR><INPUT TYPE=SUBMIT NAME='action' VALUE='      GRANT     ' style='Width: 150px' TITLE='Grant privileges to selected users'></TD><!-- BUTTONS -->
					<TD ROWSPAN=5 TITLE='Select user'><!-- SELECT USER -->
$num_of_acc <BR>
$SelectUser
<BR>
$myuser
		   			</TD>
					</TR>
					<TR><TD><P><INPUT TYPE=SUBMIT NAME='action' VALUE='     REVOKE     ' style='Width: 150px' TITLE='Revoke privileges from selected users'></TD></TR>
					<TR><TD><P><INPUT TYPE=SUBMIT NAME='action' VALUE='    REMOVE     ' style='Width: 150px; color=#CC0000' TITLE='Remove selected users'></TD></TR>
					<TR><TD><P>$show_grants_button</TD></TR>
					<TR HEIGHT=25><TD HEIGHT=25 ><P>&nbsp;</TD></TR>
    		</TABLE>
		</TD></TR></TABLE>
			</TD><!-- End of Grant, Revoke, Show --><TD>&nbsp;&nbsp;</TD>
			<TD VALIGN=TOP WIDTH=50%><!-- Change Password -->
    		
			
			<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' WIDTH=100% >
			<TR>
				<TD width=100%><!-- BORDER START -->
			<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0 BGCOLOR='#CCCCCC' WIDTH=100% >
				<TR>
					<TD VALIGN=BOTTOM >
					<INPUT TYPE=SUBMIT NAME='action' VALUE='CHANGE PASSWORD' style='width: 180px' TITLE='Change password'></TD>
					<TD VALIGN=BOTTOM>&nbsp;&nbsp;&nbsp;New&nbsp;Password</B><BR>
					<INPUT TYPE=TEXT NAME='new_password' SIZE=20 TITLE='Type new password'></TD>
				</TR>
				<TR>
					<TD COLSPAN=2>
					<INPUT TYPE=RADIO NAME='for' CHECKED TITLE='Change password for selected user'>For selected user
					<INPUT TYPE=RADIO NAME='for' VALUE='self' TITLE='Change my password'>For myself
					</TD>
				</TR>
    		</TABLE>
			</TD></TR></TABLE><BR>
			
		<!--	<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR='#AAAAAA' WIDTH=100% >
			<TR>
				<TD width=100%>
			<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0 BGCOLOR='#CCCCCC' WIDTH=100% >
				<TR>
					<TD VALIGN=BOTTOM >
					<INPUT TYPE=SUBMIT NAME='host_priv' VALUE='  HOST PRIVILEGES ' style='width: 180px' TITLE='Assign host privilege'></TD>
				</TR>
    		</TABLE>
			</TD></TR></TABLE> -->
    		
    		
			</TD>
		</TR><!-- End of Change Password -->
		
	</TABLE>
	
<INPUT TYPE=HIDDEN NAME='page' VALUE='admin'>
<INPUT TYPE=HIDDEN NAME='func' VALUE='access'>
<INPUT TYPE=HIDDEN NAME='dbname' VALUE='$database'>
<INPUT TYPE=HIDDEN NAME='selectdbname_' VALUE='$selectdbname_'>

</FORM>
		</TD>
	</TR>
	<TR>
		<TD><HR SIZE=1></TD>
	</TR>
	<TR>
		<TD><FORM ACTION="$full_url" METHOD=POST><P><B>
CREATE</B>&nbsp;<INPUT TYPE=TEXT SIZE=3 MAXLENGTH=3 NAME='new_num' VALUE='$new_num' TITLE='Type number of new accounts to be created'><B>&nbsp;ACCOUNTS</B>$alt_hostname<BR>


$other_users
<INPUT TYPE=HIDDEN NAME='page' VALUE='admin'>
<INPUT TYPE=HIDDEN NAME='func' VALUE='access'>
<INPUT TYPE=HIDDEN NAME='dbname' VALUE='$database'>
<INPUT TYPE=HIDDEN NAME='selectdbname_' VALUE='$selectdbname_'>

</FORM>
		</TD>
	</TR>
</TABLE>
<!-- MAIN TABLE ENDS -->



EOT
;
return


}
sub loadGrantTables {
# $_[0] contains $back
	my $back = {page => 'admin', func =>'access', dbname => "$database"};
	my @userlist = get_user_host();
	my $action = $q->param('action');
	my $num;
	my ($hidden_userlist, $hidden_password, $hidden_glob, $hidden_db, $hidden_table, $hidden_column);
	my %global_lables = (
	'SELECT'=>'Select_priv', 'INSERT'=>'Insert_priv','UPDATE'=>'Update_priv',
	'DELETE'=>'Delete_priv','CREATE'=>'Create_priv', 'DROP'=>'Drop_priv',
	'RELOAD'=>'Reload_priv', 'SHUTDOWN'=>'Shutdown_priv', 'PROCESS'=>'Process_priv',
	'FILE'=>'File_priv', 'GRANT'=>'Grant_priv',
	'REFERENCES'=>'References_priv', 'INDEX'=>'Index_priv', 'ALTER'=>'Alter_priv' 
	);
	my $global_values = [
	'SELECT', 'INSERT','UPDATE','DELETE','CREATE', 'DROP',
	'RELOAD', 'SHUTDOWN', 'PROCESS', 'FILE',
	'REFERENCES', 'INDEX', 'ALTER', 'GRANT',''
	];
	my $database_values = [
	'SELECT', 'INSERT','UPDATE','DELETE','CREATE', 'DROP', 'REFERENCES', 'INDEX', 'ALTER', 'GRANT', ''
	];
	
	my $table_values = [
	'SELECT', 'INSERT','UPDATE','DELETE','CREATE', 'DROP', 'REFERENCES', 'INDEX', 'ALTER', 'GRANT', ''
	];
	my $column_values = ['SELECT', 'INSERT','UPDATE','REFERENCES'];

	my @password = $q->param('user_password') if ($action =~ /next/i or $action =~ /create/i);
	if($action =~ /next/i){
		$action = 'create';
		my $userlist_ 	= getuserlist();
		@userlist			= ();
		my @username		= $q->param('user_name');
		my @host;
		@host = $q->param('user_host');
		$num 				= scalar @username;
		my @username_		= @username;
		my @password_		= @password;
		my @host_			= @host;
		$back->{new_num}	= $q->param('new_num');
		$back->{user_name} = \@username_;
		$back->{user_host} = \@host_;
		$back->{user_password} = \@password_;
		# do revike
		#return
		for (my $i = 0; $i<$num; $i++){
			$password[$i] 	=~ s/^\s*(\S*.*\S)\s*$/$1/;
			$password[$i] 	= $dbh->quote($password[$i]) if ($password[$i] ne '');
			$host[$i] 		=~ s/^\s*(\S*.*\S)\s*$/$1/;
			bail_out("Illegal host name '$host[$i]'", $back) if $host[$i] =~ /\s/;
			$host[$i]		= $dbh->quote($host[$i]);
			$username[$i] 	=~ s/^\s*(\S*.*\S)\s*$/$1/;
			bail_out("Illegal user name '$username[$i]'", $back) if $username[$i] =~ /\s/;
			$username[$i]	= $dbh->quote($username[$i]);
			if (belongs \@userlist, "$username[$i]\@$host[$i]") {
				bail_out("The entry $username[$i]\@$host[$i] is duplicated.\nCheck user/host names.", $back);
			}
			if (belongs $userlist_, "$username[$i]\@$host[$i]") {
				bail_out("The entry $username[$i]\@$host[$i] already exists.\nCheck user/host names.", $back);
			}
			push @userlist,"$username[$i]\@$host[$i]";
		}
	}
	elsif ($action =~/(grant)|(create)|(revoke)/i){
		$num = scalar @userlist
	}

	my $back_; my @query; 
	my @x = $q->param();
	foreach (@x){
		my @y	 	= $q->param($_);
		$back_->{$_} = [@y];
	}
	undef  $back_->{'create'};
	$action					= uc $action;
	my $s 					= 'S' if $num > 1;
	my $num_				= $num;
	$num_ 					= '' if $num == 1;
	my $actionDescr 		= ($action eq "CREATE") ? "CREATE $num_ NEW ACCOUNT$s" : "$action PRIVILEGES" ;
	
	if ($q->param('create') and !$q->param('after_preview')){
		my $ident;
		if ($q->param('global_priv') and ($q->param('global') or !($q->param('db_priv') or $q->param('table_priv') or $q->param('column_priv')))){
			my $priv_type;
			my $grant_opt;
			my @privileges		= $q->param('global');
			my @to				= @userlist;
			$ident				= 1;
			shift @privileges 		if ($privileges[0]	eq '');			
			pop @privileges 		if ($privileges[-1]	eq '');
			if ($action =~ /revoke/i){
				if  ($privileges[-1] eq 'GRANT'){
					$privileges[-1] = 'GRANT OPTION';
					$priv_type = join (', ', @privileges)
				}
    			elsif (scalar @privileges == 13){$priv_type = ' ALL'}
    			elsif (scalar @privileges == 0) {$priv_type = ' USAGE'}
    			else {$priv_type = join (', ', @privileges)}
				my $to = join ', ', @to;
				push @query, "REVOKE $priv_type ON *.* FROM \n$to$grant_opt\n";
			}
			else {
				if ($privileges[-1] eq 'GRANT'){
					$grant_opt = ' WITH GRANT OPTION';
					pop @privileges;
				}
				if (scalar @privileges == 13){$priv_type = ' ALL'}
				elsif (scalar @privileges == 0 and !($q->param('db_priv') or $q->param('table_priv') or $q->param('column_priv'))) {
					$priv_type = ' USAGE'
				}
				else {$priv_type = join (', ', @privileges)}
				for(my $i=0; $i < $num; $i++){
					$to[$i]	.= " IDENTIFIED BY $password[$i]" if $password[$i];
				}
				my $to = join ', ', @to;
				push @query, "GRANT $priv_type ON *.* TO \n$to\n$grant_opt\n";
			}
		}
		if ($q->param('db_priv')){
			my @query3 				= (); #
			my $priv_type;
			my $grant_opt;
			my @db					= $q->param('d_db');
			shift @db unless $db[0];
			my @other_db			= split ',', $q->param('d1_db');
			my @db2;
			my @db3;
			my $i;
			my $build_query;
			foreach(@other_db){
				my $db = $_;
				$db =~ s/^\s*(.*)\s*$/$1/g;
				next if ($db eq '');
				next if belongsb (\@db, $db);
				my $db_temp = $db;
				$db_temp =~ s/\{user\}//;
				
				if ($db =~ /^[a-zA-Z0-9_\$]*$/){push @db, $db}
				elsif($db =~ /\s/){bail_out("Illegal database name '$db'.\n(Space characters are not allowed)", $back_)}
				elsif ($db_temp =~ /^[a-zA-Z0-9_\$]*$/){push @db3,$db}
				else {push @db2, $db}
			}
			bail_out("Database privileges failed.\nNo database was selected.\n\n", $back_) unless (@db or @db2 or @db3);
			my @privileges			= $q->param('database');
			shift @privileges 		if ($privileges[0]	eq '');		
			pop @privileges 		if ($privileges[-1]	eq '');			
			my ($priv_cols, @priv_cols);
			foreach (@privileges){
				$priv_cols .= ", $global_lables{$_}";
				push @priv_cols, $global_lables{$_};
			}
					
    		my (@query2, @values, $j, @values1, $insert_pw, @set, $set);
			if (@db2){
				if ($action =~ /create/i){
					unless ($ident or @db or @db3){
						$insert_pw = ', Password';
						$query2[1]		= "INSERT INTO mysql.user (Host, User$insert_pw) VALUES ";
					}
				}
				elsif($action =~ /grant/i){
					foreach (@priv_cols){push @set, "$_='Y'"}
				}
				elsif($action =~ /revoke/i){
					foreach (@priv_cols){push @set, "$_='N'"}
				}
				$set		= join ', ', @set;
			}
			if ($action =~ /revoke/i){
				my @privileges_ = @privileges;
				if  ($privileges[-1] eq 'GRANT'){
					$privileges[-1] = 'GRANT OPTION';
					$priv_type = join (', ', @privileges)
				}
    			elsif (scalar @privileges == 9){$priv_type = ' ALL'}
    			elsif (scalar @privileges == 0) {$priv_type = ' USAGE'}
    			else {$priv_type = join (', ', @privileges)}
    			my @query1; my @where_delete; my @where_update;
    			my @to 		= @userlist;
    			my @to1		= @to;
				for(my $i=0; $i < $num; $i++){
    				
					if (@db2 or @db3) {
    					$userlist[$i]		=~ /^'(.*)'\@'(.*)'/;
						my $username 		= $1;
	    				my $hostname		= $2;
						foreach (@db3){
							my $db3 = $_;
							$db3	=~ s/\{user\}/$username/g;
							unless (belongs(\@db, $db3)){
    							push @query3, "REVOKE $priv_type \n ON $db3\.* \n FROM '$username'\@'$hostname'\n";
							}
						}
				
						foreach (@db2){
							my $db2 = $_;
							$db2	=~ s/\{user\}/$username/g;
							$db2 		= $dbh->quote($db2);
							my $where	= "Host='$hostname' AND Db=$db2 AND User='$username'";
							if (count_rows("mysql.db WHERE $where", $back_)){
								my $where_ = $where;
								my @where_;
								foreach (@$database_values){
									next if (!$_);
									unless (belongs(\@privileges_, $_)){push @where_, "$global_lables{$_}='Y'"}
								}
								if (@where_){$where_ .= " AND (".(join ' OR ', @where_) .")"}
								if (count_rows("mysql.db WHERE $where_", $back_) and ($where ne $where_)){
									push @where_update, $where;
								}
								else {
									push @where_delete, $where;
								}
							}
							else {push @query2, "/\* ERROR: There is no such grant for $userlist[$i] on database $db2 \*/"}
						}#foreach (@db2)
    				}#if (@db2)
				}#for(my $i=0; $i < $num; $i++)
				if ($set and @where_update){
					if (@where_update > 1){for (my $i=0; $i < @where_update; $i++){$where_update[$i] = "($where_update[$i])"}}
					my $where = join " OR \n", @where_update;
					push @query2, "UPDATE mysql.db SET \n$set WHERE \n$where\n";
					$build_query = 1;
				}
				if (@where_delete){
					if (@where_delete > 1){for (my $i=0; $i < @where_delete; $i++){$where_delete[$i] = "($where_delete[$i])"}}
					my $where = join " OR \n", @where_delete;
					push @query2, "DELETE FROM mysql.db WHERE \n$where\n";
					$build_query = 1;
				}
				
    			my $to = join ', ',@to;
    			my $to1 = join ', ',@to1;
    			if ($db[0]){
    				push @query, "REVOKE $priv_type \n ON $db[0]\.* \n FROM $to\n";
    				shift @db;
    			}
    			foreach (@db){
    				push @query, "REVOKE $priv_type \n ON $_\.* \n FROM $to1\n";
    			}
			}
			else{#create, grant
				if  ($privileges[-1] eq 'GRANT'){
					$grant_opt		= ' WITH GRANT OPTION';
					pop @privileges;
				}
    			if (scalar @privileges == 9){$priv_type = ' ALL'}
    			elsif (scalar @privileges == 0) {$priv_type = ' USAGE'}
    			else {$priv_type = join (', ', @privileges)}
    			my @query1;
    			my @to 		= @userlist;
    			my @to1		= @to;
				my @where_update;
    			for(my $i=0; $i < $num; $i++){
    				if (@db){
    					$to[$i]	.= " IDENTIFIED BY $password[$i]" if (($password[$i] ne '') and !$ident);
    				}
    				if (@db2 or @db3) {
    					$userlist[$i]		=~ /^'(.*)'\@'(.*)'/;
    					my $username 		= $1;
    					my $hostname		= $2;
    					if ($action =~ /create/i){
							my $ident_ = $ident;
							foreach (@db3){
								my $db3 = $_;
								$db3	=~ s/{user}/$username/g;
								unless (belongs(\@db, $db3)){
									my $pw = "IDENTIFIED BY $password[$i]" unless ($ident_ or @db);
    								push @query3, "GRANT $priv_type \nON $db3.* \nTO '$username'\@'$hostname' $grant_opt $pw\n";
								}
								$ident_ = 1;
							}
    						foreach (@db2) {
    							my $db2 		= $_;
								$db2			=~ s/{user}/$username/g;
								$db2 			= $dbh->quote($db2);
   								$values[$j] 	= "'$hostname', $db2, '$username'";
   								foreach (@priv_cols){$values[$j] .= ", 'Y'"}
   								$values[$j] 	= "\n(".$values[$j].")";
   								$j++;
								$build_query	=1;
    						}
							if ($insert_pw){
    							my $values1 = "'$hostname', '$username'";
    							if ($insert_pw){
    								$values1 .= $password[$i] ne '' ? ", PASSWORD($password[$i])" : ", ''";
    							}
    							push @values1, "\n(".$values1.")"
							}
    					}
    					else { #GRANT
							foreach (@db3){
								my $db3 = $_;
								$db3	=~ s/{user}/$username/g;
								unless (belongs(\@db, $db3)){
    								push @query3, "GRANT $priv_type \nON $db3.* TO '$username'\@'$hostname' $grant_opt\n";
								}
							}
    						foreach (@db2){
    							my $db2 = $_;
    							$db2 =~ s/{user}/$username/ig;
								$db2 		= $dbh->quote($db2);
    							my $where	= "Host='$hostname' AND Db=$db2 AND User='$username'";
    							if (count_rows("mysql.db WHERE $where", $back_)){
									push @where_update, $where;
									$build_query = 1;
    							}
								else {
									$values[$j] = "'$hostname', $db2, '$username'";
									foreach (@priv_cols){$values[$j] .= ", 'Y'"}
									$values[$j] = "\n(".$values[$j].")";
									$j++;
									$build_query = 1;
								}
    						}#foreach (@db2)
    					}#else
    				}#if (@db2)
    			}#for(my $i=0; $i < $num; $i++)
				if ($set and @where_update){
					if (@where_update > 1){for (my $i=0; $i < @where_update; $i++){$where_update[$i] = "($where_update[$i])"}}
					my $where = join " OR \n", @where_update;
					push @query2, "UPDATE mysql.db SET \n$set WHERE \n$where\n";
					$build_query = 1;
				}
				
    			my $to = join ', ',@to;
    			my $to1 = join ', ',@to1;
    			for (my $i=0; $i<@db; $i++){
    				unless ($i) {push @query, "GRANT $priv_type \nON $db[0]\.* TO \n$to\n$grant_opt\n"}
    				else {push @query, "GRANT $priv_type \nON $db[$i]\.* TO \n$to1\n$grant_opt\n"}
    			}
				if (@values){
					my $query 	= "INSERT INTO mysql.db \n(Host, Db, User $priv_cols) VALUES ";
					$query		.= join (', ',@values) ."\n";
					push @query2, $query;
				}
			}# create, grant

			push @query, @query3;
			if ($action =~ /create/i) {
				#$query2[0] .= join (', ',@values) ."\n"; # insert into mysql.db
				$query2[1] .= join (', ',@values1) ."\n" if $query2[1];#insert into mysql.user
			}
			if ($build_query) {
				push @query2, "FLUSH PRIVILEGES\n";
			}
			push @query, @query2;
			
			$ident = 1;
		}

		if ($q->param('table_priv')){
			my ($db, @tb);
			if ($q->param('t_db') eq 'OTHER DATABASE')	{
				$db 			  = $q->param('t1_db');
				@tb				  = split ',', $q->param('t1_table');
			}
			else {
				$db 			  = $q->param('t_db');
				@tb				  = $q->param('t_table');
			}
			$db =~ s/^\s*(.*)\s*$/$1/;
			bail_out("Table privileges failed.\nDatabase was not selected.\n\n", $back_) if ($db eq '');
			
			my @privileges		= $q->param('table_t');
			my $grant_opt		= '';
			my $priv_type		= '';
			shift @privileges 		if ($privileges[0]	eq '');
			pop @privileges 		if ($privileges[-1]	eq '');
   			my $ok = 0;
			if ($action =~ /revoke/i){
				if  ($privileges[-1] eq 'GRANT'){
					$privileges[-1] = 'GRANT OPTION';
					$priv_type = join (', ', @privileges)
				}
    			elsif (scalar @privileges == 9){$priv_type = ' ALL'}
    			elsif (scalar @privileges == 0) {$priv_type = ' USAGE'}
    			else {$priv_type = join (', ', @privileges)}

    			my @to = @userlist;
    			my @to1 = @to;
    			my $to = join ', ',@to;
    			my $to1 = join ', ',@to1;
    			if ($tb[0]){
    				$tb[0] =~ s/^\s*(.*)\s*$/$1/; 
    				$ok =1;
    				push @query, "REVOKE $priv_type \nON $db.$tb[0] FROM $to\n";
    				shift @tb
    			}
    			foreach (@tb){
    				s/^\s*(.*)\s*$/$1/;
    				next unless $_;
    				$ok =1;
    				push @query, "REVOKE $priv_type \nON $db.$_ FROM $to1\n "
    			}
			}
			else{
    			if ($privileges[-1] eq 'GRANT') {
    				$grant_opt = ' WITH GRANT OPTION';
    				pop @privileges;
				}
    			if (scalar @privileges == 9){$priv_type = ' ALL'}
    			elsif (scalar @privileges == 0) {$priv_type = ' USAGE'}
    			else {$priv_type = join (', ', @privileges)}
				
    			my @to = @userlist;
    			my @to1 = @to;
    			for (my $i=0; $i<$num; $i++){
    				if ($password[$i] and !$ident){$to[$i] .= " IDENTIFIED BY $password[$i]"} 
    			}
    			my $to = join ', ',@to;
    			my $to1 = join ', ',@to1;
    			if ($tb[0]){
    				$tb[0] =~ s/^\s*(.*)\s*$/$1/; 
    				$ok =1;
    				push @query, "GRANT $priv_type \nON $db.$tb[0] TO $to\n$grant_opt\n";
    				shift @tb
    			}
    			foreach (@tb){
    				s/^\s*(.*)\s*$/$1/;
    				next unless $_;
    				$ok =1;
    				push @query, "GRANT $priv_type \nON $db.$_ TO $to1\n$grant_opt\n "
    			}
				
				
			}			
			bail_out("Table privileges failed.\nTable was not selected.\n\n", $back_) unless $ok;
			$ident = 1;
		}
		if ($q->param('column_priv')){
			my ($db, $tb, @col, $col);
			if ($q->param('c_db') eq 'OTHER DATABASE')	{
				$db 			= $q->param('c1_db');
				$tb				= $q->param('c1_table');
				@col			= split ',', $q->param('c1_column');
			}
			else {
				$db 			= $q->param('c_db');
				$tb				= $q->param('c_table');
				@col			= $q->param('c_column');
			}
			$db =~ s/^\s*(.*)\s*$/$1/;
			bail_out("Column privileges failed.\nDatabase was not selected.\n\n", $back_) if ($db eq '');
			$tb =~ s/^\s*(.*)\s*$/$1/;
			bail_out("Column privileges failed.\nTable was not selected.\n\n", $back_) if ($tb eq '');
			my @privileges		= $q->param('column');
			my $priv_type		= '';
			shift @privileges 		if ($privileges[0]	eq '');
			pop @privileges 		if ($privileges[-1]	eq '');			
			if (scalar @privileges == 0) {bail_out("Error. Column privileges are not selected", $back_)}
			else {$priv_type = join (', ', @privileges)}
			my @to = @userlist;
			for (my $i=0; $i<$num; $i++){
				$to[$i] .= " IDENTIFIED BY $password[$i]" if ($password[$i] and !$ident)
			}
			my $to = join ', ',@to;
			my @col_ = ();
			foreach (@col){
				s/^\s*(.*)\s*$/$1/;
				next unless $_;
				push @col_,$_
			}
			bail_out("Column privileges failed.\nColumn was not selected.\n\n", $back_) unless @col_;
			$col = join ', ',@col_;
			if ($action =~ /revoke/i){push @query, "REVOKE $priv_type ($col) \nON $db.$tb FROM $to\n "}
			else {push @query, "GRANT $priv_type ($col) ON $db.$tb TO \n$to\n "}
			$ident = 1;
		}
	}
	print <<EOT
<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 WIDTH=650>
		<TR><FORM ACTION='$full_url' METHOD=POST>
			<TH ALIGN=LEFT WIDTH=550>
			ADMINISTRATION -> ACCESS CONTROL -> $actionDescr </TH>
			<TH WIDTH=100 ALIGN=RIGHT VALIGN=CENTER>
			<INPUT TYPE=SUBMIT VALUE='Cancel'>
			<INPUT TYPE=HIDDEN NAME='page' VALUE='admin'>
			<INPUT TYPE=HIDDEN NAME='dbname' VALUE='$database'>
			<INPUT TYPE=HIDDEN NAME='func' VALUE='access'>
			</TH></FORM>
		</TR>
</TABLE>
EOT
;
	if ($q->param('create')){
	
        if ($q->param('preview')){
        	undef $back_->{'preview'};
			$back_->{'after_preview'} = '1';
			print qq!\n<FORM ACTION='$full_url' METHOD=POST>!;
			print qq!<P><TABLE><TR><TD></TD><TD>The following queries were generated:!;
			print qq!\n<B><INPUT TYPE=SUBMIT NAME='create' VALUE='Confirm' style='font-weight: bold' TITLE="Proceed with selected options"></B>\n!;
			print qq!\n<INPUT TYPE=SUBMIT VALUE='Back' bold' TITLE="Back to edit privileges"></TD></TR>\n!;
			
			@query = quoteit(@query);
			my $i = 1;
			foreach (@query){
				next unless $_;
				my $rows = 4;
				if (/^[(INSERT INTO mysql\.db)(DELETE)(UPDATE)]/){$rows = $num + 2; if ($rows > 7){$rows = 7}}
				if (/^INSERT INTO mysql.user/){$rows = $num + 1; if ($rows > 6){$rows = 6}}
				elsif(/^\/\*\sERROR/){$rows = 2}
				elsif(/^FLUSH/){$rows = 2}
				elsif (/^(GRANT)|(REVOKE)/i){$rows = 3}
				print qq!\t<TR><TD>$i</TD><TD><TEXTAREA NAME='query' COLS=95 ROWS=$rows  WRAP=OFF>$_</TEXTAREA></TD></TR>\n!;
				$i++;
			}
			print "</TABLE>\n";
			foreach (keys %$back_){
            		print $q->hidden(-name=>$_, -value=>$back_->{$_}, -override=>1),"\n";
			}

			print qq!\n</FORM>!;
			return
        }
		else {
#	my $unregmes = unrgversion();
#	bail_out ($unregmes, $back);
			if ($q->param('after_preview')){@query = $q->param('query')}
			my $i=0; print "<P>"; my $message;
			#$dbh->commit() or bail_out("", $back_);
			#$dbh->{AutoCommit} = 1;
			my $message_ = unrgversion(); $message_ =~ s/\n/<br>/mg; print "<P><B>$message_</B><BR>\n" if $message_;
			print "<B>Result: OK</B>\n\n" unless $message; print qq!\n<FORM ACTION='$full_url' METHOD=POST>!;
			print qq!\n<INPUT TYPE=SUBMIT VALUE='Back' bold' TITLE="Back to privileges"></TD></TR>\n!;
			foreach (keys %$back_){ print $q->hidden(-name=>$_, -value=>$back_->{$_}, -override=>1),"\n";}
			print qq!\n</FORM>!; return
        }
	}
		

	@password = quoteit(@password);
	foreach (@password){
		$hidden_password .= "\t<INPUT TYPE=HIDDEN NAME=\"user_password\" VALUE=\"$_\">\n";
	}
	bail_out("Please select from user list", $back) unless (@userlist);

	@userlist = quoteit(@userlist);
	foreach (@userlist){
		$hidden_userlist .= "\t<INPUT TYPE=HIDDEN NAME=\"userlist\" VALUE=\"$_\">\n";
	}
	my $globs	= 1 if (($q->param('global_priv') or $q->param('global_priv_on')) and !$q->param('global_priv_off'));
	my $dbs	  	= 1 if (($q->param('db_priv') or $q->param('db_priv_on')) and !$q->param('db_priv_off'));
	my $tables	= 1 if (($q->param('table_priv') or $q->param('table_priv_on')) and !$q->param('table_priv_off'));
	my $columns	= 1 if (($q->param('column_priv') or $q->param('column_priv_on')) and !$q->param('column_priv_off'));
	if ($globs) {$hidden_glob = "<INPUT TYPE=HIDDEN NAME='global_priv' VALUE='on'>"}
	if ($dbs) {$hidden_db = "<INPUT TYPE=HIDDEN NAME='db_priv' VALUE='on'>"}
	if ($tables) {$hidden_table = "<INPUT TYPE=HIDDEN NAME='table_priv' VALUE='on'>"}
	if ($columns) {$hidden_column = "<INPUT TYPE=HIDDEN NAME='column_priv' VALUE='on'>"}

	my $d_db			= $q->param('d_db');
	my $t_db			= $q->param('t_db');
	#$t_db				= '' if $t_db eq 'OTHER DATABASE';
	my $c_db			= $q->param('c_db');
	my $dblistref 		= getdblist();
	my @dblist;
	my ($d_dblist, $t_dblist, $c_dblist);
	if ($DBI::err and !$database) {
		$d_dblist	= $q->scrolling_list(
										-name		=> 'd_db',
										-values		=> [''],
										-labels		=> {'' => 'ACCESS DENIED'},
										-size		=> 4,
										-multiple	=>1										
					);
		$t_dblist	= $q->scrolling_list(
										-name		=> 't_db',
										-values		=> [''],
										-labels		=> {'' => 'ACCESS DENIED'},
										-size		=> 1,
					);
		$c_dblist	= $q->scrolling_list(
										-name		=> 'c_db',
										-values		=> [''],
										-labels		=> {'' => 'ACCESS DENIED'},
										-size		=> 1,
					);	
	}
	else {
		@dblist		= @$dblistref;
		unshift		@dblist, '';
		$d_dblist	= $q->scrolling_list(
										-name		=> 'd_db',
										-values		=> \@dblist,
										-size		=> 4,
										-multiple	=>1										
					);
		unshift		@dblist, 'OTHER DATABASE';
		$t_dblist	= $q->scrolling_list(
										-name		=> 't_db',
										-values		=> \@dblist,
										-size		=> 1,
										-default	=> '',
										-onChange	=> 'this.form.submit()'
					);
		$c_dblist	= $q->scrolling_list(
										-name		=> 'c_db',
										-values		=> \@dblist,
										-size		=> 1,
										-default	=> '',
										-onChange	=> 'this.form.submit()'
					);
		}
	my $t_table		= $q->param('t_table');
	my $c_table		= $q->param('c_table');
	my $t_tablelist;
	my $c_tablelist;
	my $T_Table;
	my $T_OtherT;
	my $T_Other_Db;
	my $database_checkbox;
	my $d1_db;
	my ($C_Other_Db, $C_Other_Table, $C_Other_Column);
	if ($t_db and ($t_db ne 'OTHER DATABASE')){
		my @t_tablelist = @{getTablelist($t_db)};
		my $size		= scalar @t_tablelist;
		unshift 		@t_tablelist, '';
		if ($size == 0){
			$t_tablelist = $q->scrolling_list(
		   		  	 			   		-name		=> 't_table',
										-value		=> '',
										-labels		=> {'' => "Table list is empty\n"},
										-size		=> 1
							) ;
		}
		else {
			if ($size > 3) {$size	= 4} else {$size = $size + 1} ;
			$t_tablelist = $q->scrolling_list(
										-name		=> 't_table',
										-values		=> \@t_tablelist,
										-size		=> $size,
										-multiple	=> 1
							);
		}
		$T_Table	=<<EOT
				<TR>
					<TD ALIGN=RIGHT TITLE='Select one or more tables'><B>Table</B></TD>
					<TD TITLE='Select one or more tables'>$t_tablelist</TD>
				</TR>
EOT
;
	}
	elsif ($t_db eq '') {
		$t_tablelist = $q->scrolling_list(
									-name   => 't_table',
									-value  => '',
									-labels  => {'' => "DB is not selected\n"},
									-size	=> 1
					);
		$T_Table	=<<EOT
				<TR>
					<TD ALIGN=RIGHT TITLE='Select a database in the scrolling list above'><B>Table</B></TD>
					<TD TITLE='Select a database in the scrolling list above'>$t_tablelist</TD>
				</TR>
EOT
;
	}
	else {
	
		my $t1_table = $q->textfield(-name=>'t1_table', -size=>15, -title=>'Type table names. (Comma separated)');
		$T_OtherT 			= <<EOT
				<TR>
					<TD ALIGN=RIGHT TITLE='Type table names. (Comma separated)'><I>Tables</I></TD>
					<TD>$t1_table</TD>
				</TR>
EOT
;
		my $t1_db = $q->textfield(-name=>'t1_db', -size=>15, -title=>'Type database name');
		$T_Other_Db			= <<EOT
				<TR>
					<TD ALIGN=RIGHT TITLE='Type database name'><I>Other&nbsp;Db</I></TD>
					<TD>$t1_db</TD>
				</TR>
EOT
;

	
	}
	my @c_tablelist; my $C_Table;
	if ($c_db and ($c_db ne 'OTHER DATABASE')){
		@c_tablelist = @{getTablelist($c_db)};
		unshift 		@c_tablelist, '';
		if (@c_tablelist == 1){
			$c_tablelist = $q->scrolling_list(
		   		  	 			   		-name		=> 'c_table',
										-value		=> '',
										-labels		=> {'' => "Table list is empty\n"},
										-size		=> 1
							);
		}
		else {
			$c_tablelist = $q->scrolling_list(
										-name		=> 'c_table',
										-values		=> \@c_tablelist,
										-size		=> 1,
										-onChange	=> 'this.form.submit()'
							);
		}
		$C_Table = <<EOT
				<TR>
					<TD ALIGN=RIGHT TITLE='Select table'><B>Table</B></TD>
					<TD TITLE='Select table'>$c_tablelist</TD>
				</TR>
EOT
;
	}
	elsif ($c_db eq '') {
		$c_tablelist = $q->scrolling_list(
									-name		=> 'c_table',
									-value		=> '',
									-labels		=> {'' => "DB is not selected\n"},
									-size		=> 1
					);
		$C_Table = <<EOT
				<TR>
					<TD ALIGN=RIGHT TITLE='Select a database in the scrolling list above'><B>Table</B></TD>
					<TD TITLE='Select a database in the scrolling list above'>$c_tablelist</TD>
				</TR>
EOT
;

	}	
	else {
	
		my $c1_db = $q->textfield(-name=>'c1_db',-size=>15, -title=>'Type database name');
		$C_Other_Db = <<EOT
				<TR>
					<TD ALIGN=RIGHT TITLE='Type database name'><I>Other&nbsp;Db</I></TD>
					<TD>$c1_db</TD>
				</TR>
EOT
;
		my $c1_table = $q->textfield(-name=>'c1_table',-size=>15, -title=>'Type table name');
		$C_Other_Table = <<EOT
				<TR>
					<TD ALIGN=RIGHT TITLE='Type table name'><I>Table</I></TD>
					<TD>$c1_table</TD>
				</TR>
EOT
;
		my $c1_column = $q->textfield(-name=>'c1_column',-size=>15, -title=>'Type column names. (Comma separated)');
		$C_Other_Column = <<EOT
				<TR>
					<TD ALIGN=RIGHT TITLE='Type column names. (Comma separated)'><I>Columns</I></TD>
					<TD>$c1_column</TD>
				</TR>
EOT
;
	
	}	
	
	my $columnlist;
	my $column		= $q->param('column');
	if ($c_db ne 'OTHER DATABASE'){
		my $title;
		if ($c_table and belongs(\@c_tablelist, $c_table)) {
			my @columnlist = ();
			my ($sth, $res) = prepare_execute("DESCRIBE $c_db.$c_table",$_[0]);
			while (my @row = $sth->fetchrow_array){
				push @columnlist, $row[0];
			}
			$sth->finish;
			my $size = scalar @columnlist;
			unshift @columnlist,'';
			if ($size > 5) {$size	= 6} else {$size = $size + 1} ;
			$columnlist = $q->scrolling_list(
									-name		=> 'c_column',
									-values		=> \@columnlist,
									-size		=> $size,
									-multiple	=> 1
						);
			$title = "Select one or more columns."
		}
		else {
			$columnlist = $q->scrolling_list(
									-name		=> 'c_column',
									-value		=> '',
									-labels		=> {'' => "Table is not selected\n"},
									-size		=> 1
					);
			$title = 'Select a table in the scrolling list above';
		}
		$columnlist = <<EOT
				<TR>
					<TD ALIGN=RIGHT TITLE='$title'><B>Column</B></TD>
					<TD TITLE='$title'>$columnlist</TD>
				</TR>
EOT
;
		
	}
	my $global_priv 	= $globs	? 'global_priv_off' : 'global_priv_on';
	my $db_priv			= $dbs		? 'db_priv_off'	 	: 'db_priv_on';
	my $table_priv		= $tables	? 'table_priv_off'	: 'table_priv_on';
	my $column_priv		= $columns	? 'column_priv_off'	: 'column_priv_on';

	my $global_checkbox = $q->scrolling_list(
		  					-name		=> 'global',
							-values		=> $global_values,
							-size		=>15,
							-multiple	=>1
							) if ($globs);
	if ($dbs) {
		$database_checkbox = $q->scrolling_list(
		  					-name		=> 'database',
							-values		=> $database_values,
							-size		=>11,
							-multiple	=>1
							) ;
		$d_dblist 		=	<<EOT	
					<TR>
						<TD ALIGN=RIGHT TITLE='Select one or more databases'><B>Db</B></TD>
						<TD TITLE='Select one or more databases'>$d_dblist</TD>
					</TR>
EOT
;
		my $d1db = $q->textfield(-name=>'d1_db', -size=>15, -title=>"Type database names (comma separated).\nThe variable `{user}' will be substituted\nwith user name for each user." );
		$d1_db			= 	<<EOT
					<TR>
						<TD ALIGN=RIGHT TITLE="Type database names (comma separated).\nThe variable `{user}' will be substituted\nwith user name for each user."><I>Other&nbsp;Db</I></TD>
						<TD>$d1db</TD>
					</TR>
EOT
;
	} else {$d_dblist = ''; }
	my $table_checkbox_t;
	if ($tables){
		$table_checkbox_t = $q->scrolling_list(
		  					-name		=> 'table_t',
							-values		=> $table_values,
							-size		=>11,
							-multiple	=>1
							);
		$t_dblist = <<EOT
			<TABLE>
				<TR>
					<TD ALIGN=RIGHT TITLE='Select database'><INPUT TYPE=SUBMIT VALUE='>' TITLE='Reload page to apply changes'>&nbsp;<B>Db</B></TD>
					<TD TITLE='Select database'>$t_dblist</TD>
				</TR>
				$T_Other_Db
				$T_Table
				$T_OtherT
				<TR HEIGHT=6>
					<TD HEIGHT=6></TD>
					<TD HEIGHT=6></TD>
				</TR>
				<TR>
					<TD ALIGN=RIGHT TITLE='Choose table privileges'>&nbsp;</TD>
					<TD TITLE='Choose table privileges'>$table_checkbox_t</TD>
				</TR>
			</TABLE>
EOT
;
	}
	else {$t_dblist = ''}
	my $column_checkbox;
	if ($columns){
		$column_checkbox = $q->scrolling_list(
		  					-name		=> 'column',
							-values		=> $column_values,
							-size		=> 4,
							-multiple	=> 1
							) ;
		$c_dblist = <<EOT
				<TABLE BORDER=0>
				<TR>
					<TD ALIGN=RIGHT TITLE='Select database'><INPUT TYPE=SUBMIT VALUE='>' TITLE='Reload page to apply changes'>&nbsp;<B>Db</B></TD>
					<TD TITLE='Select database'>$c_dblist</TD>
				</TR>
				$C_Other_Db
				$C_Table
				$C_Other_Table
				$columnlist
				$C_Other_Column
				<TR HEIGHT=6>
					<TD HEIGHT=6></TD>
					<TD HEIGHT=6></TD>
				</TR>
				<TR>
					<TD ALIGN=RIGHT TITLE='Choose column privileges'>&nbsp;</TD>
					<TD TITLE='Choose column privileges'>$column_checkbox</TD>
				</TR></TABLE>
EOT
;
	
	}
	else {$c_dblist = ''}
	my $preview = $q->checkbox(	-name=>'preview', -checked=>1, -title=>'Check to preview queries before execution (recommended)');
	my $action_bar	= <<EOT
	<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>
		<TR>
			<TD ALIGN=LEFT>
			<INPUT TYPE=RESET TITLE='Reset'>&nbsp;&nbsp;
			<INPUT TYPE=SUBMIT VALUE='Reload' TITLE='Reload this page'>&nbsp;&nbsp;<B>
			<INPUT TYPE=SUBMIT NAME='create' VALUE='$action' style='font-weight: bold' TITLE="Proceed with selected options"></B>
			&nbsp;&nbsp;&nbsp;&nbsp;<I>Preview queries</I>&nbsp;$preview</TD>
		</TR>
		<TR HEIGHT=4><TD HEIGHT=4></TD</TR>
	</TABLE>
EOT
	if ($globs or $dbs or ($tables and $t_db) or ($columns and ($c_db and $c_table)) or $C_Other_Db);

print <<EOT
<!-- USER ACCOUNTS PROCEDURE STARTS HERE -->

	


<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>
	<TR HEIGHT=10><TD ALIGN=LEFT HEIGHT=10></TD></TR>
	<TR>
		<TD>
	<FORM ACTION='$full_url' METHOD=POST>

$action_bar	
	<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 BGCOLOR='#AAAAAA'><!-- PRIVILEGES -->

		<TR><TD BGCOLOR='#AAAAAA'><!-- SET OF GLOBAL PRIVILEGES -->
			<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=1 BGCOLOR='#AAAAAA'>
				<TR><TD BGCOLOR='#CCCCCC'><P TITLE='Check to assign Global Privileges'>&nbsp;<B><INPUT TYPE=SUBMIT VALUE="Global privileges" NAME=$global_priv	style='font-weight: bold; width=150px' TITLE='Click to show/hide privileges' SHADOW=0 BORDER=2>&nbsp;</B></TD>
					<TD BGCOLOR='#CCCCCC'><P TITLE='Check to assign Database Privileges'>&nbsp;<B><INPUT TYPE=SUBMIT   VALUE="Database privileges"	NAME=$db_priv style='font-weight: bold; width=150px' TITLE='Click to show/hide privileges'>&nbsp;</B></TD>
					<TD BGCOLOR='#CCCCCC'><P TITLE='Check to assign Table Privileges'>&nbsp;<B><INPUT TYPE=SUBMIT   VALUE="Table privileges" NAME=$table_priv	style='font-weight: bold; width=150px' TITLE='Click to show/hide privileges'>&nbsp;</B></TD>
					<TD BGCOLOR='#CCCCCC'><P TITLE='Check to assign Column Privileges'>&nbsp;<B><INPUT TYPE=SUBMIT VALUE="Column privileges" NAME=$column_priv	style='font-weight: bold; width=150px' TITLE='Click to show/hide privileges'>&nbsp;</B></TD>
				</TR>
				<TR BGCOLOR='#AAAAAA'>
					<TD VALIGN=TOP BGCOLOR='#CCCCCC' ALIGN=CENTER TITLE='Choose Global Privileges'><P>&nbsp;<BR><!-- GLOBAL PRIVILEGES -->
$global_checkbox
				</TD>
				<TD VALIGN=TOP BGCOLOR='#CCCCCC'><!-- DATABASE PRIVILEGES -->
				<TABLE BORDER=0>
					$d_dblist
					$d1_db
					<TR HEIGHT=6>
						<TD HEIGHT=6></TD>
						<TD HEIGHT=6></TD>
					</TR>
					<TR>
						<TD ALIGN=RIGHT TITLE='Choose Database Privileges'>&nbsp;</TD>
						<TD TITLE='Choose Database Privileges'>$database_checkbox</TD>
					</TR>
				</TABLE><P><CENTER>

				</CENTER></TD>
				<TD VALIGN=TOP BGCOLOR='#CCCCCC'><P><!-- TABLE PRIVILEGES -->
				$t_dblist
				&nbsp;
		<!--	<TABLE>
				<TR><TD><B>Table priv.</B></TD><TD><B>Column priv.</B></TD></TR>
				<TR><TD VALIGN=TOP><P><BR>table_checkbox_t</TD><TD VALIGN=TOP>table_checkbox_c</TD></TR>
				</TABLE> -->
				

				</TD>
				<TD VALIGN=TOP BGCOLOR='#CCCCCC'><P><!-- COLUMN PRIVILEGES -->
				$c_dblist
				&nbsp;
				</TD>
			</TR>	
			</TABLE>
		</TR></TD>
		
		
		
			
	</TABLE>
	
	<INPUT TYPE=HIDDEN NAME='page' VALUE='admin'>
	<INPUT TYPE=HIDDEN NAME='func' VALUE='access'>
	<INPUT TYPE=HIDDEN NAME='dbname' VALUE='$database'>
	<INPUT TYPE=HIDDEN NAME='action' VALUE='$action'>
	$hidden_glob
	$hidden_db
	$hidden_table
	$hidden_column
	$hidden_userlist
	$hidden_password
</FORM>
	</TD></TR>
	</TABLE><BR>

<!-- USER access PROCEDURE STARTS HERE -->
EOT
;
	print "\n\n<TABLE><TR><TD><B>USER LIST:</B></TD></TR>\n";
	foreach (@userlist){print "\t<TR><TD><B>$_</B></TD></TR>\n"}
	print "</TABLE>\n";
  	return
}
sub setup {
	if ($q->param('cancel')){
		$page='';
		logout();
		return
	}
	if ($q->param('save')){
		sub exitonerror{
			print 	$q->header();
			&startpage();
			print qq!<FORM ACTION="$full_url" METHOD=POST>\n!;
			printHeaderTable({name=>'SETUP'});
			print <<EOT
<FONT COLOR='#FF0000'>$_[0]</FONT><BR>
		<P><INPUT TYPE=SUBMIT VALUE="BACK">
		<INPUT TYPE=HIDDEN NAME="page" VALUE="setup" >
		</FORM>
</TD></TR></TABLE>
</BODY>
</HTML>
EOT
;
exit 0
		}
		my @config;
		my ($userName, $Password, $type) = $q->cookie('mdm_setup');
		unless (open FH, "$configFile") {exitonerror ("$configFile, $!") }
		flock (FH,2) unless $WIN32;
		while(<FH>){
			push @config, $_;
		}
		flock (FH,8) unless $WIN32;
		close FH;
		my $i=0;
		unless ($q->param('new_admin')){
			my $config = readconfig(\@config);
			if (($config->{userName} ne $userName) or ($config->{Password} ne $Password)){
				exitonerror("Login incorrect!")
			}
			
		}
		my $err_message;
		if($q->param('setPW')){
			unless ($q->param('userName') =~ /^\w+$/){
				$err_message = "User name can not be blank and must consist of alphanumeric characters only.<BR>\n";
			}
			unless ($q->param('Password') =~ /^\w+$/){
				$err_message .= "Password can not be blank and must consist of alphanumeric characters only.<BR>\n";
			}
			unless ($q->param('Password') eq $q->param('Password_')){
				$err_message .= "Password was incorrect.<BR>\n"
			}
		}
		foreach(@config){
			if (/^\s*#/ or /^\s*$/){$i++; next}
			s/^\s*(\S+.*\S*)\s*$/$1/;
    		if (/^userName\b/){
				if ($q->param('setPW') and !$err_message){
					$config[$i] = 'userName = '.$q->param('userName')."\n" ;
				}
				else {$config[$i] .= "\n" }
			}
			elsif(/^Password\b/){
				if ($q->param('setPW') and !$err_message){
						my $pw =  crypt $q->param('Password'), $q->param('userName');
						$config[$i] = "Password=$pw\n";
				}
				else {$config[$i] .= "\n";}
			}
			elsif(/^(\w*\b)/){
				$config[$i] = "$1 = ".$q->param($1)."\n";
			}
			$i++;
		}
		unless (open FH, ">$configFile") {exitonerror ("$configFile, $!") }
		else {
			flock (FH,2) unless $WIN32;
			foreach (@config) {print FH }
			flock (FH,8) unless $WIN32;
			close FH;
		}
		if ($err_message){
			$err_message = "User name and password were not changed.<P>\n$err_message<BR>\n";
			exitonerror($err_message)
		}
		
		$page='';
		logout();
		return
	}
	#print 	$q->header();
	if ($q->param('login')){
		my $pw = crypt $q->param('Password'),$q->param('userName');
		my $cookies = $q->cookie(	
							-name=>'mdm_setup',
    						-value=>[$q->param('userName'), $pw, 'glob'],
    						-secure=>0
    						);
		print 	$q->header(-cookie=>$cookies, -expires=>0);
	}
	else {print 	$q->header()}
	&startpage();
	print qq!<FORM ACTION="$full_url" METHOD=POST>\n!;
	printHeaderTable({name=>'SETUP'});
	my @config;
	my ($user_password,$config, $zip_CHECKED, $gzip_CHECKED);
	if (-e $configFile){
		open FH, $configFile or die $!;
		flock (FH,2) unless $WIN32;
		while(<FH>){
			push @config, $_;
		}
		flock (FH,8) unless $WIN32;
		close FH;
		$config 		= readconfig(\@config);
	}
	else {
		@config = @{config()};
		unless (open FH, ">$configFile") {print "<FONT COLOR='#FF0000'>$configFile, $!</FONT><BR>" }
		else {
			flock (FH,2) unless $WIN32;
			foreach (@config) {print FH "$_\n"}
			flock (FH,8) unless $WIN32;
			close FH;
			$config 		= readconfig(\@config);
		}
	}
	my $new_admin;
	my $printPopUp_CHECKED 	= 'CHECKED' if ($config->{printPopUp} > 0);
	my $allowZIP_CHECKED	= 'CHECKED' if ($config->{allowZIP} > 0);
	my $allowGZIP_CHECKED	= 'CHECKED' if ($config->{allowGZIP} > 0);
	if ($config->{compressCommand} eq 'zip'){$zip_CHECKED = 'CHECKED'}
	elsif ($config->{compressCommand} eq 'gzip'){$gzip_CHECKED = 'CHECKED'}
	
	if ($config->{userName}){
		unless ($q->param('login')){
			print <<EOT
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
	<TR>
		<TD WIDTH=100 HEIGNT=30><P>&nbsp;</TD>
		<TD><P>Admin Name&nbsp;</TD>
		<TD><P><INPUT TYPE=TEXT NAME="userName" SIZE=25>&nbsp;</TD>
	</TR>	
	<TR>
		<TD WIDTH=100 HEIGNT=10><P>&nbsp;</TD>
		<TD HEIGNT=10><P>&nbsp;</TD>
		<TD HEIGNT=10><P>&nbsp;</TD>
	</TR>	
	<TR>
		<TD WIDTH=100 HEIGNT=30><P>&nbsp;</TD>
		<TD><P>Password&nbsp;</TD>
		<TD><P><INPUT TYPE=PASSWORD NAME="Password" SIZE=25>&nbsp;</TD>
	</TR>
	<TR>
		<TD WIDTH=100 HEIGNT=10><P>&nbsp;</TD>
		<TD HEIGNT=10><P>&nbsp;</TD>
		<TD HEIGNT=10><P>&nbsp;</TD>
	</TR>	
	<TR>
		<TD WIDTH=100 HEIGNT=30><P>&nbsp;</TD>
		<TD><P>&nbsp;</TD>
		<TD><P><INPUT TYPE=SUBMIT NAME="login" VALUE="SUBMIT" SIZE=30>&nbsp;</TD>
	</TR>
</TABLE>
<INPUT TYPE=HIDDEN NAME="page" VALUE="setup">
</FORM>
</TD></TR></TABLE>
</BODY>
</HTML>
EOT
;
			return
		}
		my $pw = crypt $q->param('Password'), $q->param('userName');
		if (($config->{userName} ne $q->param('userName')) or ($pw ne $config->{Password})){
			
			print <<EOT
		<FONT COLOR='#FF0000'><B>INCORRECT USER NAME OR PASSWORD</B></FONT><P>
		<P><INPUT TYPE=SUBMIT VALUE="BACK">
		<INPUT TYPE=HIDDEN NAME="page" VALUE="setup">
		</FORM>
</TD></TR></TABLE>
</BODY>
</HTML>


EOT
;
	return
		}

		$user_password 	= "CHANGE&nbsp;USER&nbsp;NAME&nbsp;AND&nbsp;PASSWORD&nbsp;";
		$new_admin		= '';
	}

	else {
		$user_password 	= "CREATE&nbsp;ADMIN&nbsp;USER&nbsp;";
		$new_admin		= '1';
	}
	foreach (keys %{$config}){$config->{$_} = quoteit $config->{$_}}	
	print <<EOT
                    
                    <TABLE BORDER=0 BGCOLOR='#CCCCCC' CELLPADDING=1 CELLSPACING=2 WIDTH=650>
						<TR>
							<TD ALIGN=RIGHT><P>
<TABLE BORDER=0 BGCOLOR='#AAAAAA' CELLPADDING=1 CELLSPACING=0><TR><TD>		
					<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2 BGCOLOR='#CCCCCC'>
						<TR><TD COLSPAN=2><P><INPUT TYPE=CHECKBOX NAME='setPW' TITLE="Check to submit user name and password">&nbsp;<B>$user_password</B></TD>
						</TR>
						<TR>
							<TD><P>User Name:</TD>
							<TD>
								<P><INPUT TYPE=TEXT NAME="userName" VALUE="" SIZE=20 
								TITLE="Admin user name.\nOnly alphanumeric characters are allowed">&nbsp;
							</TD>
						</TR>
						<TR>
							<TD><P>Password:</TD>
							<TD>
								<P><INPUT TYPE=PASSWORD NAME="Password" VALUE="" SIZE=20 
								TITLE="Password.\nOnly alphanumeric characters are allowed">&nbsp;
							</TD>
						</TR>
						<TR>
							<TD><P>Confirm Password:</TD>
							<TD>
								<P><INPUT TYPE=PASSWORD NAME="Password_" VALUE="" SIZE=20 
								TITLE="Confirm Password.\nOnly alphanumeric characters are allowed">&nbsp;
							</TD>
						</TR>
					</TABLE></TD></TR></TABLE>
							</TD>
						</TR>
                        <TR>
                            <TD BGCOLOR='#AAAAAA'>
                                <TABLE BORDER=0 WIDTH=100% BGCOLOR='#CCCCCC' CELLPADDING=2 CELLSPACING=0>
                                    <TR>
                                        <TD WIDTH="48%"><P><B>PARAMETERS</B></TD>
                                        <TD WIDTH="51%"><P><B>DESCRIPTION</B></TD>
                                    </TR>
                                </TABLE>
                            </TD>
                        </TR>
                        <TR>
                            <TD BGCOLOR='#AAAAAA'><P>
                                <TABLE BORDER=0 WIDTH=100% BGCOLOR='#CCCCCC' CELLPADDING=2 CELLSPACING=0>
                                    <TR>
                                        <TD WIDTH="48%"><P>Home page URL:<BR>
                                        <INPUT TYPE=TEXT NAME="homeURL" VALUE="http://www.edatanew.com" SIZE=32 
										TITLE="URL of your Home Page. For example,\n http://www.edatanew.com/index.html\nor ../index.html" >&nbsp;</TD>
                                        <TD WIDTH="51%"><P>Your home page URL. </TD>
                                    </TR>
                                </TABLE>
                            </TD>
                        </TR>
                        <TR>
                            <TD BGCOLOR='#AAAAAA'>
                                <TABLE BORDER=0 WIDTH=100% BGCOLOR='#CCCCCC' CELLPADDING=2 CELLSPACING=0>
                                    <TR>
                                        <TD WIDTH="48%" HEIGHT=16><P>Help directory URL:<BR>
                                        <INPUT TYPE=TEXT NAME="helpURL" VALUE="$config->{helpURL}" SIZE=32 
										TITLE="URL of 'help' directory. For example,\nhttp://www.edatanew.com/help\nor  ../help">&nbsp;</TD>
                                        <TD WIDTH="51%"><P>URL of directory where 'help' files are installed</TD>
                                    </TR>
                                </TABLE>
                            </TD>
                        </TR>
                        <TR>
                            <TD BGCOLOR='#AAAAAA'>
                                <TABLE BORDER=0 WIDTH=100% BGCOLOR='#CCCCCC' CELLPADDING=2 CELLSPACING=0>
                                    <TR>
                                        <TD WIDTH="48%" HEIGHT=16><P>MYSQL CONNECTION PARAMETERS<BR><BR>Default socket<BR>
										<INPUT TYPE=TEXT NAME="defaultSocket" VALUE="$config->{defaultSocket}" SIZE=32 
										TITLE="These are connection parameters of the most frequently used Mysql server. If defined as default, it will be not necessarily to type them at login page.">
                                        <BR>Default host<BR>
                                        <INPUT TYPE=TEXT NAME="defaultHost" VALUE="$config->{defaultHost}" SIZE=32 
										TITLE="These are connection parameters of the most frequently used Mysql server. If defined as default, it will be not necessarily to type them at login page.">
                                        <BR>Default port number<BR>
                                        <INPUT TYPE=TEXT NAME="defaultPort" VALUE="$config->{defaultPort}" SIZE=16 
										TITLE="These are connection parameters of the most frequently used Mysql server. If defined as default, it will be not necessarily to type them at login page.">&nbsp;</TD>
                                        <TD WIDTH="51%"><P>Default socket, Default host and Default port are used when the field 'HOST:PORT' is blank (login page).<BR>&nbsp;</TD>
                                    </TR>
                                </TABLE>
                            </TD>
                        </TR>
                        <TR>
                            <TD BGCOLOR='#AAAAAA'>
                                <TABLE BORDER=0 WIDTH=100% BGCOLOR='#CCCCCC' CELLPADDING=2 CELLSPACING=0>
                                    <TR>
                                        <TD WIDTH="100%" COLSPAN=2><P><I>mysql</I> CLIENT PARAMETERS (Restore databases)</TD>
                                   </TR>
                                    <TR>
                                        <TD WIDTH="48%" HEIGHT=16><P>Path to binary <i>mysql</i> client<BR>
										<INPUT TYPE=TEXT NAME="mysql" VALUE="$config->{mysql}" SIZE=32 MAXLENGTH=200
										TITLE="Path to binary mysql client.\nFor example,\n for Windows: c:\\mysql\\bin\\mysql.exe\n for Unix/Linux: /usr/local/mysql/bin/mysql">
										<TD WIDTH="51%"><P>Path to binary <i>mysql</i> client</TD>
									</TR>
									<TR>
                                        <TD WIDTH="48%" ><P>Other parameters<BR>
                                        <INPUT TYPE=TEXT NAME="otherMysql" VALUE="$config->{otherMysql}" SIZE=32 MAXLENGTH=200
										TITLE="You can use some additional parameters in mysql client call syntax">
                                        <TD WIDTH="51%"><P>Additional parameters used to call <i>mysql</i><br>
										For example 'SILENT' AND 'COMPRESS': -s -C</TD>
                                    </TR>
                                </TABLE>
                            </TD>
                        </TR>
                        <TR>
                            <TD BGCOLOR='#AAAAAA'>
                                <TABLE BORDER=0 WIDTH=100% BGCOLOR='#CCCCCC' CELLPADDING=2 CELLSPACING=0>
                                    <TR>
                                        <TD WIDTH="48%" HEIGHT=16><P>Path to user directory:<BR>
                                        <INPUT TYPE=TEXT NAME="userDirectory" VALUE="$config->{userDirectory}" SIZE=32 MAXLENGTH=200
										TITLE="Path to user directory.\nFor example,\nfor Windows: C:\\MYDOCU~1\\DATA\\USR\nfor Unix/Linux: /home/mydirname/usr">&nbsp;</TD>
                                        <TD WIDTH="51%"><P>Path to directory where user subdirectories are stored.</TD>
                                    </TR>
                                </TABLE>
                            </TD>
                        </TR>
                        <TR>
                            <TD BGCOLOR='#AAAAAA'>
                                <TABLE BORDER=0 WIDTH=100% BGCOLOR='#CCCCCC' CELLPADDING=2 CELLSPACING=0>
                                    <TR>
                                        <TD WIDTH="48%" HEIGHT=16><P>Max. total size of backup files (per user): <BR>
                                        <INPUT TYPE=TEXT NAME="backupMax" VALUE="$config->{backupMax}" SIZE=10 MAXLENGTH=10
										TITLE="Maximum total size of backup files per user [kilobytes].\nZero value or blank field means 'Unlimited'">&nbsp;[kbyte] </TD>
                                        <TD WIDTH="51%"><P>Maximum allowed total size of bacup files for each user (in kilobytes)</TD>
                                    </TR>
                                </TABLE>
                            </TD>
                        </TR>
                        <TR>
                            <TD BGCOLOR='#AAAAAA'>
                                <TABLE BORDER=0 WIDTH=100% BGCOLOR='#CCCCCC' CELLPADDING=2 CELLSPACING=0>
                                    <TR>
                                        <TD WIDTH="48%" HEIGHT=16><P>Max. total size of SQL scripts (per user):<BR>
                                        <INPUT TYPE=TEXT NAME="SQLMax" VALUE="$config->{SQLMax}" SIZE=10 MAXLENGTH=10
										TITLE="Maximum total size of SQL scripts per user [kilobytes].\nZero value or blank field means 'Unlimited'">&nbsp;[kbyte]</TD>
                                        <TD WIDTH="51%"><P>Maximum allowed total size of SQL scripts for each user (in kilobytes)</TD>
                                    </TR>
                                </TABLE>
                            </TD>
                        </TR>
                        <TR>
                            <TD BGCOLOR='#AAAAAA'>
                                <TABLE BORDER=0 WIDTH=100% BGCOLOR='#CCCCCC' CELLPADDING=2 CELLSPACING=0>
                                    <TR>
                                        <TD WIDTH="48%" HEIGHT=16><P>Administrator email:<BR>
                                        <INPUT TYPE=TEXT NAME="adminEmail" VALUE="$config->{adminEmail}" SIZE=32 MAXLENGTH=200
										TITLE="Put your administrator email address here">&nbsp;</TD>
                                        <TD WIDTH="51%"><P>Email address used in error messages</TD>
                                    </TR>
                                </TABLE>
                            </TD>
                        </TR>
                        <TR>
                            <TD BGCOLOR='#AAAAAA'>
                                <TABLE BORDER=0 WIDTH=100% BGCOLOR='#CCCCCC' CELLPADDING=2 CELLSPACING=0>
                                    <TR>
                                        <TD WIDTH="48%" HEIGHT=16><P>Compressing method:<BR>
                                        <INPUT TYPE=RADIO $zip_CHECKED NAME="compressCommand" VALUE="zip"
										TITLE="It defines, which method 'ZIP' or 'GZIP' will be used in 'Compress File' command">&nbsp;zip&nbsp;
                                        <INPUT TYPE=RADIO $gzip_CHECKED NAME="compressCommand" VALUE="gzip"
										TITLE="It defines, which method 'ZIP' or 'GZIP' will be used in 'Compress File' command"> gzip</TD>
                                        <TD WIDTH="51%"><P>Compressing method used by "Compress" command</TD>
                                    </TR>
                                </TABLE>
                            </TD>
                        </TR>
                        <TR>
                            <TD BGCOLOR='#AAAAAA'>
                                <TABLE BORDER=0 WIDTH=100% BGCOLOR='#CCCCCC' CELLPADDING=2 CELLSPACING=0>
                                    <TR>
                                        <TD WIDTH="48%" HEIGHT=16><P>
                                        <INPUT TYPE=CHECKBOX NAME="allowZIP" VALUE="1" $allowZIP_CHECKED
										TITLE="Check to allow ZIP method to compress backup files">&nbsp;Allow ZIP </TD>
                                        <TD WIDTH="51%"><P>Uncheck if zip utility is not installed</TD>
                                    </TR>
                                </TABLE>
                            </TD>
                        </TR>
                        <TR>
                            <TD BGCOLOR='#AAAAAA'>
                                <TABLE BORDER=0 WIDTH=100% BGCOLOR='#CCCCCC' CELLPADDING=2 CELLSPACING=0>
                                    <TR>
                                        <TD WIDTH="48%" HEIGHT=16><P>
                                        <INPUT TYPE=CHECKBOX NAME="allowGZIP" VALUE="1" $allowGZIP_CHECKED
										TITLE="Check to allow GZIP method to compress backup files">&nbsp;Allow GZIP </TD>
                                        <TD WIDTH="51%"><P>Uncheck if gzip utility is not installed</TD>
                                    </TR>
                                </TABLE>
                            </TD>
                        </TR>
                        <TR>
                            <TD BGCOLOR='#AAAAAA'>
                                <TABLE BORDER=0 WIDTH=100% BGCOLOR='#CCCCCC' CELLPADDING=2 CELLSPACING=0>
                                    <TR>
                                        <TD WIDTH="48%" HEIGHT=16><P>ZIP call syntax:<BR>
                                        <INPUT TYPE=TEXT NAME="zipSyntax" VALUE="$config->{zipSyntax}" SIZE=16 
										TITLE="For Windows command line utility 'Wzzip' syntax is: 'Wzzip -Pr' \nFor Unix/Linux zip utility: 'zip -qj'">&nbsp;</TD>
                                        <TD WIDTH="51%"><P>Syntax used to call ZIP utility.</TD>
                                    </TR>
                                </TABLE>
                            </TD>
                        </TR>
                        <TR>
                            <TD BGCOLOR='#AAAAAA'>
                                <TABLE BORDER=0 WIDTH=100% BGCOLOR='#CCCCCC' CELLPADDING=2 CELLSPACING=0>
                                    <TR>
                                        <TD WIDTH="48%" HEIGHT=16><P>Syntax to suppress the output from ZIP utility<BR>
                                        <INPUT TYPE=TEXT NAME="zipLog" VALUE="$config->{zipLog}" SIZE=16 
										TITLE="In the case of Windows command line ZIP utility 'Wzzip' this syntax looks like: 1>NUL">&nbsp;</TD>
                                        <TD WIDTH="51%"><P>Some command lline ZIP programs print output information that must be 
										suppressed using this syntax.</TD>
                                    </TR>
                                </TABLE>
                            </TD>
                        </TR>
                        <TR>
                            <TD BGCOLOR='#AAAAAA'>
                                <TABLE BORDER=0 WIDTH=100% BGCOLOR='#CCCCCC' CELLPADDING=2 CELLSPACING=0>
                                    <TR>
                                        <TD WIDTH="48%" HEIGHT=16><P>
                                        <INPUT TYPE=CHECKBOX NAME="printPopUp" VALUE="1" $printPopUp_CHECKED 
										TITLE="Check to enable print pop up window">&nbsp;Print Pop Up </TD>
                                        <TD WIDTH="51%"><P>Unchech if your browser does not support JavaScript function window.print(), or you do not want print pop up window to appear </TD>
                                    </TR>
                                </TABLE>
                            </TD>
                        </TR>
						<TR>
							<TD ALIGN=RIGHT>
							<INPUT TYPE=SUBMIT NAME="save" VALUE="SAVE AND EXIT">
							<INPUT TYPE=SUBMIT NAME="cancel" VALUE="CANCEL">
							<INPUT TYPE=RESET>
							</TD>
						</TR>
                    </TABLE>
					<INPUT TYPE=HIDDEN NAME="page" VALUE="setup">
					<INPUT TYPE=HIDDEN NAME='new_admin' VALUE='$new_admin'>

</FORM>
</TD></TR></TABLE>
</BODY>
</HTML>

EOT
;
	
}

sub getdatanstructure {
	my $hashref			= shift;
	my @tablelist 		= @{$hashref->{tablelist}} if defined $hashref->{tablelist};
	my @newtablelist	= @{$hashref->{newtablelist}} if defined $hashref->{newtablelist};
	my $include			= $hashref->{include};
	my $dropifexists	= $hashref->{dropifexists};
	my $back			= $hashref->{back};
	my $comments		= $hashref->{comments};
	my @locks;
	my $filecontent		= '';
	if ($hashref->{lock}){
		my $query = "LOCK TABLES";
		foreach (@tablelist){
			push @locks, " $_ READ";
		}
		$query .= join(',',@locks);
		$dbh->do($query) or bail_out("Cannon lock!",$back);
	}
	my $j	= 0;
	foreach my $table (@tablelist) {
		$filecontent .= "\n#\tTABLE $table \n" if $comments;
		$filecontent .= getCreateTableSQL([$table],$dropifexists, $hashref->{newtablelist}) unless ($include eq 'data');
		unless ($include eq 'structure') {
    		$filecontent .= "\n#\tDUMPING DATA\n\n" if $comments;	
    
    		my $query 		= "SELECT * FROM $table";
    		my ($sth, $res) = prepare_execute($query,$back);
			$table			= $newtablelist[$j] if $newtablelist[$j];
    		while (my @row = $sth->fetchrow_array){
    			$filecontent .= "INSERT INTO $table VALUES ( ";
    			my @rowdata;
    			for (my $i = 0; $i < @row; $i++) {
    				push @rowdata, $dbh->quote($row[$i]);
    			}
    			$filecontent .= join (', ', @rowdata);
    			$filecontent .= ");\n";

    		}
    		$sth->finish;
		}
		$filecontent .= "\n#--------------------------------------------------------\n" if $comments;
		$j++;
	}
	$filecontent .= "#\tEND OF FILE\n" if ($filecontent and $comments);
	if ($hashref->{lock}){
		$dbh->do("UNLOCK TABLES") or bail_out("Cannot unlock!", $back);
	}
	return $filecontent
}
sub config {
	my $config = <<EOT
#######################################################################################
# 				MYSQL DATA MANAGER CONFIGURATION FILE
#######################################################################################
# User name and Password used to access this file.
# If you forgot the user name or password, you should leave these value blank, like this:
# userName = 
# Password = 
# in order to access the SETUP page
userName = 
Password = 

# Home page URL.
# This URL is used in hyperlink "HOME". It can be any internet address.
# Example:
# homeURL = http://www.mydomain.com/index.html
# or 
# homeURL = ../index.html
# or even
# homeURL = ../
homeURL = 

# Help directory URL
# Example:
# helpURL = ../help
# or
# helpURL = http://www.mydomain.com/help
helpURL = ../help

# MySQL connection parameters
# These parameters are used as default when the field 'HOST:PORT' is left blank
# Under Linux/Unix default socket file name may look like:
# defaultSocket =  /tmp/mysql.socket
# default host name may be:
# defaultHost = edatanew.com
# or 
# defaultHost = localhost
defaultSocket = 
defaultHost = localhost
defaultPort = 3306

# Path to mysql Client (binary).
# Under Linux/Unix it may be:
# mysql = /usr/local/mysql/bin/mysql
# under Windows:
# c:\\mysql\\bin\\mysql.exe
mysql = /usr/local/mysql/bin/mysql

# Other parameters used to call mysql client
# For example, set 'SILENT' AND 'COMPRESS': 
# otherMysql = -s -C
# for more options run 'mysql -?' in command line.
otherMysql = 


# Path to user directory.
# This is a directory where user subdirectory are created and stored.
# These subdirectories are used to store SQL scripts and backup files.
# Under Linux/Unix it should be something like this:
# userDirectory = /home/directoryname/data/usr
# Under Windows:
# userDirectory = C:\\MYDOCU~1\\MYSQLDIR\\DATA\\USR
userDirectory = SET VALID VALUE!

# Maximum total size of backup files (per user) in kilobytes: 
backupMax = 200

# Maximum total size of SQL scripts (per user) in kilobytes:
SQLMax = 50

# Administrator email (to be used in error messages):
adminEmail = 

# Compressing method used by command 'Compress' backup files:
compressCommand = gzip

# Allow ZIP and GZIP compressing methods to create compressed backup files
# By default both methods are allowed:
#  allowZIP = 1
#  allowGZIP = 1
allowZIP = 1
allowGZIP = 1

# ZIP program call syntax 
# This syntax depends on operating system and version of ZIP program (under Windows)
# default is syntax for Unix zip utility.
# Under Windows it may look like "Wzzip -Pr" or "Wzzip"
# This value is meaningless if allowZIP is not set
zipSyntax = zip -qj

# This value shows where to redirect the output of ZIP program.
# Some ZIP programs, for example Wzzip, may not have silence mode and produce
# some output that must be printed somewhere. For Wzzip you can redirect this output
# to NUL device.
# zipLog = 1>NUL
zipLog = 

# printPopUp makes Print pop up window to appear by itself each time you use Print 
# result facility
printPopUp = 1


EOT
;
	my @config = split "\n", $config;
	return (\@config);
}
sub unrgversion {
	return "
Unregistered version does not support this function.
Normaly this operation should be executed.
Try it using the online demo: http://www.edatanew.com/demo

To register and download the latest release of the program visit http://www.edatanew.com/order .
	"
}
sub unrgversion1 {
	return "
Unregistered version does not support this function on tables with more than five columns.
Normaly this operation should be executed.
Try it using the online demo: http://www.edatanew.com/demo

To register and download the latest release of the program visit http://www.edatanew.com/order .
	"
}
sub readconfig {
	my $config;
	my @config = @{$_[0]};
	foreach(@config){
		next if (/^\s*#/ or /^\s*$/);
		s/^\s*(\S+.*\S*)\s*$/$1/;
		if (/^\w*/){
			if (s/^(\w*)\s*=\s*(\S+.*\S*)\s*$/$1/){$config->{$1}=$2}
		}
	}
	return $config
}
print "<H1>There is no data<H1>";
exit 0;

#++++++++++++++++++++++++++++++++++++++
