/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/
/*
   re_brow.c: browse REFERENCES database
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <malloc.h>
#include <dos.h>
#include <signal.h>
#include "re_brow.h"
#include "refs.h"
#include "ix01_fun.h"
#include "ix02_fun.h"
#include "ix04_fun.h"
#include "fl_ut.h"
#include "str_fun.h"
#include "l_menu.h"
#include "str_refs.h"
#include "re_fun.h"
#include "abbruch.h"
#include "abstr.h"
#include "rfnr_fun.h"
#include "keycodes.h"
#include "cfg_fun.h"
#include "vtxt.h"

 extern journal_rec one_journal_rec;
 extern desc_rec one_desc_rec;
 extern buch_rec one_buch_rec;
 extern quell_rec one_quell_rec;
 extern refspix_rec ix01rec;
 extern abstr_rec one_abstr_rec;
 extern abstrpix_rec ix04rec;

 extern config_set one_config_set;

 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];
 extern char datpath[120];
 extern char journal_pix_name[PFAD_LEN];
 extern char journal_name[PFAD_LEN];
 extern char desc_name[PFAD_LEN];
 extern char book_name[PFAD_LEN];
 extern char autorjl_name[PFAD_LEN];
 extern char autorbu_name[PFAD_LEN];
 extern char quell_pix_name[PFAD_LEN];
 extern char quell_name[PFAD_LEN];
 extern char stichw_name[PFAD_LEN];
 extern char stichw_pix_name[PFAD_LEN];
 extern char abstr_pix_name[PFAD_LEN];
 extern char last_search_name[PFAD_LEN];

 extern char kennziff_temp_name[PFAD_LEN];

 char kennziffer_global[KENNZIFFER_LEN+1];


 static char * au_zeile;
 static char * ed_zeile;
 static char * showrec;
 static char * ex_au_zeile;
 static char * desc_zeile;

 FILE * ix01;
 extern FILE * ix01file;
 extern FILE * ix04file;

 int re_brow_main(char * dpf, char * modus_cb);
 static void auedstring_blaettern(
                           char * au_zeile,
                           FILE * datfl,
                           long aued_rptr
                         );

 static void desc_blaettern(
                           char * desc_zeile,
                           FILE * datfl,
                           long desc_rptr
                         );

 static void browse_menu(char * ix_name);
 static void browse_bbt(char * bbt_name, char * ix_name);
 static void save_bbt(const char * schluessel);
 static int show_textfile(char * t_name);
 static int daten_datei_lesen(char * kennziffer);


#define BROWSE_BBT_NAME "BROWSE.BBT"
#define TMP_REC_KEY "R_KEY.T"
#define RECORD_ZAHLSTRING_LEN 8
#define RECORD_ZAHL_MAX_VORGABE 99999999L
  /* die groesste Zahl mit RECORD_ZAHLSTRING_LEN Ziffern */
#define ABST_TXT  "ABSTRACT.TMP"
#define ABST_DAT "ABST.DAT"
#define ABSTRACT_ZEILE_LEN 30600
#define MAX_BLOECKE 62

int re_brow_main(char * dpf, char * modus_cb)
{
     strcpy(datpath,dpf);
     strcpy(kennziff_temp_name,datpath);strcat(kennziff_temp_name,TMP_REC_KEY);

     dateien_identifizieren();
     strcpy(kennziffer_global,"");

     kennziffer_lesen_allein(kennziffer_global);

     if ((au_zeile =  (char *) malloc(AUTORZEILE_LEN * sizeof(char)))==NULL)
     {
        beenden("RE_ED.EXE: Memory allocation error 001",1);
     }

     if  ((ed_zeile = (char *) malloc(AUTORZEILE_LEN * sizeof(char)))==NULL)
     {
        beenden("BatchTableBrowse: Memory allocation error 002",1);
     }


     if  ((showrec = (char *) malloc(SHOWREC_LEN * sizeof(char)))==NULL)
     {
        beenden("BatchTableBrowse: Memory allocation error 003",1);
     }

     if  ((ex_au_zeile = (char *) malloc(AUTORZEILE_LEN * sizeof(char)))==NULL)
     {
        beenden("BatchTableBrowse: Memory allocation error 004",1);
     }
     if  ((desc_zeile = (char *) malloc(DESC_ZEILE_LEN * sizeof(char)))==NULL)
     {
        beenden("BatchTableBrowse: Memory allocation error 005",1);
     }
     strcpy(au_zeile,"");
     strcpy(ed_zeile,"");
     strcpy(ex_au_zeile,"");

     if (strcmp(modus_cb,"-c")==0)
     {
        browse_menu(journal_pix_name);
     }
     if ((strcmp(modus_cb,"-b")==0) || (strcmp(modus_cb,"-s")==0))
     {
         char file_name[100];
         char bbt_name[PFAD_LEN];
         static int dateipos;

         cls_line("");
         strcpy(bbt_name,"");
         if (strcmp(modus_cb,"-b")==0)
         {
            if (datei_suchen_default("*.BBT",file_name,&dateipos))
            {
                char cmp_name[150];
                int anzahl;

                strcat(bbt_name,file_name);
                anzahl=countitem(bbt_name,"\\");
                extractitem(anzahl,bbt_name,"\\",cmp_name);
                upper(cmp_name);
                if (!strcmp(cmp_name,BROWSE_BBT_NAME))
                {
                   sprintf(wrtxtbu,"\nFile %s is not allowed: it is the target of the "
                          "'Save' option \nin 'BatchTableBrowse', "
                          "please select another BBT-file\n\n",
                             BROWSE_BBT_NAME);
                   wrtxt(wrtxtbu);
                   wrtxt("[Please press any key]>");
                   tastelesen();
                   return 0;
                }
                wrtxt("\n[Please press any key for the BROWSE menu]>");
                tastelesen();
                cls_line("");
                browse_bbt(bbt_name,journal_pix_name);
            }  else
            {
                wrtxt("\n[Please press any key]>");
                tastelesen();
            }
         }
         else
         {
             strcpy(bbt_name,last_search_name);
             upper(bbt_name);

             if (strlen(bbt_name) < 1)
             {
                sprintf(wrtxtbu,"\nNo BBT-file known: "
                   "please run a 'SearchR' command first\n\n");
                wrtxt(wrtxtbu);
                wrtxt("[Please press any key]>");
                tastelesen();
                return 0;
             }
             if (!strcmp(bbt_name,BROWSE_BBT_NAME))
             {
                sprintf(wrtxtbu,"\nFile %s is not allowed: it is the target of the "
                       "'Save' option \nin 'BatchTableBrowse', "
                       "please select another BBT-file\n\n",
                          BROWSE_BBT_NAME);
                wrtxt(wrtxtbu);
                wrtxt("[Please press any key]>");
                tastelesen();
                return 0;
             }
             cls_line("");
             browse_bbt(bbt_name,journal_pix_name);
         }
     }
     free(au_zeile);
     free(ed_zeile);
     free(showrec);
     free(ex_au_zeile);
     free(desc_zeile);
     kennziffer_schreiben(kennziffer_global);
   return 0;
}

static void auedstring_blaettern(
                           char * au_zeile,
                           FILE * datfl,
                           long aued_rptr
                         )
{
   /* Diese Funktion erfordert, dass datfl bereits offen ist */
   author_rec aued_rec;
   int i, anz_autoren;

   strcpy(au_zeile,"");
   if (aued_rptr==-1)
   {
       return;
   }

   fseek(datfl,aued_rptr*sizeof(aued_rec),SEEK_SET);
   fread(&aued_rec,sizeof(aued_rec),1,datfl);
   anz_autoren = aued_rec.au_n;
   fseek(datfl,aued_rptr*sizeof(aued_rec),SEEK_SET);

   for(i=1;i<=anz_autoren;i++)
   {
      if (i > MAX_N_AUTHORS)
      {
         trim(au_zeile,' ');
         break;
      }
      fread(&aued_rec,sizeof(aued_rec),1,datfl);
      strlimcat(au_zeile,aued_rec.au_nachname,AUTORZEILE_LEN);
      strlimcat(au_zeile,",",AUTORZEILE_LEN);
      strlimcat(au_zeile,aued_rec.au_vornamen,AUTORZEILE_LEN);
      strlimcat(au_zeile,";",AUTORZEILE_LEN);
   }
   trim(au_zeile,' ');
   return;
}



static void desc_blaettern(
                           char * desc_zeile,
                           FILE * datfl,
                           long desc_rptr
                         )
{
   desc_rec dr;
   int i, anz_rec;

   strcpy(desc_zeile,"");
   if (desc_rptr==-1)
   {
      return;
   }
   fseek(datfl,desc_rptr*sizeof(dr),SEEK_SET);
   fread(&dr,sizeof(dr),1,datfl);
   anz_rec = dr.desc_n;
   fseek(datfl,desc_rptr*sizeof(dr),SEEK_SET);
   for(i=1;i<=anz_rec;i++)
   {
      if (i > MAX_N_DESC)
      {
         trim(au_zeile,' ');
         break;
      }
      fread(&dr,sizeof(dr),1,datfl);
      strlimcat(desc_zeile,dr.keywordsfield,DESC_ZEILE_LEN);
      if (i < anz_rec)
      {
         strlimcat(desc_zeile,", ",DESC_ZEILE_LEN);
      }
   }
   trim(desc_zeile,' ');
   return;
}

static void browse_menu(char * ix_name)
{
   int  erst_ansicht;
     /*
        0 : beim Ersteintritt in die Anzeigeschleife
        1 : beim Verbleib in der Schleife;
     */
   long ix_zeiger, byte_zeiger, abst_ix_zeiger;
   long n_ix; /* Anzahl Indexeintraege */
   char eingabe_zeile[KENNZIFFER_LEN + 2];
   refspix_rec ix01rec_lokal;
   abstrpix_rec ix04rec_lokal;

   FILE * fpjournal;
   FILE * fpdesc;
   FILE * fpbuch;
   FILE * fpautorjl;
   FILE * fpautorbu;


   int taste;

   if (!isfile(ix_name))
   {
      sprintf(wrtxtbu,"\n[Cannot read %s]>",ix_name);
      wrtxt(wrtxtbu);
      tastelesen();
      return;
   }


   if (filesize(ix_name) < sizeof(ix01rec_lokal))
   {
      sprintf(wrtxtbu,"\n[Cannot read data from %s]>",ix_name);
      wrtxt(wrtxtbu);
      tastelesen();
      return;
   }
   if (!isfile(abstr_pix_name))
   {
      sprintf(wrtxtbu,"\n[Cannot find file %s]>",abstr_pix_name);
      wrtxt(wrtxtbu);
      tastelesen();
      return;
   }
   /* Groesse der Indexdatei abfragen */
   n_ix = filesize(ix_name)/sizeof(ix01rec);
   n_ix--;

   if ((!isfile(journal_name)) ||
       (!isfile(book_name)) ||
       (!isfile(autorjl_name)) ||
       (!isfile(autorbu_name)) ||
       (n_ix < 0)
      )
   {
      sprintf(wrtxtbu,"For browsing, a complete set of data files must be available\n"
             "and at least one record must be available\n\n"
             "[Please press any key]>");
      wrtxt(wrtxtbu);
      tastelesen();
      return;
   }
   if (!read_ix04(abstr_pix_name))
   {
      sprintf(wrtxtbu,"\n[Cannot read %s]>",abstr_pix_name);
      wrtxt(wrtxtbu);
      tastelesen();
      return;
   }
   if ((fpjournal = fopen(journal_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: Cannot read %s",journal_name);
      beenden(fehlermeldung,2);
   }
   if ((fpdesc = fopen(desc_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: Cannot read %s",desc_name);
      beenden(fehlermeldung,2);
   }
   read_ix01(ix_name);
   if ((fpbuch = fopen(book_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: Cannot read %s",book_name);
      beenden(fehlermeldung,2);
   }
   if ((fpautorjl = fopen(autorjl_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: Cannot read %s",autorjl_name);
      beenden(fehlermeldung,2);
   }
   if ((fpautorbu = fopen(autorbu_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: Cannot read %s",autorbu_name);
      beenden(fehlermeldung,2);
   }


   ix_zeiger = 0;
   taste = 1;
   erst_ansicht = 1;
   do
   {
       if (erst_ansicht)
       {
          erst_ansicht = 0;
          if (strlen(kennziffer_global) > 0)
          {
             ix_zeiger = locate_ix01(kennziffer_global,&ix01rec_lokal);
             if (ix_zeiger > -1)
             {
                fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
                fread(&ix01rec_lokal,sizeof(ix01rec_lokal),1,ix01file);
                fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
                taste=-1;
             }
             else taste = 2;
          }
          else taste = 2;
       } else
       {
          static int menupos;
          taste = lotus_menu_default(
          & menupos,
          "First$View first REFERENCE@"
          "Last$View last REFERENCE@"
          "Next$View next REFERENCE@"
          "Previous$View previous REFERENCE@"
          "KeyValue$Enter the KEY of a REFERENCE@"
          "#ofRecord$Enter the record number of a REFERENCE@"
          "Info$Show the record number@"
          "Save$Save the current REFERENCE NUMBER in BROWSE.BBT@"
          "ViewAbstr$Show abstract of current record"
                         );
       }
       if (taste==7)
       {
         abst_ix_zeiger = locate_ix04(ix01rec_lokal.kennziffer,&ix04rec_lokal);
         if (abst_ix_zeiger==-1)
         {
           sprintf(wrtxtbu,"\n[Current record %li, range: %li..%li, *no ABSTRACT*]>",
             ix_zeiger,0L,n_ix);
           wrtxt(wrtxtbu);
         }
         else
         {
           sprintf(wrtxtbu,"\n[Current record %li, range %li..%li with ABSTRACT]>",
                ix_zeiger,0L,n_ix);
           wrtxt(wrtxtbu);
         }
         tastelesen();
         sc_gotoxy(1,one_config_set.sl-1);
         continue;
       }
       if (taste==9)
       {
          if(daten_datei_lesen(ix01rec_lokal.kennziffer))
          {
              show_textfile(ABST_TXT);
              cls_line("");
           }
           else
           {
             sc_gotoxy(1,one_config_set.sl-1);
             continue;
           }
       }
       if (taste==8)
       {
          save_bbt(ix01rec_lokal.kennziffer);
          continue;
       }
       if (taste==6)
       {
          long zahl;
          int zahl_taste;
          char zahlstring[RECORD_ZAHLSTRING_LEN+1];
          int ok_zahl, ok_schleife;
          if (ix_zeiger < RECORD_ZAHL_MAX_VORGABE)
            sprintf(zahlstring,"%li",ix_zeiger);
          else
            strcpy(zahlstring,"");
          ok_schleife = 0;
          do
          {
             sprintf(fehlermeldung,"Please enter record number: %li..%li "
                   "to be shown",0L,n_ix);
             info_zeile(fehlermeldung);
             strcpy(wrtxtbu,"Record #...........");
             wrtxt(wrtxtbu);
             zahl_taste = e_zle(
                           1+strlen(wrtxtbu),
                           one_config_set.sl-1,
                           zahlstring,
                           RECORD_ZAHLSTRING_LEN,
                           RECORD_ZAHLSTRING_LEN,
                           0
                                    );
             sc_gotoxy(1,one_config_set.sl);sc_clreol();
             sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
             string_in_long(zahlstring,&zahl,&ok_zahl);
             if (((ok_zahl) && (zahl >= 0L) && (zahl <= n_ix)) &&
                 (zahl_taste == ENTER_KEY))
             {
                 ok_schleife=1;
                 ix_zeiger = zahl;
             }
             else
                 ok_schleife = 0;
             if (zahl_taste == ESC_KEY) ok_schleife=1;

          } while (!ok_schleife);
          if (zahl_taste==ESC_KEY) continue;
          fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
          fread(&ix01rec_lokal,sizeof(ix01rec_lokal),1,ix01file);
          fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
       }

       if (taste==1)  /* First */
       {
            ix_zeiger = 0;
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
            fread(&ix01rec_lokal,sizeof(ix01rec_lokal),1,ix01file);
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
       }
       if (taste==2)  /* Last */
       {
            if (n_ix > 0)
            {
               ix_zeiger = n_ix;
            }
            else
            {
               ix_zeiger = 0;
            }
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
            fread(&ix01rec_lokal,sizeof(ix01rec_lokal),1,ix01file);
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
       }
       if (taste==3)   /* Next */
       {
            if ((n_ix > 0) && (ix_zeiger < n_ix))
            {
                ix_zeiger++;
            }
            else
            {
               beeps();
               ix_zeiger = n_ix;
            }
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
            fread(&ix01rec_lokal,sizeof(ix01rec_lokal),1,ix01file);
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
       }
       if (taste==4)   /* Previous */
       {
            if ((n_ix > 0) && (ix_zeiger > 0))
            {
                ix_zeiger--;
            }
            else
            {
               beeps();
               ix_zeiger = 0;
            }
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
            fread(&ix01rec_lokal,sizeof(ix01rec_lokal),1,ix01file);
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
       }
       if (taste==5) /* KeyValue  */
       {
            if (n_ix > 0)
            {
              info_zeile("Enter number of a reference, [Esc] Quit");
              strcpy(eingabe_zeile,kennziffer_global);
              strcpy(wrtxtbu,"Ref.-number........");
              wrtxt(wrtxtbu);
              taste = e_zle(
                          1+strlen(wrtxtbu),
                          one_config_set.sl-1,
                          eingabe_zeile,
                          KENNZIFFER_LEN,
                          KENNZIFFER_LEN,
                          0
                       );
              sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
              sc_gotoxy(1,one_config_set.sl);sc_clreol();
              sc_gotoxy(1,one_config_set.sl-1);
              if (taste==ESC_KEY) continue;

              if (strlen(eingabe_zeile)==0) continue;
              ix_zeiger = locate_ix01(eingabe_zeile,&ix01rec_lokal);
              if (ix_zeiger==-1)
              {

                  sprintf(wrtxtbu,"\n[REFERENCE with key `%s' not found]>",eingabe_zeile);
                  wrtxt(wrtxtbu);
                  tastelesen();
                  sc_gotoxy(1,one_config_set.sl-1);
                  ix_zeiger = 0;
              }
            }
            else
            {
               beeps();
               ix_zeiger = 0;
            }
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
            fread(&ix01rec_lokal,sizeof(ix01rec_lokal),1,ix01file);
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
       }
       if (taste==0) break;
       strcpy(kennziffer_global,ix01rec_lokal.kennziffer);
       byte_zeiger = ix01rec_lokal.journal_rptr * sizeof(one_journal_rec);
       fseek(fpjournal,byte_zeiger,SEEK_SET);
       fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

       desc_blaettern(desc_zeile,fpdesc,ix01rec_lokal.desc_rptr);

       if (!strcmp(one_journal_rec.reftyp,"j1"))
       {
          auedstring_blaettern(au_zeile,fpautorjl,ix01rec_lokal.autorjl_rptr);
          j1_rec_zeigen(au_zeile,desc_zeile,showrec,ex_au_zeile);
       }
       if (!strcmp(one_journal_rec.reftyp,"b1") || !strcmp(one_journal_rec.reftyp,"b2"))
       {

          byte_zeiger = ix01rec_lokal.buch_rptr * sizeof(one_buch_rec);
          fseek(fpbuch,byte_zeiger,SEEK_SET);
          fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);

          if (!strcmp(one_journal_rec.reftyp,"b1"))
          {
              auedstring_blaettern(ed_zeile,fpautorbu,ix01rec_lokal.autorbu_rptr);
              b1_rec_zeigen(ed_zeile,desc_zeile,showrec,ex_au_zeile);
          }
          if (!strcmp(one_journal_rec.reftyp,"b2"))
          {
              auedstring_blaettern(ed_zeile,fpautorbu,ix01rec_lokal.autorbu_rptr);
              auedstring_blaettern(au_zeile,fpautorjl,ix01rec_lokal.autorjl_rptr);
              b2_rec_zeigen(au_zeile,ed_zeile,desc_zeile,showrec,ex_au_zeile);
          }
       }
   } while (1);


   close_ix01();
   close_ix04();
   fclose(fpjournal);
   fclose(fpdesc);
   fclose(fpbuch);
   fclose(fpautorjl);
   fclose(fpautorbu);
   return;
}

static void browse_bbt(char * bbt_name, char * ix_name)
{
   long bbt_zeiger, byte_zeiger, abst_ix_zeiger;
   long n_bbt; /* Anzahl Indexeintraege */
   char eingabe_zeile[KENNZIFFER_LEN + 2];
   refspix_rec ix01rec_lokal;
   abstrpix_rec ix04rec_lokal;
   bbatchtable_rec one_bbt_rec;

   FILE * fpjournal;
   FILE * fpdesc;
   FILE * fpbuch;
   FILE * fpbbt;
   FILE * fpautorjl;
   FILE * fpautorbu;

   int taste;

   cls_line(TITEL_BROWSE_BBT);

   if (!isfile(ix_name))
   {
      sprintf(wrtxtbu,"\n[Cannot read %s]>",ix_name);
      wrtxt(wrtxtbu);
      tastelesen();
      return;
   }
   if (!isfile(abstr_pix_name))
   {
      sprintf(wrtxtbu,"\n[Cannot find file %s]>",abstr_pix_name);
      wrtxt(wrtxtbu);
      tastelesen();
      return;
   }

   if (filesize(ix_name) < sizeof(ix01rec_lokal))
   {
      sprintf(wrtxtbu,"\n[Cannot read data from %s]>",ix_name);
      wrtxt(wrtxtbu);
      tastelesen();
      return;
   }

   if (!isfile(bbt_name))
   {
      sprintf(wrtxtbu,"\n[Cannot read %s]>",bbt_name);
      wrtxt(wrtxtbu);
      tastelesen();
      return;
   }
   if (filesize(bbt_name) < sizeof(one_bbt_rec))
   {
      cls_line(TITEL_BROWSE_BBT);
      sprintf(wrtxtbu,"\n[WARNING: file %s is empty, "
                 "please press any key]>",bbt_name);
      wrtxt(wrtxtbu);
      tastelesen();
      return;
   }

   /* Groesse der Bbt-datei abfragen */
   n_bbt = filesize(bbt_name)/sizeof(one_bbt_rec);
   n_bbt--;

   if (!read_ix04(abstr_pix_name))
   {
      sprintf(wrtxtbu,"\n[Cannot read %s]>",abstr_pix_name);
      wrtxt(wrtxtbu);
      tastelesen();
      return;
   }

   if ((fpbbt = fopen(bbt_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: Cannot read %s",bbt_name);
      beenden(fehlermeldung,2);
   }

   if ((!isfile(journal_name)) ||
       (!isfile(book_name)) ||
       (!isfile(autorjl_name)) ||
       (!isfile(autorbu_name))
      )
   {
      wrtxt("\n[For browsing, a complete set of data files must be available]>");
      close_ix04();
      fclose(fpbbt);
      tastelesen();
      return;
   }


   if ((fpjournal = fopen(journal_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: Cannot read %s",journal_name);
      beenden(fehlermeldung,2);
   }
   if ((fpdesc = fopen(desc_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: Cannot read %s",desc_name);
      beenden(fehlermeldung,2);
   }
   read_ix01(ix_name);

   if ((fpbuch = fopen(book_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: Cannot read %s",book_name);
      beenden(fehlermeldung,2);
   }
   if ((fpautorjl = fopen(autorjl_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: Cannot read %s",autorjl_name);
      beenden(fehlermeldung,2);
   }
   if ((fpautorbu = fopen(autorbu_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: Cannot read %s",autorbu_name);
      beenden(fehlermeldung,2);
   }


   bbt_zeiger = 0;
   rewind(fpbbt);
   taste = 1;


   sprintf(wrtxtbu,"File %s with %li records",
          bbt_name, n_bbt+1);
   sc_gotoxy(1,one_config_set.sl-3);
   wrtxt(wrtxtbu);
   sc_gotoxy(1,one_config_set.sl-1);


   do
   {
       static int menupos;
       taste = lotus_menu_default(
       & menupos,
       "First$Batch table: View first REFERENCE@"
       "Last$Batch table: view last REFERENCE@"
       "Next$Batch table: view next REFERENCE@"
       "Previous$Batch table: view previous REFERENCE@"
       "KeyValue$Enter the KEY of a REFERENCE@"
       "#ofRecord$Enter a valid record number within the current BBT-file@"
       "Info$About the current batch table@"
       "Save$Save the current REFERENCE NUMBER in BROWSE.BBT@"
       "ViewAbstr$Show abstract of current record, if available"
                         );
       if (taste==8)  /* Save */
       {
            byte_zeiger = bbt_zeiger * sizeof(one_bbt_rec);
            fseek(fpbbt,byte_zeiger,SEEK_SET);
            fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
            if (locate_ix01(one_bbt_rec.kennziffer,&ix01rec_lokal)==-1)
            {
               sprintf(wrtxtbu,"\n[Reference `%s' not found]>",one_bbt_rec.kennziffer);
               wrtxt(wrtxtbu);
               tastelesen();
               sc_gotoxy(1,one_config_set.sl-1);
               continue;
            }
            fseek(fpbbt,byte_zeiger,SEEK_SET);
            save_bbt(ix01rec_lokal.kennziffer);
            continue;
       }
       if (taste==7 ||  taste== 9)
       {
            sprintf(wrtxtbu,"File %s: record %li, range: %li..%li\n",
              bbt_name,bbt_zeiger,0L,n_bbt);
            wrtxt(wrtxtbu);
            byte_zeiger = bbt_zeiger * sizeof(one_bbt_rec);
            fseek(fpbbt,byte_zeiger,SEEK_SET);
            fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
            if (locate_ix01(one_bbt_rec.kennziffer,&ix01rec_lokal)==-1)
            {
               sprintf(wrtxtbu,"[Reference `%s' not found in database, please press any key]>",
                  one_bbt_rec.kennziffer);
               wrtxt(wrtxtbu);
               tastelesen();
               sc_gotoxy(1,one_config_set.sl-1);
               continue;
            }
            else
            {
               abst_ix_zeiger=locate_ix04(one_bbt_rec.kennziffer,
                     &ix04rec_lokal);
               if (abst_ix_zeiger >= 0)
               {
                  if (taste==9) /* ViewAbstract */
                  {
                     if(daten_datei_lesen(ix01rec_lokal.kennziffer))
                     {
                        show_textfile(ABST_TXT);
                        cls_line("");
                     }
                     else
                     {
                         sc_gotoxy(1,one_config_set.sl-1);
                         continue;
                      }
                  }
                  else /* Info */
                  {
                    sprintf(wrtxtbu,"[REFERENCE `%s' and ABSTRACT in database, "
                              "please press any key]>",one_bbt_rec.kennziffer);
                    wrtxt(wrtxtbu);
                    tastelesen();
                    sc_gotoxy(1,one_config_set.sl-1);
                    continue;
                  }
               }
               else
               {
                  sprintf(wrtxtbu,"[REFERENCE `%s' in database, *no ABSTRACT* "
                            "please press any key]>",one_bbt_rec.kennziffer);
                  wrtxt(wrtxtbu);
                  tastelesen();
                  sc_gotoxy(1,one_config_set.sl-1);
                  continue;
               }
            }
            fseek(fpbbt,byte_zeiger,SEEK_SET);
            sc_gotoxy(1,one_config_set.sl-1);

       }
       if (taste==6) /* #ofRecord */
       {
            long zahl;
            int zahl_taste;
            char zahlstring[RECORD_ZAHLSTRING_LEN + 1];
            int ok_zahl, ok_schleife;
            if (bbt_zeiger < RECORD_ZAHL_MAX_VORGABE)
               sprintf(zahlstring,"%li",bbt_zeiger);
            else
               strcpy(zahlstring,"");
            ok_schleife = 0;
            do
            {
                sprintf(fehlermeldung,"Please enter record number: %li..%li "
                    "to be shown",0L,n_bbt);
                info_zeile(fehlermeldung);
                strcpy(wrtxtbu,"Record #...........");
                wrtxt(wrtxtbu);
                zahl_taste = e_zle(
                                1+strlen(wrtxtbu),
                                one_config_set.sl-1,
                                zahlstring,
                                RECORD_ZAHLSTRING_LEN,
                                RECORD_ZAHLSTRING_LEN,
                                0
                                      );
                sc_gotoxy(1,one_config_set.sl);sc_clreol();
                sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
                string_in_long(zahlstring,&zahl,&ok_zahl);
                if (((ok_zahl) && (zahl >= 0L) && (zahl <= n_bbt)) &&
                    (zahl_taste == ENTER_KEY))
                {
                    ok_schleife = 1;
                    bbt_zeiger = zahl;
                }
                else
                   ok_schleife = 0;

                if (zahl_taste==ESC_KEY) ok_schleife=1;

            } while (!ok_schleife);


            if (zahl_taste==ESC_KEY) continue;
            byte_zeiger = bbt_zeiger * sizeof(one_bbt_rec);
            fseek(fpbbt,byte_zeiger,SEEK_SET);
            fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
            if (locate_ix01(one_bbt_rec.kennziffer,&ix01rec_lokal)==-1)
            {
               sprintf(wrtxtbu,"\n[Reference `%s' not found]>",one_bbt_rec.kennziffer);
               wrtxt(wrtxtbu);
               tastelesen();
               sc_gotoxy(1,one_config_set.sl-1);
               continue;
            }
            fseek(fpbbt,byte_zeiger,SEEK_SET);
       }
       if (taste==5) /* KeyValue */
       {
            if (n_bbt >= 0)
            {
              info_zeile("Enter number of a reference, [Esc] Quit");
              strcpy(eingabe_zeile,kennziffer_global);
              strcpy(wrtxtbu,"Ref.-number........");
              wrtxt(wrtxtbu);
              taste = e_zle(
                          1+strlen(wrtxtbu),
                          one_config_set.sl-1,
                          eingabe_zeile,
                          KENNZIFFER_LEN,
                          KENNZIFFER_LEN,
                          0
                       );
              sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
              sc_gotoxy(1,one_config_set.sl);sc_clreol();
              sc_gotoxy(1,one_config_set.sl-1);
              if (taste==ESC_KEY) continue;
              fseek(fpbbt,0L,SEEK_SET);
              if (strlen(eingabe_zeile)==0) continue;
              for (bbt_zeiger=0;bbt_zeiger<=n_bbt;bbt_zeiger++)
              {
                 fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
                 if (!strcmp(one_bbt_rec.kennziffer,eingabe_zeile))
                 {
                   break; /* record found in bbt-file */
                 }
                 if (bbt_zeiger == n_bbt)
                 {
                    sprintf(wrtxtbu,"\n[Key `%s' not found in BBT-file]>",
                      eingabe_zeile);
                    wrtxt(wrtxtbu);
                    tastelesen();
                    sc_gotoxy(1,one_config_set.sl);sc_clreol();
                    sc_gotoxy(1,one_config_set.sl-1);
                    bbt_zeiger = 0;
                    break;
                 }

              }

              byte_zeiger = bbt_zeiger * sizeof(one_bbt_rec);
              fseek(fpbbt,byte_zeiger,SEEK_SET);
              fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
              if (locate_ix01(one_bbt_rec.kennziffer,&ix01rec_lokal)==-1)
              {
                 sprintf(wrtxtbu,"\n[Reference `%s' not found]>",one_bbt_rec.kennziffer);
                 wrtxt(wrtxtbu);
                 tastelesen();
                 sc_gotoxy(1,one_config_set.sl-1);
                 continue;
              }
              fseek(fpbbt,byte_zeiger,SEEK_SET);
            }
            else
            {
               beeps();
               bbt_zeiger = 0;
            }

       }
       if (taste==1)
       {
            bbt_zeiger = 0;
            byte_zeiger = bbt_zeiger * sizeof(one_bbt_rec);
            fseek(fpbbt,byte_zeiger,SEEK_SET);
            fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
            if (locate_ix01(one_bbt_rec.kennziffer,&ix01rec_lokal)==-1)
            {
               sprintf(wrtxtbu,"\n[Reference `%s' not found]>",one_bbt_rec.kennziffer);
               wrtxt(wrtxtbu);
               tastelesen();
               sc_gotoxy(1,one_config_set.sl-1);
               continue;
            }
            fseek(fpbbt,byte_zeiger,SEEK_SET);
       }
       if (taste==2)
       {
            bbt_zeiger = n_bbt;
            byte_zeiger = bbt_zeiger * sizeof(one_bbt_rec);
            fseek(fpbbt,byte_zeiger,SEEK_SET);
            fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
            if (locate_ix01(one_bbt_rec.kennziffer,&ix01rec_lokal)==-1)
            {
               sprintf(wrtxtbu,"\n[Reference `%s' not found]>",one_bbt_rec.kennziffer);
               wrtxt(wrtxtbu);
               tastelesen();
               sc_gotoxy(1,one_config_set.sl-1);
               continue;
            }
            fseek(fpbbt,byte_zeiger,SEEK_SET);
       }
       if (taste==3)
        {
            bbt_zeiger++;
            if (bbt_zeiger > n_bbt)
            {
               bbt_zeiger = n_bbt;
               sprintf(wrtxtbu,"\n[This is the last record "
               "referred to in the current batch table]>");
               wrtxt(wrtxtbu);
               tastelesen();
               sc_gotoxy(1,one_config_set.sl-1);
               continue;
            }
            byte_zeiger = bbt_zeiger * sizeof(one_bbt_rec);
            fseek(fpbbt,byte_zeiger,SEEK_SET);
            fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
            if (locate_ix01(one_bbt_rec.kennziffer,&ix01rec_lokal)==-1)
            {
               sprintf(wrtxtbu,"\n[Reference `%s' not found]>",one_bbt_rec.kennziffer);
               wrtxt(wrtxtbu);
               tastelesen();
               sc_gotoxy(1,one_config_set.sl-1);
               continue;
            }
            fseek(fpbbt,byte_zeiger,SEEK_SET);
       }
       if (taste==4)
       {
            bbt_zeiger--;
            if (bbt_zeiger < 0)
            {
               bbt_zeiger = 0;
               sprintf(wrtxtbu,"\n[This is the first record referred to "
               "in the current batch table]>");
               wrtxt(wrtxtbu);
               tastelesen();
               sc_gotoxy(1,one_config_set.sl-1);
               continue;
            }
            byte_zeiger = bbt_zeiger * sizeof(one_bbt_rec);
            fseek(fpbbt,byte_zeiger,SEEK_SET);
            fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
            if (locate_ix01(one_bbt_rec.kennziffer,&ix01rec_lokal)==-1)
            {
               sprintf(wrtxtbu,"\n[Reference `%s' not found]>",one_bbt_rec.kennziffer);
               wrtxt(wrtxtbu);
               tastelesen();
               sc_gotoxy(1,one_config_set.sl-1);
               continue;
            }
            fseek(fpbbt,byte_zeiger,SEEK_SET);
       }

       if (taste==0) break;
       strcpy(kennziffer_global,ix01rec_lokal.kennziffer);
       byte_zeiger = ix01rec_lokal.journal_rptr * sizeof(one_journal_rec);
       fseek(fpjournal,byte_zeiger,SEEK_SET);
       fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

       desc_blaettern(desc_zeile,fpdesc,ix01rec_lokal.desc_rptr);

       if (!strcmp(one_journal_rec.reftyp,"j1"))
       {
          auedstring_blaettern(au_zeile,fpautorjl,ix01rec_lokal.autorjl_rptr);
          j1_rec_zeigen(au_zeile,desc_zeile,showrec,ex_au_zeile);
       }
       if (!strcmp(one_journal_rec.reftyp,"b1") || !strcmp(one_journal_rec.reftyp,"b2"))
       {
          byte_zeiger = ix01rec_lokal.buch_rptr * sizeof(one_buch_rec);
          fseek(fpbuch,byte_zeiger,SEEK_SET);
          fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);

          if (!strcmp(one_journal_rec.reftyp,"b1"))
          {
              auedstring_blaettern(ed_zeile,fpautorbu,ix01rec_lokal.autorbu_rptr);
              b1_rec_zeigen(ed_zeile,desc_zeile,showrec,ex_au_zeile);
          }
          if (!strcmp(one_journal_rec.reftyp,"b2"))
          {
              auedstring_blaettern(ed_zeile,fpautorbu,ix01rec_lokal.autorbu_rptr);
              auedstring_blaettern(au_zeile,fpautorjl,ix01rec_lokal.autorjl_rptr);
              b2_rec_zeigen(au_zeile,ed_zeile,desc_zeile,showrec,ex_au_zeile);
          }
       }
   } while (1);


   close_ix01();
   close_ix04();
   fclose(fpjournal);
   fclose(fpdesc);
   fclose(fpbbt);
   fclose(fpbuch);
   fclose(fpautorjl);
   fclose(fpautorbu);


   return;
}


static void save_bbt(const char * schluessel)
{
    FILE * fpbrowsebbt;
    bbatchtable_rec one_bbt_rec;

    memset(&one_bbt_rec,0,sizeof(one_bbt_rec));
    if (!isfile(BROWSE_BBT_NAME))
    {
       if ((fpbrowsebbt=fopen(BROWSE_BBT_NAME,"wb"))==NULL)
       {
           sprintf(fehlermeldung,"ERROR: cannot create %s or write into %s",
               BROWSE_BBT_NAME,BROWSE_BBT_NAME);
           beenden(fehlermeldung,2);
       }
    }
    else
    {
       if ((fpbrowsebbt=fopen(BROWSE_BBT_NAME,"r+b"))==NULL)
       {
           sprintf(fehlermeldung,"ERROR: cannot create %s or write into %s",
             BROWSE_BBT_NAME,BROWSE_BBT_NAME);
           beenden(fehlermeldung,2);
       }
       fseek(fpbrowsebbt,0L,SEEK_END);
    }
    strncpy(one_bbt_rec.kennziffer,schluessel,KENNZIFFER_LEN +1);
    if (fwrite(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbrowsebbt)==1)
    {
       sprintf(wrtxtbu,"\n[Reference number: %s saved in %s]>",schluessel,
           BROWSE_BBT_NAME);
       wrtxt(wrtxtbu);
       tastelesen();
       sc_gotoxy(1,one_config_set.sl-1);
    }
    fclose(fpbrowsebbt);
}


static int show_textfile(char * t_name)
{
     vtxt_main(t_name);
     return 1;
}

static int daten_datei_lesen(char * kennziffer)
{
    long rec_zeiger, byte_zeiger, pos_zeiger;
    int i, anzahl_records;
    unsigned int laenge;
    char * abstract;
    FILE * fpabsdat;
    FILE * fpabstext;

    if ((abstract = (char *) malloc ((ABSTRACT_ZEILE_LEN +1) * sizeof(char)))
                          ==NULL)
    {
        wrtxt("\n[Unable to alloacte memory for showing abstract]>");
        tastelesen();
        return 0;
    }

    /*   read_ix04(abstr_pix_name); */
    pos_zeiger = locate_ix04(kennziffer,&ix04rec);
    /*   close_ix04(); */
    if (pos_zeiger==-1)
    {
        wrtxt("\n[No abstract available, please press any key]>");
        free(abstract);
        tastelesen();
        return 0;
    }
    else
    {
       strcpy(abstract,"");
       rec_zeiger=ix04rec.abstr_rptr;
       byte_zeiger = rec_zeiger * sizeof(one_abstr_rec);

       if ((fpabsdat=fopen(ABST_DAT,"rb"))==NULL)
       {
           sprintf(wrtxtbu,"\n[Unexpected ERROR: Cannot read %s]>",
                   ABST_DAT);
           wrtxt(wrtxtbu);
           free(abstract);
           tastelesen();
           return 0;
       }
       fseek(fpabsdat,byte_zeiger,SEEK_SET);
       fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsdat);

       fseek(fpabsdat,byte_zeiger,SEEK_SET);
       anzahl_records=one_abstr_rec.abstr_n;
       if (anzahl_records > MAX_BLOECKE)
          anzahl_records = MAX_BLOECKE;
       /* die letzten 2 Zeilen eingefuegt am 18.2.1998 */
       for (i=1;i<=anzahl_records;i++)
       {
          fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsdat);
          strcat(abstract,one_abstr_rec.abs_text);

          if (i > MAX_BLOECKE)
          {
            wrtxt("[Unexpected ERROR in 'dat_datei_lesen()', "
                   "please inform program author]>");
            tastelesen();
            break;
          }
       }
       fclose(fpabsdat);
    }
    laenge = strlen(abstract);
    for (i=0;i<laenge;i++)
    {
      if (abstract[i]=='\xfe')
         abstract[i]='\n';
    }

    if ((fpabstext=fopen(ABST_TXT,"wt"))==NULL)
    {
        sprintf(wrtxtbu,"\n[Cannot write into %s]>",ABST_TXT);
        wrtxt(wrtxtbu);
        tastelesen();
        free(abstract);
        return 0;
    }


    fprintf(fpabstext,"BEGIN OF ABSTRACT\n\n");
    fprintf(fpabstext,"%s",abstract);
    fprintf(fpabstext,"\n\nEND OF ABSTRACT");

    fclose(fpabstext);
    free(abstract);
    return 1;
}
