/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/
/*
   rfnr_fun.c
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include "rfnr_fun.h"
#include "str_fun.h"
#include "refs.h"
#include "keycodes.h"
#include "l_menu.h"

 char kennziff_temp_name[PFAD_LEN];
 extern char wrtxtbu[WRTXTBU_LEN];
 extern config_set one_config_set;

 FILE * fpkennzifftemp;


int kennziffer_lesen(char * schluessel)
{
   char ch;
   int i, taste, schleife_ok;
   i = 0;
   if ((fpkennzifftemp=fopen(kennziff_temp_name,"r"))==NULL)
   {
      strcpy(schluessel,"");
   }
   else
   {
      strcpy(schluessel,"");
      do
      {
         ch = fgetc(fpkennzifftemp);
         if (ch!=EOF && ch!='\n')
            schluessel[i] = ch;
         else schluessel[i] = '\0';
         i++;
      } while (ch!=EOF && ch!= '\n' && i < KENNZIFFER_LEN);
      schluessel[KENNZIFFER_LEN]= '\0';
      fclose(fpkennzifftemp);
   }
   schleife_ok = 0;
   sc_gotoxy(1,one_config_set.sl-1); sc_clreol();
   do
   {
        info_zeile("Please enter the reference number of the abstract"
                   " to be edited/saved");
        strcpy(wrtxtbu,"Ref.-number........");
        wrtxt(wrtxtbu);

        taste = e_zle(
             1+strlen(wrtxtbu),
             one_config_set.sl-1,
             /* kennziffer, */
             schluessel,
             KENNZIFFER_LEN,
             KENNZIFFER_LEN,
             0
                     );
        sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
        if (taste==ENTER_KEY && strlen(/* kennziffer */ schluessel ) > 0) schleife_ok = 1;
        if (taste==ESC_KEY) schleife_ok = 1;
   } while (!schleife_ok);
   sc_gotoxy(1,one_config_set.sl); sc_clreol();
   /* printf("%s",kennziffer); */
   if (taste==ENTER_KEY)
      return 1;
   else
      return 0;
}


int kennziffer_schreiben(char * schluessel)
{
   if ((fpkennzifftemp=fopen(kennziff_temp_name,"w"))==NULL)
   {
      sprintf(wrtxtbu,"[Unexpected ERROR: unable to write into %s]>",
              kennziff_temp_name);
      wrtxt(wrtxtbu);
      tastelesen();
      return 0;
   }
   fprintf(fpkennzifftemp,"%s",schluessel);
   fclose(fpkennzifftemp);
   return 1;
}


int kennziffer_lesen_allein(char * schluessel)
{
   char ch;
   int i;
   i = 0;
   if ((fpkennzifftemp=fopen(kennziff_temp_name,"r"))==NULL)
   {
      strcpy(schluessel,"");
      return 0;
   }
   else
   {
      strcpy(schluessel,"");
      do
      {
         ch = fgetc(fpkennzifftemp);
         if (ch!=EOF && ch!='\n')
            schluessel[i] = ch;
         else schluessel[i] = '\0';
         i++;
      } while (ch!=EOF && ch!= '\n' && i < KENNZIFFER_LEN);
      schluessel[KENNZIFFER_LEN]= '\0';
      fclose(fpkennzifftemp);
   }
   if (strlen(schluessel) > 0)
     return 1;
   else
     return 0;
}
