* Program..: Backup.PRG
* Author...: Ray Love
* Date.....: May 1, 1985
* Version..: dBASE III, any version
* Note(s)..: This program is used to back up large files to
*            floppies in drive A: from a hard disk.  The
*            disks are numbered and date-stamped.
*
SET TALK OFF
STORE "A:" TO drive
* ---Build a line from graphics characters.
STORE CHR( 205 ) TO line
STORE line + line + line + line + line TO line
STORE line+line+line+line+line+line+line+line TO line
CLEAR
@  1, 0 SAY CHR( 201 ) + line
@  1,39 SAY line + CHR( 187 )
@  2, 0 SAY CHR( 186 )
@  2,79 SAY CHR( 186 )
@  2,30 SAY "F I L E    B A C K U P"
@  2,68 SAY DATE()
@  3, 0 SAY CHR( 200 ) + line
@  3,39 SAY line + CHR( 188 )
*
* ---Get file to use.
mfile = SPACE( 8 )
rec_size = 2
done = .F.
DO WHILE mfile = SPACE( 8 )
   @ 11,15 SAY "Enter the file to backup.";
           GET mfile PICTURE "@!"
   @ 11,52 SAY "'Q' TO EXIT."
   READ
   IF TRIM( mfile ) = "Q"
      SET TALK ON
      done = .T.
      EXIT
   ENDIF
   @ 13,10 SAY "Number of bytes per record = ";
           GET rec_size RANGE 2,4000
   READ
   mfile = TRIM( mfile ) + ".DBF"
   IF .NOT. FILE( "&mfile" )
      @ 23,20 SAY mfile + " File does not exist.  Please re-enter"
      mfile = SPACE( 8 )
   ENDIF
ENDDO
* ---The memory variable, done, is used to EXIT the loop and
* ---RETURN from the program after the loop.  It is coded this
* ---way because of the anomaly on RETURNing from within a
* ---DO WHILE loop.  See page D3-32 of the April 1985 issue of
* ---TechNotes for further discussion of this anomaly.
IF done
   RETURN
ENDIF
*
* ---Calculate number of records per disk to copy,
* ---leaving room for the file header.
* ---If you are using the 1.2 MB floppy on the IBM PC AT,
* ---change 350000 to 1200000.
recs_copy = INT( 350000 / rec_size )
*
* ---Clear screen from 4th row to the end.
@ 4,0 CLEAR
* ---Make the backup files.
USE &mfile
STORE 1 TO disk
DO WHILE .NOT. EOF()
   STORE " " TO ready
   @ 5,15 SAY "Insert a blank formatted disk in drive " + drive
   @ 6,15 SAY "Use a new disk for each " +;
              STR( recs_copy) + " records to back up."
   @ 7,15 SAY "Hit any key to begin copying " + mfile + ".";
          GET ready
   READ
   @ 5,15 CLEAR
   * ---Backup filename is in the format: FF-MM-DD.999
   * ---where FF is the first two characters of the file,
   * ---MM-DD is the current date,
   * ---.999 is the disk number.
   backup = drive + SUBSTR(mfile,1,2) + "-" + ;
      SUBSTR( DTOC( DATE() ),1,2 ) + "-" + ;
      SUBSTR( DTOC( DATE() ),4,2 ) + "." + STR( disk,1 )
   @ 4,0
   SET TALK ON
   ? "Copying Next " + STR( recs_copy) + " TO " + backup
   COPY NEXT recs_copy TO &backup
   SET TALK OFF
   @ 5,0 CLEAR
   IF .NOT. EOF()
      SKIP
   ENDIF
   disk = disk + 1
ENDDO
CLOSE DATABASES
SET TALK ON
RETURN
* EOP Backup.PRG