; DIRWIDE.ASM - v2.10, public domain w/ NASM src
; ftp://ftp.simtel.net/pub/simtelnet/msdos/dirutl/dirwi210.zip
; Anthony Williams, anthonyw@dibbs.net
;

%define offset                           ; these two lines are
%define ptr                              ;  only needed with NASM

CR EQU 13
LF EQU 10

ALL_FILES EQU 11110111b                  ; find all except volume label
INVALID_PATH EQU 3                       ; error #3
NO_FILES EQU 18                          ; error #18

DIR EQU 00010000b                        ; bit 4

; file attributes
ARCHIVE EQU 00100000b                    ; bit 5
SYSTEM EQU 00000100b                     ; bit 2
HIDDEN EQU 00000010b                     ; bit 1
READONLY EQU 00000001b                   ; bit 0

; options
OPT_I EQU 1000000000000000b              ; bit 15
OPT_L EQU 0100000000000000b              ; bit 14
OPT_U EQU 0010000000000000b              ; bit 13
OPT_P EQU 0001000000000000b              ; bit 12
OPT_F EQU 0000100000000000b              ; bit 11
OPT_D EQU 0000010000000000b              ; bit 10
OPT_V EQU 0000001000000000b              ; bit 9
OPT_S EQU 0000000100000000b              ; bit 8
OPT_B EQU 0000000010000000b              ; bit 7

; =============
  segment .text                          ; code segment (NASM)
; =============

; code segment                           ; code segment (MASM)
; assume cs:code,ds:code,es:code

org 100h                                 ; .COM file

Start:
        call check_help                  ; change /? to /H
        call parser                      ; get filespec, call options
        call scan                        ; add default '*.*' or '\*.*'
        call findfirst                   ;  to filespec
        call findnext
        call odd_crlf                    ; print CRLF after last filename
        call misc_info                   ; num of items, free space,
                                         ;  time, date
Adios:
        mov ah,4Ch
        mov al,byte ptr [error]          ; return errorlevel to DOS
        int 21h


; parser
parser:
        mov si,80h                       ; [80h] = length of cmdline
        mov di,offset filespec           ; 81h = beginning of cmdline
parser_load:
        inc si
        cmp byte ptr [si],CR             ; cmdline ends with a CR
        jz short parser_ret
        cmp byte ptr [si],' '
        jz short parser_load
        cmp byte ptr [si],'/'            ; options start with a /
        jnz short parser_move
parser_bogus_slash:
        inc si
        cmp byte ptr [si],CR
        jz short parser_ret
        cmp byte ptr [si],'/'            ; ignores extra even-# slashes
        jz short parser_bogus_slash
        call letter_toupper              ; convert 'a' to 'A' in option /a
        cmp byte ptr [si],'!'            ; [si] = '!' if not a letter
        jz short parser_load
        call setup_option
        cmp word ptr [bx],0              ; call option if offset isn't 0
        jz short parser_load
        call word ptr [bx]
        jmp short parser_load
parser_move:
        movsb                            ; store part of filespec
        dec si
        jmp short parser_load            ; continue until CR
parser_ret:
        mov byte ptr [di],0              ; filespec is ASCIIZ
        ret

; setup_option
setup_option:
        xor ah,ah                        ; setup array of option offsets
        mov al,byte ptr [si]
        sub al,'A'
        mov bx,offset options_list
        shl ax,1
        add bx,ax
setup_option_ret:
        ret

; findfirst
findfirst:
        call setup_dta                   ; change DTA from default location
findfirst_find:
        mov ah,4Eh
        mov cx,ALL_FILES
        mov dx,offset filespec
        int 21h
        jnc short findfirst_continue     ; if successful, no carry flag set
        cmp ax,NO_FILES
        jz short findfirst_no_files_found
        cmp byte ptr [fsbackup],0
        jz short findfirst_errors        ; the scan routine appends '*.*'
        mov cx,40                        ;  or '\*.*' to filespec, but
        mov si,offset fsbackup           ;  it isn't always needed, so
        mov di,offset filespec           ;  if error, we return to
        rep movsw                        ;  original unaltered filespec
        mov byte ptr [fsbackup],0        ;  and try again
        jmp short findfirst_find
findfirst_errors:
        cmp ax,INVALID_PATH
        jnz short findfirst_no_files_found
        call print_full_filespec
        mov si,offset invalid_path_msg
        call print2                      ; non-redirectable error msg
        mov byte ptr [error],INVALID_PATH
findfirst_no_files_found:
        cmp ax,NO_FILES
        jnz short findfirst_ret
        call print_full_filespec
        mov si,offset no_files_msg
        call print2                      ; make sure it's printed to screen
        mov byte ptr [error],NO_FILES    ; save errorlevel for later
        jmp short findfirst_ret
findfirst_continue:
        call print_full_filespec         ; 'c:\program\files\zip\*.*'
        call print_crlf
        call print_file                  ; prints filename if /F
        call print_dir                   ; prints filename if /D
        call print_name                  ; prints filename all other times
findfirst_ret:
        ret

; findnext
findnext:
        test word ptr [options],OPT_D    ; find next matching file
        jnz short findnext_find
        test word ptr [options],OPT_F
        jnz short findnext_find
        cmp word ptr [numitems],0        ; leave if findfirst failed
        jz short findnext_ret            ;  but skip this if /F or /D
findnext_find:
        mov ah,4Fh
        mov cx,ALL_FILES
        mov dx,offset filespec
        int 21h
        jc short findnext_ret            ; carry flag = error
        call print_file                  ; /F only
        call print_dir                   ; /D only
        call print_name                  ; all other times
        jmp short findnext
findnext_ret:
        ret

; print
print:
        mov ah,2                         ; SI = offset of string
print_load:                              ; prints string to screen
        mov dl,byte ptr [si]             ; redirectable
        inc si
        or dl,dl
        jz short print_load_ret
        int 21h
        jmp short print_load
print_load_ret:
        ret

; print2
print2:
        lodsb                            ; SI = offset of string
        or al,al                         ; prints string to screen
        jz short print2_ret              ; non-redirectable
        int 29h
        jmp short print2
print2_ret:
        ret

; print_filename
print_filename:
        inc word ptr [numitems]
        call lowercase
        mov si,offset dta+1Eh            ; offset of ASCIIZ filename in DTA
        call getlen                      ; get it's length
        mov word ptr [fnlen],ax          ; put it here so we can align it
        call print
        call print_info                  ; info that comes after filename
        call add_total
        call test_redir                  ; test if redirecting to file
print_filename_ret:                      ;  or if we need to pause
        ret

; print_info
print_info:
        call print_size                  ; print filesize if not dir
        call print_msg                   ;  otherwise print [dir]
        call print_date                  ;  if /V print file date
        call print_time                  ;  if /V print file time
        call print_attr                  ;  if /V print file attribs
        call print_crlf_fake             ; /V is different than /B or /S
print_info_ret:
        ret

; print_crlf_fake
print_crlf_fake:                         ; only prints linefeed
        test word ptr [options],OPT_B    ;  on every other file
        jnz short print_crlf_fake_begin
        test word ptr [options],OPT_S
        jnz short print_crlf_fake_begin
        test word ptr [options],OPT_V
        jnz short print_crlf_fake_begin
        xor dx,dx
        mov ax,word ptr [numitems]
        mov cx,2
        div cx
        or dx,dx
        jnz short print_crlf_fake_ret
print_crlf_fake_begin:
        call print_crlf
print_crlf_fake_ret:
        ret

; print_size
print_size:
        test word ptr [options],OPT_S    ; /S doesn't have filesizes
        jnz short print_size_spaces
        mov cx,20
        mov bx,word ptr [fnlen]
        sub cx,bx
        call print_spaces                ; pre-align with spaces
        test byte ptr [dta+15h],DIR
        jnz short print_size_ret
        mov dx,word ptr [dta+1Ch]        ; high word of filesize in DTA
        mov ax,word ptr [dta+1Ah]        ; low word of filesize
        call print_dword                 ; converts DX:AX to ASCIIZ string
        mov si,offset backup
        call getlen                      ; get length and save it
        mov word ptr [fnlen],ax
        call print                       ; print number
print_size_spaces:
        call spaces                      ; post-align number with spaces
print_size_ret:
        ret

; print_msg
print_msg:
        test word ptr [options],OPT_S
        jnz short print_msg_spaces
        test byte ptr [dta+15h],DIR
        jz short print_msg_ret           ; if not a dir, leave
        mov si,offset dirmsg
        call getlen                      ; otherwise, get length
        mov word ptr [fnlen],ax          ;  of msg, save it, and
        call print                       ;  and print
print_msg_spaces:
        call spaces                      ; then, post-align with spaces
print_msg_ret:
        ret


; print_date
print_date:
        test word ptr [options],OPT_V    ; leave if /V isn't set
        jz short print_date_ret
        call filedate                    ; put filedate in buffer
        mov si,offset buffer
        call print                       ; print filedate
print_date_ret:
        ret

; print_time
print_time:
        test word ptr [options],OPT_V
        jz short print_time_ret
        mov cx,5
        call print_spaces                ; post-align with spaces
        call filetime                    ; put filetime in buffer
        mov si,offset buffer
        call print                       ; print filetime
print_time_ret:
        ret

; print_attr
print_attr:
        test word ptr [options],OPT_V
        jz short print_attr_ret
        mov cx,5
        call print_spaces                ; post-align with spaces
        call fileattr                    ; put attributes in buffer
        mov si,offset buffer
        call print                       ; print attributes
print_attr_ret:
        ret

; print_name
print_name:
        test word ptr [options],OPT_F    ; leave if /F or /D are set
        jnz short print_name_ret         ;  (remember, /F and /D together
        test word ptr [options],OPT_D    ;  cancel each other out)
        jnz short print_name_ret
        call print_filename
print_name_ret:
        ret

; print_file
print_file:
        test word ptr [options],OPT_F    ; if /F not set, leave
        jz short print_file_ret
        test byte ptr [dta+15h],DIR      ; if dir, leave
        jnz short print_file_ret
        call print_filename
print_file_ret:
        ret

; print_dir
print_dir:
        test word ptr [options],OPT_D    ; if /D not set, leave
        jz short print_dir_ret
        test byte ptr [dta+15h],DIR      ; if not dir, leave
        jz short print_dir_ret
        call print_filename
print_dir_ret:
        ret

; print_spaces
print_spaces:                            ; print CX number of spaces
        mov dl,' '
print_spaces_loop:
        call print_char
        loop print_spaces_loop
print_spaces_ret:
        ret

; print_crlf
print_crlf:                              ; print linefeed
        mov si,offset crlf
        call print
print_crlf_ret:
        ret

; print_char
print_char:                              ; print single character in DL
        mov ah,2
        int 21h
print_char_ret:
        ret

; print_full_filespec
print_full_filespec:                     ; print drive, dir, filespec searched
        mov si,offset filespec
        cmp byte ptr [si+1],':'
        jnz short print_full_filespec_fix
        call letter_toupper
        xor ah,ah
        lodsb
        sub al,'A'
        inc al
        mov byte ptr [drive],al          ; save user-chosen drive for /i
        test word ptr [options],OPT_L
        jnz short print_full_filespec_ret
        jmp short print_full_filespec_finish
print_full_filespec_fix:
        call default_drive               ; if no drive in filespec, get default
print_full_filespec_finish:
        call print_filespec              ; print raw filespec (no path)
print_full_filespec_ret:
        ret

; default_drive
default_drive:
        test word ptr [options],OPT_L
        jnz short default_drive_ret
        mov di,offset fsbackup
        mov ah,19h                       ; get drive
        int 21h
        inc al
        mov byte ptr [drive],al          ; save drive for int 21h,36h
        dec al
        add al,'a'
        stosb
        mov al,':'
        stosb
        mov al,'\'
        stosb
        mov byte ptr [di],0
        dec di
        mov si,offset fsbackup
        call print
default_drive_ret:
        ret

; default_dir
default_dir:                             ; get default dir if needed
        mov si,offset filespec
        cmp byte ptr [si],'\'
        jz short default_dir_ret
        cmp byte ptr [si+1],':'
        jz short default_dir_ret
        mov ah,47h
        mov dl,byte ptr [drive]
        mov si,offset fsbackup
        int 21h
        mov si,offset fsbackup           ; reuse filespec backup data area
        call tolower                     ;  to store the default dir
        call print
        cmp byte ptr [di],'\'
        jz short default_dir_ret
        mov dl,'\'
        call print_char
default_dir_ret:
        ret

; print_filespec
print_filespec:
        test word ptr [options],OPT_L
        jnz short print_filespec_ret
        call default_dir                 ; print dir (if needed)
        mov si,offset filespec           ;  and user-inputed spec
        cmp byte ptr [si],'\'
        jnz short print_filespec_continue
        inc si
print_filespec_continue:
        call tolower                     ; convert to lower case
        call print                       ; print raw filespec
        call print_crlf
print_filespec_ret:
        ret

; spaces
spaces:                                  ; post-space alignment for
        mov cx,19                        ;  even-numbered files
        mov bx,word ptr [fnlen]
        sub cx,bx
        call print_spaces
spaces_ret:
        ret

; scan
scan:                                    ; add '*.*' or '\*.*'
        mov si,offset filespec           ;  to filespec, if needed
        mov di,offset fsbackup           ;  (and even if we aren't sure)
        mov cx,40
        rep movsw
        mov al,0
        mov di,offset filespec
        cmp byte ptr [di],0
        jz short scan_dec_di
        mov cx,80
        repnz scasb
        sub di,2
        cmp byte ptr [di],'\'
        jz short scan_load_all
        inc di
        mov byte ptr [di],'\'
        jmp short scan_load_all
scan_dec_di:
        dec di
scan_load_all:
        inc di
        mov si,offset all
        mov cx,4
        rep movsb
        mov byte ptr [di],0
scan_ret:
        ret

; check_help
check_help:                              ; my parser only parses options
        mov al,'/'                       ;  with letter (i.e. /A), so
        mov cx,19h                       ;  this routine makes /? = /H
        mov di,81h
check_help_again:
        repnz scasb
        jcxz check_help_ret
        cmp byte ptr [di],'?'
        jnz short check_help_again
        mov byte ptr [di],'H'
check_help_ret:
        ret

; lowercase
lowercase:                               ; convert filename to lowercase
        test byte ptr [dta+15h],DIR      ;  if /U isn't set
        jz short lowercase_filecount
        inc word ptr [numdirs]
        jmp short lowercase_test_opt_u
lowercase_filecount:
        inc word ptr [numfiles]
lowercase_test_opt_u:
        test word ptr [options],OPT_U
        jnz short lowercase_ret
        test byte ptr [dta+15h],DIR
        jnz short lowercase_ret
        mov si,offset dta+1Eh
        call tolower
lowercase_ret:
        ret

; tolower
tolower:                                 ; SI = offset of string to convert
        push si                          ; makes ASCIIZ string lowercase
        dec si
tolower_try_again:
        inc si
        cmp byte ptr [si],0
        jz short tolower_leave
        cmp byte ptr [si],'A'
        jb short tolower_try_again
        cmp byte ptr [si],'Z'
        ja short tolower_try_again
        add byte ptr [si],'a'-'A'
        jmp short tolower_try_again
tolower_leave:
        pop si
tolower_ret:
        ret

; letter_toupper
letter_toupper:                          ; converts [si] to uppercase letter
        cmp byte ptr [si],'A'            ;  and returns '!' if failed
        jb short letter_toupper_fix
        cmp byte ptr [si],'Z'
        jbe short letter_toupper_ret
        cmp byte ptr [si],'a'
        jb short letter_toupper_fix
        cmp byte ptr [si],'z'
        ja short letter_toupper_fix
        sub byte ptr [si],'a'-'A'
        jmp short letter_toupper_ret
letter_toupper_fix:
        mov byte ptr [si],'!'
letter_toupper_ret:
        ret

; option_i
option_i:
        xor word ptr [options],OPT_I     ; toggle option I
option_i_ret:
        ret

; option_l
option_l:
        xor word ptr [options],OPT_L     ; toggle option L
option_l_ret:
        ret

; option_u
option_u:
        xor word ptr [options],OPT_U     ; toggle option U
option_u_ret:
        ret

; option_h
option_h:
        mov si,offset help_msg           ; print help msg, exit program
        call print
        mov ax,4C00h
        int 21h
option_h_ret:
        ret

; option_p
option_p:
        xor word ptr [options],OPT_P     ; toggle option P
option_p_ret:
        ret

; option_d
option_d:
        test word ptr [options],OPT_F
        jz short option_d_set
        xor word ptr [options],OPT_F     ; if /F, un-toggle /F
        jmp short option_d_ret
option_d_set:
        xor word ptr [options],OPT_D     ; toggle option D
option_d_ret:
        ret

; option_f
option_f:
        test word ptr [options],OPT_D
        jz short option_f_set
        xor word ptr [options],OPT_D     ; if /D, un-toggle /D
        jmp short option_f_ret
option_f_set:
        xor word ptr [options],OPT_F     ; toggle option F
option_f_ret:
        ret

; option_z
option_z:                                ; multiple options  /Z:abcd
        inc si                           ;  where abcd are the options
        mov cl,byte ptr [si]
        cmp byte ptr [si],':'            ; /Z alone won't work
        jnz short option_z_ret           ;  it must be /Z:
option_z_load:
        inc si
        mov cl,byte ptr [si]
        call letter_toupper
        cmp byte ptr [si],'!'
        jz short option_z_ret
        call setup_option
        cmp word ptr [bx],0              ; ignore if option offset is 0
        jz short option_z_load
        call word ptr [bx]               ; call option
        jmp short option_z_load
option_z_ret:
        mov byte ptr [si],cl
        dec si
        ret

; option_r
option_r:                                ; reset to textmode 3 (80x25)
        mov ax,3
        int 10h
option_r_ret:
        ret

; option_t
option_t:                                ; /T will print time and date
        push si                          ;  non-redirectably but
        call print_crlf                  ;  /T: will append time and date
        call date                        ;  to text file
        mov si,offset buffer
        call print2
        mov dl,' '
        call print_char
        call time
        mov si,offset buffer
        call print2
        pop si
        inc si
        cmp byte ptr [si],':'
        jnz short option_t_exit
        inc si
        cmp byte ptr [si],CR
        jz short option_t_exit
        mov di,si
        mov cx,80
        mov al,CR
        repnz scasb
        jcxz option_t_error
        sub di,si
        dec di
        mov cx,di
        mov di,offset logfile
        rep movsb                        ; save destination filename
        mov byte ptr [di],0
        call write_logfile               ; write logfile, if possible
        jmp short option_t_exit
option_t_error:
        push cx
        mov si,offset logfile_error
        call print2                      ; non-redirectable error msg
        pop cx                           ;  to force error to screen
        jcxz option_t_exit
        mov si,offset logfile
        call print2                      ; non-redirectable
option_t_exit:
        call print_crlf
        mov ax,4C00h
        int 21h

; option_v
option_v:
        test word ptr [options],OPT_S
        jnz short option_v_ret
        test word ptr [options],OPT_B
        jnz short option_v_ret           ; if /B or /S aren't set,
        xor word ptr [options],OPT_V     ;  toggle option V
        mov byte ptr [pausenum],15
option_v_ret:
        ret

; option_s
option_s:
        test word ptr [options],OPT_V
        jnz short option_s_ret
        test word ptr [options],OPT_B
        jnz short option_s_ret           ; if /V or /B aren't set,
        xor word ptr [options],OPT_S     ;  toggle option S
        mov byte ptr [pausenum],15
option_s_ret:
        ret

; option_b
option_b:
        test word ptr [options],OPT_S
        jnz short option_b_ret
        test word ptr [options],OPT_V
        jnz short option_b_ret           ; if /S or /V aren't set,
        xor word ptr [options],OPT_B     ;  toggle option B
        mov byte ptr [pausenum],15
option_b_ret:
        ret

; pause
pause:
        test word ptr [options],OPT_P
        jnz short pause_ret
        xor dx,dx
        mov ax,word ptr [numitems]
        xor ch,ch
        mov cl,byte ptr [pausenum]       ; if so many files have been found,
        div cx                           ;  then pause the output
        or dx,dx
        jnz short pause_ret
        mov ah,8
        int 21h
pause_ret:
        ret

; test_redir
test_redir:
        mov ax,4400h
        mov bx,1                         ; 1 = STDOUT
        int 21h
        jc short test_redir_pause
        test dx,0000000010000000b        ; check for device
        jnz short test_redir_pause       ; if not found, skip this
        test dx,0000000000000010b        ; check for file redirection
        jz short test_redir_pause        ; if true, ignore pauses automatically
        jmp short test_redir_ret
test_redir_pause:
        call pause                       ; only pause if no file redirection
test_redir_ret:
        ret

; setup_dta
setup_dta:
        mov ah,1Ah                       ; change default DTA's location
        mov dx,offset dta
        int 21h
setup_dta_ret:
        ret

; date
date:                                    ; put current date into buffer
        mov si,offset days               ;  as ASCIIZ string
        mov di,offset buffer
        mov ah,2Ah
        int 21h
date_day_of_week:
        xor ah,ah
        mov bx,cx
        mov cx,3
        mul cl
        add si,ax                        ; load array, select correct day
        rep movsb
        mov al,' '
        stosb
date_month:
        xor ah,ah
        mov al,dh
        dec al
        mov si,offset months             ; load array of months
        mov cl,3
        mul cl
        add si,ax
        rep movsb                        ; select correct month
        mov al,' '
        stosb
date_day_of_month:
        xor ah,ah
        mov al,dl
        mov cl,10
        div cl
        or ax,'00'                       ; make into ASCII number, store
        stosw
        mov al,','                       ; put a comma after it
        stosb
date_year:                               ; the following could've been
        xor dx,dx                        ;  done with bin2dec instead,
        mov ax,bx                        ;  which would've reduced the
        mov bx,4                         ;  .COM size, but I preferred
        jmp short date_skip_xchg_again   ;  to keep it easily portable
date_year_digit:
        xchg bx,cx
date_skip_xchg_again:
        div cx
        xchg dx,ax
        or al,'0'
        push ax
        xor ax,ax
        xchg dx,ax
        xchg bx,cx
        loop date_year_digit
        mov cx,4
date_year_store:
        pop ax
        stosb
        loop date_year_store             ; store year
        mov byte ptr [di],0
date_ret:
        ret

; time
time:                                    ; puts current time into buffer
        mov di,offset buffer
        mov ah,2Ch
        int 21h
        cmp ch,12
        jb short time_am
        cmp ch,12
        jz short time_noon
        sub ch,12
time_noon:
        mov si,offset pm_msg
        jmp short time_not_midnight
time_am:
        mov si,offset am_msg
time_midnight:
        or ch,ch
        jnz short time_not_midnight
        add ch,12
time_not_midnight:
        xor ah,ah
        mov al,ch
        aaa
        or ax,'00'                       ; convert to ASCII number
        xchg al,ah
        stosw                            ; store hour
        mov al,':'
        stosb                            ; put a colon after it
        xor ah,ah
        mov al,cl
        mov cl,10
        div cl
        or ax,'00'                       ; convert minutes to ASCII
        stosw                            ;  and store it
        push di
        call getlen                      ; get length of ?m_msg string used
        pop di
        mov cx,ax
        rep movsb                        ; store it
        mov byte ptr [di],0
time_ret:
        ret

; filedate
filedate:                                ; puts filedate into buffer as ASCII
        mov si,offset months
        mov di,offset buffer
        mov ax,word ptr [dta+18h]        ; offset of file's date in DTA
        mov bx,ax
filedate_month:
        and ax,0000000111100000b
        mov cl,5
        shr ax,cl
        dec ax
        mov cx,3
        mul cx
        add si,ax                        ; load offset of array
        rep movsb                        ;  and store month's name
        mov al,' '
        stosb
        mov ax,bx
filedate_day:
        and ax,0000000000011111b
        mov cx,10
        div cl
        or ax,'00'                       ; convert day to ASCII number
        stosw                            ;  and store it
        mov ax,','
        stosb                            ; put a comma after it
        mov ax,bx
filedate_year:
        and ax,1111111000000000b
        xchg ah,al
        shr al,1
        add ax,1980
        xor dx,dx                        ; redundant, but keeps it portable
        mov bx,4
        jmp short filedate_skip_xchg
filedate_year_digit:
        xchg bx,cx
filedate_skip_xchg:
        div cx
        xchg dx,ax
        or al,'0'
        push ax
        xor ax,ax
        xchg dx,ax
        xchg bx,cx
        loop filedate_year_digit
        mov cx,4
filedate_year_store:
        pop ax
        stosb
        loop filedate_year_store         ; store filedate's year in buffer
        mov byte ptr [di],0
filedate_ret:
        ret

; filetime
filetime:                                ; puts filetime into buffer as ASCII
        mov di,offset buffer
        mov ax,word ptr [dta+16h]        ; offset of file's time
        mov bx,ax
filetime_hour:
        and ax,1111100000000000b
        mov cl,11
        shr ax,cl
        or al,al
        jz short filetime_midnight
        cmp al,12
        jb short filetime_morning
        cmp al,12
        jz short filetime_afternoon
        sub al,12
filetime_afternoon:
        mov si,offset pm_msg
        jmp short filetime_continue
filetime_midnight:
        add al,12
filetime_morning:
        mov si,offset am_msg
filetime_continue:
        mov cl,10
        div cl
        or ax,'00'                       ; convert hour, store it
        stosw
        mov al,':'
        stosb                            ; put a colon after it
        mov ax,bx
filetime_minutes:
        and ax,0000011111100000b
        mov cl,5
        shr ax,cl
        mov cl,10
        div cl
        or ax,'00'                       ; convert minutes, store it
        stosw
        mov al,':'                       ; put a colon after it
        stosb
        mov ax,bx
filetime_seconds:
        and ax,0000000000011111b
        shl ax,1
        mov cl,10
        div cl
        or ax,'00'                       ; convert seconds, store it
        stosw
        push di
        call getlen                      ; get length of ?m_msg string used
        pop di
        mov cx,ax
        rep movsb                        ; store it
        mov byte ptr [di],0
filetime_ret:
        ret

; fileattr
fileattr:                                ; puts attributes into buffer
        mov di,offset buffer             ;  as ASCII (no, I don't consider
        mov si,di                        ;  [dir] an attribute)
        xor bh,bh
        mov bl,byte ptr [dta+15h]        ; offset of file's attributes
        mov ax,'..'
        mov cx,2
        rep stosw                        ; make '....' default (no attribs)
        mov byte ptr [di],0
        mov di,si
fileattr_archive:
        xor ah,ah
        mov al,'a'
        mov dx,ARCHIVE                   ; test for archive
        call test_attrib
fileattr_system:
        xor ah,ah
        mov al,'s'
        mov dx,SYSTEM                    ; test for system
        call test_attrib
fileattr_hidden:
        xor ah,ah
        mov al,'h'
        mov dx,HIDDEN                    ; test for hidden
        call test_attrib
fileattr_readonly:
        xor ah,ah
        mov al,'r'
        mov dx,READONLY                  ; test for readonly
        call test_attrib
fileattr_ret:
        ret

; test_attrib
test_attrib:
        test bx,dx
        jz short test_attrib_inc
        mov byte ptr [di],al
test_attrib_inc:
        inc di
test_attrib_ret:
        ret

; misc_info
misc_info:
        test word ptr [options],OPT_I
        jz short misc_info_ret
        call print_crlf
        call count_items                 ; counts number of items, dirs,
        call time_info                   ;  and files found
        call hdspace                     ; prints free HD space on drive
        call print_crlf                  ;  in filespec
misc_info_ret:
        ret

; count_items
count_items:                             ; prints number of items,
        mov ax,word ptr [numitems]       ;  dirs, and files found
        call print_word
        call print_fancy_number
        mov si,offset items_msg
        call print
        mov ax,word ptr [numdirs]
        call print_word
        call print_fancy_number
        mov si,offset dirs_msg
        call print
        mov ax,word ptr [numfiles]
        call print_word
        call print_fancy_number
        mov si,offset files_msg
        call print
        mov ax,word ptr [total]
        mov dx,word ptr [total+2]        ; prints total space used by files
        call print_dword
        call print_fancy_number
        mov si,offset bytes
        call print
        call print_crlf
count_items_ret:
        ret

; add_total
add_total:                               ; saves total space used by files
        mov ax,word ptr [total]
        mov bx,word ptr [dta+1Ah]
        add ax,bx
        mov word ptr [total],ax
        mov ax,word ptr [total+2]
        mov bx,word ptr [dta+1Ch]
        adc ax,bx
        mov word ptr [total+2],ax
add_total_ret:
        ret

; hdspace
hdspace:                                 ; prints free space on drive
        mov ah,36h
        mov dl,byte ptr [drive]          ; drive is default unless otherwise
        int 21h                          ;  specified in filespec (i.e. a:\)
        mul cx
        mul bx
        call print_dword
        call print_fancy_number
        mov si,offset bytes_msg
        call print
hdspace_ret:
        ret

; time_info
time_info:                               ; prints time and date
        call date
        mov si,offset buffer
        call print
        mov dl,' '
        call print_char
        call time
        mov si,offset buffer
        call print
        mov dl,';'
        call print_char
        mov dl,' '
        call print_char
time_info_ret:
        ret

; odd_crlf
odd_crlf:                                ; only prints linefeed on
        call opt_f_no_files              ;  every other file found
        test word ptr [options],OPT_S    ;  (does the opposite of
        jnz short odd_crlf_ret           ;  print_crlf_fake)
        test word ptr [options],OPT_B
        jnz short odd_crlf_ret
        test word ptr [options],OPT_V
        jnz short odd_crlf_ret
        xor dx,dx
        mov ax,word ptr [numitems]
        mov cx,2
        div cx
        or dx,dx
        jz short odd_crlf_ret
        call print_crlf
odd_crlf_ret:
        ret

; opt_f_no_files
opt_f_no_files:                          ; prints error msg if only dirs
        test word ptr [options],OPT_F    ;  are detected when using /F
        jz short opt_f_no_files_ret
        cmp word ptr [numitems],0
        jnz short opt_f_no_files_ret
        mov si,offset no_files_msg
        call print2                      ; make sure it's printed to screen
        mov byte ptr [error],NO_FILES    ; save errorlevel for later
opt_f_no_files_ret:
        ret

; write_logfile
write_logfile:                           ; writes time and date to file
        call textfiles_only              ;  (only .TXT files!)
        cmp byte ptr [logfile],0         ; 0 = non-text file
        jnz short write_logfile_write
        ret
write_logfile_write:
        mov ax,3D01h                     ; open for write
        mov dx,offset logfile
        int 21h
        jc short write_logfile_create    ; if error, we must create it
write_logfile_append:
        mov word ptr [handle],ax
        mov ax,4202h                     ; move file pointer to end
        mov bx,word ptr [handle]         ;  to append data
        xor cx,cx
        xor dx,dx
        int 21h
        jmp short write_logfile_date
write_logfile_create:
        mov ah,3Ch                       ; create file
        xor cx,cx
        int 21h
        mov word ptr [handle],ax         ; save file's handle
write_logfile_date:
        call date
        mov al,0
        mov cx,20
        mov di,offset buffer
        repnz scasb
        mov byte ptr [di],0
        dec di
        mov byte ptr [di],' '            ; add a space after the date
write_logfile_date_save:
        mov si,offset buffer
        call getlen                      ; get length of string in buffer
        mov cx,ax
        mov ah,40h                       ; write buffer to file
        mov bx,word ptr [handle]
        mov dx,offset buffer
        int 21h
        jc short write_logfile_error     ; if carry, error occurred
        cmp cx,ax
        jnz short write_logfile_error    ; if AX not = CX, error
write_logfile_time:
        call time
        mov al,0
        mov cx,10
        repnz scasb
        dec di
        mov ax,0A0Dh                     ; add linefeed to time string
        stosw
        mov byte ptr [di],0
write_logfile_time_save:
        mov si,offset buffer
        call getlen                      ; get length of time buffer
        mov cx,ax
        mov ah,40h                       ; write buffer to file
        mov bx,word ptr [handle]
        mov dx,offset buffer
        int 21h
        jc short write_logfile_error     ; if carry, error
        cmp cx,ax
        jz short write_logfile_close     ; if AX not = CX, error
write_logfile_error:
        call logfile_error_print         ; print filename
        jmp short write_logfile_ret
write_logfile_close:
        mov ah,3Eh                       ; close logfile
        mov bx,word ptr [handle]
        int 21h
write_logfile_ret:
        ret

; logfile_error_print
logfile_error_print:
        mov si,offset logfile_error      ; print filename to screen
        call print2                      ;  (non-redirectable!)
        mov si,offset logfile
        call print2
logfile_error_print_ret:
        ret

; textfiles_only
textfiles_only:                          ; checks for .txt, aborts otherwise
        mov al,'.'
        mov cx,80
        mov di,offset logfile
        repnz scasb
        jcxz textfiles_only_error
        mov cx,3
        mov si,offset textfile
        repz cmpsb
        jz textfiles_only_ret
textfiles_only_error:
        call logfile_error_print
        mov byte ptr [logfile],0         ; [logfile] = 0 if not textfile
textfiles_only_ret:
        ret

; getlen
getlen:                                  ; gets the length of ASCIIZ
        mov al,0                         ;  string whose offset is in SI
        mov di,si                        ;  (preserves SI)
        mov cx,750
        repnz scasb
        sub di,si
        dec di
        mov ax,di
getlen_ret:
        ret


; bin2dec (written by Terje Mathisen, modified by me)
bin2dec:
        mov di,offset buffer             ; converts DX:AX to ASCIIZ string
        push bx                          ;  without commas
        push cx
        push si
        mov si,dx
        mov bx,10
        mov cx,sp
bin2dec_big:
        cmp dx,bx
        jb short bin2dec_small
        xchg ax,si
        xor dx,dx
        div bx
        xchg ax,si
        div bx
        push dx
        mov dx,si
        jmp short bin2dec_big
bin2dec_small:
        div bx
        push dx
        xor dx,dx
        or ax,ax
        jnz short bin2dec_small
bin2dec_store:
        pop ax
        add al,'0'
        stosb
        cmp cx,sp
        jne short bin2dec_store
        mov byte ptr [di],0
        pop si
        pop cx
        pop bx
bin2dec_ret:
        ret

; put_commas
put_commas:                              ; adds commas to ASCIIZ number
        mov si,offset buffer             ; (it's not very efficient)
        mov al,0
        mov cx,12
        mov dl,cl
        mov di,offset buffer
        repnz scasb
        mov di,offset backup
        inc cl
        mov al,cl
        sub dl,al
        xchg dl,al
        cmp al,3
        jb short put_commas_small_numbers
        mov cl,3
        div cl
        mov bl,al
        or ah,ah
        jz short put_commas_continue
        mov cl,ah
        rep movsb
        mov bl,al
        mov al,','
        stosb
put_commas_continue:
        mov cl,bl
put_commas_loop_here:
        push cx
        mov cx,3
        rep movsb
        mov al,','
        stosb
        pop cx
        loop put_commas_loop_here
        dec di
        mov byte ptr [di],0
        jmp short put_commas_ret
put_commas_small_numbers:
        mov cl,al
        rep movsb
        mov byte ptr [di],0
put_commas_ret:
        ret

; print_word
print_word:
        xor dx,dx
        call print_dword
print_word_ret:
        ret

; print_dword
print_dword:
        call bin2dec
        call put_commas
print_dword_ret:
        ret

; print_fancy_number
print_fancy_number:
        mov si,offset backup             ; print comma-fied number
        call print
print_fancy_number_ret:
        ret

; =============
  segment .data                          ; initialized data segment (NASM)
; =============

all db '*.*',0
crlf db CR,LF,0
dirmsg db '[dir]',0
am_msg db 'am',0
pm_msg db 'pm',0
bytes_msg db ' bytes free',0
items_msg db ' items: ',0
dirs_msg db ' dirs; ',0
files_msg db ' files totaling ',0
bytes db ' bytes',0
invalid_path_msg db 'Invalid path.',CR,LF,0
no_files_msg db 'No files found.',CR,LF,0
logfile_error db CR,LF,'Could not write to file: ',0
textfile db 'txt'

days db 'SunMonTueWedThuFriSat'
months db 'JanFebMarAprMayJunJulAugSepOctNovDec'

help_msg db CR,LF,'DirWide 2.10 - anthonyw@dibbs.net',CR,LF
         db 'Usage:  dw [*.*] [options]',CR,LF,CR,LF
         db '/b bare mode (fname,fsize)',CR,LF
         db '/d dirs only',CR,LF
         db '/f files only',CR,LF
         db '/h this help screen',CR,LF
         db '/i misc info after listing',CR,LF
         db '/l no filespec printing',CR,LF
         db '/p no pausing',CR,LF
         db '/r goto textmode 3 (80x25)',CR,LF
         db '/s script mode (fname)',CR,LF
         db '/t: print/write date and time',CR,LF
         db '/u keep filenames uppercase',CR,LF
         db '/v verbose file info',CR,LF
         db '/z: aligning options',CR,LF,0

pausenum db 30

;               A B        C D        E F        G
options_list dw 0,option_b,0,option_d,0,option_f,0

;              H        I        J K L        M N
            dw option_h,option_i,0,0,option_l,0,0

;              O P        Q R        S        T        U
            dw 0,option_p,0,option_r,option_s,option_t,option_u

;              V        W X Y Z
            dw option_v,0,0,0,option_z

total dd 0
numitems dw 0
numfiles dw 0
numdirs dw 0

options dw 0                             ; default options
                                         ; 1 = on, 0 = off
                                         ; options dw 0000000000000000b
                                         ;            ILUPFDVSB.......

handle dw 0
fnlen dw 0
error db 0                               ; error number
drive db 0                               ; drive used for int 21h,36h

; dta db 43 dup(?)                       ; uninitialized data (MASM)
; filespec db 80 dup(?)
; fsbackup db 80 dup(?)
; logfile db 80 dup(?)
; buffer db 16 dup(?)
; backup db 16 dup(?)

; ============
  segment .bss                           ; uninitialized data (NASM)
; ============

dta resb 43
filespec resb 80
fsbackup resb 80
logfile resb 80
buffer resb 16
backup resb 16

; code ends                              ; end of code segment (MASM)
; end Start
