/*************************************************************
 *                                                           *
 * Program DCOPY - physical sector to sector copy     	     *
 * Copyright (c) 1986 Joerg Genius, Munich, West-Germany     *
 *                                                           *
 *************************************************************/

#include <stdio.h>
#include <alloc.h>
#include <sys\types.h>
#include <sys\stat.h>
#include "dcdefs.h"


dfdestination (f_name,von,nach,nocompress)

int von,nocompress;
FILE *nach;
char *f_name;

{
   struct drive_data source;
   unsigned int blcnt,seccnt;
   register unsigned int ccnt,current;
   int error;
   unsigned char *freesec; /* SECTOR BITMAP */
   unsigned char *freewhat;
   unsigned char *dsk_buf;
   unsigned int sec_maps;
   unsigned int w_count=0;
   unsigned int max_blocks;


   if (get_drive_data(von,&source)!=0)
      return 1;
   if (nocompress==0 && blk_p_buffer>64)
      blk_p_buffer=64;
   max_blocks=get_max_blocks(source.sec_p_drive);
   printf (text[8],d_types[disk_type]);
   printf (text[9],source.sec_p_drive,von+'A',f_name);
   if (nocompress) {
      for (blcnt=0;blcnt<source.sec_p_drive;blcnt+=max_blocks) {
         max_blocks=(blcnt+max_blocks>=source.sec_p_drive ? source.sec_p_drive-blcnt : max_blocks);
         if ((error=read_block(von,blcnt,max_blocks,disk_buffer))!=0) {
            fprintf (stderr,text[10],error,err_text[error]);
            return 1;
         }
         if (fwrite(disk_buffer,512,max_blocks,nach)!=max_blocks) {
            fprintf (stderr,text[11]);
            return 1;
         }
      }
      printf (text[12],source.sec_p_drive,von+'A',f_name);
      return 0;
   }
   if ((freesec=malloc((source.sec_p_drive+7)/8))==NULL ||
       (freewhat=malloc(source.sec_p_drive))==NULL) {
      fprintf (stderr,text[2]);
      return 1;
   }
   sec_maps=(source.sec_p_drive+7)/8;
   for (blcnt=0;blcnt<sec_maps;freesec[blcnt++]=0);
   if (fwrite(&source.sec_p_drive,2,1,nach)!=1) {
      fprintf (stderr,text[11]);
      return 1;
   }
   if (fwrite(freesec,1,sec_maps,nach)!=sec_maps) {
      fprintf (stderr,text[11]);
      return 1;
   }
   if (fwrite(freewhat,1,source.sec_p_drive,nach)!=source.sec_p_drive) {
      fprintf (stderr,text[11]);
      return 1;
   }
   for (blcnt=0;blcnt<source.sec_p_drive;blcnt+=max_blocks) {
      max_blocks=(blcnt+max_blocks>=source.sec_p_drive ? source.sec_p_drive-blcnt : max_blocks);
      if ((error=read_block(von,blcnt,max_blocks,disk_buffer))!=0) {
         fprintf (stderr,text[10],error,err_text[error]);
         return 1;
      }
      dsk_buf=disk_buffer;
      for (seccnt=blcnt;seccnt<blcnt+max_blocks;seccnt++) {
	 current=dsk_buf[0];
	 ccnt=0;
	 while (ccnt<512 && dsk_buf[ccnt++]==current);
	 if (ccnt<512) {
            w_count++;
            if (fwrite(dsk_buf,1,512,nach)!=512) {
               fprintf (stderr,text[11]);
               return 1;
            }
	 }
	 else {
            freesec[seccnt/8]|=1<<((seccnt)%8);
	    freewhat[seccnt]=current;
	 }
         dsk_buf+=512;
      }
   }
   fseek(nach,(long)2,0);
   if (fwrite(freesec,1,sec_maps,nach)!=sec_maps) {
      fprintf (stderr,text[11]);
      return 1;
   }
   if (fwrite(freewhat,1,source.sec_p_drive,nach)!=source.sec_p_drive) {
      fprintf (stderr,text[11]);
      return 1;
   }
   printf (text[12],source.sec_p_drive,von+'A',f_name);
   printf (text[13],(long)(source.sec_p_drive-w_count)*(long)512-(long)(sec_maps+source.sec_p_drive+2));
   return 0;
}

