{-----------------------------------------------------------------------------}
{                                                                             }
{ AE -- ANOTHER EDITOR                                                        }
{ WRITTEN IN TURBO PASCAL 5.5                                                 }
{                                                                             }
{-----------------------------------------------------------------------------}
{ KEY DEFINITIONS                                                             }
{                                                                             }
{           NORMAL                      SHIFT                                 }
{           --------------------------  ------------------------------        }
{ F1        HELP                        SETUP                                 }
{ F2        SAVE FILE                   WRITE TO FILE                         }
{ F3        LOAD FILE                   INSERT FILE                           }
{ F4        FIND                        FIND & REPLACE                        }
{ F5        PUT MARK                    ERASE MARK                            }
{ F6        CUT BLOCK TO PASTE BUFFER   DELETE BLOCK                          }
{ F7        COPY BLOCK TO PASTE BUFFER  COMPARE BLOCK TO PASTE BUFFER         }
{ F8        PASTE BLOCK                 PRINT BLOCK                           }
{ F9        NEXT WINDOW                 PREVIOUS WINDOW                       }
{ F10       DOS COMMAND                                                       }
{                                                                             }
{ alt 0-9   REPLAY MACRO                                                      }
{     A     SWITCH TO WINDOW A                                                }
{     B                                                                       }
{     C     CENTER LINE                                                       }
{     D     DEFINE KEYBOARD MACRO                                             }
{     E     EJECT PRINTER PAGE                                                }
{     F     FORMAT PARAGRAPH                                                  }
{     G     GET SAVED POSITION                                                }
{     H                                                                       }
{     I     IBM CHARACTER SET (ASCII TABLE)                                   }
{     J     JUSTIFY LINE TO RIGHT                                             }
{     K                                                                       }
{     L     DELETE LINE                                                       }
{     M     MATCH BRACKETS                                                    }
{     N     NEW (CLEAR FILE BUFFER)                                           }
{     O                                                                       }
{     P     PRINT ENTIRE FILE BUFFER                                          }
{     Q     DISPLAY EDITOR STATUS                                             }
{     R     REPEAT LAST FIND/REPLACE                                          }
{     S     SAVE POSITION                                                     }
{     T     TOGGLE CASE IN BLOCK                                              }
{     U                                                                       }
{     V                                                                       }
{     W     DELETE WORD FORWARD                                               }
{     X     EXIT PROGRAM                                                      }
{     Y                                                                       }
{     Z     DISPLAY VERSION NUMBER AND DATE                                   }
{                                                                             }
{ FIND/REPLACE OPTIONS: I = IGNORE CASE                                       }
{                       N = NO QUERY                                          }
{                       R = REVERSE SEARCH                                    }
{                                                                             }
{ SETUP : E = ENVIRONMENT                                                     }
{                K = KEYCLICK (ON/OFF)                                        }
{                B = BELL (ON/OFF)                                            }
{                W = WORD WRAP LENGTH (0 = OFF)                               }
{                T = TAB SPACING                                              }
{                A = AUTO-INDENT (ON/OFF)                                     }
{                I = INSERT/OVERWRITE                                         }
{         F = FILE                                                            }
{                E = SAVE FILES ON EXIT (ON/OFF)                              }
{                I = INTERVAL FOR AUTO-SAVE (0 = OFF)                         }
{                B = MAKE .BAK FILE (ON/OFF)                                  }
{         P = PRINTER                                                         }
{                P = PAGE LENGTH (0 = OFF)                                    }
{                L = LEFT MARGIN                                              }
{                T = TOP MARGIN                                               }
{                N = PRINT PAGE NUMBERS (ON/OFF)                              }
{         D = DISPLAY                                                         }
{                T = CHANGE CURSOR TYPE                                       }
{                C = CHANGE SCREEN COLORS                                     }
{                D = DISPLAY SPACES AS DOTS (ON/OFF)                          }
{         S = SAVE SETTINGS                                                   }
{                                                                             }
{-----------------------------------------------------------------------------}
{                                                                             }
{ COPYRIGHT (c) 1991-1993 DICK ALSTEIN                                            }
{ Read the copyright notice accompanying the package                          }
{                                                                             }
{-----------------------------------------------------------------------------}

PROGRAM AE ;

{$M 8192, 92000, 224000}
{ memory requirements: stack size, min heap size, max heap size }

{$R-}  { array range checking off }
{$B-}  { short-circuit boolean evaluation }
{$I-}  { do not generate run-time errors for I/O operations }
{$S+}  { stack checking on }
{$V-}  { relaxed var string checking }

USES Crt, Dos, Printer, AE0, AE1, AE2, AE3, AE4, AE5 ;

BEGIN
AEVersionNr := '1.7' ;
AEVersionDate := '24 Mar 1993' ;
Initialize ;
REPEAT IF (MacroStackPointer = Inactive) AND
          (Config.Setup.FastRedraw OR (NOT KEYPRESSED))
          THEN RedrawScreen ;
       ExecKey (GetKeyNr) ;
UNTIL ProgramFinished ;
ShutOff ;
END.
