/* Copyright (C) Stephen Chung, 1991-1993.  All rights reserved. */

#include "jwp.h"
#include <math.h>


static struct {
    int spacing;
    int spacemulti;
} NewSettings;


static BOOL ReformatProc (FILEOPTIONS *f, PARAGRAPH far *p, int n)
{
    p->spacing = NewSettings.spacing;
    p->spacemulti = NewSettings.spacemulti;

    return (TRUE);
}


BOOL FAR PASCAL FormatParagraphProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    switch (message) {
        case WM_INITDIALOG: {
            int left, right, first, spacemulti;
            PARAGRAPH far *pp, far *start, far *stop;
            char buffer[MAXLINELEN];

            if (SELPARA1(global.active) == NULL) {
                start = CURPARA(global.active);
                stop = start->next;
            } else {
                start = SELPARA1(global.active);
                stop = SELPARA2(global.active)->next;
            }

            left = start->leftindent;
            right = start->rightindent;
            first = start->firstindent - start->leftindent;
            spacemulti = start->spacemulti;

            SetDlgItemInt(hwnd, 4201, left, TRUE);
            SetDlgItemInt(hwnd, 4202, right, TRUE);
            SetDlgItemInt(hwnd, 4203, first, TRUE);

            for (pp = start; pp != stop; pp = pp->next) {
                if (left != pp->leftindent) SetDlgItemText(hwnd, 4201, "");
                if (right != pp->rightindent) SetDlgItemText(hwnd, 4202, "");
                if (first != (pp->firstindent - pp->leftindent)) SetDlgItemText(hwnd, 4203, "");
                if (spacemulti != pp->spacemulti) spacemulti = -1;
            }

            SendDlgItemMessage(hwnd, 4201, EM_LIMITTEXT, 3, 0L);
            SendDlgItemMessage(hwnd, 4202, EM_LIMITTEXT, 3, 0L);
            SendDlgItemMessage(hwnd, 4203, EM_LIMITTEXT, 3, 0L);
            SendDlgItemMessage(hwnd, 4211, EM_LIMITTEXT, 4, 0L);

            if (spacemulti >= 100) {
                if (spacemulti % 100 == 0) {
                    sprintf(buffer, "%d", spacemulti / 100);
                } else if (spacemulti % 10 == 0) {
                    sprintf(buffer, "%3.1lf", (double) spacemulti / 100.0);
                } else {
                    sprintf(buffer, "%4.2lf", (double) spacemulti / 100.0);
				}
                SetDlgItemText(hwnd, 4211, buffer);
            } else {
                SetDlgItemText(hwnd, 4211, "");
            }

            CenterDialogBox(hwnd);
            return (TRUE);
        }

		case WM_COMMAND:
            switch (wParam) {
                case IDOK: {
                    int i, left, right, first;
					double r;
                    PARAGRAPH far *pp, far *start, far *stop;
					char buffer[MAXLINELEN];
                    char word[MAXLINELEN];

                    if (SELPARA1(global.active) == NULL) {
                        start = CURPARA(global.active);
                        stop = start->next;
                        UndoAddFormatParagraph(global.active, global.active->current, global.active->current);
                    } else {
                        start = SELPARA1(global.active);
                        stop = SELPARA2(global.active)->next;
                        UndoAddFormatParagraph(global.active, SEL1(global.active), SEL2(global.active));
                    }

                    for (i = 0, pp = start; pp != stop; i++, pp = pp->next) {
                        left = pp->leftindent;
                        right = pp->rightindent;
                        first = pp->firstindent;

                        /* Indentations */

                        GetDlgItemText(hwnd, 4201, buffer, MAXLINELEN);
                        word[0] = '\0'; sscanf(buffer, "%s", word);
                        if (word[0]) left = atoi(word);

                        GetDlgItemText(hwnd, 4202, buffer, MAXLINELEN);
                        word[0] = '\0'; sscanf(buffer, "%s", word);
                        if (word[0]) right = atoi(word);

                        GetDlgItemText(hwnd, 4203, buffer, MAXLINELEN);
                        word[0] = '\0'; sscanf(buffer, "%s", word);
                        if (word[0]) first = left + atoi(word);

                        if (left >= 256 || right >= 256 || first >= 256) {
                            ErrorMessage(hwnd, "Indentations must be smaller than 255!");
                            return (TRUE);
                        }
                        if (left < 0 || right < 0 || first < 0) {
                            ErrorMessage(hwnd, "Indentations cannot be negative!");
                                return (TRUE);
                        }
                        if (first + right >= global.active->linelen) {
                            ErrorMessage(hwnd, "Total first-line indentation is larger than "
                                               "the total length of line #%d!", i + 1);
                            return (TRUE);
                        }
                        if (left + right >= global.active->linelen) {
                            ErrorMessage(hwnd, "Total line indentation is larger than "
                                               "the total length of line #%d!", i + 1);
                            return (TRUE);
                        }

                        if (left != pp->leftindent) {
                            pp->leftindent = left;
                            global.active->changed = TRUE;
                        }
                        if (right != pp->rightindent) {
                            pp->rightindent = right;
                            global.active->changed = TRUE;
                        }
                        if (first != pp->firstindent) {
                            pp->firstindent = first;
                            global.active->changed = TRUE;
                        }
                    }

                    /* Line spacing */

                    GetDlgItemText(hwnd, 4211, buffer, MAXLINELEN);
                    word[0] = '\0'; sscanf(buffer, "%s", word);
                    if (word[0]) {
                        r = atof(word);
                        if (r < 1.0) r = 1.0;
                        NewSettings.spacemulti = (int) floor(r * 100.0 + 0.5);

                        NewSettings.spacing = (global.active->basefont->height + global.active->spacing) * r;
                        NewSettings.spacing -= global.active->basefont->height;

                        SetReformatProc(ReformatProc);
                        global.active->changed = TRUE;
                    }

                    EndDialog(hwnd, TRUE);
                    return (TRUE);
                }

                case IDCANCEL:
                    EndDialog(hwnd, FALSE);
                    return (TRUE);
            }
            break;
    }

    return (FALSE);
}
