unit jphands;
{
This unit was written for JugglePro on March 17, 1993
}

Interface

procedure setorientation; {default orientation of hands}
procedure setuphands;  {default setup of hands}
procedure puthands(filename:string);  {output to disk}
procedure savehands;   {saves hands to disk}
procedure loadhands;   {loads hands from disk}
procedure edithands2;  {uses graphics for visual hand movement entry}
procedure permhands;   {entry of permutation rule for hands}

Implementation
uses crt,graph,header,demoinput,jpdos,jpfcts,menus;

procedure setorientation;
var
  i,j,x,y,z:integer;

begin
  for i:=1 to hact do
    for j:=1 to nt*ti+1 do
      begin
        x:=hpx[1,hi(i,j)];
        y:=hpy[1,hi(i,j)];
        z:=hpz[1,hi(i,j)];
        if i mod 2 = 0 then hpx[2,hi(i,j)]:=x+15
                       else hpx[2,hi(i,j)]:=x-15;
        hpy[2,hi(i,j)]:=y;
        hpz[2,hi(i,j)]:=z;
        hpx[3,hi(i,j)]:=x;
        hpy[3,hi(i,j)]:=y-15;
        hpz[3,hi(i,j)]:=z;
      end;
end;

procedure setuphands;
var
  j:integer;
begin
  moveflag:=false;              {no movement}
  nt:=1;                        {period of movement set to one}
  ti:=1;                        {time steps per frame = one}
  for j:=1 to hact do           {go thru each actual hand}
    begin
      hpx[1,hi(j,1)]:=round(cx*2/(hact+1)*j);   {evenly spaced across}
      hpy[1,hi(j,1)]:=cy*2-30;  {set these to bottom of screen}
      hpz[1,hi(j,1)]:=cy*2-18;
      permrule[j]:=j;           {set permutation rule to identity}
    end;
  setorientation;
  hedit:=hact;                  {record this edit}
end;

procedure puthands(filename:string);
var
  out:text;
  i,t,tmp,o:integer;

begin
  assign(out,filename);                   {prepare for writing}
  rewrite(out);
  writeln(out,hact,'x',nt,'x',ti);        {follow hand data format}
  for i:=1 to hact do
   begin
    for t:=1 to nt*ti do
      begin
        tmp:=round(hpx[1,hi(i,t)]/xscale);      {values scaled for output}
        write(out,'(',tmp,',');
        tmp:=round((maxheight-hpy[1,hi(i,t)])/yscale);
        write(out,tmp,',');
        tmp:=round((maxheight-hpz[1,hi(i,t)]+6)/zscale);
        write(out,tmp,')');
      end;
    writeln(out);
   end;
  writeln(out,'639x399x399');    {maxx by maxy by maxz: jp uses this std.}
  for i:=1 to hact do
    begin                        {permutation rule (optional)}
      if i>1 then write(out,',');
      write(out,permrule[i])
    end;
  writeln(out);
  for o:=2 to 3 do              {orientation coordinates}
    begin
      for i:=1 to hact do
       begin
        for t:=1 to nt*ti do
          begin
            tmp:=round(hpx[o,hi(i,t)]/xscale);  {values scaled for output}
            write(out,'(',tmp,',');
            tmp:=round((maxheight-hpy[o,hi(i,t)])/yscale);
            write(out,tmp,',');
            tmp:=round((maxheight-hpz[o,hi(i,t)]+6)/zscale);
            write(out,tmp,')');
          end;
        writeln(out);
       end;
    end;
  close(out);
end;

procedure savehands;
var
  filename:string[40];

begin
  window(1,2,79,8);
  clrscr;
  write('Filename:');
  readlndemo(filename);
  if pos('.',filename)=0 then filename:=filename+'.hnd';
  puthands(path+filename);
  clrscr;
end;

procedure loadhands;
var
  filename:string[40];
  line:array [1..1024] of char;
  inn:text;
  maxx,maxy,maxz,x2,x,i,t,o,newh,tmp,e,linelen:integer;
  f,xsize,ysize,zsize:real;
  q,s:string;

procedure readln2;
var i:integer;
begin
  i:=0;
  repeat
    i:=i+1;
    read(inn,line[i]);
  until (line[i]=chr(10));    {read until end of line reached}
  linelen:=i;                 {up to 1024 characters allowed}
end;

function pos2(x:char; s,e:integer):integer;
begin
  while (s<=e) and (line[s]<>x) do   {find position of x in line}
    s:=s+1;
  if s=e+1 then pos2:=0
           else pos2:=s;
end;

function copy2(s,e:integer):string;
var i:integer;
    q:string;

begin                       {copy chars from s to e into string}
  q:='';
  for i:=s to e do
    q:=q+line[i];
  copy2:=q;
end;

procedure resize(o:byte);
var i,j:integer;

begin
  xsize:=maxx/getmaxx;      {transform coordinates from (maxx,maxy,maxz)}
  ysize:=maxy/maxheight;    {scale to normal screen scale}
  zsize:=maxz/(maxheight+6);
  for i:=1 to nt*ti do
  for j:=1 to newh do
    begin
      hpx[o,hi(j,i)]:=round(hpx[o,hi(j,i)]/xsize);
      hpy[o,hi(j,i)]:=maxheight-round(hpy[o,hi(j,i)]/ysize); {flip vertical}
      hpz[o,hi(j,i)]:=maxheight+6-round(hpz[o,hi(j,i)]/zsize);
    end;
end;

procedure readhandcoords(o:byte);
var
  x,x2,tmp,i,t,e:integer;

begin
  for i:=1 to newh do
    begin
      readln2;
      x2:=0;
      for t:=1 to nt*ti do
       begin                          { (hpx,hpy,hpz) }
        x:=pos2('(',x2+1,linelen);
        x2:=pos2(',',x+1,linelen);
        val(copy2(x+1,x2-1),tmp,e);
        hpx[o,hi(i,t)]:=tmp;
        x:=pos2(',',x2+1,linelen);
        val(copy2(x2+1,x-1),tmp,e);
        hpy[o,hi(i,t)]:=tmp;
        x2:=pos2(')',x+1,linelen);
        val(copy2(x+1,x2-1),tmp,e);
        hpz[o,hi(i,t)]:=tmp;
       end;
    end;
end;

begin
  window(1,2,79,25);
  clrscr;
  filename:=getfilename('hnd');
  clrscr;
  if filename='.hnd' then exit;
  assign(inn,path+filename);
  {$i-}
  reset(inn);
  {$i+}
  if ioresult<>0
    then hitenter('Hand file missing!')
    else
      begin
        readln(inn,q);                {(newh) x (nt) x (ti)}
        s:=parse1(q,1,'x');
        x:=ord(s[1]);
        delete(s,1,1);
        val(s,newh,e);
        s:=parse1(q,x,'x');
        x:=ord(s[1]);
        delete(s,1,1);
        val(s,nt,e);
        val(copy(q,x,length(q)-x+1),ti,e);
        if hact<>newh then
         begin
          clrscr;
          writeln('WARNING: ',newh,' hand(s) required');
          write('Hit enter');
          readlndemo(q);
         end;
        readhandcoords(1);
        readln(inn,q);                 { (maxx,maxy,maxz) }
        x:=pos('x',q);                 {this is just as easy as}
        val(copy(q,1,x-1),maxx,e);     {using parse1}
        delete(q,1,x);
        x:=pos('x',q);
        val(copy(q,1,x-1),maxy,e);
        delete(q,1,x);
        val(q,maxz,e);
        resize(1);                     {coordinate transformation}
        moveflag:=true;
        if nt=1 then moveflag:=false;
        for i:=1 to newh do      {default permutation to identity}
          permrule[i]:=i;
        readln(inn,q);
        if length(q)>0 then
         begin
          for i:=1 to newh-1 do        { 3,2,1,6,5,4 }
            begin
             x:=pos(',',q);
             val(copy(q,1,x-1),permrule[i],e);
             delete(q,1,x);
            end;
          val(q,permrule[newh],e);
         end;
        if eof(inn) then setorientation
                    else begin
                           readhandcoords(2);
                           resize(2);
                           readhandcoords(3);
                           resize(3);
                         end;
        close(inn);
        t:=nt*ti+1;
        for i:=1 to newh do
          for o:=1 to 3 do
            begin
              hpx[o,hi(i,t)]:=hpx[o,hi(i,1)];
              hpy[o,hi(i,t)]:=hpy[o,hi(i,1)];
              hpz[o,hi(i,t)]:=hpz[o,hi(i,1)];
            end;
        hedit:=newh;                  {flag the edit}
        clrscr;
      end;
end;

procedure edithands2;
var
  ox,oy,oz,dv,dx,x1,y1,z1,x2,y2,z2,x3,y3,z3,dlin:integer;
  timestep,frame,plane,handnum,stepsize,t,i,o:byte;
  exflg:boolean;
  ch:char;
  s:string;
  coordbufx,coordbufy,coordbufz:array [1..3,1..20] of integer;

procedure setupeh2;
var
  ont,oti:byte;
  e:integer;
  s:string;

begin
  window(1,2,79,23);
  clrscr;
  writeln('                     HAND MOVEMENT EDITOR');
  writeln('Z...................Shows X-Z plane (side view)');
  writeln('Y...................Shows X-Y plane (aerial view)');
  writeln('Arrow keys..........Move the hand in X-Z or X-Y planes');
  writeln('N...................Takes you to the next timestep');
  writeln('P...................Takes you to the previous timestep');
  writeln('1-9.................Specifies which hand to modify');
  writeln('A-K.................Specifies which hand (10-20) to modify');
  writeln('L...................Sets a large stepsize equal to 10');
  writeln('S...................Sets a small stepsize equal to 1');
  writeln('Alt C...............Copies all hand coordinates to clipboard');
  writeln('Alt P...............Pastes clipboard to current timestep');
  writeln('Enter...............Allows direct entry of coordinates');
  writeln('Alt 1-3.............Rotates the hand in plane number specified');
  writeln;
  writeln('The hand under modification is the one holding the ball.');
  writeln;
  writeln('Specify number of throws after which movement repeats.  Then');
  writeln('specify the number of time intervals you wish to specify the');
  writeln('movement per frametime.');
  ont:=nt;
  repeat
    write('# of throws/cycle of movement: (',nt,') ');
    readlndemo(s);
    if (s='X') or (s='x') then
      begin
        clrscr;
        exit;
      end;
    val(s,nt,e);
    if length(s)=0 then nt:=ont;
  until nt>0;
  oti:=ti;
  repeat
    write('# of time intervals/frametime: (',ti,') ');
    readlndemo(s);
    if (s='X') or (s='x') then
      begin
        clrscr;
        exit;
      end;
    val(s,ti,e);
    if length(s)=0 then ti:=oti;
  until ti>0;
  if (nt<>ont) or (ti<>oti) then setorientation;
end;

procedure plothand(k,x1,y1,z1,x2,y2,z2,x3,y3,z3:integer);
begin
  if plane=1 then
    if oktoplot(x1,z1) then
      begin
        if k=handnum then putimage(x1,z1-18,ball[1,5],normalput);
        setcolor(1);
        if oktoplot(x2,z2) then line(x1,z1,x2,z2);
        setcolor(3);
        if oktoplot(x3,z3) then line(x1,z1,x3,z3);
      end;
  if plane=2 then
    if oktoplot(x1,y1) then
      begin
        if k=handnum then putimage(x1,y1-10,ball[1,5],normalput);
        setcolor(1);
        if oktoplot(x2,y2) then line(x1,y1,x2,y2);
        setcolor(3);
        if oktoplot(x3,y3) then line(x1,y1,x3,y3);
      end;
end;

procedure displayeh2;
var i:byte;
    s:string;
begin                {display hands, key and all variables}
  cleardevice;
  for i:=1 to hact do
    plothand(i,hpx[1,hi(i,t)],hpy[1,hi(i,t)],hpz[1,hi(i,t)],
               hpx[2,hi(i,t)],hpy[2,hi(i,t)],hpz[2,hi(i,t)],
               hpx[3,hi(i,t)],hpy[3,hi(i,t)],hpz[3,hi(i,t)]);
  moveto(0,dlin);
  outtext('hand=  frame=  timestep=   x=     y=     z=          Esc to exit');
  moveto(0,0);
  outtext('KEY: 1,2..=hand P=-step N=+step Y=aerial Z=side L=long S=small Enter=direct');
  moveto(0,10);
  outtext('     Alt 1-3=rotate hand');
  str(handnum,s);
  outtextxy(5*8,dlin,s);
  str(frame,s);
  outtextxy(13*8,dlin,s);
  str(timestep,s);
  outtextxy(24*8,dlin,s);
  str(x1,s);
  outtextxy(29*8,dlin,s);
  str(y1,s);
  outtextxy(36*8,dlin,s);
  str(z1,s);
  outtextxy(43*8,dlin,s);
end;

procedure setxyz;
begin
  t:=(frame-1)*ti+timestep;              {get the time step, t}
  x1:=hpx[1,hi(handnum,t)]-xorigin;             {find x,y,z coordinates}
  y1:=maxheight-hpy[1,hi(handnum,t)]-yorigin;   {for user from arrays}
  z1:=maxheight+6-hpz[1,hi(handnum,t)]-zorigin;
  x2:=hpx[2,hi(handnum,t)]-xorigin;
  y2:=maxheight-hpy[2,hi(handnum,t)]-yorigin;
  z2:=maxheight+6-hpz[2,hi(handnum,t)]-zorigin;
  x3:=hpx[3,hi(handnum,t)]-xorigin;
  y3:=maxheight-hpy[3,hi(handnum,t)]-yorigin;
  z3:=maxheight+6-hpz[3,hi(handnum,t)]-zorigin;
end;

procedure dectime;
begin                           {decrease timestep by one}
  timestep:=timestep-1;
  if timestep=0 then
    begin
      timestep:=ti;
      frame:=frame-1;           {previous frame}
    end;
  if frame=0 then frame:=nt;    {wrap-around}
  setxyz;                       {get the new x,y,z}
end;

procedure inctime;
begin                           {increase timestep by one}
  timestep:=timestep+1;
  if timestep=ti+1 then
    begin
      timestep:=1;
      frame:=frame+1;           {next frame}
    end;
  if frame=nt+1 then frame:=1;  {wrap-around}
  setxyz;                       {get the new x,y,z}
end;

procedure editcoords;
var
  e,ox,oy,oz:integer;
  s:string;

begin
  window(10,4,13,7);
  clrscr;
  repeat                               {numerically}
    ox:=hpx[1,hi(handnum,t)]-xorigin;
    moveto(0,50);
    outtext('enter x: ');
    readlndemo(s);
    val(s,x1,e);
    if length(s)=0 then x1:=ox;
  until (x1>=-xorigin) and (x1<=getmaxx-xorigin);
  x2:=x2+x1-ox;
  x3:=x3+x1-ox;
  repeat
    oy:=maxheight-hpy[1,hi(handnum,t)]-yorigin;
    moveto(0,65);
    outtext('enter y: ');
    readlndemo(s);
    val(s,y1,e);
    if length(s)=0 then y1:=oy;
  until (y1>=-yorigin) and (y1<=getmaxy-yorigin);
  y2:=y2+y1-oy;
  y3:=y3+y1-oy;
  repeat
    oz:=maxheight+6-hpz[1,hi(handnum,t)]-zorigin;
    moveto(0,80);
    outtext('enter z: ');
    readlndemo(s);
    val(s,z1,e);
    if length(s)=0 then z1:=oz;
  until (z1>=-zorigin) and (z1<=getmaxy-zorigin);
  z2:=z2+z1-oz;
  z3:=z3+z1-oz;
end;

procedure copycoords;
var i,o:byte;
begin                           {copy all hands in this timestep}
for i:=1 to hact do             {into the buffer}
 for o:=1 to 3 do
   begin
    coordbufx[o,i]:=hpx[o,hi(i,t)];
    coordbufy[o,i]:=hpy[o,hi(i,t)];
    coordbufz[o,i]:=hpz[o,hi(i,t)];
   end;
end;

procedure pastecoords;
var i,o:byte;
begin                           {copy buffer into hand arrays}
for i:=1 to hact do
 for o:=1 to 3 do
   begin
     hpx[o,hi(i,t)]:=coordbufx[o,i];
     hpy[o,hi(i,t)]:=coordbufy[o,i];
     hpz[o,hi(i,t)]:=coordbufz[o,i];
   end;
setxyz;
end;

procedure rothxy;
var
  xx,yy:real;

begin
  xx:=x2-x1;
  yy:=y2-y1;
  transform(xx,yy);
  x2:=round(xx+x1);
  y2:=round(yy+y1);
  xx:=x3-x1;
  yy:=y3-y1;
  transform(xx,yy);
  x3:=round(xx+x1);
  y3:=round(yy+y1);
end;

procedure rothxz;
var
  xx,zz:real;

begin
  xx:=x2-x1;
  zz:=z2-z1;
  transform(xx,zz);
  x2:=round(xx+x1);
  z2:=round(zz+z1);
  xx:=x3-x1;
  zz:=z3-z1;
  transform(xx,zz);
  x3:=round(xx+x1);
  z3:=round(zz+z1);
end;

procedure rothyz;
var
  yy,zz:real;

begin
  yy:=y2-y1;
  zz:=z2-z1;
  transform(yy,zz);
  y2:=round(yy+y1);
  z2:=round(zz+z1);
  yy:=y3-y1;
  zz:=z3-z1;
  transform(yy,zz);
  y3:=round(yy+y1);
  z3:=round(zz+z1);
end;

begin
 setupeh2;
 dlin:=cy*2-8;  {position of data line}
 setgraphmode(graphmode);
 exflg:=false;
 plane:=1;      {default to X-Z plane (up/down)}
 frame:=1;
 timestep:=1;
 handnum:=1;    {current hand number for edit}
 stepsize:=10;  {large step size default}
 setxyz;        {get x,y,z of hand}
 repeat
   displayeh2;  {clear graphics screen and display hands,etc}
   ch:=readkeydemo;  {check ch for handnum entry}
   if (ch>='1') and (ch<='9') then handnum:=ord(ch)-48;
   if ((upcase(ch)>='A') and (upcase(ch)<='K'))
     then handnum:=ord(upcase(ch))-55;
   if handnum>hact then handnum:=hact;
   setxyz;      {new hand --update x,y,z variables}
   if ch=chr(13) then editcoords;  {enter for numeric entry}
   if (ch='y') or (ch='Y') then plane:=2;  {X-Y plane (aerial)}
   if (ch='z') or (ch='Z') then plane:=1;  {X-Z plane (side)}
   if (ch='p') or (ch='P') then dectime;   {p for previous}
   if (ch='n') or (ch='N') then inctime;   {n for next}
   if ch=chr(27) then exflg:=true;         {esc to exit}
   if (ch='l') or (ch='L') then stepsize:=10;  {large stepsize}
   if (ch='s') or (ch='S') then stepsize:=1;   {small stepsize}
   if ch=chr(0) then
     begin                                 {change coordinates and}
       ch:=readkeydemo;                    {orientation of selected hand}
       dx:=0;
       dv:=0;
       if ch='P' then dv:=-stepsize;
       if ch='K' then dx:=-stepsize;
       if ch='H' then dv:=stepsize;
       if ch='M' then dx:=stepsize;
       x1:=x1+dx;
       x2:=x2+dx;
       x3:=x3+dx;
       if plane=1
         then begin
                z1:=z1+dv;
                z2:=z2+dv;
                z3:=z3+dv;
              end
         else begin
                y1:=y1+dv;
                y2:=y2+dv;
                y3:=y3+dv;
              end;
       if ch=chr(46) then copycoords;      {ALT C}
       if ch=chr(25) then pastecoords;     {ALT P}
       if ch='x' then rothxy;   {ALT 1}
       if ch='y' then rothxz;   {ALT 2}
       if ch='z' then rothyz;   {ALT 3}
     end;
   hpx[1,hi(handnum,t)]:=x1+xorigin;              {store coordinates}
   hpz[1,hi(handnum,t)]:=maxheight+6-z1-zorigin;
   hpy[1,hi(handnum,t)]:=maxheight-y1-yorigin;
   hpx[2,hi(handnum,t)]:=x2+xorigin;
   hpz[2,hi(handnum,t)]:=maxheight+6-z2-zorigin;
   hpy[2,hi(handnum,t)]:=maxheight-y2-yorigin;
   hpx[3,hi(handnum,t)]:=x3+xorigin;
   hpz[3,hi(handnum,t)]:=maxheight+6-z3-zorigin;
   hpy[3,hi(handnum,t)]:=maxheight-y3-yorigin;
 until exflg;
 setupmenu;
 t:=nt*ti+1;
 for i:=1 to hact do
   for o:=1 to 3 do
     begin
       hpx[o,hi(i,t)]:=hpx[o,hi(i,1)];
       hpy[o,hi(i,t)]:=hpy[o,hi(i,1)];
       hpz[o,hi(i,t)]:=hpz[o,hi(i,1)];
     end;
 moveflag:=true;
 if nt=1 then moveflag:=false;
 hedit:=hact;                     {flag the edit}
end;

procedure permhands;
var
  i,opr:byte;
  e:integer;
  s:string;

begin
  window(1,2,79,25);
  clrscr;
  writeln('                *** Permute Hands ***');
  writeln;
  writeln('In passing patterns there are many instances where an initial');
  writeln('formation is returned to but with persons interchanged (for');
  writeln('example Bruno''s Nightmare).  Permuting hands saves you time and');
  writeln('effort and also saves memory.  Below is a permutation rule.');
  writeln('It tells the computer which hands to change to after completing');
  writeln('one period of the movement.');
  writeln;
  for i:=1 to hact do        {show hand numbers}
    write(i:3);
  writeln;
  for i:=1 to hact do        {show permutation rule}
    write(permrule[i]:3);
  writeln;
  for i:=1 to hact do        {input new permutation rule}
    begin
     opr:=permrule[i];
     write(i,' goes to? ');
     readlndemo(s);
     val(s,permrule[i],e);
     if length(s)=0 then permrule[i]:=opr;
    end;
  clrscr;
end;

var i,j,o:byte;
begin
  hact:=2;    {default setup to two hands}
  nt:=1;      {default setup to no movement}
  ti:=1;
  moveflag:=false;
  for i:=1 to 20 do          {set all hand coordinates to nice values}
    begin
      for j:=1 to 50 do
      for o:=1 to 3 do
        begin
          hpx[o,hi(i,j)]:=40;
          hpz[o,hi(i,j)]:=40;
          hpy[o,hi(i,j)]:=40;
        end;
      permrule[i]:=i;       {set permutation rule to identity}
    end;
  setuphands;               {setup two hands at bottom}
end.
