/*
 * Decompiled with CFR 0.152.
 */
package sync;

import java.io.File;
import java.util.Date;
import java.util.Locale;
import sync.Sync;
import sync.SyncIO;

class FileUnit {
    final File file;
    final boolean isDirectory;
    final String name;
    final long size;
    final long time;
    private boolean computedCrc = false;
    private long crc = 0L;
    FileUnit match = null;
    boolean sameName = false;
    boolean sameSize = false;
    boolean sameTime = false;
    boolean sameCrc = false;
    private String sizeString = null;
    private String timeString = null;
    private String crcString = null;

    FileUnit(File f) {
        this.file = f;
        this.time = f.lastModified();
        this.isDirectory = f.isDirectory();
        if (this.isDirectory) {
            this.name = SyncIO.trimTrailingSeparator(f.getName()) + File.separatorChar;
            this.size = 0L;
            this.crc = 0L;
            this.computedCrc = true;
        } else {
            this.name = f.getName();
            this.size = f.length();
        }
    }

    public long getCrc() {
        if (!this.computedCrc) {
            SyncIO.Crc32Checksum result = SyncIO.getCrc32Checksum(this.file);
            if (result.error == null) {
                this.crc = result.checksum;
                this.computedCrc = true;
            } else {
                Sync.reportWarning("Unable to compute CRC-32 checksum of file \"" + this.file.getPath() + "\".\nThe CRC-32 checksum of this file will be assumed to be 0.");
                this.crc = 0L;
                this.computedCrc = true;
            }
        }
        return this.crc;
    }

    public String getSizeString() {
        if (this.sizeString == null) {
            this.sizeString = this.size < 1024L ? String.format("%d b", this.size) : (this.size < 0x100000L ? String.format("%.1f kb", (double)this.size / 1024.0) : (this.size < 0x40000000L ? String.format("%.1f Mb", (double)this.size / 1048576.0) : String.format("%.1f Gb", (double)this.size / 1.073741824E9)));
        }
        return this.sizeString;
    }

    public String getTimeString() {
        if (this.timeString == null) {
            this.timeString = String.format(Locale.ENGLISH, "%1$tF %1$tT.%1$tL", new Date(this.time));
        }
        return this.timeString;
    }

    public String getCrcString() {
        if (this.crcString == null) {
            this.crcString = Long.toHexString(this.getCrc()).toUpperCase(Locale.ENGLISH);
        }
        return this.crcString;
    }
}

