/*
 * Decompiled with CFR 0.152.
 */
package sync;

import java.util.Comparator;
import sync.FileUnit;

class FileUnitComparator
implements Comparator<FileUnit> {
    private final boolean name;
    private final boolean size;
    private final boolean time;
    private final boolean crc;

    FileUnitComparator(boolean name, boolean size, boolean time, boolean crc) {
        this.name = name;
        this.size = size;
        this.time = time;
        this.crc = crc;
    }

    @Override
    public int compare(FileUnit u1, FileUnit u2) {
        int i;
        if (this.name && (i = u1.name.compareTo(u2.name)) != 0) {
            return i;
        }
        if (this.size) {
            if (u1.size < u2.size) {
                return -1;
            }
            if (u1.size > u2.size) {
                return 1;
            }
        }
        if (this.time) {
            if (u1.time < u2.time) {
                return -1;
            }
            if (u1.time > u2.time) {
                return 1;
            }
        }
        if (this.crc) {
            if (u1.getCrc() < u2.getCrc()) {
                return -1;
            }
            if (u1.getCrc() > u2.getCrc()) {
                return 1;
            }
        }
        return 0;
    }
}

