/*
 * Decompiled with CFR 0.152.
 */
package sync;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class FilterNode {
    private final List<FilterNode> children;
    private final LogicType logic;
    private final Pattern pattern;
    private final boolean inverted;
    private final String stringValue;

    FilterNode(LogicType logic) {
        this.logic = logic;
        this.children = new ArrayList<FilterNode>();
        this.pattern = null;
        this.inverted = false;
        this.stringValue = null;
    }

    FilterNode(FilterType type, boolean inverted, String expression) throws PatternSyntaxException {
        this.logic = null;
        this.children = null;
        this.inverted = inverted;
        String s = null;
        Pattern p = null;
        switch (type) {
            case REGEX: {
                p = Pattern.compile(expression);
                s = inverted ? "regexnot" : "regex";
                break;
            }
            case GLOB: {
                p = FilterNode.globToRegexPattern(expression);
                s = inverted ? "globnot" : "glob";
            }
        }
        this.pattern = p;
        this.stringValue = s + "(\"" + expression + "\")";
    }

    public void addFilter(FilterNode child) {
        this.children.add(child);
    }

    public boolean matches(String s) {
        if (this.children == null) {
            return this.pattern.matcher(s).matches() != this.inverted;
        }
        if (this.children.isEmpty()) {
            throw new RuntimeException("FilterNode object is a non-leaf node without any children");
        }
        switch (this.logic) {
            case AND: {
                for (FilterNode n : this.children) {
                    if (n.matches(s)) continue;
                    return false;
                }
                return true;
            }
            case NAND: {
                for (FilterNode n : this.children) {
                    if (n.matches(s)) continue;
                    return true;
                }
                return false;
            }
            case OR: {
                for (FilterNode n : this.children) {
                    if (!n.matches(s)) continue;
                    return true;
                }
                return false;
            }
            case NOR: {
                for (FilterNode n : this.children) {
                    if (!n.matches(s)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static Pattern globToRegexPattern(String glob) throws PatternSyntaxException {
        ArrayDeque<String> parserMode = new ArrayDeque<String>();
        parserMode.push("--");
        int globLength = glob.length();
        int index = 0;
        StringBuilder t = new StringBuilder();
        while (index < globLength) {
            char c;
            if ((c = glob.charAt(index++)) == '\\') {
                if (index == globLength) {
                    t.append(Pattern.quote("\\"));
                    continue;
                }
                c = glob.charAt(index);
                String s = c + "";
                if ("--".equals(parserMode.peek()) && "\\[]{}?*".contains(s) || "[]".equals(parserMode.peek()) && "\\[]{}?*!-".contains(s) || "{}".equals(parserMode.peek()) && "\\[]{}?*,".contains(s)) {
                    ++index;
                    t.append(Pattern.quote(s));
                    continue;
                }
                t.append(Pattern.quote("\\"));
                continue;
            }
            if (c == '*') {
                t.append(".*");
                continue;
            }
            if (c == '?') {
                t.append('.');
                continue;
            }
            if (c == '[') {
                t.append('[');
                parserMode.push("[]");
                if (index >= globLength || glob.charAt(index) != '!') continue;
                ++index;
                t.append('^');
                continue;
            }
            if (c == ']' && "[]".equals(parserMode.peek())) {
                t.append(']');
                parserMode.pop();
                continue;
            }
            if (c == '-' && "[]".equals(parserMode.peek())) {
                t.append('-');
                continue;
            }
            if (c == '{') {
                t.append("(?:(?:");
                parserMode.push("{}");
                continue;
            }
            if (c == '}' && "{}".equals(parserMode.peek())) {
                t.append("))");
                parserMode.pop();
                continue;
            }
            if (c == ',' && "{}".equals(parserMode.peek())) {
                t.append(")|(?:");
                continue;
            }
            t.append(Pattern.quote(c + ""));
        }
        if ("[]".equals(parserMode.peek())) {
            throw new PatternSyntaxException("Cannot find matching closing square bracket ] in GLOB expression", glob, -1);
        }
        if ("{}".equals(parserMode.peek())) {
            throw new PatternSyntaxException("Cannot find matching closing curly brace } in GLOB expression", glob, -1);
        }
        return Pattern.compile(t.toString());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.children == null) {
            s.append(this.stringValue);
        } else {
            if (this.children.isEmpty()) {
                throw new RuntimeException("FilterNode object is a non-leaf node without any children");
            }
            String delimiter = null;
            switch (this.logic) {
                case AND: {
                    delimiter = " AND ";
                    break;
                }
                case NAND: {
                    s.append("NOT ");
                    delimiter = " AND ";
                    break;
                }
                case OR: {
                    delimiter = " OR ";
                    break;
                }
                case NOR: {
                    s.append("NOT ");
                    delimiter = " OR ";
                }
            }
            int n = this.children.size();
            if (n > 1) {
                s.append("{");
            }
            for (int i = 0; i < n - 1; ++i) {
                s.append(this.children.get(i).toString());
                s.append(delimiter);
            }
            s.append(this.children.get(n - 1).toString());
            if (n > 1) {
                s.append("}");
            }
        }
        return s.toString();
    }

    static enum FilterType {
        REGEX,
        GLOB;

    }

    static enum LogicType {
        AND,
        NAND,
        OR,
        NOR;

    }
}

