/*
 * Decompiled with CFR 0.152.
 */
package sync;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Scanner;
import java.util.zip.CRC32;
import sync.Sync;

class SyncIO {
    private static final int BUFFER_SIZE = 0x100000;

    SyncIO() {
    }

    static String setFileTime(File file, long time) {
        boolean success = file.setLastModified(time);
        if (!success) {
            return "Failed to set last-modified time using Java's File.setLastModified() method.";
        }
        return null;
    }

    static String renameFile(File source, File target) {
        boolean renameFile = false;
        File existingFile = null;
        String existingName = null;
        boolean existingIsDirectory = false;
        if (target.exists() && !target.equals(source)) {
            try {
                existingFile = target.getCanonicalFile();
            }
            catch (Exception e) {
                existingFile = target;
            }
            existingIsDirectory = existingFile.isDirectory();
            existingName = SyncIO.trimTrailingSeparator(existingFile.getName()) + (existingIsDirectory ? Character.valueOf(File.separatorChar) : "");
            if (Sync.defaultActionOnOverwrite == 'Y') {
                SyncIO.printFlush("\n  Overwriting existing " + (existingIsDirectory ? "directory" : "file") + " \"" + existingName + "\"");
                renameFile = true;
            } else if (Sync.defaultActionOnOverwrite == 'N') {
                SyncIO.printFlush("\n  Skipping overwriting of existing " + (existingIsDirectory ? "directory" : "file") + " \"" + existingName + "\"");
            } else if (Sync.defaultActionOnOverwrite == '\u0000') {
                SyncIO.print("\n  Overwrite existing " + (existingIsDirectory ? "directory" : "file") + " \"" + existingName + "\"?\n");
                char choice = SyncIO.userCharPrompt("  (Y)es/(N)o/(A)lways/Neve(R): ", "YNAR");
                if (choice == 'Y') {
                    renameFile = true;
                } else if (choice == 'A') {
                    Sync.defaultActionOnOverwrite = (char)89;
                    renameFile = true;
                } else if (choice == 'R') {
                    Sync.defaultActionOnOverwrite = (char)78;
                }
            }
        } else {
            renameFile = true;
        }
        if (renameFile) {
            boolean success;
            if (existingFile != null) {
                if (existingIsDirectory) {
                    String error = SyncIO.deleteDirTreeOperation(existingFile);
                    if (error != null) {
                        return "Failed to delete existing directory \"" + SyncIO.trimTrailingSeparator(existingFile.getPath()) + File.separatorChar + "\":\n" + error;
                    }
                } else {
                    boolean success2 = existingFile.delete();
                    if (!success2) {
                        return "Failed to delete existing file \"" + existingFile.getPath() + "\" using Java's File.delete() method.";
                    }
                }
            }
            if (success = source.renameTo(target)) {
                return null;
            }
            return "Failed to rename file using Java's File.renameTo() method.";
        }
        return "";
    }

    static String copyFile(File source, File target) {
        boolean copyFile = false;
        File existingFile = null;
        String existingName = null;
        boolean existingIsDirectory = false;
        if (target.exists()) {
            try {
                existingFile = target.getCanonicalFile();
            }
            catch (Exception e) {
                existingFile = target;
            }
            existingIsDirectory = existingFile.isDirectory();
            existingName = SyncIO.trimTrailingSeparator(existingFile.getName()) + (existingIsDirectory ? Character.valueOf(File.separatorChar) : "");
            if (Sync.defaultActionOnOverwrite == 'Y') {
                SyncIO.printFlush("\n  Overwriting existing " + (existingIsDirectory ? "directory" : "file") + " \"" + existingName + "\"");
                copyFile = true;
            } else if (Sync.defaultActionOnOverwrite == 'N') {
                SyncIO.printFlush("\n  Skipping overwriting of existing " + (existingIsDirectory ? "directory" : "file") + " \"" + existingName + "\"");
            } else if (Sync.defaultActionOnOverwrite == '\u0000') {
                SyncIO.print("\n  Overwrite existing " + (existingIsDirectory ? "directory" : "file") + " \"" + existingName + "\"?\n");
                char choice = SyncIO.userCharPrompt("  (Y)es/(N)o/(A)lways/Neve(R): ", "YNAR");
                if (choice == 'Y') {
                    copyFile = true;
                } else if (choice == 'A') {
                    Sync.defaultActionOnOverwrite = (char)89;
                    copyFile = true;
                } else if (choice == 'R') {
                    Sync.defaultActionOnOverwrite = (char)78;
                }
            }
        } else {
            copyFile = true;
        }
        if (copyFile) {
            String error;
            if (existingFile != null) {
                if (existingIsDirectory) {
                    String error2 = SyncIO.deleteDirTreeOperation(existingFile);
                    if (error2 != null) {
                        return "Failed to delete existing directory \"" + SyncIO.trimTrailingSeparator(existingFile.getPath()) + File.separatorChar + "\":\n" + error2;
                    }
                } else {
                    boolean success = existingFile.delete();
                    if (!success) {
                        return "Failed to delete existing file \"" + existingFile.getPath() + "\" using Java's File.delete() method.";
                    }
                }
            }
            if ((error = SyncIO.copyFileOperation(source, target)) == null) {
                return null;
            }
            return "Failed to copy file:\n" + error;
        }
        return "";
    }

    static String deleteFileDir(File file) {
        if (file.isDirectory()) {
            String error = SyncIO.deleteDirTreeOperation(file);
            if (error != null) {
                return "Failed to delete directory:\n" + error;
            }
        } else {
            boolean success = file.delete();
            if (!success) {
                return "Failed to delete file using Java's File.delete() method.";
            }
        }
        return null;
    }

    private static String deleteDirTreeOperation(File dir) {
        ArrayList<String> errors = new ArrayList<String>();
        ArrayDeque<File> fullDirs = new ArrayDeque<File>();
        ArrayDeque<File> emptyDirs = new ArrayDeque<File>();
        File marker = new File("");
        fullDirs.push(dir);
        while (!fullDirs.isEmpty()) {
            File fd = (File)fullDirs.pop();
            if (fd == marker) {
                File ed = (File)emptyDirs.pop();
                boolean success = ed.delete();
                if (success) continue;
                errors.add("Failed to delete directory \"" + ed.getPath() + "\" using Java's File.delete() method (it could still be nonempty)");
                continue;
            }
            File[] files = fd.listFiles();
            if (files == null) {
                errors.add("Failed to get contents of directory \"" + fd.getPath() + "\"");
                continue;
            }
            emptyDirs.push(fd);
            fullDirs.push(marker);
            for (File f : files) {
                if (f.isDirectory()) {
                    fullDirs.push(f);
                    continue;
                }
                boolean success = f.delete();
                if (success) continue;
                errors.add("Failed to delete file \"" + f.getPath() + "\" using Java's File.delete() method");
            }
        }
        if (!errors.isEmpty()) {
            StringBuilder t = new StringBuilder();
            for (String s : errors) {
                t.append(s);
                t.append("; ");
            }
            t.delete(t.length() - 2, t.length());
            return t.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String copyFileOperation(File source, File target) {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            ArrayList<String> errors = new ArrayList<String>();
            try {
                bis = new BufferedInputStream(new FileInputStream(source));
            }
            catch (Exception e) {
                String string = "Failed to open source file for reading (" + e.getMessage() + ")";
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                if (bos == null) return string;
                try {
                    bos.close();
                    return string;
                }
                catch (Exception e3) {
                    // empty catch block
                }
                return string;
            }
            File targetParentDir = target.getParentFile();
            if (!targetParentDir.exists()) {
                targetParentDir.mkdirs();
            }
            if (!targetParentDir.isDirectory()) {
                String string = "Failed to create parent directory of target file";
                return string;
            }
            try {
                bos = new BufferedOutputStream(new FileOutputStream(target));
            }
            catch (Exception e) {
                String e4 = "Failed to open target file for writing (" + e.getMessage() + ")";
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception e5) {
                        // empty catch block
                    }
                }
                if (bos == null) return e4;
                try {
                    bos.close();
                    return e4;
                }
                catch (Exception e6) {
                    // empty catch block
                }
                return e4;
            }
            byte[] byteBuffer = new byte[0x100000];
            try {
                int byteCount;
                while ((byteCount = bis.read(byteBuffer, 0, 0x100000)) != -1) {
                    ((BufferedOutputStream)bos).write(byteBuffer, 0, byteCount);
                }
            }
            catch (Exception e) {
                String e6 = "Failed to copy data from source file to target file (" + e.getMessage() + ")";
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception e7) {
                        // empty catch block
                    }
                }
                if (bos == null) return e6;
                try {
                    bos.close();
                    return e6;
                }
                catch (Exception e8) {
                    // empty catch block
                }
                return e6;
            }
            try {
                bis.close();
                bis = null;
            }
            catch (Exception e) {
                errors.add("Failed to close source file after reading (" + e.getMessage() + ")");
            }
            try {
                bos.close();
                bos = null;
            }
            catch (Exception e) {
                errors.add("Failed to close target file after writing (" + e.getMessage() + ")");
            }
            boolean success = target.setLastModified(source.lastModified());
            if (!success) {
                errors.add("Failed to set last-modified time of target file after writing");
            }
            if (!errors.isEmpty()) {
                StringBuilder t = new StringBuilder();
                Object i$ = errors.iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        t.delete(t.length() - 2, t.length());
                        i$ = t.toString();
                        return i$;
                    }
                    String s = (String)i$.next();
                    t.append(s);
                    t.append("; ");
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Crc32Checksum getCrc32Checksum(File file) {
        if (file.isDirectory()) {
            return new Crc32Checksum(null, 0L);
        }
        BufferedInputStream bis = null;
        try {
            try {
                bis = new BufferedInputStream(new FileInputStream(file));
            }
            catch (Exception e) {
                Crc32Checksum crc32Checksum = new Crc32Checksum("Failed to open file for reading (" + e.getMessage() + ")", 0L);
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                return crc32Checksum;
            }
            byte[] byteBuffer = new byte[0x100000];
            CRC32 crc32 = new CRC32();
            try {
                int byteCount;
                while ((byteCount = bis.read(byteBuffer, 0, 0x100000)) != -1) {
                    crc32.update(byteBuffer, 0, byteCount);
                }
            }
            catch (Exception e) {
                Crc32Checksum crc32Checksum = new Crc32Checksum("Failed to read data from file (" + e.getMessage() + ")", 0L);
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                }
                return crc32Checksum;
            }
            try {
                bis.close();
                bis = null;
            }
            catch (Exception e) {
                // empty catch block
            }
            Crc32Checksum crc32Checksum = new Crc32Checksum(null, crc32.getValue());
            return crc32Checksum;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    static String trimTrailingSeparator(String path) {
        if (path.endsWith(File.separator)) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    static char userCharPrompt(String prompt, String ops) {
        char c;
        String response;
        String options = ops.toUpperCase(Locale.ENGLISH);
        Scanner kb = new Scanner(System.in);
        do {
            SyncIO.printFlush(prompt);
            response = kb.nextLine();
            SyncIO.printLog(response + "\n");
        } while ((response = response.trim()).length() != 1 || options.indexOf(c = response.toUpperCase(Locale.ENGLISH).charAt(0)) < 0);
        return c;
    }

    static void print(String s) {
        Sync.stdout.print(s);
        if (Sync.log != null) {
            Sync.log.print(s);
        }
    }

    static void printFlush(String s) {
        Sync.stdout.print(s);
        Sync.stdout.flush();
        if (Sync.log != null) {
            Sync.log.print(s);
            Sync.log.flush();
        }
    }

    static void printToErr(String s) {
        Sync.stderr.print(s);
        Sync.stderr.flush();
        if (Sync.log != null) {
            Sync.log.print(s);
            Sync.log.flush();
        }
    }

    static void printLog(String s) {
        if (Sync.log != null) {
            Sync.log.print(s);
            Sync.log.flush();
        }
    }

    static class Crc32Checksum {
        public String error = null;
        public long checksum;

        Crc32Checksum(String error, long checksum) {
            this.error = error;
            this.checksum = checksum;
        }
    }
}

