      SUBROUTINE PCTIDY (DOUSER,SCDISK,CFILNM)
C
C     INTERACTIVE FILE DEFINITION ROUTINE FOR TIDY
C
      INCLUDE 'TIDY.INC'
      INCLUDE 'UNITS.INC'
      COMMON/TDYVER/VERNUM
      CHARACTER*30 VERNUM
      CHARACTER DRIVE
      CHARACTER RESP(80)
      CHARACTER*64 FILNM1, FILNM2, CFILNM
      INTEGER DOSDEV, OPFIL
      LOGICAL DOUSER, SCDISK
C
C     DISPLAY VERSION NUMBER ON CONSOLE
      WRITE (STDERR,25) VERNUM
C
C     CHECK FOR USER CONTROL FILE.
C      RESPONSE MUST BE Y OR N.
 10   WRITE (STDERR,30)
      READ (STDIN,40) RESP
      I=0
 20   I=I+1
      IF (I.GT.80) GO TO 10
      IF (RESP(I).EQ.' ') GO TO 20
      IF (RESP(I).EQ.'Y'.OR.RESP(I).EQ.'y') THEN
           DOUSER=.TRUE.
      ELSE IF (RESP(I).EQ.'N'.OR.RESP(I).EQ.'n') THEN
           DOUSER=.FALSE.
      ELSE
           WRITE (STDERR,35)
           GO TO 10
      ENDIF
C
C     OPEN CONTROL FILE IF PRESENT.
      IF (DOUSER) THEN
           CFILNM=' '
           IOPFL = OPFIL (USRFIL,CFILNM,0,-1,'control card',LNG)
           ISCONS=DOSDEV(CFILNM)
      END IF
C
C     DEFINE SOURCE, LISTING, AND OUTPUT FILES.
      FILNM1=' '
      IOPFL =  OPFIL (INFILE,FILNM1,0,-1,'source',LNG)
      FILNM1=' '
      IOPFL =  OPFIL (OUTFIL,FILNM1,0,1,'listing',LNG)
      FILNM1=' '
      IOPFL =  OPFIL (PUNFIL,FILNM1,0,1,'punched output',LNG)
      FILNM1=' '
C
C     FOR PC'S, ALLOW USER TO SPECIFY DISK FOR SCRATCH FILES.
      IF (SCDISK) THEN
           WRITE (STDERR,50)
           READ (STDIN,40) DRIVE
           FILNM1=DRIVE//':SCFIL1.TDY'
           FILNM2=DRIVE//':SCFIL2.TDY'
      ELSE
           FILNM1='SCFIL1.TDY'
           FILNM2='SCFIL2.TDY'
      END IF
C
C     OPEN SCRATCH FILES
      IOPFL =  OPFIL (SCFIL1,FILNM1,-1,2,'SCRATCH',LNG)
      IOPFL =  OPFIL (SCFIL2,FILNM2,-1,2,'SCRATCH',LNG)
C
C     PROMPT USER FOR CONTROL CARDS IF CONSOLE INPUT.
      IF (ISCONS.EQ.2) WRITE (STDERR,60)
C
      RETURN
C
 25   FORMAT (1X,A)
 30   FORMAT (' Do you have a CONTROL CARD file? (y-n) ')
 35   FORMAT (' YES or NO?')
 40   FORMAT (80A1)
 50   FORMAT (' ENTER DISK TO USE FOR TEMPORARY FILES: ')
 60   FORMAT (' Enter TIDY control cards.  Type CTRL-Z to stop.')
      END
      INTEGER FUNCTION OPFIL(KUNIT,FNAME,KTYPE,KNOUT,EXPRES,LENGTH)
C-------------------------------------------------------------------------
C---- THIS IS THE OPEN FILE FUNCTION BY W.J. MEERSCHAERT & P.J. DAUGHERTY
C---- JULY 25, 1986
C---- DUMMY PARAMETERS ARE AS FOLLOWS:
C
C    IUNIT....UNIT NUMBER OF THE FILE TO BE OPENED, PREFERRABLY > 20
C    FNAME....NAME OF FILE TO BE OPENED, IF SCRATCH, IT IS IGNORED,
C                IF MISSING, IT IS PROMPTED FOR
C    ITYPE....TYPE OF FILE TO BE OPENED, AS FOLLOWS:
C            >0   RECL FOR A DIRECT ACCESS UNFORMATTED FILE
C            >100000 DIRECT ACCESS FORMATTED FILE RECL=MOD(ITYPE,100000)
C             0   FORMATTED SEQUENTIAL FILE
C            <0   UNFORMATTED SEQUENTIAL FILE
C    INOUT....SPECIFIES WHAT THE FILE IS FOR:
C            -2   INPUT FILE, IF NOT EXIST, EXIT WITH ERROR CODE
C            -1   INPUT FILE, IF NOT EXIST, PROMPT USER FOR NEW NAME
C             0   SCRATCH FILE
C             1   OUTPUT FILE, IF EXIST, PROMPT USER FOR ACTION
C             2   OUTPUT FILE, IF EXIST, OVERWRITE AUTOMATICALLY
C             3   OUTPUT FILE, IF EXIST, APPEND AUTOMATICALLY
C             4   OUTPUT FILE, IF EXIST, EXIT WITH ERROR CODE
C    EXPRES...EXPRESSION FOR PROMPTING USER FOR FILENAME
C    LENGTH...NUMBER OF LINES IN OLD PART OF APPENDED FILE
C
C OPFIL RETURNS THE FOLLOWING:
C    0......ALL IS WELL
C    >0.....COMPILER OR SYSTEM ERROR MESSAGE ON OPEN STATEMENT
C    1......USER EOF ON A READ PROMPT (I.E., ABORT OPEN)
C    2......ERROR CODE BASED ON INOUT, FILE M=NOT OPENED
C
C-------------------------------------------------------------------------
      CHARACTER FNAME*(*),EXPRES*(*),ANS
      INTEGER DOSDEV
      LOGICAL EXST,FILOPN
      INCLUDE 'UNITS.INC'
C
C---- REASSIGN INTEGER DUMMY VARIABLES
C
      IUNIT=KUNIT
      ITYPE=KTYPE
      INOUT=KNOUT
      LENGTH=0
C
C---- OPEN SCRATCH FILE
C
      IF (INOUT.EQ.0) THEN
           IF (ITYPE) 10,20,30
 10        OPEN (IUNIT,STATUS='SCRATCH',FORM='UNFORMATTED',ACCESS='SEQUE
     1NTIAL',IOSTAT=OPFIL)
           RETURN
 20        OPEN (IUNIT,STATUS='SCRATCH',FORM='FORMATTED',ACCESS='SEQUENT
     1IAL',IOSTAT=OPFIL)
           RETURN
 30        IF (ITYPE.GT.100000) THEN
                ITYPE=MOD(ITYPE,100000)
                OPEN (IUNIT,ACCESS='DIRECT',STATUS='SCRATCH',RECL=ITYPE,
     1FORM='FORMATTED',IOSTAT=OPFIL)
           ELSE
                OPEN (IUNIT,ACCESS='DIRECT',STATUS='SCRATCH',RECL=ITYPE,
     1FORM='UNFORMATTED',IOSTAT=OPFIL)
           END IF
           RETURN
      END IF
C
C---- CHECK FOR LOGIC OF ARGUMENTS AND FILE PROPERTIES
C
 40   IF (FNAME.EQ.' '.AND.INOUT.NE.2) THEN
           WRITE (STDERR,190) EXPRES
           READ (STDIN,200,END=170) FNAME
           IF (FNAME(1:1).EQ.'?') THEN
                PAUSE 'Type DIR to see a list of files'
                FNAME=' '
                GO TO 40
           ELSE IF (FNAME(1:1).EQ.'>'.AND.FNAME(2:2).NE.'>') THEN
                IF (INOUT.GT.0) INOUT=2
                FNAME=FNAME(2:)
           ELSE IF (FNAME(1:2).EQ.'>>') THEN
                IF (INOUT.GT.0) INOUT=3
                FNAME=FNAME(3:)
           ELSE
                IF (INOUT.GT.0) INOUT=1
           END IF
      END IF
C
C---- GET EXST AND FILOPN
C
      INQUIRE (FILE=FNAME,EXIST=EXST,OPENED=FILOPN)
C
C     DON'T OPEN SAME FILE TWICE.
      IF (FILOPN) THEN
           WRITE (STDERR,210) FNAME
           FNAME=' '
           GO TO 40
      END IF
C
C---- INPUT FILE
C
      IF (.NOT.EXST.AND.INOUT.LT.0) THEN
           IF (INOUT.EQ.-1) THEN
                WRITE (STDERR,220) FNAME
                FNAME=' '
                GO TO 40
           ELSE IF (INOUT.EQ.-2) THEN
                GO TO 180
           END IF
C
C---- OUTPUT FILE
C
      ELSE IF (EXST.AND.INOUT.EQ.1) THEN
C
           ISDEV = 0
C
C     DOS DEVICES ARE OK IF THEY EXIST
           ISDEV =  DOSDEV(FNAME)
           IF (ISDEV.GT.0) THEN
                INOUT=2
                GO TO 60
           END IF
C
C     OTHERWISE ASK USER WHAT TO DO.
 50        WRITE (STDERR,230) EXPRES,FNAME
           READ (STDIN,240,END=170) ANS
           IF (ANS.EQ.'o'.OR.ANS.EQ.'O') THEN
                INOUT=2
           ELSE IF (ANS.EQ.'a'.OR.ANS.EQ.'A') THEN
                INOUT=3
           ELSE IF (ANS.EQ.'n'.OR.ANS.EQ.'N') THEN
                FNAME=' '
                GO TO 40
           ELSE
                GO TO 50
           END IF
      ELSE IF (EXST.AND.INOUT.EQ.4) THEN
           OPFIL=2
           RETURN
      END IF
C
C---- OPEN FILE
C
 60   IF (ITYPE) 70,80,90
 70   OPEN (IUNIT,FILE=FNAME,STATUS='UNKNOWN',FORM='UNFORMATTED',ACCESS=
     1'SEQUENTIAL',IOSTAT=OPFIL)
      GO TO 100
 80   OPEN (IUNIT,FILE=FNAME,STATUS='UNKNOWN',FORM='FORMATTED',ACCESS='S
     1EQUENTIAL',IOSTAT=OPFIL)
      GO TO 100
 90   IF (ITYPE.GT.100000) THEN
           ITYPE=MOD(ITYPE,100000)
           OPEN (IUNIT,FILE=FNAME,STATUS='UNKNOWN',FORM='FORMATTED',ACCE
     1SS='DIRECT',RECL=ITYPE,IOSTAT=OPFIL)
      ELSE
           OPEN (IUNIT,FILE=FNAME,STATUS='UNKNOWN',FORM='UNFORMATTED',AC
     1CESS='DIRECT',RECL=ITYPE,IOSTAT=OPFIL)
      END IF
      RETURN
 100  REWIND IUNIT
C
C---- APPEND IF REQUESTED
C
      IF (INOUT.EQ.3) THEN
           IF (ITYPE) 110,120,120
 110       READ (IUNIT,END=130)
           LENGTH=LENGTH+1
           GO TO 110
 120       READ (IUNIT,240,END=130) ANS
           LENGTH=LENGTH+1
           GO TO 120
 130       REWIND IUNIT
           DO 160 N=1,LENGTH
                IF (ITYPE) 140,150,150
 140            READ (IUNIT)
                GO TO 160
 150            READ (IUNIT,240) ANS
 160       CONTINUE
           END FILE IUNIT
           BACKSPACE (IUNIT)
      END IF
C
C---- ALL DONE
C
      RETURN
 170  OPFIL=1
      RETURN
 180  OPFIL=2
      RETURN
C
C
 190  FORMAT (/T3,'Open the ',A,' file'/T3,'Enter a file name here: ')
 200  FORMAT (A)
 210  FORMAT (/T3,'File already open: ',A)
 220  FORMAT (/T3,'File not found: ',A)
 230  FORMAT (/T3,A,' file exists: ',A/T5,'[O]verwrite'/T5,'[A]ppend'
     1/T5,'[N]ew file spec'/T3,'Enter here: ')
 240  FORMAT (A1)
      END
