/* ---------------------------------------------------------------------- */
/*   VUX.c(C) Copyright Bill Buckels 1989-1999                            */
/*   All Rights Reserved.                                                 */
/*                                                                        */
/*   VUX is distributed as ShareWare.                                     */
/*   It is part of the STIX(C) Children's Sticker Draw Package.           */
/*   Suggested Registration for STIX(C) is $10.00 per family.             */
/*                                                                        */
/*   You are expected to register with the Author if you use STIX         */
/*   or any of its associated files and programs including VUX            */
/*   beyond a 30-day evaluation period. Send registration in the form     */
/*   of cheque, or money order to:                                        */
/*                                                                        */
/*   Bill Buckels                                                         */
/*   589 Oxford Street                                                    */
/*   Winnipeg, Manitoba, Canada R3M 3J2                                   */
/*                                                                        */
/*   Email: bbuckels@escape.ca                                            */
/*   WebSite: http://www.escape.ca/~bbuckels                              */
/*                                                                        */
/*   Registered users of STIX have a royalty-free right to use, modify,   */
/*   reproduce and distribute this source code (and/or any modified       */
/*   version) in way you find useful, provided that you do not compete    */
/*   with Bill Buckels or his agents, and that you agree that Bill        */
/*   Buckels has no warranty obligations or liability whatsoever          */
/*   resulting from any associated loss or damage.                        */
/*                                                                        */
/*   If you do not agree with these terms, remove this source and         */
/*   all associated files from your computer now.                         */
/*                                                                        */
/*   Description                                                          */
/*   -----------                                                          */
/*   Supported Screen Modes are CGA Graphics Modes 4 and 6 only.          */
/*                                                                        */
/*   Command Line Viewer For                                              */
/*                                                                        */
/*   a. BASIC BSAVED IMAGE FILE (full screen CGA graphics)                */
/*   b. ZSOFT .PCX format PCPAINTBRUSH compatible image file              */
/*      per the VERSION 2.8 STANDARD without Color Map.                   */
/*                                                                        */
/*   Autosenses ZSOFT .PCX CGA graphics file or BASIC BSAVED              */
/*   image file. If the file is not a valid .PCX file, an attempt is      */
/*   made to load it as a BSAVED image.                                   */
/*                                                                        */
/*   Assumes VERSION 2.8 STANDARD .PCX w/o Color Map & CGA Screen Dump    */
/*   or equivalent.                                                       */
/*                                                                        */
/*   The extension .PCX, .BAS, etc must be entered. I didn't want to      */
/*   make assumptions as to which file to load if both formats            */
/*   are present.                                                         */
/*                                                                        */
/*   If a BSAVED IMAGE FILE is selected, the viewer has no way            */
/*   of determining if the ORIGIN SCREEN MODE was hi res or med res       */
/*   and displays in hi res until a key is pressed, and reverts           */
/*   to med res until the second key press. This can be over-ridden       */
/*   by supplying a second command line argument of BITS PER PIXEL.       */
/*                                                                        */
/*   1- bit  per pixel is monochrome graphics (MODE 6)                    */
/*   2- bits per pixel is color graphics      (MODE 4)                    */
/*                                                                        */
/*   This program has been tested with PCPAINTBRUSH Version 3             */
/*   and LOGITECH PAINTSHOW PLUS Version 2.1 and its PCX2TIF and          */
/*   TIF2PCX import/export utilities and with GWBASIC 3.22 and            */
/*   QUICKBASIC versions 2.0 and 4.5.                                     */
/*                                                                        */
/*   USAGE: "VUX FILENAME"                                                */
/*                                                                        */
/*   VUX is written in Large Model Microsoft C Version 6.00a              */
/*                                                                        */
/* ---------------------------------------------------------------------- */

#include <stdio.h>
#include <fcntl.h>
#include <dos.h>
#include <bios.h>
#include <io.h>
#include <string.h>
#include <malloc.h>

#define SUCCESS  0
#define INVALID -1
#define TRUE     1
#define FALSE    0

#define TEXT     3
#define CGA_320  4
#define HI_RES   6

int iScreenMode=CGA_320;

/* type conversion functions */
unsigned int byteword(unsigned char a, unsigned char b){return b<<8|a;}
unsigned char lsb(unsigned int word){ return word &0xff;}
unsigned char msb(unsigned int word){ return word >>8;}
unsigned char pcxheader[128];

int checkforpcx(char *pcxheader)
{
    int i;    /* we only want CGA compatible full screens. */

    unsigned int zsoft,version,codetype,pixbits;
    unsigned int xmin, ymin, xmax, ymax;
    unsigned int hres, vres;
    unsigned int no_planes, bytesperline;
    int status=SUCCESS;

    zsoft   =pcxheader[0];
    version =pcxheader[1];
    codetype=pcxheader[2];
    pixbits =pcxheader[3];

    if(zsoft!=10)        status = INVALID;
    if(codetype!=1)      status = INVALID;
    if(pixbits != 2 )
       if(pixbits != 1)  status = INVALID;

    xmin=byteword(pcxheader[4],pcxheader[5]);
    ymin=byteword(pcxheader[6],pcxheader[7]);
    xmax=byteword(pcxheader[8],pcxheader[9]);
    ymax=byteword(pcxheader[10],pcxheader[11]);

    hres=byteword(pcxheader[12],pcxheader[13]);
    vres=byteword(pcxheader[14],pcxheader[15]);

    no_planes   =pcxheader[65];
    bytesperline=byteword(pcxheader[66],pcxheader[67]);

    if(xmin != 0  )      status = INVALID;
    if(ymin != 0  )      status = INVALID;
    if(xmax != 319)
       if(xmax!=639)     status = INVALID;
    if(ymax != 199)      status = INVALID;

    if(pixbits == 1)
      iScreenMode=HI_RES;

    if(no_planes!=1)     status = INVALID;
    if(bytesperline !=80)status = INVALID;
    /* we can ignore the color map since we        */
    /* are limiting ourselves to CGA modes         */
    /* so we will not handle over 2-bits per pixel */
    return status;

}


void setcrtmode(m)
unsigned char m;
{
    union REGS rin,rout;
    rin.h.ah = 0;
    rin.h.al = m;
    int86(0x10,&rin,&rout);

}

void setcolor(background, palette)
unsigned char background, palette;
{
    union REGS rin,rout;
    rin.h.ah = 11;
    rin.h.bh = 0;
    rin.h.bl = background;
    int86(0x10,&rin,&rout);
    rin.h.bh = 1;
    rin.h.bl = palette;
    int86(0x10,&rin,&rout);

}


int pcxload(char *pcxfilename)
{
    unsigned char *crt =(unsigned char *) 0xB8000000l;
    unsigned int byteoff=0,inleaf=8192,packet,width=0;
    FILE *fp;
    unsigned char byte,bytecount;
    unsigned wordcount,target;

    if((fp=fopen(pcxfilename,"rb"))==NULL)return INVALID;
    target = (unsigned)filelength(fileno(fp));
    for(wordcount=0;wordcount<128;wordcount++)
      pcxheader[wordcount]=fgetc(fp);
    if(checkforpcx(pcxheader)==INVALID) {
      fclose(fp);
      return INVALID;
    }
    setcrtmode(iScreenMode);

    do{ bytecount=1;                          /* start with a seed count */
        byte=fgetc(fp);
        wordcount++;
                                              /* check to see if its raw */
        if(0xC0 == (0xC0 &byte)){             /* if its not, run encoded */
          bytecount= 0x3f &byte;
          byte=fgetc(fp);
          wordcount++;
        }
        for(packet=0;packet<bytecount;packet++){
          if(width<80){
            crt[byteoff]=byte;
            width++;
            byteoff++;
          }
          else {
            crt[inleaf]=byte;
            inleaf++;
            width++;
            if(width>159)width=0;
          }
        }
    } while(wordcount<target);
    fclose(fp);
    return(SUCCESS);
}

/* a microsoft compatible bsaved image format descriptor */
char BSAVED_header[7]={
    '\xfd','\x00','\xb8','\x00','\x00','\x00','\x40'};

int checkforbas(char *buf)
{
    int i;

    for(i=0;i<4;i++) {
      if (buf[i] !=BSAVED_header[i]) {
        return INVALID;
        break;
      }
    }

    return (SUCCESS);
}

int bload(char *bsaved_file)
{
    unsigned char *crt =(unsigned char *) 0xB8000000l;
    int fh, status;
    char headbuf[7];

    status = fh = open(bsaved_file,O_RDONLY|O_BINARY);
    if (status != INVALID) {
      read(fh,headbuf,7);
      status = checkforbas(headbuf);
      if (status != INVALID)
        read(fh,crt,16385);
      close(fh);
    }
    return status;

}


int check_for_CGA()
{
    /* clear the screen and try to read a whitespace from the
       start address for the CGA. if its not there return 0 and split
       because the rest of the stuff won't work. */

    unsigned char *crt =(unsigned char *) 0xB8000000l;
    union REGS reg;

    setcrtmode(TEXT);
    reg.h.ah = 6;
    reg.h.al = 0;
    reg.h.ch = 0;
    reg.h.cl = 0;
    reg.h.dh = 24;
    reg.h.dl = 79;
    reg.h.bh = 0x07;
    int86(0x10, &reg, &reg);

    if(crt[0]==32)return TRUE;
    return FALSE;
}

main(int argc,char *argv[])
{
   int status,i,j,index,basloops=2;
   char c;

   if((status=check_for_CGA())==FALSE){
     printf("CGA required\n");
     exit(1);
   }

  switch(argc) {
    case 3: basloops=1;
    case 2:

            if((status=pcxload(argv[1]))==INVALID){
              for(index=0;index<basloops;index++){
                if(index==1|| basloops==1 && atoi(argv[2])==2)
                iScreenMode=CGA_320;
                else iScreenMode=HI_RES;
                setcrtmode(iScreenMode);
                if((status=bload(argv[1]))==INVALID)break;
                if(getch()==0)getch();
              }
            }
            else {
              for(i=0;i<32;i++)
              {
                for(j=0;j<2;j++)
                {
                   if (iScreenMode != HI_RES)
                     setcolor(i,j);
                   c = getch();
                   if (c == 27)break;
                   if (c == 0)getch();
                }
                if (c == 27)
                  break;
                if (i == 31)
                  i = 0;
              }
            }
            setcrtmode(TEXT);
            exit(SUCCESS);

    default:
            setcrtmode(TEXT);
            printf("VUX(C) Copyright Bill Buckels 1989-1999\n");
            printf("All Rights Reserved.\n");
            printf("Usage : \"VUX [filename] [bits-per-pixel(optional 1 or2)]\"\n");
            printf("File viewer for  .PCX GRAPHICS and BSAVED IMAGES.\n");
            printf("CGA MED_RES and HI_RES modes, screen dumps only.\n");
  }
  exit(1);
}
