/**********************************************************************/
/***  vefc.c						    WA8YCD  ***/
/***  Ver 2.4                                            02 Sep 89  ***/
/***								    ***/
/***  This utility provides a counting aid, a character inclusion   ***/
/***  list, and sending time at 5, 13, and 20 wpm.		    ***/
/***								    ***/
/***  usage:	vefc textfile reportfile    [report to file]	    ***/
/***	 or	vefc textfile		    [report to screen]	    ***/
/***	 or	vefc textfile > prn	    [report to printer]     ***/
/***  ____________________________________________________________  ***/
/***  Change history:						    ***/
/***  890505 WA8YCD   1.0 - original version--exclusions only	    ***/
/***  890521 WA8YCD   2.0 - display input with count columns	    ***/
/***  890525 WA8YCD   2.1 - include AND exclude list in report	    ***/
/***  890902 WA8YCD   2.2 - add counts to report for each letter    ***/
/***  890908 WA8YCD   2.3 - Oops-Didn't print counts if all letters ***/
/***                        were there. Also print input file name. ***/
/***  891227 WA8YCD   2.4 - Latest data says numbers, punctuation,  ***/
/***                        and prosigns ALL count as 2. Also, the  ***/
/***                        newest SuperMorse (SM305) uses "=" not  ***/
/***                        "-" for <BT> now.                       ***/
/***  ____________________________________________________________  ***/
/***  Copyright (c) 1989 Robert L. West, Jr., WA8YCD		    ***/
/***  Distribution of this program is allowed provided no monetary  ***/
/***  compensation beyond reasonable reproduction costs is made.    ***/
/***  It is provided as a public service to the amateur community.  ***/
/***  ____________________________________________________________  ***/
/***  Compiled using Turbo C Version 2.0 under MS-DOS 3.3           ***/
/***  Turbo C (tm) Borland International. MS (r) MicroSoft Corp.    ***/
/**********************************************************************/

#include <stdio.h>

#define  MIN_LTR      65
#define  MAX_LTR      91

#define  MIN_NUM      48
#define  MAX_NUM      58

#define  SK           36
#define  COMMA        44
#define  PERIOD       46
#define  DN	      47
#define  BT           61           /* 2.4 */
#define  QUERY        63
#define  AR	      64

#define  LENGTH_5     25
#define  LENGTH_13    65
#define  LENGTH_20   100

#define  TRUE	       1
#define  FALSE	       0

main(argc, argv)
int argc;
char *argv[];
{
  int	 i, no_zeros=1, output_to_file;
  long	 inch=0, counts[256];
  float  test_time_5, test_time_13, test_time_20;
  char	c;
  FILE  *fopen(), *infile, *outfile;

/* first, see if the correct number of parameters are given... */
  if (argc < 2)
  { printf("\nusage:\n    freq input-filename [output-filename]\n");
    printf("\n   if output-filename is omitted display appears \n");
    printf("   on the screen.\n\n");
    exit();
  }

/* next, see if the first parameter can be opened as an input file... */
  if ((infile = fopen(argv[1], "rb")) == NULL)
  { printf("\nUnable to open input file, \"%s\"!\n\n", argv[1]);
    printf("vefc:  abnormal termination.\n");
    exit();
  }

/* now, see if the second parameter can be opened as an output file... */
  if (argc == 3)
  { if ((outfile = fopen(argv[2], "w")) == NULL)
    { printf("\nUnable to open output file, \"%s\"!\n\n", argv[2]);
      printf("vefc:  abnormal termination.\n");
      exit();
    }
  }
  else
  { if ((outfile = fopen("CON", "w")) == NULL)
    { printf("\nUnable to open console for output!\n\n");
      printf("vefc:  abnormal termination.\n");
      exit();
    }
  }

/*************************************************************************/
/***								       ***/
/*************************************************************************/

  fprintf(outfile, "- VE CODE EXAM VALIDATER ver 2.4,  12/27/89 -\n");
  fprintf(outfile, "   Input File: \"%s\"\n", argv[1]);
  fprintf(outfile, "\n");
  fprintf(outfile, "        ");
  fprintf(outfile, "....5...10...15...20...25");
  fprintf(outfile, "        ");
  fprintf(outfile, "...30...35...40...45...50\n");
  fprintf(outfile, "%7ld ", inch);

  for (i=0; i<256; i++)
    counts[i]=0;

  while((c=getc(infile)) != EOF)
  {
    if (c>='a' && c<='z')
      c=c-'a'+'A';

    switch((int)c)
    {
      case 'A': case 'F': case 'K': case 'P': case 'U':
      case 'B': case 'G': case 'L': case 'Q': case 'V':
      case 'C': case 'H': case 'M': case 'R': case 'W':
      case 'D': case 'I': case 'N': case 'S': case 'X':
      case 'E': case 'J': case 'O': case 'T': case 'Y':
      case 'Z':
	counts[(int)c]++;
	fprintf(outfile, "%c", c);
        if  ( !(++inch % 50) )
        { fprintf(outfile, "\n%7ld ", inch); }
        else { if  ( !(inch % 25) )
                 fprintf(outfile, "        "); }
	break;

      case '0': case '1': case '2': case '3': case '4':
      case '5': case '6': case '7': case '8': case '9':
      case '/': case '@': case '$': case '=':
      case '.': case ',': case '?':
	counts[(int)c]++;
	fprintf(outfile, "%c", c);
        if  ( !(++inch % 50) )
        { fprintf(outfile, "\n%7ld ", inch); }
        else { if  ( !(inch % 25) )
                 fprintf(outfile, "        "); }
	fprintf(outfile, "_");
        if  ( !(++inch % 50) )
        { fprintf(outfile, "\n%7ld ", inch); }
        else { if  ( !(inch % 25) )
                 fprintf(outfile, "        "); }
	break;

      default:
	break;
    }
  }
  fclose(infile);     /* We're finished with the input file, so close it */

  no_zeros = TRUE;
  for (i=MIN_LTR; i<MAX_LTR; i++)
    no_zeros = no_zeros && counts[i];
  for (i=MIN_NUM; i<MAX_NUM; i++)
    no_zeros = no_zeros && counts[i];
  no_zeros = no_zeros && counts[PERIOD];
  no_zeros = no_zeros && counts[COMMA];
  no_zeros = no_zeros && counts[DN];
  no_zeros = no_zeros && counts[QUERY];
  no_zeros = no_zeros && counts[BT];
  no_zeros = no_zeros && counts[AR];
  no_zeros = no_zeros && counts[SK];

  if (no_zeros)
  {
    fprintf(outfile, "\n");
    fprintf(outfile, "\n");
    fprintf(outfile, "All required characters are contained in this test.\n");
    fprintf(outfile, "\n");

    for (i=MIN_LTR; i<MAX_LTR; i++)
      if (counts[i])
	fprintf(outfile, " %s:%-7ld", &i, counts[i]);

    for (i=MIN_NUM; i<MAX_NUM; i++)
      if (counts[i])
	fprintf(outfile, " %s:%-7ld", &i, counts[i]);

    printf("\n");
    if (counts[PERIOD])
      fprintf(outfile, " %c:%-7ld", PERIOD, counts[PERIOD]);
    if (counts[COMMA])
      fprintf(outfile, " %c:%-7ld", COMMA, counts[COMMA]);
    if (counts[DN])
      fprintf(outfile, " %c:%-7ld", DN, counts[DN]);
    if (counts[QUERY])
      fprintf(outfile, " %c:%-7ld", QUERY, counts[QUERY]);
    if (counts[BT])
      fprintf(outfile, " %c:%-7ld", BT, counts[BT]);
    if (counts[AR])
      fprintf(outfile, " %c:%-7ld", AR, counts[AR]);
    if (counts[SK])
      fprintf(outfile, " %c:%-7ld", SK, counts[SK]);
    fprintf(outfile, "\n");

  }
  else
  {
    fprintf(outfile, "\n");
    fprintf(outfile, "\n");
    fprintf(outfile, "The following characters are in this test:\n");
    fprintf(outfile, "\n");

    for (i=MIN_LTR; i<MAX_LTR; i++)
      if (counts[i])
	fprintf(outfile, " %s:%-7ld", &i, counts[i]);

    for (i=MIN_NUM; i<MAX_NUM; i++)
      if (counts[i])
	fprintf(outfile, " %s:%-7ld", &i, counts[i]);

    printf("\n");
    if (counts[PERIOD])
      fprintf(outfile, " %c:%-7ld", PERIOD, counts[PERIOD]);
    if (counts[COMMA])
      fprintf(outfile, " %c:%-7ld", COMMA, counts[COMMA]);
    if (counts[DN])
      fprintf(outfile, " %c:%-7ld", DN, counts[DN]);
    if (counts[QUERY])
      fprintf(outfile, " %c:%-7ld", QUERY, counts[QUERY]);
    if (counts[BT])
      fprintf(outfile, " %c:%-7ld", BT, counts[BT]);
    if (counts[AR])
      fprintf(outfile, " %c:%-7ld", AR, counts[AR]);
    if (counts[SK])
      fprintf(outfile, " %c:%-7ld", SK, counts[SK]);

    fprintf(outfile, "\n");
    fprintf(outfile, "\n");
    fprintf(outfile, "The following characters are not in this test:\n");
    fprintf(outfile, "\n");

    for (i=MIN_LTR; i<MAX_LTR; i++)
      if (!counts[i])
	fprintf(outfile, " %s        ", &i);

    for (i=MIN_NUM; i<MAX_NUM; i++)
      if (!counts[i])
	fprintf(outfile, " %s        ", &i);

    if (!counts[PERIOD])
      fprintf(outfile, " %c        ", PERIOD);
    if (!counts[COMMA])
      fprintf(outfile, " %c        ", COMMA);
    if (!counts[DN])
      fprintf(outfile, " %c        ", DN);
    if (!counts[QUERY])
      fprintf(outfile, " %c        ", QUERY);
    if (!counts[BT])
      fprintf(outfile, " %c        ", BT);
    if (!counts[AR])
      fprintf(outfile, " %c        ", AR);
    if (!counts[SK])
      fprintf(outfile, " %c        ", SK);

    fprintf(outfile, "\n");
  }

  test_time_5  = (float) inch / LENGTH_5;
  test_time_13 = (float) inch / LENGTH_13;
  test_time_20 = (float) inch / LENGTH_20;

  fprintf(outfile, "\n");
  fprintf(outfile, "This test contains %5d characters\n", inch);
  fprintf(outfile, "\n");
  fprintf(outfile, "This test lasts %8.2f minutes at  5 wpm.\n",
		   test_time_5);
  fprintf(outfile, "This test lasts %8.2f minutes at 13 wpm.\n",
		   test_time_13);
  fprintf(outfile, "This test lasts %8.2f minutes at 20 wpm.\n",
		   test_time_20);

  fclose(outfile);
  printf("vefc 2.4 normal termination!\n");
}
