Common Tech Support Questions


Why does Jaws act differently?

You may have a computer at work and one at home, both running Jaws. 
You may have noticed a difference between the two, the one at home
may act differently than the one at work.  Why is this?

1.  You may have different synthesizers, with different features
and capabilities.  Jaws is written specially for each synthesizer,
designed to use the special features and/or make up for features
that are not there.  For example, with the Accent Jaws will keep
the voice close to the visible data and will stop on the last word
spoken, but with the Echo PC the voice can lag far behind the
visible data in some circumstances, and there is no way to route
the cursor back to the last word spoken.

2.  You may have bought or received the computers and your copies
of Jaws at different times, the Jaws may be different versions or
"releases".  We are always making improvements and changes to Jaws,
so your two copies may be different.  If you are using the same
type of synthesizer in each case then you can simply copy the Jaws
you like (or the most recent one) and put it on the other computer. 
If the synthesizers are different you may be able to "update" one
of them to get the latest improvements, or keep reading for more
tips.

3.  You may have different copies or versions of the Jaws macro
file, frame file, dictionary file, or other configuration setting. 
If a key on one computer performs differently than the same key on
the other computer then maybe you are using different "macro" or
keyboard files.  If so just copy one to the other and that should
fix things.

4.  There may be differences in the computers or their keyboards
that Jaws cannot make up for.  One computer may have a 88-key key
board while the other has a 101-key key board, or one may be a
Toshiba with a really weird keyboard.  The computers could have
different BIOS's, which may also be confusing Jaws.  You may be
able to alleviate some of the differences by re-positioning the
Jaws keys.  Use the Macro Revise, Duplicate, and Erase functions in
the Jaws menus to do this.  A little experimentation or trial-and-
error will help out here.

There are many things that can vary from one computer to another:
model, processor type, speed, amount of memory, color versus
monochrome, EGA versus VGA, number and type of disk drives, BIOS,
keyboard, number of serial and parallel ports, number and type of
expansion cards or boards installed, modems, DOS version, extended
and/or expanded memory, version of application program, etc.  In a
given instance it is impossible to say just what is causing the
differences in performance without a thorough investigation.

Is the screen color or monochrome?

Sometimes the user or owner of the computer knows what kind of
video card and/or monitor is being used, color or monochrome. 
Usually Jaws can sense this also, during the loading  or
initialization procedure.  If Jaws thinks it is color it will load
the color menus, which display real colors for choices in the
"Enhancements Find" menu, choices like "Red" or "Magenta".  If Jaws
thinks it is monochrome it will display the monochrome attributes,
like "Reverse" or "Intense".

If you want to know what Jaws thinks go to the Enhancements menu,
select "F" for Find, then read the choices.  Another way is to
select the "Screen Color" macro, usually Insert-Number Row 5, which
will tell you the color/attribute of the character where the active
cursor is.  If it says colors, like "Blue on Cyan" then it is
color, or at least Jaws thinks it is.  If it says "Normal" or
"Blinking" then it is monochrome.

Sometimes Jaws gets confused, the technique it is using to tell
color from monochrome is returning inaccurate information.  In this
case you can force Jaws to go color or monochrome, by using a
command-line parameter.  For color it is "/c", for monochrome
it is "/m".  For example, if you have a Braille 'n Speak for
a synthesizer enter:

J_BNS /c

If you have an Accent SA enter:

J_ACNTSA /m

If you have a DecTalk enter:

J_DECTLK /c

If Jaws cannot tell what type of video card is installed, color or
monochrome, then it is likely that it will have trouble recognizing
or finding the enhancement or attribute you are looking for.  Just
be aware that you may get inconsistent results with the
"Enhancements Find" search in the menus.

Remember that the colors are influenced or "shaded" or "tinted" by
the type of monitor being used.  What looks "Yellow" to a sighted
person is not necessarily the same to the computer or to Jaws. 
Many monochrome monitors display "White" as green or amber.

Some computers think that they are color but actually appear to be
black and white or monochrome.  This would include the AT&T 6300
and the IBM PS2 model 30.  They are actually using a "color" video
card but a monochrome monitor, the colors appear in shades of grey. 
A blind user may not notice any difference, but a sighted user may
get confused.  Most people will never have to know if it is color
or monochrome.
Searching for a screen enhancement or color:

If you need to create a Jaws macro to find a highlighted word, like
in a spell checker, or to follow a menu bar then it will be helpful
to know if you are using color or monochrome.  There are some
simple steps you should follow in such a case:

1.  Find out what color/attribute/enhancement you want to "find" or
"track".  Simply move the Jaws Cursor to the highlighted area and
press the "Screen Color" macro, usually Insert-Number Row 5.  You
may need to experiment a bit to know if you are on the
"highlighted" area, since it is only different from the rest of the
screen.  There is no enhancement or color that is guaranteed to be
the highlight.  In the case of a spell checker, simply mis-spell
the first word of the document, then you know it will he
highlighted when you ask the computer to check the spelling.

2.  Define a "search pattern" or search criteria to consistently
find the highlighted area.  You already know what color or
monochrome enhancement to search for, but should you search from
the top down or the bottom up?  Should you start the search at the
cursor and search down or search up?  Must you move the cursor to
an appropriate place before starting the search?  Do you need to
restrict the search to a particular "frame" or rectangular area of
the screen?  This is valuable when there is more than one area or
piece of data with the same attribute.  Refer to the selection
below concerning "Search Options" for details.

3.  Once you have found a good search pattern then create a macro,
to put all that power into one key or key combo.  See our
documentation or training tapes on macros for more details.

Search Options:

When you want to find a specific color/attribute, or a particular
character or string of characters on the screen you have two basic
steps: Use the "Enhancements" menu to select the attribute or
highlight/color, or the "Search" menu to enter the string of
characters.  Then when it asks for "Options" you can enter one or
more of the following:

"T" means start at the top of the screen or frame;
"B" means start at the bottom of the screen or frame if specified
and search upwards or backwards;
"C" means start at the cursor position and search backwards;
"##", one or two digits, means search only in the area defined by
the specified frame number;
"F" means search for the specified color in the foreground.  If
this is not specified Jaws will automatically search in the
background.  This is applicable only on color, not monochrome;
"P" means search only in the frame that the PC cursor is in, "J"
means search only in the frame the Jaws cursor is in, and "A" means
restrict the search to the frame the "active" cursor is in, the
cursor that is turned on.
These options can be used in any logical combination, for example:

"T", start at the top and search the entire screen;
"T5", start at the top of frame 5 and search only within the
boundaries of frame 5;
"BP", search from the bottom of the frame that the PC cursor is in;
"CFJ", search only in the frame that the Jaws cursor is in,
starting at the cursor position and going backwards, and look for
the given color only in the foreground, not the background.

Naturally you cannot use illogical combinations, like "TB" or
"PJ5".

Using a letter to specify a frame

In the Jaws menus you may be prompted to or given the option to
enter a frame number in order to define a frame or rectangular
section of the screen.  You may enter a number or a letter.  When
you enter a "J", "A", or "P" you are telling Jaws to use the frame
that the given cursor is in, Jaws, Active, or PC.  What if it is in
more than one frame, since the frames can overlap, like sheets of
paper scattered on a desk?  In this case Jaws will select the frame
with the highest number.  For example, if you select "P" for a
search option, and the PC cursor is in frame 55 and frame 82, then
Jaws will select frame 82 as the one to use during the search.

You can use this letter technique in Frame Speak, Frame Activate,
and in the enhancement search or string search options.

Macros that do not work

Sometimes you will find that one of the macros that we have created
for a popular application program, like Word Perfect, will not work
as we say it should.  Why is that?  There are several possible
explanations:  

1.  you may not have the correct macro file loaded.  You should be
sure that the proper file or group of macros are being loaded into
Jaws: you must be sure that the macro you are trying to use
actually exists, that it is present in Jaws at that point in time. 
If you have loaded it "manually", from the Jaws menus, then go
through that procedure again to be sure.  If you are not sure refer
to that section of the manual or the Jaws training tapes,
"Configuration Files".  If you are loading the macros and other
configuration files from DOS using the J_LOAD program and a "batch"
file then review those steps and/or the documentation and training
tapes.  Most if not all of the macro files have a corresponding
documentation file or section of the manual, like "123J.DOC" for
the Lotus 123 macro file "123J.JMF".  

 2.  The environment that the macro is performing in has changed. 
Certainly the macro was created and tested on a different computer
in a different time and place.  Computers and software change very
quickly, and it can be difficult to keep up.  Without going into
all the things that could change and effect the macros lets just
assume that what you have, that is the environment, is similar to
the one the macro was created for and you expect it to work.  What
can we do to fix it?  You must first understand what the macro is
trying to do, then figure out why it is not doing it, then decide
on the proper steps that would work correctly, then create or
modify the macro to perform the correct steps.

One of the most common problems we encounter is a macro that is
supposed to search for and find a certain color or video attribute,
such as in the Word Perfect spell checker or a menu light bar. 
Usually Jaws is simply looking for the wrong color, some one has
changed the colors on the screen and Jaws has not automatically
adapted.  This can be caused by a change in hardware, like a non-
standard video card, or a change in the application software (Word
Perfect 5.0 and 5.1 use different colors), or the user has changed
the colors to suit his/her taste (Word Perfect allows the user to
change the screen colors and attributes).  The solution is simple
in most cases, just change the macro to search for the correct
color/attribute.  Read the section on "Colors" or the sample Word
Perfect spell check macro for more info.

In another situation Jaws is looking for a graphics character that
is highlighted and simply cannot find it.  This situation occurs
with the "Professional Write" word processor, and the "First
Choice" word processor.  The Jaws macro to read the menu choice is
searching for the arrow that points to the highlighted menu choice. 
On some color machines Jaws simply cannot find the graphic arrow
character.  The solution is easy, just change the "Color Pallet"
being used by the word processor.  This is done in the setup or
configuration screen of the word processor, select the color pallet
not being used and then the search will work.

Word Perfect spell check macro:

The spell check macro is designed to search for the highlighted
word and say it, putting the Jaws cursor on the first letter of the
word for closer inspection.  First it does a "if color-flag" to see
if it is a color or monochrome video card, if color then it
searches for a color, else it searches for a reverse video
attribute.  Then it does a "if success-flag" to see if the
color/attribute was found, if so it says the word, else it speaks
a "label" or phrase that identifies the macro.  Use the "Macro
Revise" choice in the menu to look at the macro in detail.  This
macro is usually "on" or attached to the control-up arrow key, or
it may be the control-numpad minus key, or some other key.  Refer
to the specific documentation file, as new versions and new
features become available we may have to move the macro keys around
to fit the circumstances.

If you are having a problem with the spell check macro you may also
have one with the Revealed Codes macro, since it also searches for
a color in versions 5.0 and 5.1 of WP.  Follow these instructions
for tips on how to correct the Revealed codes macro if need be.
 
The spell check macro for Word Perfect version 5.1 searches for the
color Red in the background from the top of the screen.  This is
the default or standard color used to highlight the misspelled
word.  The color Red is represented by the "R" in the macro.  Below
we have laid out the macro so we can explain it, the comments are
in parenthesis, the numbers represent the item number.  The color
being searched for is item 7: 

1.  IF  (start a "if" statement)
2.  COLOR-FLAG (is it color video, not monochrome?)
3.  THEN (yes, it is color)
4.  MENUS  (invoke the Jaws menus)
5.  E (select the Enhancements menu)
6.  F  (select "Find a specific color")
7.  R  (choose the color Red)
8.  T (start the search from the top of the screen)
9.  ENTER (start the search)
10.  ELSE (not color video, must be monochrome)
11.  MENUS (invoke the Jaws menus)
12.  E (select Enhancements menu)
13.  F (select the Find manu)
14.  R (select Reverse video attribute)
15.  T (start at the top of the screen)
16.  ENTER (start the search)
17.  ENDIF (end of the "if" statement)
18.  IF  (start another "if" statement)
19.  SUCCESS-FLAG (was the search successful?)
20.  THEN (yes, the attribute was found)
21.  SAYWORD2 (say the word, do not spell it)
22.  ELSE (the word was not found)
23.  BEGIN LABEL (start of the key label to be spoken)
24.  "FIND THE MISSPELLED WORD" (this is the label)
25.  END LABEL (end of the label or phrase)
26.  ENDIF (end of the "if" statement)

You probably know by now that you need to change item 7 if you want
the macro to find a different color.  Invoke the "Enhancements
Find" menu, just like the macro does, to see all the color choices
and the letter or letters used to represent them.  The macro
"controls" the menus and the selections just like you do from the
keyboard, you must figure which keys are to be pressed, then put
them in the macro.  Move to the color you want in the menu and
press the "Say Character" key to hear the letter.  For example, for
item 7, R is Red, but Blue is BL, Black is BK, Magenta is M, Yellow
is Y, etc.  Some colors require one letter, others require two. 
Figure out the logic first, then put it in the macro.

For more information on color/enhancement searches and the options
associated with them refer to the "Colors" subjects in the manual,
the Jaws training tapes, or the Word Perfect training tapes and
documentation.
 
Item 8 is a "option" to modify the search.  See the section of
Search Options to see more about how this effects the search.
