/*

	eb1.hpp
	7-30-91
	Electronic Book: Header for eb1.cpp

	Copyright 1991
	John W. Small
	All rights reserved

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	John Small
	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#ifndef EB1_HPP
#define EB1_HPP

#ifndef EBDEF_HPP
#include <ebdef.hpp>
#endif

#ifndef FLEXLIST_CPP
#include <flexlist.hpp>
#endif



/*

	ParseLinks() works like strtok(), the first call
	sets up the parser and returns either the topic or
	first target respectively for inlinks or outlinks
	specifiers.  Successive calls returns clues or
	additional targets respectively.

*/

extern char * parseLinks(const char * inOutLinks
		 = (char *)0);



/*

	ExtractLinksDup() returns a duplicate of the inlinks
	or outlinks specifier present in the input string.
	InOut must be nonzero to extract an inlinks
	specifier and zero to extract an outlinks specifier.

*/


extern char * extractLinksDup(const char *inOutLinks,
		int inOut);



/*

	The TargetParser class parses a target to determine
	whether it is near or far and if the target is
	hypertext or a system or exec call.  The user of the
	class can read the topic and parameters.  If the
	parse() function is called without a parameter than
	the target type is returned for the last target
	parsed.

*/


class TargetParser {
public:
	enum HYPER_TARGETS { UNKNOWN, NEAR_TOPIC, NEAR_DEFAULT,
		FAR_TOPIC, FAR_DEFAULT, FAR_SYSTEM,
		FAR_SPAWN };
private:
	enum HYPER_TARGETS ttype;
	char buf[MAX_HYPER_LINE];
	char *tp, *pm;
	void reset()  {	ttype = UNKNOWN;
		tp = pm = (char *)0; }
public:
	enum HYPER_TARGETS parse(const char *target
		= (char *)0);
	TargetParser(const char *target = (char *)0)
		{ reset(); parse(target); }
	char *topic()  { return tp; }
	char *params() { return pm; }
};
typedef TargetParser * TargetParseR;
#define TargetParseR0 ((TargetPareR)0)



/*

	The HyperTextTarget class is constructed dynamically
	only in the FlexNodes of the HyperStack FlexList.
	An instance records the HyperText file name and
	topic within as well as the window and cursor
	positioning within the HyperContext of the topic.

*/

class HyperTextTarget  {
	unsigned startColumn, startRow;
	unsigned cursorColumn, cursorRow;
	char *fname, *topic;
	int constructOK;
	#pragma argsused
	void * operator new(size_t size)
		{ return (void *)0; }
public:
	#pragma argsused
	void * operator new(size_t size, void * ptr)
		{ return ptr; }
	HyperTextTarget(const char *fname,
		const char *topic = (char *) 0,
		unsigned startColumn = 1,
		unsigned startRow = 1,
		unsigned cursorColumn = 1,
		unsigned cursorRow = 1);
	int ConstructOK()  { return constructOK; }
	char *Fname()  { return fname; }
	char *Topic()  { return topic; }
	int setView(unsigned startColumn, unsigned startRow,
		unsigned cursorColumn, unsigned cursorRow);
	unsigned StartColumn()  { return startColumn; }
	unsigned StartRow()  { return startRow; }
	unsigned CursorColumn()  { return cursorColumn; }
	unsigned CursorRow()  { return cursorRow; }
	~HyperTextTarget()  { delete fname; delete topic; }
};
typedef HyperTextTarget * HyperTextTargeT;
#define HyperTextTargeT0 ((HyperTextTargeT)0)



/*

	The HyperStack class is a variant FlexList of
	HyperTextTargets.  A variant FlexList is used so
	that the HyperTextTarget's destructor can be called
	automatically by the FlexList member functions.
	The top target is used to fetch the current
	HyperContext for subsequent viewing.

*/


class HyperStack : FlexList  {
	#pragma argsused
	virtual FlexN FNnew(const void *D)  { return
		(FlexN) new char[sizeof(FlexNode)-1
		+sizeof(HyperTextTarget)]; }
	#pragma argsused
	virtual int   FNwrite(void *ND, const void *D)
		{ return 0; }
	#pragma argsused
	virtual int   FNread(const void *ND, void *D)
		{ return 0; }
	virtual int   FNdestruct(void *ND, void *D);
public:
	HyperStack() : FlexList(FLvariantData) {}
	HyperTextTargeT pushTarget(const char *fname,
		const char *topic = (char *)0);
	int popTarget() { return popD(); }
	HyperTextTargeT topTarget()
		{ return (HyperTextTargeT) topD(); }
	char *topFname() { return
		((HyperTextTargeT)topD())->Fname(); }
	int setTopView(unsigned startColumn,
		unsigned startRow, unsigned cursorColumn,
		unsigned cursorRow);
	unsigned targets() { return Nodes(); }
	~HyperStack() {}
};
typedef HyperStack * HyperStacK;
#define HyperStacK0 ((HyperStacK)0)


#endif

