unit multierr; (* error messages for use by MULTIJOY and MINIJOY *)


interface


procedure error_msg (msg_nr, code : integer;
                     multipath, multicfg, multiport : string);
(* displays error message and halts the program *)


implementation


function dos_error (code : integer) : string;
(* returns dos error message to specified error code *)
var error : string;
begin
  case code of
     2 : error := ('File not found');
     3 : error := ('Path not found');
     5 : error := ('Access denied');
     6 : error := ('Invalid Handle');
     8 : error := ('Not enough memory');
    10 : error := ('Invalid environment');
    11 : error := ('Invalid format');
    18 : error := ('No more files');
    else begin
      str (code, error);
      dos_error := 'error #' + error;
    end;
  end;
  dos_error := error;
end;


procedure error_msg (msg_nr, code : integer;
                     multipath, multicfg, multiport : string);
(* displays error message and halts the program *)
begin
  writeln ('MULTIJOY.TPU error message: ');
  case msg_nr of
     1 : writeln ('Config file read error: ', dos_error (code));
     2 : writeln ('Config file syntax error: undefined action code (''', chr (code), ''')');
     3 : writeln ('Config file read error: unexpected end of file');
     4 : writeln ('Config file found but not able to read it (', dos_error (code), ')');
    12 : writeln ('Config file error: illegal joystick number (', code, ')!');
     5 : writeln ('DOS environment does not contain MULTIPATH (path of config file)');
     6 : writeln ('DOS environment does not contain MULTICFG  (name of config file)');
     7 : writeln ('DOS environment variable MULTICFG must have no extension!');
    13 : writeln ('DOS environment variable MULTIDELAY is not a number');
     8 : writeln ('Invalid DOS environment variable MULTIPORT (''', chr (code), ''')');
     9 : writeln ('MINIJOY does not support keyboard emulation mode!');
    10 : writeln ('Config file read error: address out of range (''', code, ''')');
    11 : writeln ('Printer port ',code,' not found!')
    else writeln ('critical error - no appropriate error message found (error #', code, ')');
  end;
  writeln;
  writeln ('MULTIPATH = ', multipath);
  writeln ('MULTICFG  = ', multicfg );
  writeln ('MULTIPORT = ', multiport);
  halt;
end;


begin
end.