unit genericp;  {generic procedures unit - not rnr-specific at all}

{

Russell_Schulz@locutus.ofB.ORG (951123)

Copyright 1996 Russell Schulz

this code is not in the Public Domain

permission is granted to use these routines in any application regardless
of commercial status as long as the author of these routines assumes no
liability for any damages whatsoever for any reason.  have fun.

}

{
version of this unit: 1ish
}

interface

uses dos,genericf;

procedure mkhier(hier: string);
procedure copyfile(oldfn,newfn: string);
procedure deletefile(fn: string);
procedure emptyfile(fn: string);
procedure movefile(oldfn,newfn: string);
procedure copyfilethenempty(oldfn,newfn: string);
procedure execp(cmd,cmdline: string);
procedure execpo(cmdline: string);
procedure waitnseconds(n: integer);

implementation

procedure mkhier;

var
  s: string;
  i: integer;
  fileinfo: searchrec;
  dir: string;

begin

{$I-}

{if the directory already exists, don't worry about an error}

{WHY DOESN'T THIS WORK WITH TP6 ?!?!?!}

  s := hier;

  for i := 1 to length(s) do
    if s[i]='/' then
      s[i] := '\';

  if length(s)>0 then
    if s[length(s)]='\' then
      s := copy(s,1,length(s)-1);

  for i := 2 to length(s) do
    if (s[i]='\') and (s[i-1]<>':') then
      begin
        dir := copy(s,1,i-1);
        findfirst(dir,directory,fileinfo);
        if doserror<>0 then
          mkdir(dir);
      end;

  findfirst(s,directory,fileinfo);
  if doserror<>0 then
    mkdir(s);

{$I+}

end;

procedure copyfile;

const
  bufsize=1024;

var
  infile, outfile: file;
  done: boolean;
  numread: word;
  buffer: array[1..bufsize] of char;
  timestamp: longint;

begin
  assign(outfile,newfn);
  rewrite(outfile,1);

  assign(infile,oldfn);
  reset(infile,1);
  getftime(infile,timestamp);

  done := false;
  while not done do
    begin
      blockread(infile,buffer,bufsize,numread);
      blockwrite(outfile,buffer,numread);
      done := (numread<bufsize);
    end;
  setftime(outfile,timestamp);

  close(infile);
  close(outfile);
end;

procedure deletefile;

var
  f: file;

begin
  if fexists(fn) then
    begin
      assign(f,fn);
{$I-} {doesn't help tp4?}
      erase(f);
{$I+}
    end;
end;

procedure emptyfile;

var
  f: file;

begin
  assign(f,fn);
  rewrite(f);
  close(f);
end;

procedure movefile;

begin
  copyfile(oldfn,newfn);
  deletefile(oldfn);
end;

procedure copyfilethenempty;

begin
  copyfile(oldfn,newfn);
  emptyfile(oldfn);
end;

procedure execp;

var
  path: string;
  success: boolean;
  ncmd: string;
  nbase: string;
  npath: string;
  el: string;
  at: integer;

    function indir(cmd,dir: string): boolean;

    var
      fileinfo: searchrec;

    begin {indir}
      findfirst(withbackslash(dir)+cmd,archive,fileinfo);
      indir := (doserror=0);
    end; {indir}

begin {execp}
  success := false;

  ncmd := crepl(cmd,'/','\');
  nbase := ncmd;

{strip path from nbase}

  repeat
    at := pos(':',nbase);
    if at<>0 then
      nbase := copy(nbase,at+1,255);
  until at=0;

  repeat
    at := pos('\',nbase);
    if at<>0 then
      nbase := copy(nbase,at+1,255);
  until at=0;

{chop off path.  if trailing \, chop, unless root or drive:root (then add .)}

  npath := '';
  if nbase<>ncmd then
    begin
      success := true;  {so as to not look further than given path}
      npath := copy(ncmd,1,length(ncmd)-length(nbase));
      if npath='\' then
        npath := npath+'.';
      if pos(':\',npath)<>0 then
        if copy(npath,length(npath)-1,2)=':\' then
          npath := npath+'.';
      if copy(npath,length(npath),1)='\' then
        npath := copy(npath,1,length(npath)-1);
    end;

{if an explicit path, use it -- otherwise, just try '.'}

  if npath='' then
    npath := '.';

{if no extension, try com then exe}

  if pos('.',nbase)=0 then
    begin
      if indir(nbase+'.com',npath) then
        begin
          success := true;
          exec(withbackslash(npath)+nbase+'.com',cmdline);
        end
      else if indir(nbase+'.exe',npath) then
        begin
          success := true;
          exec(withbackslash(npath)+nbase+'.exe',cmdline);
        end
    end
  else if indir(nbase,npath) then
    begin
      success := true;
      exec(withbackslash(npath)+nbase,cmdline);
    end;

  if not success then
    begin

{not found in explicit path (or ., if no explicit path).  try $PATH}

      path := getenv('PATH');
      while not success and (path<>'') do
        begin
          if copy(path,length(path),255)<>';' then
            path := path+';';
          at := pos(';',path);
          el := copy(path,1,at-1);
          path := copy(path,at+1,255);
          if pos('.',nbase)=0 then
            begin
              if indir(nbase+'.com',el) then
                begin
                  success := true;
                  exec(withbackslash(el)+nbase+'.com',cmdline);
                end
              else if indir(nbase+'.exe',el) then
                begin
                  success := true;
                  exec(withbackslash(el)+nbase+'.exe',cmdline);
                end;
            end
          else
            begin
              if indir(nbase,el) then
                begin
                  success := true;
                  exec(withbackslash(el)+nbase,cmdline);
                end;
            end;
        end;
    end;
end;

procedure execpo;

var
  thecmd: string;
  thecmdline: string;

begin {execpo}
  thecmdline := cmdline;
  thecmd := chopfirstw(thecmdline);
  execp(thecmd,thecmdline);
end;

{ assumes n<320 or so}
procedure waitnseconds;

var
  h,m,s,s00: word;
  olds, olds00: word;
  starting: word;
  s00towait: integer;

begin
  if n<320 then
    s00towait := n*100
  else
    s00towait := 32000;

  gettime(h,m,olds,olds00);
  s := olds;
  s00 := olds00;

  starting := olds*100+olds00;

  while (s*100+s00)<starting+s00towait do
    begin
      gettime(h,m,s,s00);
      if s<olds then
        dec(starting,6000);  {safer than inc(s,60) to allow for n>59}
      olds := s;
    end;
end;

end.
