#!/bin/sh
############################################################
# FILE NAME: install_db.sh
#
# VERSION: 2.0
#
# Copyright (c) 2003 Webplus, Inc. All rights reserved.
#
# DESCRIPTION: 
# This script is used to install Webplus, Inc. Web+ sample database
#
# MAINTENANCE LOG:
# 17-03-2000 Added check for directory /var/lib/mysql and set DBPORT to the 
#            mysql.socket. For support of RPM installs of MySQL. -NJA
# 18-03-2003 Added mysqld.sock (in addition to mysql.sock) to set DBPORT.
#            Added allowing to have admin user without password.
#
############################################################

TECH_SUPPORT="Webplus Tech Support at 651-209-3100"
FPRODID="Productid"
ABORTED="Installation for Web+ sample database is aborted."
OS=`uname -s`

if [ "$OS" = "SunOS" ]; then
	ECHO="/usr/ucb/echo"
else
	ECHO="echo"
fi

echo
echo "**************** W E L C O M E *****************"
echo "This script installs Web+ sample database."         
echo 

WEBP_DIR="$1"

if [ -z "$WEBP_DIR" ] && [ -f /usr/local/webplus/webpadmin ]; then
	DEFWEBP="/usr/local/webplus"
else
	DEFWEBP=""
fi

#####
# Find out where Web+ is installed
#####
while true
do
   if [ -z "$WEBP_DIR" ]; then
   	echo
	if [ -z "$DEFWEBP" ]; then
   		$ECHO -n "Please enter Web+ home directory: "
	else
		$ECHO -n "Please enter Web+ home directory [$DEFWEBP]: "
	fi
   	read WEBP_DIR
	if [ -z "$WEBP_DIR" ]; then
		WEBP_DIR="$DEFWEBP"
	fi
   fi

   if [ -z "$WEBP_DIR" ]; then
	continue
   fi

   if [ "${WEBP_DIR}" = "quit" ] || [ "${WEBP_DIR}" = "QUIT" ]; then
        echo $ABORTED
        exit 1
   fi

   if [ ! -d "${WEBP_DIR}" ]; then
      echo "Directory ${WEBP_DIR} does not exist. Please enter another one."
	WEBP_DIR=""
	continue
   fi

   if [ ! -f "${WEBP_DIR}/webpadmin" ]; then
        echo "Directory ${WEBP_DIR} does not have 'webpadmin' file."
        echo "Please check and make sure ${WEBP_DIR} is Web+ directory."
	WEBP_DIR=""
        continue
   fi

   break
done

echo
echo "************** IMPORTANT NOTICE *****************"
echo "Before proceeding with the installation, please read the following"
echo "instructions carefully. In order to install Web+ sample DB, you need to"
echo "prepare the following:"
echo
echo "1) You need to know Web+ directory."
echo "2) You have installed a database package MySQL 3.22 or higher"
echo "   or PostgreSQL 6.5 or higher on this machine or on a remote machine."
echo "3) You need to know which port the database is using. Default port for"
echo "   MySQL is 3306, PostgreSQL is 5432."
echo "4) You need to know the remote hostname if the database is on a remote"
echo "   machine."
echo "5) If you have set sysadmin password for MySQL, we need to know the "
echo "   sysadmin password to create Web+ sample database and privileges."
echo
echo "Press the ENTER key to continue or anything else to abort the installation."
read ans
if [ ! -z "$ans" ]; then
	echo $ABORTED
	exit 1
fi 

#######
# Database configuration: 
#     database type: MySQL or postgreSQL
#     Web+ sample database username and password
#######
DBUSER="webplus"
DBPASS="webplus"

echo
echo "******** D B  C O N F I G U R A T I O N *****"
echo "Web+ supports MySQL 3.22 or higher and postgreSQL 6.5 or higher"
echo "on a local or remote machine."

while true; do
########
# Local or remote
########
while true; do
     echo
     echo "Please specify where your database is."
     echo "[L] Local machine"
     echo "[R] Remote machine"
     echo "[quit"
     echo
     $ECHO -n "Please make your choice: "
     read DBHOW
     case "$DBHOW" in
     L|l|local|LOCAL)
	DBHOW="local"
	DBHOST="localhost"
	WPHOST="localhost"
	break
	;;
     R|r|remote|REMOTE)
	DBHOW="remote"
	WPHOST=`hostname`
	break
	;;
     quit|QUIT)
	echo $ABORTED
	exit 1
	;;
     *)
        echo
        echo "Please enter 'L', 'R' or 'quit'."
	continue
        ;;
     esac
done

######
# If remote, what's the host name
######
if [ "$DBHOW" = "remote" ]; then
    $ECHO -n "Enter the hostname that hosts your database: "
    read DBHOST
    if [ "$DBHOST" = "quit" ] || [ "$DBHOST" = "QUIT" ]
    then
	echo $ABORTED
	exit 1
    fi

    #??? need more work here
    if [ -z "$DBHOST" ]; then
	DBHOST="localhost"
    fi
else
   DBHOST='localhost'
fi

########
# Choose MySQL or postgreSQL 
########
while true; do
     echo
     echo "Please choose the database you are using."
     echo "[M] MySQL 3.22 or higher"
     echo "[P] PostgreSQL 6.5 or higher"
     echo "[quit]"
     echo
     $ECHO -n "Enter a choice: "
     read DBTYPE
     case "$DBTYPE" in 
     m|M)
         DBTYPE="MySQL"
	 DEFPORT="3306"
         break
	   ;;
     p|P)
	 DBTYPE="Postgres"
	 DEFPORT="5432"
         break
	   ;;
     quit|QUIT)
	 echo; echo "You have chosen to abort the installation."
	 echo $ABORTED
         exit
         ;;
     *)
	 echo;echo "Please enter 'M' or 'P' or 'quit'."
	 ;;
     esac
done # end of database type

######
# Ask for database running port
######
DBPORT=$DEFPORT
echo; $ECHO -n "Enter the port number that $DBTYPE uses [$DBPORT]: "
read DBPORT
if [ "$DBPORT" = "quit" ] || [ "$DBPORT" = "QUIT" ]; then
	echo $ABORTED
	exit 1
fi

if [ -z "$DBPORT" ]; then
	DBPORT=$DEFPORT
fi

echo
echo "If you have set sysadmin password, please enter the sysadmin user name"
echo "and password. Otherwise, press ENTER to skip the following question."
$ECHO -n "Please enter $DBTYPE sysadmin user name: "
read ADMUSER
if [ "$ADMUSER" = 'quit' ] || [ "$ADMUSER" = 'QUIT' ]; then
	echo $ABORTED
	exit 1
fi 

if [ -z "$ADMUSER" ]; then
	ADMUSER="none"
	ADMPASS="none"
elif [ -z "$ADMPASS" ]; then
	ADMPASS="none"
else
	$ECHO -n "Enter $DBTYPE sysadmin password: "
	read ADMPASS
	if [ "$ADMPASS" = 'quit' ] || [ "$ADMPASS" = 'QUIT' ]; then
		echo $ABORTED
		exit 1
	fi
fi 


echo
echo "********** V E R I F I C A T I O N ***********"
echo "You have made the following choices about database:"
echo 
echo "Database on local or remote machine: $DBHOW"
if [ "$DBHOW" = 'remote' ]; then
	echo "Database hostname: $DBHOST"
fi
echo "Database product: $DBTYPE"
echo "$DBTYPE uses port number: $DBPORT"
echo "Sysadmin user name: $ADMUSER"
echo "Sysadmin password: $ADMPASS"
echo
echo "Note that the $DBTYPE user account for Web+ sample is"
echo "automatically generated by this script, that is, "
echo "user name: $DBUSER, password: $DBPASS."
echo
$ECHO -n "Press ENTER to confirm or anything else to change: "
read ans 
if [ -z "$ans" ]; then
	break
fi

done 


#####
# Create database
#####
echo
echo "Installing $DBTYPE database for Web+ sample..."
if [ "$DBTYPE" = "MySQL" ]; then
	SCRIPT="install_DB_mysql.sh"
	DBPATH="./database/mysql/example"
else
	SCRIPT="install_DB_postgres.sh"
	DBPATH="./database/postgresql/example"
fi

EXESCRIPT="$DBPATH/$SCRIPT $DBPATH "$WEBP_DIR/UNINSTALL" $DBUSER $DBPASS $DBPORT $WPHOST $ADMUSER $ADMPASS $DBHOST 1 webpdb"
eval "$EXESCRIPT"

#####
# Update webpsvr.conf
#####

WEBPCONF="$WEBP_DIR/bin/webpsvr.conf"
TMP=webpsvr.tmp

echo 
echo "Updating webpsvr.conf file...."
echo "If you encounter any problems, you can recover the original from"
echo "${WEBPCONF}.ssave"

   if [ -r "/var/lib/mysql/mysql.sock" ] && [ "$DBTYPE" = "MySQL" ]; then
        DBPORT="/var/lib/mysql/mysql.sock"
	 elif [ -r "/var/lib/mysql/mysqld.sock" ] && [ "$DBTYPE" = "MySQL" ]; then
				DBPORT="/var/lib/mysql/mysqld.sock"
   fi

cp $WEBPCONF ${WEBPCONF}.ssave
cp $WEBPCONF $TMP

./database/add_sample_conf.sh $DBTYPE "webpdb" $DBHOST $DBPORT $DBUSER $DBPASS $TMP< $WEBPCONF

mv $TMP $WEBPCONF
echo "Done"
   
 
echo

#####
# Restart Web+ to force new webpsvr.conf value to be read
#####
RESTARTCMD="${WEBP_DIR}/webpadmin restart"
eval ${RESTARTCMD}

echo "Web+ sample database is installed!"

exit


