/*
 * Decompiled with CFR 0.152.
 */
package com.jagacy;

import com.jagacy.util.ByteBuffer;
import com.jagacy.util.JagacyException;
import com.jagacy.util.JagacyProperties;
import com.jagacy.util.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractConduit {
    private final String[] do;
    private final int[] if;
    private final int[] a;
    protected int myWidth;
    protected int myHeight;
    protected JagacyProperties myProperties;
    protected Logger myLogger;
    protected InputStream myInput;
    protected OutputStream myOutput;
    protected Object myMutex = new Object();
    protected String myTerminal;

    public abstract void open() throws JagacyException;

    public abstract void send(ByteBuffer var1) throws JagacyException;

    public abstract ByteBuffer receive(int var1) throws JagacyException;

    public abstract boolean isExtended();

    protected abstract String[] getTerminals();

    protected abstract int[] getWidths();

    protected abstract int[] getHeights();

    protected abstract int[] createReceiveState();

    protected abstract void resetTimeout() throws JagacyException;

    protected abstract boolean isInitialReceiveState(int[] var1);

    protected abstract boolean isValidReceivedData(int[] var1, byte var2);

    protected abstract boolean isReceiveDone(int[] var1, byte var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logBytes(String string, byte[] byArray) {
        if (this.myLogger.isTraceEnabled()) {
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(16);
            synchronized (stringBuffer2) {
                stringBuffer.append(string).append(Logger.NL);
                stringBuffer.append(">").append(Logger.NL);
                int n2 = 0;
                block3: while (true) {
                    int n3 = 0;
                    while (n3 < 16) {
                        if (n2 + n3 == byArray.length) {
                            if (n3 <= 0) break block3;
                            stringBuffer.append(Logger.NL);
                            break block3;
                        }
                        String string2 = Integer.toHexString(byArray[n2 + n3] & 0xFF);
                        if (string2.length() < 2) {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(string2);
                        stringBuffer.append(" ");
                        ++n3;
                    }
                    stringBuffer.append(Logger.NL);
                    n2 += 16;
                }
                stringBuffer.append("<");
                this.myLogger.trace(stringBuffer.toString());
            }
        }
    }

    protected AbstractConduit() {
        this.do = this.getTerminals();
        this.if = this.getWidths();
        this.a = this.getHeights();
        this.myTerminal = this.do[0];
        this.myWidth = this.if[0];
        this.myHeight = this.a[0];
    }

    public void setLogger(Logger logger) {
        this.myLogger = logger;
    }

    public void setProperties(JagacyProperties jagacyProperties) {
        this.myProperties = jagacyProperties;
    }

    public int getWidth() {
        return this.myWidth;
    }

    public int getHeight() {
        return this.myHeight;
    }

    protected void init() throws JagacyException {
        if (this.myInput != null) {
            throw new JagacyException(1, "Conduit is already open");
        }
        this.myLogger.trace("Opening conduit");
        this.myTerminal = this.myProperties.get("jagacy.terminal", this.myTerminal).trim();
        this.myTerminal = this.myTerminal.toUpperCase();
        int n2 = 0;
        while (n2 < this.do.length) {
            if (this.myTerminal.equals(this.do[n2])) break;
            ++n2;
        }
        if (n2 == this.do.length) {
            throw new JagacyException(1, "Unknown terminal type " + this.myTerminal);
        }
        this.myWidth = this.if[n2];
        this.myHeight = this.a[n2];
    }

    protected void send(byte[] byArray) throws JagacyException {
        if (this.myOutput == null) {
            throw new JagacyException(1, "Conduit is closed");
        }
        this.logBytes("Sending", byArray);
        try {
            this.myOutput.write(byArray);
            this.myOutput.flush();
        }
        catch (IOException iOException) {
            this.abort();
            throw new JagacyException(1, "Cannot send data", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBuffer receive(ByteBuffer byteBuffer) throws JagacyException {
        byte by;
        if (this.myInput == null) {
            throw new JagacyException(1, "Conduit is closed");
        }
        int[] nArray = this.createReceiveState();
        this.myLogger.trace("Reading");
        do {
            int n2 = -1;
            try {
                Object object = this.myMutex;
                synchronized (object) {
                    n2 = this.myInput.read();
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                n2 = -2;
            }
            catch (IOException iOException) {
                this.abort();
                throw new JagacyException(15, "read", iOException);
            }
            if (n2 == -2 && this.isInitialReceiveState(nArray)) {
                return byteBuffer;
            }
            if (n2 < 0) {
                if (!this.isInitialReceiveState(nArray)) break;
                this.abort();
                throw new JagacyException(15, "read returned " + n2);
            }
            this.resetTimeout();
            by = (byte)n2;
            if (!this.isValidReceivedData(nArray, by)) continue;
            byteBuffer.append(by);
        } while (!this.isReceiveDone(nArray, by));
        if (this.myLogger.isTraceEnabled()) {
            this.logBytes("Received", byteBuffer.getBytes());
        }
        return byteBuffer;
    }

    public abstract void sendBreak() throws JagacyException;

    protected void abort() throws JagacyException {
        this.myLogger.trace("Disconnected");
        this.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws JagacyException {
        block8: {
            try {
                try {
                    if (this.myInput != null) {
                        this.myInput.close();
                    }
                    if (this.myOutput != null) {
                        this.myOutput.close();
                    }
                }
                catch (IOException iOException) {
                    throw new JagacyException(1, "Error closing conduit", iOException);
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                if (this.myInput != null) {
                    this.myTerminal = this.do[0];
                    this.myWidth = this.if[0];
                    this.myHeight = this.a[0];
                }
                this.myInput = null;
                this.myOutput = null;
                throw throwable;
            }
            {
                Object var2_4 = null;
                if (this.myInput == null) break block8;
            }
            this.myTerminal = this.do[0];
            this.myWidth = this.if[0];
            this.myHeight = this.a[0];
        }
        this.myInput = null;
        this.myOutput = null;
    }
}

