/*
 * Decompiled with CFR 0.152.
 */
package com.jagacy.util;

import com.jagacy.util.JagacyException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ByteBuffer {
    private byte[] if;
    private int int;
    private int a;
    private int for;
    private int do;

    public ByteBuffer(int n2) {
        this.if = new byte[n2];
        this.a = n2;
    }

    public void append(byte by) {
        if (this.int == this.if.length) {
            byte[] byArray = new byte[this.int + this.a];
            System.arraycopy(this.if, 0, byArray, 0, this.int);
            this.if = byArray;
        }
        this.if[this.int] = by;
        ++this.int;
        ++this.do;
    }

    public void appendEscape(byte by) {
        this.append(by);
        if (by == 255) {
            this.append(by);
            --this.do;
        }
    }

    public void append(byte[] byArray) {
        if (this.int + byArray.length > this.if.length) {
            byte[] byArray2 = new byte[this.int + byArray.length];
            System.arraycopy(this.if, 0, byArray2, 0, this.int);
            this.if = byArray2;
        }
        System.arraycopy(byArray, 0, this.if, this.int, byArray.length);
        this.int += byArray.length;
        this.do += byArray.length;
    }

    public int getLength() {
        return this.int - this.for;
    }

    public int getSize() {
        return this.do - this.for;
    }

    public void reset() {
        this.int = 0;
        this.for = 0;
        this.do = 0;
        this.if = new byte[this.a];
    }

    public void addStart(int n2) throws JagacyException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid offset " + n2);
        }
        if (this.for + n2 > this.int) {
            throw new JagacyException("Buffer overrun");
        }
        this.for += n2;
    }

    public void subtractLength(int n2) throws JagacyException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid offset " + n2);
        }
        if (this.int - n2 < this.for) {
            throw new JagacyException("Buffer underrun");
        }
        this.int -= n2;
    }

    public byte byteAt(int n2) throws JagacyException {
        if (this.for + n2 >= this.int) {
            throw new JagacyException("Buffer overrun");
        }
        return this.if[this.for + n2];
    }

    public void setByteAt(int n2, byte by) throws JagacyException {
        if (this.for + n2 >= this.int) {
            throw new JagacyException("Buffer overrun");
        }
        this.if[this.for + n2] = by;
    }

    public byte get() throws JagacyException {
        if (this.getLength() == 0) {
            throw new JagacyException("Buffer overrun");
        }
        return this.if[this.for++];
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.int - this.for];
        System.arraycopy(this.if, this.for, byArray, 0, byArray.length);
        return byArray;
    }
}

