import com.jagacy.Key;
import com.jagacy.Session3270;
import com.jagacy.util.JagacyException;
import com.jagacy.util.JagacyProperties;
import com.jagacy.util.Logger;

/**
 * This class uses positions to retrieve the first 5 java copyrights from the
 * Library of Congress.
 * 
 * @author Robert M. Preston
 * 
 */
public class Example2 extends Session3270 {

    private JagacyProperties props;

    private Logger logger;

    private Example2() throws JagacyException {
        super("example2");
        props = getProperties();
        logger = getLogger();
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.jagacy.Session3270#logon()
     */
    protected boolean logon() throws JagacyException {
        // Notice that you don't have to prefix each property with 'example2'.
        // Jagacy will do this for you. But, you do have to prefix the
        // entries in the property file.
        boolean success = waitForPosition("logon.wait", "logon.timeout.seconds");
        if (!success) {
            logger.fatal("Not main screen");
        }

        return success;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.jagacy.Session3270#logoff()
     */
    protected void logoff() throws JagacyException {
        writePosition("logoff1.entry");
        writeKey(Key.ENTER);
        waitForChange("logoff.timeout.seconds");

        // Intermediate screen that occurs sometimes.
        // Use a 0 timeout to just poll.
        if (waitForPosition("intermediate.wait", 0)) {
            writeKey(Key.ENTER);
            waitForChange("logoff.timeout.seconds");
        }

        if (waitForPosition("logon.wait", "logoff.timeout.seconds")) {
            writePosition("main.entry", props.get("main.entry.endValue"));
            writeKey(Key.ENTER);
            waitForPosition("logoff2.wait", "logoff.timeout.seconds");
        }

        writePosition("logoff2.entry");
        writeKey(Key.ENTER);
        waitForChange("logoff.timeout.seconds");
    }

    /**
     * Retrieves the first 5 Java copyrights and writes them to System.out.
     * 
     * @throws JagacyException If an error occurs.
     */
    private void getJavaCopyrights() throws JagacyException {
        writePosition("main.entry");
        writeKey(Key.ENTER);

        if (!waitForPosition("notice.wait", "notice.timeout.seconds")) {
            logger.fatal("Not notice screen");
            return;
        }
        writePosition("notice.entry");
        writeKey(Key.ENTER);

        if (!waitForPosition("copyright.wait", "copyright.timeout.seconds")) {
            logger.fatal("Not copyright screen");
            return;
        }
        writePosition("copyright.entry");
        writeKey(Key.ENTER);

        if (!waitForPosition("monograph.wait", "monograph.timeout.seconds")) {
            logger.fatal("Not monograph screen");
            return;
        }
        writePosition("monograph.entry", "java");
        writeKey(Key.ENTER);

        waitForChange("data.timeout.seconds");
        if (!waitForPosition("data.wait", "data.timeout.seconds")) {
            logger.fatal("Not data screen");
            return;
        }

        for (int i = props.getCardinal("data.begin"), length = props
            .getCardinal("data.end"); i < length; i++) {

            System.out.println(readPosition(i, 0, getWidth()));
        }
    }

    /**
     * Print exception(s) to System.err.
     * 
     * @param e JagacyException
     */
    private static void printExceptions(JagacyException e) {
        System.err.println(e);
        if (e.hasException()) {
            System.err.println(e.getException());
        }
    }

    public static void main(String[] args) {
        Example2 example = null;
        try {
            example = new Example2();
            example.open();
            example.getJavaCopyrights();
            example.close();
        } catch (JagacyException e) {
            printExceptions(e);
            if (example != null) {
                example.abort();
            }
        }

        if ((example != null) && example.props.getBoolean("window", false)) {
            // Swing requires this if window is enabled.
            System.exit(0);
        }
    }
}