
/* ---------------------------------------------------------------------*/
/*									*/
/*	MOUKEY v1.0 for C/C++						*/
/*	Event-driven mouse & keyboard interface				*/
/*									*/
/*	EVENTS.H: header file						*/
/*									*/
/*	May 1997							*/
/*									*/
/*	Copyright (c) 1997 Tanescu A. Horatiu				*/
/*									*/
/* ---------------------------------------------------------------------*/

#if !defined( __EVENTS_H )
#define __EVENTS_H

#if !defined(__cplusplus)
#error C++ is required
#endif

#include <string.h>

/* Event types */

#define ET_NOEVENT		0x0000	// No event
#define ET_MOUSE		0x000F	// Mouse event
#define ET_KEYBOARD		0x0010	// Keyboard event
#define ET_STD    		0xFF00	// Standard event
#define ET_ALLEVENTS		0xFFFF	// All events

/* Empty event */

#define EV_NULL			0x0000	// event already handled or no event

/* Mouse events */

#define EV_MOUSEMOVE		0x0001  // Mouse changed location
#define EV_MOUSEDOWN		0x0002  // Mouse button pressed
#define EV_MOUSEUP		0x0004  // Mouse button released
#define EV_MOUSEAUTO		0x0008	// Periodic event generated while a
					// mouse button is held down

/* Keyboard events */

#define EV_KEYDOWN		0x0010	// Key pressed

/* TMouseEvent structure */

typedef struct {

  union {
    struct {
      unsigned leftState      : 1;
      unsigned rightState     : 1;
      unsigned middleState    : 1;
      unsigned dblClick       : 1;
      unsigned notused        : 4;
      unsigned mousemove      : 1;
      unsigned leftPressed    : 1;
      unsigned leftReleased   : 1;
      unsigned rightPressed   : 1;
      unsigned rightReleased  : 1;
      unsigned middlePressed  : 1;
      unsigned middleReleased : 1;
    } info;

    struct {
      unsigned char state;
      unsigned char event;
    } button;
  };

  unsigned int X;
  unsigned int Y;
  unsigned int lastX;
  unsigned int lastY;

} TMouseEvent;

/* TKeyEvent structure */

typedef struct {

  union {
    unsigned int key;
    struct {
      unsigned char ascii;
      unsigned char scan;
    } code;
  };

} TKeyEvent;

/* TStdEvent structure */

typedef struct {

  union {
    unsigned int  wParam;
    unsigned char wParamB[2];
  };
  union {
    unsigned long lParam;
    unsigned int  lParamW[2];
    unsigned char lParamB[4];
  };
  union {
    unsigned long extraL;
    unsigned int  extraW[2];
    unsigned char extraB[4];
  };

} TStdEvent;

/* TEvent structure */

typedef struct {

  unsigned int event;
  union {
    TMouseEvent mouse;
    TKeyEvent   key;
    TStdEvent   std;
  };
  unsigned long time;

} TEvent;

/* Variables */

extern unsigned int  mouseDoubleDelay;
extern unsigned int  mouseAutoDelay;
extern unsigned int  mouseAutoRate;
extern unsigned char textcoord;
extern unsigned char mouseQueueEvents;
extern void (*_fullqueue_handler)();

/*  Event-driven mouse interface */

int  initMouseEvents(unsigned int queuesize = 16);
int  suspendMouseEvents(void);
int  mouseEvents(void);
int  clearMouseEvents(void);
void getMouseEvent(TEvent& event);

/*  Event-driven keyboard interface */

void getKeyEvent(TEvent& event);

/*  Miscellaneous routines */

void inline clearEvent(TEvent& event)
  { memset(&event, 0, sizeof(TEvent)); }

#endif  /* __EVENTS_H */