/* ptest.cc
 * 1998/27/02
 * (c)Cipher AKA Jeff Weeks of Code X
 *
 * A quick demo of some of PETAL's features.
 * Use this as a framework for creating your
 * own programs.
 */

#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>

#include "petal/petal.h"               /* The PETAL graphics library  */
#include "petal/font.h"                /* The additional font support */
#include "petal/pcx.h"                 /* The additional PCX support  */

#include "petal/drivers/lfb.h"
#include "petal/drivers/pmode.h"
#include "petal/drivers/banked.h"

/* some functions... */
void frects(void);
void rects(void);
void pixels(void);
void lines(void);
void circs(void);
void fcircs(void);
void outline(char *text);
void intro(void);
void setup(void);
void shutdown(void);

/* some variables...  */
int max_x, max_y, bpp, size, i;
Font *gothic, *small;
Pcx  *cansoft;
Image *img;

int main(void) {
  setup();
  intro();
  pixels();
  lines();
  circs();
  fcircs();
  rects();
  frects();
  shutdown();
}

void pixels(void) {
  outline("Pixels");
  clip_image(100,100,440,280);
  for(i = 0; i < 2000; i ++)
    putpixel(rand() % max_x, rand() % max_y, rand() % max_col);
  clip_image(false);
  show_image();
  while(get_key() == 0) {}
}

void lines(void) {
  outline("Lines");
  clip_image(100,100,440,280);
  for(i = 0; i < 500; i ++)
    line(rand() % max_x, rand() % max_y, rand() % max_x, rand() % max_y, rand() % max_col);
  clip_image(false);
  show_image();
  while(get_key() == 0) {}
}

void circs(void) {
  outline("Circles");
  clip_image(100,100,440,280);
  for(i = 0; i < 500; i ++)
    circle(rand() % max_x, rand() % max_y, rand() % 50, rand() % max_col);
  clip_image(false);
  show_image();
  while(get_key() == 0) {}
}

void fcircs(void) {
  outline("Filled Circles");
  clip_image(100,100,440,280);
  for(i = 0; i < 500; i ++)
    filled_circle(rand() % max_x, rand() % max_y, rand() % 50, rand() % max_col);
  clip_image(false);
  show_image();
  while(get_key() == 0) {}
}

void frects(void) {
  outline("Filled Rectangles");
  clip_image(100,100,440,280);
  for(i = 0; i < 100; i ++)
    filled_rect(rand() % max_x, rand() % max_y, rand() % max_x, rand() % max_y, rand() % max_col);
  clip_image(false);
  show_image();
  while(get_key() == 0) {}
}

void rects(void) {
  outline("Rectangles");
  clip_image(100,100,440,280);
  for(i = 0; i < 200; i ++)
    rect(rand() % max_x, rand() % max_y, rand() % max_x, rand() % max_y, rand() % max_col);
  clip_image(false);
  show_image();
  while(get_key() == 0) {}
}

void outline(char *text) {
  /* Draw the red outline, and clip the image appropriately */
  clear_image();
  gothic->outtextxy(10,50,text);
  i = colour(1,0,0);
  rect(99,99,541,381,i);
}

void intro(void) {
  clear_image();

  gothic->colour( colour(0.2, 0.4, 1.0) );
  gothic->bold(true);
  gothic->outtextxy(10,50,"Welcome");

  small->colour( colour(0.2, 1.0, 0.4) );
  small->bold(false);
  small->points(20);
  small->outtextxy(10,80, "This is the PETAL demonstration program.  It will ");
  small->outtextxy(10,100,"illustrate some of the features of the PETAL ");
  small->outtextxy(10,120,"graphics library, like these fonts for example.");
  small->outtextxy(10,140,"These are Borland stroked fonts, with scaling &");
  small->outtextxy(10,160,"emphasizing support.");
  small->bold(true);
  small->outtextxy(500, 180, "- Cipher");
  small->bold(false);

  small->outtextxy(160,370," ^ PCX support too.");

  small->colour( colour(1,1,1) );
  small->points(12);
  small->outtextxy(10, max_y-20, "Press any key to continue");

  show_image();
  show_image(cansoft->img, 160, 220);

  while(get_key() == 0) {}
}

void setup(void) {
  int i;

  // Try to initialize the graphics system using the quoted driver.
  // We also give a window name in this function in case we're in X-Windows.
  if(init_petal(&lfb_driver, "PETAL Test Program"))
  if(init_petal(&pmode_driver, "PETAL Test Program"))
  if(init_petal(&banked_driver, "PETAL Test Program")) {
    printf("Error initializing graphics system\n");
    exit(1);
  }

  // Try to enter a graphics mode, or open a window.  The resolution
  // parameters are simply _suggestions_.  In a system such as X-Windows
  // there can be no garuantee of what colour depth your program will
  // be running in.  If at all possible, these values will be used,
  // however, it is good practice to check the driver structure
  // after setting the mode to see exactly what mode you are in,
  // or you can use get_resolution.
  if(set_resolution(640,480,16)) {
    printf("Error setting graphics mode\n");
    exit(1);
  }

  // Check the mode information, as suggested
  size = get_resolution(&max_x, &max_y, &bpp);
  printf("Running at %dx%dx%d\n", max_x, max_y, bpp);
  printf("%ld colours\n", max_col);

  // allocate a virtual screen and check for errors
  img = new_image();
  if(img == NULL || img->address == NULL) {
    printf("Could not allocate virtual screen\n");
    exit(1);
  }
  // Setup our virtual screen as the default screen
  set_image(img);

  gothic = new Font; gothic->load("./fonts/goth.chr");
  small = new Font;   small->load("./fonts/litt.chr");

  gothic->points(36);
  small->points(12);

  cansoft = new Pcx("./cansoft.pcx");
  set_pal(cansoft->palette);

  return;
}

void shutdown(void) {
  deinit_petal();
  delete_image(img);
}
