// ***************************************
// TEXT TO LOG TRANSLATOR
//
//
//              Written by Emil Dotchevski
// ***************************************

// This program reads any tool/compiler output from stdin, translates it
// to log format, and writes translated text to stdout.
//
// POWER VIEW IDE LOG FORMAT DESCRIPTION
//
// All lines written to stdout must be in the format
//
// <file>,<line>,<column>,<message>\n
//
// where <file> is full file specification of the source file, <line>
// and <column> are location of the message (error) in the source file,
// and <message> is the text to be displayed by the IDE.
//
// If any of <file>, <line> or <column> are unknown, leave responding
// field empty, for example ",,,something" describes none of <file>,
// <line> and <column> are given, and the message is "something".
//
// It is a good idea, if compiler output is not recognized to copy all
// stdin lines to stdout in the form ",,,<message>", wich guarantees
// all the messages will be displayed in the log.


#include <stdio.h>
#include <string.h>

#define MAX_LINE_SIZE     255


static char buffer[MAX_LINE_SIZE+1]; //buffer for read lines


static char *read( void )
//read a line from stdin in the buffer
{
  return fgets( buffer, MAX_LINE_SIZE, stdin );
}


static int write( char *l )
//write string to stdout
{
  return fputs( l, stdout );
}


void main( void )
{
  while( read() != NULL )
  {
    write( ",,," );
    write( buffer );
  }
}
