//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVINPUT.CPP                          |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Input box implementation             |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_stdio
#define uses_math
#define uses_string
#define uses_basics
#define uses_dc
#define uses_dialog
#define uses_hist
#define uses_icons
#define uses_input
#define uses_lines
#define uses_stddlg
#define uses_system

#include "PVuses.h"


//Tinput_editor publics:

Tinput_editor::Tinput_editor(  char *_line, int _max_len, int _xl ):
  Tmemo( _line, _max_len+1, _xl, 1 )
{
  ~text_editor->valid_chars;
  for( int i = 32; i < 256; i++ )
    text_editor->valid_chars << i;
  left_icon = NEW( Ticon( "|i", cmLEFT_ARROW, 0 ) );
    left_icon->set_flags( bfREPEAT, 1 );
    left_icon-> set_state( isHIDDEN, 1 );
    put_in( left_icon, -1, 0 );
  right_icon = NEW( Ticon( "|i", cmRIGHT_ARROW, 0 ) );
    right_icon->set_flags( bfREPEAT, 1 );
    put_in( right_icon, xl, 0 );
    right_icon->set_state( isHIDDEN, 1 );
}

void Tinput_editor::scroll_to( int _x, int _y )
{
  int l;

  l = text_editor->buf_len - _x;
  if( l < xl - 1 )
  {
    _x += l - xl + 1;
    if( _x < 0 ) _x = 0;
  }
  Teditor::scroll_to( _x, _y );
}

//Tinput_editor protected:

void Tinput_editor::get_focused( void )
{
  text_editor->set_select( 0, text_editor->buf_len, 1 );
}

#ifndef HGR
void Tinput_editor::set_palette( void )
{
  Teditor::set_palette();
  if( !graph_flag )
  {
    text_attr = rolb( text_attr, 4 );
    bold_attr &= 0x0F;
    bold_attr |= (char) ( text_attr & 0xF0 );
  }
}
#endif

void Tinput_editor::event_handler( Tevent &ev )
{
  Teditor::event_handler( ev );
  if( state( isFOCUSED ) && ( ev.code == evCOMMAND ) )
  {
    switch( ev.CMD_CODE )
    {
      case cmLEFT_ARROW:
        scroll_to( delta_x - 1, 1 ); break;
      case cmRIGHT_ARROW:
        scroll_to( delta_x + 1, 1 ); break;
      default:
        goto hot;
    }
    redraw();
    handled( ev );
  }
hot:
  left_icon->set_state( isHIDDEN, !delta_x );
  right_icon->set_state( isHIDDEN, ( text_editor->buf_len - delta_x ) < xl );
  if( item_acted == this ) item_acted = owner;
}

void Tinput_editor::convert_event( Tevent &ev )
{
  Tevent svd;

  svd = ev;
  Teditor::convert_event( ev );
  if( ( ev.code == evCOMMAND ) && ( ev.CMD_CODE >= cmeLINE_UP ) &&
     ( ev.CMD_CODE <= cmeNEW_LINE ) ) ev = svd;
}


//Tinput publics:

Tinput::Tinput( char *_prompt, char *_line, int _max_length, int _xl ):
  Tcombo_item( _prompt, _xl + 3 )
{
  init( _line, _max_length, _xl );
#ifndef NOHIST
  history_id = NULL;
#endif
}

#ifndef NOHIST
Tinput::Tinput( char *_prompt, char *_line, int _max_length, int _xl, Tlb_list *_hist ):
  Tcombo_item( _prompt, _xl + 3, _hist )
{
  init( _line, _max_length, _xl );
  put_in( NEW( Thistory( _hist ) ), xl, 0 );
}
#endif

void Tinput::set_data( uint i )
{
  char s[256];

  gettxt( i, s );
  set_txt( s );
}

void Tinput::get_data( char *s )
{
  editor->text_editor->get_line_str( s, editor->text_editor->buf_len );
}

void Tinput::set_txt( char *s )
{
  char tmp[256];

  strcpy( tmp, s );
  if( strlen( tmp ) > editor->text_editor->buf_size ) tmp[editor->text_editor->buf_size] = 0;
  editor->text_editor->set_select( 0, editor->text_editor->buf_len, 1 );
  editor->text_editor->insert_string( tmp, 0 );
  redraw();
  item_acted = this;
}

void Tinput::get_txt( char *s )
{
  editor->text_editor->get_line_str( s, editor->text_editor->buf_len );
}

//Tinput protected:

void Tinput::draw( void )
{
#ifndef HGR
  if( !graph_flag )
  {
    selected_attr = rolb( selected_attr, 4 );
    text_attr = rolb( text_attr, 4 );
    txtf( "|%c%s|r%c %s", state(isDISABLED)?'d':'t', i_left_line, xl - 2, i_right_line );
    return;
  }
#endif
  txtf( "%s|r%c %s", i_left_line, xl - 2, i_right_line );
}

void Tinput::get_focused( void )
{
  editor->text_editor->set_select( 0, editor->text_editor->buf_len, 1 );
}

boolean Tinput::release_focus( void )
{
  if( Tcombo_item::release_focus() )
  {
    editor->text_editor->hide_select();
    return 1;
  }
  return 0;
}

//Tinput private:

void Tinput::init( char *_line, int _max_length, int _xl )
{
  editor = NEW( Tinput_editor( _line, _max_length, _xl + 1 ) );
  put_in( editor, 1, 0 );
  put_in( NEW( Tline0( xl ) ), x, 1 );
  put_in( NEW( Tline1( xl ) ), x, -1 );
}


//Tlinput publics:

Tlinput::Tlinput ( char *_prompt, long &_data, long _min, long _max ):
  Tinput( _prompt, lin, len, init_len( _min, _max ) )
{
  init( _data, _min, _max );
}

#ifndef NOHIST
Tlinput::Tlinput( char *_prompt, long &_data, long _min, long _max, Tlb_list *_hist ):
  Tinput( _prompt, lin, len, init_len( _min, _max ), _hist )
{
  init( _data, _min, _max );
}
#endif

boolean Tlinput::valid( uint stop_st )
{
  long v;
  char line[256], *end_ptr;
  Tcombo_item::valid( stop_st );
  if( stop_st == cmCANCEL ) return 1;
  get_txt( line );
  v = strtol( line, &end_ptr, hex?16:10 );
  if( (!v && *end_ptr) || v<min || v>max )
  {
#ifdef CYR
    sprintf( line, "   .\n\n      %%l%c  %%l%c ", hex?'x':'d', hex?'x':'d' );
#else
    sprintf( line, "Value not within the valid range.\n\nPlease enter new integer value between %%l%c and %%l%c ", hex?'x':'d', hex?'x':'d' );
#endif
    focus(); _terror();
    ok( line, min, max );
    return 0;
  }
  *data = v;
  return 1;
}

void Tlinput::set_num( long n )
{
  char s[256];

  n = maxl( n, min );
  n = minl( n, max );
  ltoa( n, s, hex?16:10 );
  set_txt( s );
}

long Tlinput::get_num( void )
{
  char s[256];

  get_txt( s );
  return atol( s );
}

//Tlinput private:

char Tlinput::init_len( long _min, long _max )
{
  hex = __hexnum();
  ltoa( _min, lin, hex?16:10 ); len = (char) strlen( lin );
  ltoa( _max, lin, hex?16:10 ); if( strlen( lin ) > len ) len = (char) strlen( lin );
  return len;
}

void Tlinput::init( long &_data, long _min, long _max )
{
  ltoa( _data, lin, hex?16:10 );
  set_txt( lin );
  data = &_data; min = _min; max = _max;
  ~editor->text_editor->valid_chars;
  editor->text_editor->valid_chars << '-';
  for( int i = '0'; i <= '9'; i++ )
    editor->text_editor->valid_chars << i;
  if( hex )
  {
    for( i = 'A'; i <= 'F'; i++ )
      editor->text_editor->valid_chars << i;
    for( i = 'a'; i <= 'f'; i++ )
      editor->text_editor->valid_chars << i;
  }
}


//Tiinput publics:

Tiinput::Tiinput( char *_prompt, int &_data, int _min, int _max ):
  Tlinput( _prompt, tmp, _min, _max )
{
  set_num( _data );
  tmp = _data;
  dta = &_data;
}

#ifndef NOHIST
Tiinput::Tiinput( char *_prompt, int &_data, int _min, int _max, Tlb_list *_hist ):
  Tlinput( _prompt, tmp, _min, _max, _hist )
{
  set_num( _data );
  tmp = _data;
  dta = &_data;
}
#endif

boolean Tiinput::valid( uint stop_st )
{
  boolean result;

  result = Tlinput::valid( stop_st );
  *dta = tmp;
  return result;
}


//Tsinput publics:

Tsinput::Tsinput( char *_prompt, short &_data, short _min, short _max ):
  Tlinput( _prompt, tmp, _min, _max )
{
  set_num( _data );
  tmp = _data;
  dta = &_data;
}

#ifndef NOHIST
Tsinput::Tsinput( char *_prompt, short &_data, short _min, short _max, Tlb_list *_hist ):
  Tlinput( _prompt, tmp, _min, _max, _hist )
{
  set_num( _data );
  tmp = _data;
  dta = &_data;
}
#endif

boolean Tsinput::valid( uint stop_st )
{
  boolean result;

  result = Tlinput::valid( stop_st );
  *dta = (short) tmp;
  return result;
}


//Tcinput publics:

Tcinput::Tcinput( char *_prompt, char &_data, char _min, char _max ):
  Tlinput( _prompt, tmp, _min, _max )
{
  set_num( _data );
  tmp = _data;
  dta = &_data;
}

#ifndef NOHIST
Tcinput::Tcinput( char *_prompt, char &_data, char _min, char _max, Tlb_list *_hist ):
  Tlinput( _prompt, tmp, _min, _max, _hist )
{
  set_num( _data );
  tmp = _data;
  dta = &_data;
}
#endif

boolean Tcinput::valid( uint stop_st )
{
  boolean result;

  result = Tlinput::valid( stop_st );
  *dta = (char) tmp;
  return result;
}


//Twinput publics:

Twinput::Twinput( char *_prompt, word &_data, word _min, word _max ):
  Tlinput( _prompt, tmp, _min, _max )
{
  set_num( _data );
  tmp = _data;
  dta = &_data;
  editor->text_editor->valid_chars >> '-';
}

#ifndef NOHIST
Twinput::Twinput( char *_prompt, word &_data, word _min, word _max, Tlb_list *_hist ):
  Tlinput( _prompt, tmp, _min, _max, _hist )
{
  set_num( _data );
  tmp = _data;
  dta = &_data;
  editor->text_editor->valid_chars >> '-';
}
#endif

boolean Twinput::valid( uint stop_st )
{
  boolean result;

  result = Tlinput::valid( stop_st );
  *dta = (word) tmp;
  return result;
}


//Tdinput publics:

#ifndef NOFLOAT
Tdinput::Tdinput( char *_prompt, double &_data, double _min, double _max, char _decimals ):
  Tinput( _prompt, lin, len, init_len( _data, _min, _max, _decimals ) )
{
  init();
}

#ifndef NOHIST
Tdinput::Tdinput( char *_prompt, double &_data, double _min, double _max, char _decimals, Tlb_list *_hist ):
  Tinput( _prompt, lin, len, init_len( _data, _min, _max, _decimals ), _hist )
{
  init();
}
#endif

boolean Tdinput::valid( uint stop_st )
{
  double v;
  char line[256], *err;

  if( !Tinput::valid( stop_st ) ) return 0;
  if( stop_st == cmCANCEL ) return 1;
  get_txt( line );
  v = strtod( line, &err );
  if( *err || ( v < min ) || ( v > max ) )
  {
    focus();
    _terror();
#ifdef CYR
    ok( "   .\n\n     %*.*f  %*.*f ",
      integer, decimals, min, integer, decimals, max );
#else
    ok( "Value not within the valid range.\n\nPlease enter new value\nbetween %*.*f and %*.*f",
      integer, decimals, min, integer, decimals, max );
#endif
    return 0;
  };
  sprintf( line, "%*.*f", integer, decimals, v );
  v = strtod( line, NULL );
  *data = v;
  return 1;
}

void Tdinput::set_num( double n )
{
  char s[256];
  sprintf( s, "%*.*f", integer*(state(isFOCUSED)==0), decimals, n );
  set_txt( s );
}

double Tdinput::get_num( void )
{
  char s[256];
  get_txt( s );
  return atof( s );
}

//Tdinput private:

char Tdinput::init_len( double &_data, double _min, double _max, char _decimals )
{
  int l1,l2;
  min = _min; max = _max;
  decimals = _decimals;
  data = &_data;
  l1=sprintf( lin, "%0.*f", decimals, max );
  l2=sprintf( lin, "%0.*f", decimals, min );
  len=integer=::max(l1,l2);
  sprintf( lin, "%*.*f", integer, decimals, *data );
  return integer;
}

void Tdinput::init( void )
{
  ~editor->text_editor->valid_chars;
  for( char i = '0'; i <= '9'; i++ )
    editor->text_editor->valid_chars << i;
  editor->text_editor->valid_chars<<'.'<<'E'<<'e'<<'-';
}

void Tdinput::get_focused( void )
{
  set_num(get_num());
  Tinput::get_focused();
}

boolean Tdinput::release_focus( void )
{
  char s[256];
  if( !Tinput::release_focus() ) return 0;
  sprintf( s, "%*.*f", integer, decimals, get_num() );
  set_txt( s );
  return 1;
}



//Tfinput publics:

Tfinput::Tfinput( char *_prompt, float &_data, float _min, float _max, char _decimals ):
  Tdinput( _prompt, tmp, (double) _min, (double) _max, _decimals )
{
  set_num( _data );
  tmp = _data;
  dta = &_data;
}

#ifndef NOHIST
Tfinput::Tfinput( char *_prompt, float &_data, float _min, float _max, char _decimals, Tlb_list *_hist ):
  Tdinput( _prompt, tmp, (double) _min, (double) _max, _decimals, _hist )
{
  set_num( _data );
  tmp = _data;
  dta = &_data;
}
#endif

boolean Tfinput::valid( uint stop_st )
{
  boolean result;

  result = Tdinput::valid( stop_st );
  *dta = (float) tmp;
  return result;
}

#endif //NOFLOAT

//PREFIXES

static void *history_ = NULL;
static boolean hexnum_ = 0;

/*
  Description:
    Specify the text edit box to have a 'history'. Call just before construct
    a text box.
  Entry:
    history_id - unique history identifier. Text edit boxes with same history
                 identifiers share one history list.
*/
void *_history( void *history_id )
{
  history_ = history_id;
  return history_id;
}

void *__history( void )
{
  void *result;

  result = history_;
  history_ = NULL;
  return result;
}

/*
  Description:
    Specify the integer input box to accept hexadecimal entry.
*/
void _hexnum( void )
{
  hexnum_ = 1;
}

boolean __hexnum( void )
{
  boolean result = hexnum_;
  hexnum_ = 0;
  return result;
}

//CONSTRUCTORS FOR USE WITH DIALOG BOXES

static void _input( Tinput *i )
{
  hspaces( i->prompt_len );
  put_item( i, i->xl +
#ifndef NOHIST
    ( i->history_id != NULL ) * i_combo_open_len +
#endif
    1, 2 );
  if( !fill() ) hspaces( -i->prompt_len );
}

/*
  Description:
    Construct text edit box and insert it in the dialog box.
  Entry:
    t    - title, shortcut prefix '|~';
    data - buffer that holds current value;
    len  - maximum valid length of the output string;
    size - number of characters to be displayed - size of the text edit box.
  Exit:
    Return pointer to the edit box.
*/
Tinput *input( char *t, char *data, int len, int size )
{
  Tinput *i;
#ifndef NOHIST
  void *history_id;
  Tlb_list *history;

  history_id = __history();
  if( history_id != NULL )
  {
    history = registrate_history( history_id );
    i = NEW( Tinput( t, data, len, size, history ) );
    i->history_id = history_id;
  }
  else
#endif
    i = NEW( Tinput( t, data, len, size ) );
  _input( i );
  return i;
}

/*
  Description:
    Construct longint edit box and insert it in the dialog box.
  Entry:
    t       - title, shortcut prefix '|~';
    data    - buffer that holds current value;
    min,max - valid number range.
  Exit:
    Return pointer to the edit box.
*/
Tlinput *linput( char *t, long &data, long min, long max )
{
  Tlinput *i;
#ifndef NOHIST
  void *history_id;
  Tlb_list *history;

  history_id = __history();
  if( history_id != NULL )
  {
    history = registrate_history( history_id );
    i = NEW( Tlinput( t, data, min, max, history ) );
    i->history_id = history_id;
  }
  else
#endif
    i = NEW( Tlinput( t, data, min, max ) );
  _input( i );
  return i;
}

/*
  Description:
    Construct integer edit box and insert it in the dialog box.
  Entry:
    t       - title, shortcut prefix '|~';
    data    - buffer that holds current value;
    min,max - valid number range.
  Exit:
    Return pointer to the edit box.
*/
Tsinput *sinput( char *t, short &data, short min, short max )
{
  Tsinput *i;
#ifndef NOHIST
  void *history_id;
  Tlb_list *history;

  history_id = __history();
  if( history_id != NULL )
  {
    history = registrate_history( history_id );
    i = NEW( Tsinput( t, data, min, max, history ) );
    i->history_id = history_id;
  }
  else
#endif
    i = NEW( Tsinput( t, data, min, max ) );
  _input( i );
  return i;
}

/*
  Description:
    Construct int edit box and insert it in the dialog box.
  Entry:
    t       - title, shortcut prefix '|~';
    data    - buffer that holds current value;
    min,max - valid number range.
  Exit:
    Return pointer to the edit box.
*/
Tiinput *iinput( char *t, int &data, int min, int max )
{
  Tiinput *i;
#ifndef NOHIST
  void *history_id;
  Tlb_list *history;

  history_id = __history();
  if( history_id != NULL )
  {
    history = registrate_history( history_id );
    i = NEW( Tiinput( t, data, min, max, history ) );
    i->history_id = history_id;
  }
  else
#endif
    i = NEW( Tiinput( t, data, min, max ) );
  _input( i );
  return i;
}

/*
  Description:
    Construct char edit box and insert it in the dialog box.
  Entry:
    t       - title, shortcut prefix '|~';
    data    - buffer that holds current value;
    min,max - valid number range.
  Exit:
    Return pointer to the edit box.
*/
Tcinput *cinput( char *t, char &data, char min, char max )
{
  Tcinput *i;
#ifndef NOHIST
  void *history_id;
  Tlb_list *history;

  history_id = __history();
  if( history_id != NULL )
  {
    history = registrate_history( history_id );
    i = NEW( Tcinput( t, data, min, max, history ) );
    i->history_id = history_id;
  }
  else
#endif
    i = NEW( Tcinput( t, data, min, max ) );
  _input( i );
  return i;
}

/*
  Description:
    Construct word edit box and insert it in the dialog box.
  Entry:
    t       - title, shortcut prefix '|~';
    data    - buffer that holds current value;
    min,max - valid number range.
  Exit:
    Return pointer to the edit box.
*/
Twinput *winput( char *t, word &data, word min, word max )
{
  Twinput *i;
#ifndef NOHIST
  void *history_id;
  Tlb_list *history;

  history_id = __history();
  if( history_id != NULL )
  {
    history = registrate_history( history_id );
    i = NEW( Twinput( t, data, min, max, history ) );
    i->history_id = history_id;
  }
  else
#endif
    i = NEW( Twinput( t, data, min, max ) );
  _input( i );
  return i;
}

#ifndef NOFLOAT
/*
  Description:
    Construct double edit box and insert it in the dialog box.
  Entry:
    t        - title, shortcut prefix '|~';
    data     - buffer that holds current value;
    min,max  - valid number range;
    decimals - number of digits after the point ( precision ).
  Exit:
    Return pointer to the edit box.
*/
Tdinput *dinput( char *t, double &data, double min, double max, char decimals )
{
  Tdinput *i;
#ifndef NOHIST
  void *history_id;
  Tlb_list *history;

  history_id = __history();
  if( history_id != NULL )
  {
    history = registrate_history( history_id );
    i = NEW( Tdinput( t, data, min, max, decimals, history ) );
    i->history_id = history_id;
  }
  else
#endif
    i = NEW( Tdinput( t, data, min, max, decimals ) );
  _input( i );
  return i;
}

/*
  Description:
    Construct float edit box and insert it in the dialog box.
  Entry:
    t        - title, shortcut prefix '|~';
    data     - buffer that holds current value;
    min,max  - valid number range;
    decimals - number of digits after the point ( precision ).
  Exit:
    Return pointer to the edit box.
*/
Tfinput *finput( char *t, float &data, float min, float max, char decimals )
{
  Tfinput *i;
#ifndef NOHIST
  void *history_id;
  Tlb_list *history;

  history_id = __history();
  if( history_id != NULL )
  {
    history = registrate_history( history_id );
    i = NEW( Tfinput( t, data, min, max, decimals, history ) );
    i->history_id = history_id;
  }
  else
#endif
    i = NEW( Tfinput( t, data, min, max, decimals ) );
  _input( i );
  return i;
}

/*
  Description:
    Construct money edit box and insert it in the dialog box.
  Entry:
    t    - title, shortcut prefix '|~';
    data - buffer that holds current value;
    max  - maximum of the value. Minimum is 0, precision is 0.01.
  Exit:
    Return pointer to the edit box.
*/
Tfinput *minput( char *t, float &data, float max )
{
  Tfinput *i;
#ifndef NOHIST
  void *history_id;
  Tlb_list *history;

  history_id = __history();
  if( history_id != NULL )
  {
    history = registrate_history( history_id );
    i = NEW( Tfinput( t, data, 0, max, 2, history ) );
    i->history_id = history_id;
  }
  else
#endif
    i = NEW( Tfinput( t, data, 0, max, 2 ) );
  _input( i );
  return i;
}

#endif //NOFLOAT
