//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVLABEL.CPP                          |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Items labels implementation          |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_string
#define uses_basics
#define uses_cmd
#define uses_dc
#define uses_icons
#define uses_label
#define uses_system

#include "PVuses.h"

//Tlabel publics:

Tlabel::Tlabel( char *t, Titem *i ):
  Titem( 0, 1 )
{
  set_flags( ifSELECTABLE, 0 );
  title = STRDUP( t );
  resize( smart_len( t ), 1 );
  shortcut = get_shortcut( t );
  item = i;
}

Tlabel::~Tlabel( void )
{
  FREE( title );
}

//Tlabel protected:

void Tlabel::set_palette( void )
{
  Titem::set_palette();
  if( item == NULL ) return;
  if( item->state( isDISABLED ) ) shortcut_attr = disabled_attr;
}

void Tlabel::draw( void )
{
  char *s;

  if( title == NULL ) return;
  s = "";
  if( item != NULL )
  {
    if( item->state( isDISABLED ) )
      s = "|d";
    else
      if( item->state( isSELECTED ) )
        s = "|b";
  }
  txtf( "%s%s", s, title );
}

void Tlabel::event_handler( Tevent &ev )
{
  switch( ev.code )
  {
    case evKEY_PRESS:
      if( ev.ASCII==shortcut && item!=NULL && !item->state(isHIDDEN|isDISABLED) )
      {
        item->focus();
        message( item, cmLABEL_FOCUSED );
        handled(ev);
        return;
      }
      break;
#ifndef NOMOUSE
    case evMOUSE_DOWN:
      if( ev.INSIDE )
      {
        item->focus();
        handled(ev);
        return;
      }
      break;
#endif
  }
  Titem::event_handler( ev );
}

//Tbox publics:

Tbox::Tbox( char *t, Titem *i ):
  Tlabel( t, i )
{
  if( item != NULL )
  {
    item->optimize_bounds();
    resize( item->bound_xl + 2, item->bound_yl + 2 );
  }
  title_len = (char) smart_len( t );
}

//Tbox potected:

boolean Tbox::check_inside( int _x, int _y )
{
  int a,b;
  get_origin( a, b );
  return Tlabel::check_inside( _x, _y ) &&
         ( _x==a || _x==a+xl-1 || _y==b );//|| _y==b+yl-1 );
}

void Tbox::draw( void )
{
  static char t[] = "|r...|n.|l..|r...";
  static char s[] = " |l.";

  txt( i_box_ul ); Tlabel::draw();
  t[2] = (char) ( xl - title_len - 2 ); t[3] = frame_standard[1];
  t[4] = i_box_ur[0]; t[7] = frame_normal[3]; t[10] = (char) ( yl - 2 );
  t[11] = i_box_dl[0]; t[14] = (char) ( xl - 2 ); t[15] = frame_normal[1];
  t[16] = i_box_dr[0];
  txt( t );
  s[0] = frame_normal[5]; s[3] = (char) ( yl - 2 );
  set_base( current_dc->base_x + xl - 1, current_dc->base_y + 1 ); txt( s );
}
