//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVLINES.CPP                          |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Smart horizontal lines implementation|
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_basics
#define uses_dc
#define uses_icons
#define uses_lines
#define uses_system

#include "PVuses.h"

//Tline publics:

Tline::Tline( int l ):
  Titem( l, 1 )
{
  set_events_mask( (uint)-1, 0 );
  set_flags( ~ifVISIBLE, 0 );
#ifndef HGR
  set_state( isHIDDEN, !graph_flag );
#endif
}

//Tline0 publics:

Tline0::Tline0( int l ):
  Tline( l )
{
}

//Tline0 protected:

void Tline0::draw( void )
{
  txtf( "|r%c%c", xl, '' );
}

//Tline1 publics:

Tline1::Tline1( int l ):
  Tline( l )
{
  set_state( isON_TOP, 1 );
}

//Tline1 protected:

void Tline1::draw( void )
{
  word buffer[512], *a, *b, c;
  uint n;

  n = xl + 1;
  if( current_dc->cursor_x < 0 )
  {
    n += current_dc->cursor_x;
    goto_xy( -current_dc->cursor_x, where_y() );
  }
  a = (word *) ( ( (char *) current_dc->address ) + current_dc->cursor_ofs );
  b = buffer;
  hi( c ) = text_attr;
  while( --n )
  {
    if( lo( *a++ ) == 0xD1 ) lo( c ) = 0xD3; else lo( c ) = 0xD2;
    *b++ = c;
  }
  current_dc->print( buffer, xl );
}
